import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    darkMode: "class",
    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                primary: "#008037",
                hvPrimary: "#00A94A",
                activeSidebar: "#CCF0DA",
                light: "#f3f4f6",
                // txLight: "#111827",
                dark: "#111827",
                // txDark: "#f9fafb",
            },
        },
    },

    plugins: [forms],
};
