<aside id="sidebar" style="position: fixed; overflow-y: auto;"
    class="sidebar bg-gray-50 dark:bg-dark text-dark dark:text-light shadow-lg dark:shadow-gray-700 w-72 fixed inset-y-0 left-0 transform -translate-x-full lg:hidden z-40">
    <div class="px-5 py-4">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-2">
                
                <img src="/logo_app/<?php echo e(Auth::user()->logo); ?>" alt="logo" class="w-14">
                <div>
                    <h2 class=" text-xl font-semibold">
                        BUKU INDUK</h2>
                    <h2 class="text-xs"><?php echo e(Auth::user()->nama_sekolah); ?></h2>
                </div>
            </div>
            <div class="lg:hidden hover:text-hvPrimary">
                <button id="closeSidebar">
                    <i class="fa-solid fa-arrow-left-long"></i>
                </button>
            </div>
        </div>
        <div class="border border-gray-200 mt-4"></div>
        <ul class="mt-4 text-[15px]">
            
            <li class="my-1">
                <a href="/dashboard"
                    class="block py-2 px-4 font-semibold <?php echo e(request()->is('dashboard') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10'); ?>">
                    <i class="fa-solid fa-house me-1"></i> Dashboard
                </a>
            </li>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                <div class="mt-1 text-primary font-semibold">Akademik</div>
                
                <li class="my-1">
                    <a href="/tahun-ajaran"
                        class="block py-2 px-4 font-semibold <?php echo e(request()->is('tahun-ajaran') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10'); ?>">
                        <i class="fa-solid fa-calendar-days me-1"></i> Tahun Ajaran
                    </a>
                </li>

                
                <li class="my-1">
                    <a href="/kelas"
                        class="block py-2 px-4 font-semibold <?php echo e(request()->is('kelas') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10'); ?>">
                        <i class="fa-solid fa-border-all me-1"></i> Data Kelas
                    </a>
                </li>
                <li class="my-1">
                    <a href="/mata-pelajaran"
                        class="block py-2 px-4 font-semibold <?php echo e(request()->is('mata-pelajaran') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10'); ?>">
                        <i class="fa-solid fa-scroll me-1"></i> Mata Pelajaran
                    </a>
                </li>

                
                

                
                
                <li class="my-1">
                    <a href="/siswa"
                        class="block py-2 px-4 font-semibold <?php echo e(request()->is('siswa') || request()->is('siswa/create') || request()->is('siswa/*') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10'); ?>">
                        <i class="fa-solid fa-user-graduate me-1"></i> Data Siswa
                    </a>
                </li>

                <div class="mt-1 text-primary font-semibold">Laporan</div>
            <?php endif; ?>
            
            
            
            <li class="my-1">
                <a href="/buku-induk"
                    class="block py-2 px-4 font-semibold <?php echo e(request()->is('buku-induk') || request()->is('buku-induk/*') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10'); ?>">
                    <i class="fa-solid fa-book-open me-1"></i> Buku Induk
                </a>
            </li>
            
            

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admin')): ?>
                <div class="mt-1 text-primary font-semibold">Akun</div>
            <?php endif; ?>
            
            <li class="my-1">
                <a href="/profil"
                    class="block py-2 px-4 font-semibold <?php echo e(request()->is('profil') || request()->is('profil/*') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10'); ?>">
                    <i class="fa-solid fa-user-circle me-1"></i> Profil
                </a>
            </li>

        </ul>
    </div>
</aside>

<?php $__env->startPush('js'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.getElementById('sidebar');

            if (!sidebar) {
                return;
            }

            const storageKey = 'sidebar-scroll-position';
            const savedPosition = localStorage.getItem(storageKey);

            if (savedPosition !== null) {
                sidebar.scrollTop = parseInt(savedPosition, 10) || 0;
            }

            sidebar.addEventListener('scroll', function() {
                localStorage.setItem(storageKey, sidebar.scrollTop);
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\_Project_Laravel\E-Raport-Book\resources\views/layouts/navigation.blade.php ENDPATH**/ ?>