<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buku Induk - <?php echo e($kelasName); ?></title>
    <style>
        @page {
            size: A4 landscape;
            margin: 1cm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 8pt;
            line-height: 1.2;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 10px;
        }
        
        .header h1 {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 3px;
        }
        
        .header p {
            font-size: 9pt;
            margin: 2px 0;
        }
        
        table.data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        
        table.data-table, 
        table.data-table th, 
        table.data-table td {
            border: 1px solid #000;
        }
        
        table.data-table th {
            background-color: #e2e8f0;
            font-weight: bold;
            padding: 4px 2px;
            text-align: center;
            font-size: 7pt;
            vertical-align: middle;
        }
        
        table.data-table td {
            padding: 3px 2px;
            font-size: 7pt;
            vertical-align: middle;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-left {
            text-align: left;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .col-no {
            width: 20px;
        }
        
        .col-nisn {
            width: 60px;
        }
        
        .col-nama {
            width: 100px;
        }
        
        .col-status {
            width: 50px;
        }
        
        .col-nilai {
            width: 30px;
        }
        
        .col-deskripsi {
            width: 120px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>BUKU INDUK NILAI SISWA</h1>
        <p><strong>Kelas:</strong> <?php echo e($kelasName); ?></p>
        <p><strong>Semester:</strong> <?php echo e($semester); ?> | <strong>Tahun Ajaran:</strong> <?php echo e($tahunAjaran); ?></p>
    </div>

    <table class="data-table">
        <thead>
            
            <tr>
                <th rowspan="3" class="col-no">No.</th>
                <th rowspan="3" class="col-nisn">NISN</th>
                <th rowspan="3" class="col-nama">Nama Siswa</th>
                <th rowspan="3" class="col-status">Status Input</th>
                <?php $__currentLoopData = $mapelHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mapelHead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($mapelHead->details->isNotEmpty()): ?>
                        <th colspan="<?php echo e($mapelHead->details->count() * 1); ?>"><?php echo e($mapelHead->nama_mapel); ?></th>
                    <?php else: ?>
                        <th rowspan="2" colspan="1"><?php echo e($mapelHead->nama_mapel); ?></th>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
            
            
            <tr>
                <?php $__currentLoopData = $mapelHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mapelHead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($mapelHead->details->isNotEmpty()): ?>
                        <?php $__currentLoopData = $mapelHead->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th colspan="1" class="col-deskripsi"><?php echo e($detail->nama_mapel_detail); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
            
            
            <tr>
                <?php $__currentLoopData = $mapelHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mapelHead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($mapelHead->details->isNotEmpty()): ?>
                        <?php $__currentLoopData = $mapelHead->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="col-nilai">Nilai</th>
                            
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <th class="col-nilai">Nilai</th>
                        
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $siswa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $bookHead = $bookHeads->get($siswa->id);
                    $bookDetails = $bookHead ? $bookHead->details->keyBy(function ($detail) {
                        return $detail->mapel_detail_id ?? 'head_' . $detail->mapel_head_id;
                    }) : collect();

                    // Determine status input
                    $statusInput = 'Belum Input';
                    if ($bookHead && $mapelHeads->isNotEmpty()) {
                        $allFilled = true;
                        foreach ($mapelHeads as $mapelHead) {
                            if ($mapelHead->details->isNotEmpty()) {
                                foreach ($mapelHead->details as $detail) {
                                    $detailData = $bookDetails->get($detail->id);
                                    if (!$detailData || empty($detailData->nilai_akhir) || empty($detailData->deskripsi)) {
                                        $allFilled = false;
                                        break 2;
                                    }
                                }
                            } else {
                                $headData = $bookDetails->get('head_' . $mapelHead->id);
                                if (!$headData || empty($headData->nilai_akhir) || empty($headData->deskripsi)) {
                                    $allFilled = false;
                                    break;
                                }
                            }
                        }
                        if ($allFilled) {
                            $statusInput = 'Sudah Input';
                        }
                    }
                ?>
                <tr>
                    <td class="text-center"><?php echo e($key + 1); ?></td>
                    <td class="text-center"><?php echo e($siswa->nisn); ?></td>
                    <td><?php echo e($siswa->nama_siswa); ?></td>
                    <td class="text-center"><?php echo e($statusInput); ?></td>
                    <?php $__currentLoopData = $mapelHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mapelHead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($mapelHead->details->isNotEmpty()): ?>
                            <?php $__currentLoopData = $mapelHead->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $detailData = $bookDetails->get($detail->id);
                                ?>
                                <td class="text-center"><?php echo e($detailData ? $detailData->nilai_akhir : '-'); ?></td>
                                
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <?php
                                $headData = $bookDetails->get('head_' . $mapelHead->id);
                            ?>
                            <td class="text-center"><?php echo e($headData ? $headData->nilai_akhir : '-'); ?></td>
                            
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="<?php echo e(4 + ($mapelHeads->sum(function($m) { return $m->details->isNotEmpty() ? $m->details->count() * 2 : 2; }))); ?>" class="text-center">
                        Tidak ada siswa ditemukan
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH D:\_Project_Laravel\E-Raport-Book\resources\views/pages/buku_induk/pdf_table.blade.php ENDPATH**/ ?>