<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Favicons -->
    <link href="/img/logoUtama.png" rel="icon">
    <link href="/img/logoUtama.png" rel="apple-touch-icon">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!--Icons Cdn-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.3/font/bootstrap-icons.css">
    <!--Flowbite Cdn CSS-->
    <link href="https://cdn.jsdelivr.net/npm/flowbite@2.5.1/dist/flowbite.min.css" rel="stylesheet" />

    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"
        integrity="sha512-vKMx8UnXk60zUwyUnUPM3HbQo8QfmNx7+ltw8Pm5zLusl1XIfwcxo8DbWCqMGKaWeNxWA8yrx5v3SaVpMvR3CA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!--Link CSS-->
    <link rel="stylesheet" href="/css/style.css">

    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        (function() {
            if (localStorage.getItem("theme") === "dark") {
                document.documentElement.classList.add("dark");
            }
        })();
    </script>

    <script src="https://unpkg.com/flowbite@latest/dist/flowbite.min.js"></script>

    <link rel="stylesheet" href="https://unpkg.com/swiper@11/swiper-bundle.min.css" />
    <script src="https://unpkg.com/swiper@11/swiper-bundle.min.js"></script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <style>
        /* Style minimalis untuk scrollbar */
        .minimal-scroll {
            overflow-y: scroll;
        }

        .minimal-scroll::-webkit-scrollbar {
            width: 6px;
            /* Lebar scrollbar */
        }

        .minimal-scroll::-webkit-scrollbar-thumb {
            background-color: #c4c4c4;
            /* Warna thumb scrollbar */
            border-radius: 10px;
            /* Membuat ujung thumb bulat */
        }

        .minimal-scroll::-webkit-scrollbar-thumb:hover {
            background-color: #a1a1a1;
            /* Warna thumb saat hover */
        }

        .minimal-scroll::-webkit-scrollbar-track {
            background-color: #f4f4f4;
            /* Warna track scrollbar */
            border-radius: 10px;
            /* Membuat ujung track bulat */
        }

        @media (min-width: 1024px) {
            .translate-x {
                transform: translateX(0);
            }

            .margin-lg {
                margin-left: 288px;
            }
        }

        /* Sembunyikan scrollbar untuk semua browser */
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }

        .scrollbar-hide {
            -ms-overflow-style: none;
            /* IE and Edge */
            scrollbar-width: none;
            /* Firefox */
        }

        .swiper-slide img {
            width: auto;
            height: auto;
            max-width: 100%;
            max-height: 100%;
            display: block;
            margin: 0 auto;
        }

        .swiper-container,
        #swiper-container {
            height: auto;
            /* Biarkan swiper container menyesuaikan tinggi */
        }

        .bubble-with-arrow {
            position: absolute;
        }

        .bubble-with-arrow::after {
            content: '';
            position: absolute;
            top: 50%;
            right: -16px;
            /* posisi panah di luar sisi kanan */
            transform: translateY(-50%);
            border-width: 10px;
            border-style: solid;
            border-color: transparent transparent transparent #cbd5e1;
            /* warna panah sama dgn bg-light */
        }

        /* Untuk mode dark */
        .dark .bubble-with-arrow::after {
            border-color: transparent transparent transparent #111827;
            /* warna sama dgn bg-dark */
        }
    </style>
</head>

<body class="font-sans antialiased bg-light dark:bg-dark text-dark dark:text-light minimal-scroll">
    <div class="min-h-screen">
        <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Page Heading -->
        <div class="flex-1">
            <?php if(isset($header)): ?>
                <?php
                    $roleDescription = '';

                    if (Auth::check()) {
                        $user = Auth::user();

                        if ($user->role === 'Admin') {
                            $roleDescription = '';
                        } elseif ($user->role === 'Wali') {
                            $wali = $user->waliKelas;
                            $kelasDisplay = null;

                            if ($wali) {
                                $periodeAktif = $wali->periodeWaliKelas()
                                    ->where('deleted', '0')
                                    ->with('kelas')
                                    ->orderByDesc('thn_ajaran_awal')
                                    ->orderByDesc('thn_ajaran_akhir')
                                    ->first();

                                $kelas = $periodeAktif?->kelas;

                                if ($kelas) {
                                    $roman = trim($kelas->nama_kelas_romawi ?? '');
                                    $sub = trim($kelas->nama_kelas_sub ?? '');
                                    $number = trim((string) ($kelas->nama_kelas_nomor ?? ''));

                                    $romanDisplay = $roman;
                                    if ($sub !== '') {
                                        $romanDisplay = trim($romanDisplay . ' ' . $sub);
                                    }

                                    $numberDisplay = $number;
                                    if ($sub !== '') {
                                        $numberDisplay .= $sub;
                                    }

                                    $kelasDisplay = $romanDisplay ?: ($kelas->nama_kelas ?? null);

                                    if ($romanDisplay !== '' && $numberDisplay !== '') {
                                        $kelasDisplay = trim(($kelasDisplay ?? $romanDisplay) . ' (' . $numberDisplay . ')');
                                    }
                                }
                            }

                            $roleDescription = $kelasDisplay ? 'Wali Kelas ' . $kelasDisplay : 'Wali Kelas';
                        } else {
                            $roleDescription = ucfirst(strtolower($user->role ?? ''));
                        }
                    }
                ?>

                <header class="zoom flex px-5 py-3 bg-primary shadow-md dark:shadow-gray-700 fixed w-full top-0 z-20">
                    <!-- Hamburger Button -->
                    <button id="hamburger" class="lg:ms-72 me-3 text-gray-50 hover:text-gray-300">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6h16M4 12h16m-7 6h7" />
                        </svg>
                    </button>

                    <button id="theme-toggle" class="text-gray-50 hover:text-gray-300">
                        <i id="theme-icon" class="fas fa-moon text-lg"></i>
                    </button>

                    <div class="flex items-center">
                        
                        
                    </div>
                    <div class="flex-1 flex justify-end">
                        <a href="#" id="dropdownH"
                            class="flex text-gray-50 hover:text-gray-300 justify-end items-center">
                            <div class="text-end">
                                <div class="font-semibold text-sm"><?php echo e(Auth::user()->name); ?></div>
                                <div class="text-[11px] text-right mt-[-1px]"><?php echo e($roleDescription); ?></div>
                            </div>
                            <img src="/img/profil.webp" alt="profile" class="w-10 rounded-full mx-2">
                            <i class="fas fa-chevron-down transition-transform duration-300" id="chevronH"></i>
                        </a>
                    </div>

                    
                    <div id="cardH"
                        class="hidden opacity-0 transition-opacity duration-300 bg-light text-dark dark:bg-dark dark:text-light shadow-md border border-gray-200 dark:border-gray-700 pt-4 rounded-xl z-50"
                        style="position: absolute; top: 60px; right: 10px; z-index: 1000;">
                        <div class="mx-12 text-center">
                            <div class="font-semibold"><?php echo e(Auth()->user()->name); ?></div>
                            
                        </div>
                        <div class="border border-gray-200 dark:border-gray-700 mt-4 w-full"></div>
                        <a href="/profil">
                            <div class="mx-5 my-2 hover:text-hvPrimary"><i class="bi bi-person"></i> Profile</div>
                        </a>
                        <div class="border border-gray-200 dark:border-gray-700 w-full"></div>
                        <a href="#" data-modal-target="logoutAdmin" data-modal-toggle="logoutAdmin">
                            <div class="mx-5 my-2 hover:text-hvPrimary mb-3">
                                <i class="bi bi-box-arrow-left"></i> Logout
                            </div>
                        </a>
                    </div>
                </header>

                
                <div id="logoutAdmin" tabindex="-1" aria-hidden="true"
                    class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                    <div class="relative p-4 w-full max-w-lg max-h-full">
                        <!-- Modal content -->
                        <div class="relative bg-light text-dark dark:bg-gray-700 dark:text-light rounded-lg shadow">
                            <!-- Modal header -->
                            <div
                                class="flex items-center justify-between p-4 md:p-5 border-b border-gray-200 dark:border-gray-600 rounded-t">
                                <h3 class="text-lg sm:text-xl font-semibold text-red-500">
                                    <i class="fa-solid fa-circle-info"></i> INFORMASI
                                </h3>
                                <button type="button"
                                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                                    data-modal-hide="logoutAdmin">
                                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                        fill="none" viewBox="0 0 14 14">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                    </svg>
                                    <span class="sr-only">Close modal</span>
                                </button>
                            </div>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <!-- Modal body -->
                                <div class="p-4 md:p-5 text-center sm:text-base text-sm">
                                    Apakah anda yakin akan keluar dari website?
                                </div>
                                <!-- Modal footer -->
                                <div
                                    class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 dark:border-gray-600 rounded-b">
                                    <button type="submit"
                                        onclick="event.preventDefault();
                                            this.closest('form').submit();"
                                        class="py-2 px-10 sm:text-base text-sm rounded-md bg-red-500 hover:bg-red-400 transition text-white">Ya,
                                        Keluar
                                        <i class="bi bi-arrow-right"></i></button>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Page Content -->
            <main>
                <?php echo e($slot); ?>

            </main>
        </div>
    </div>

    
    <script src="/javaScript/script.js"></script>

    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"
        integrity="sha512-VEd+nq25CkR676O+pLBnDW09R7VQX9Mdiij052gVCp5yVH3jGtH70Ho/UUv4mJDsEdTvqRCFZg0NKGiojGnUCw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    
    

    
    <?php if(Session::has('successNotif')): ?>
        <script>
            toastr.options = {
                "progressBar": true,
                "closeButton": true,
                "positionClass": "toast-top-right",
            }
            toastr.success("<?php echo e(Session::get('successNotif')); ?>", 'INFORMASI', {
                timeOut: 2000
            });
        </script>
    <?php endif; ?>
    <?php if(Session::has('error')): ?>
        <script>
            toastr.options = {
                "progressBar": true,
                "closeButton": true,
                "positionClass": "toast-top-right",
            }
            toastr.error("<?php echo e(Session::get('error')); ?>", 'INFORMASI', {
                timeOut: 5000
            });
        </script>
    <?php endif; ?>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const themeToggle = document.getElementById("theme-toggle");
            const themeIcon = document.getElementById("theme-icon");
            const htmlElement = document.documentElement;

            // Cek localStorage untuk menyimpan preferensi pengguna
            if (localStorage.getItem("theme") === "dark") {
                htmlElement.classList.add("dark");
                themeIcon.classList.replace("fa-moon", "fa-sun");
            }

            themeToggle.addEventListener("click", function() {
                htmlElement.classList.toggle("dark");
                const isDark = htmlElement.classList.contains("dark");

                // Simpan preferensi tema di localStorage
                localStorage.setItem("theme", isDark ? "dark" : "light");

                // Ubah ikon
                if (isDark) {
                    themeIcon.classList.replace("fa-moon", "fa-sun");
                } else {
                    themeIcon.classList.replace("fa-sun", "fa-moon");
                }
            });
        });

        //Dropdown Master Data
        document.querySelectorAll(".master-data").forEach(function(button) {
            button.addEventListener("click", function(event) {
                event.preventDefault();

                const dropdown = this.nextElementSibling; // Ambil ul setelah a
                const icon = this.querySelector(".chevron-icon");

                if (dropdown.classList.contains("hidden")) {
                    dropdown.classList.remove("hidden");
                    dropdown.style.maxHeight = dropdown.scrollHeight + "px";
                    icon.classList.add("rotate-180");
                } else {
                    dropdown.style.maxHeight = "0";
                    icon.classList.remove("rotate-180");
                    dropdown.addEventListener(
                        "transitionend",
                        function() {
                            dropdown.classList.add("hidden");
                        }, {
                            once: true,
                        }
                    );
                }
            });
        });
    </script>

    <?php echo $__env->yieldPushContent('js'); ?>

</body>

</html>
<?php /**PATH D:\_Project_Laravel\E-Raport-Book\resources\views/layouts/app.blade.php ENDPATH**/ ?>