<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\KelasController;
use App\Http\Controllers\SiswaController;
use App\Http\Controllers\WaliKelasController;
use App\Http\Controllers\RaportController;
use App\Http\Controllers\MataPelajaranController;
use App\Http\Controllers\PekerjaanController;
use App\Http\Controllers\TahunAjaranController;
use App\Http\Controllers\WaliKelasPeriodeController;
use App\Http\Controllers\KepalaSekolahController;
use App\Http\Controllers\EkskulController;
use App\Http\Controllers\BukuIndukController;
use App\Http\Controllers\RekapNilaiController;

Route::get('/', function () {
    return view('welcome');
});

Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('tahun-ajaran/{id}/check-usage', [TahunAjaranController::class, 'checkUsage'])->name('tahun-ajaran.check-usage');
    Route::resource('tahun-ajaran', TahunAjaranController::class);
    Route::get('mata-pelajaran/{id}/check-usage', [MataPelajaranController::class, 'checkUsage'])->name('mata-pelajaran.check-usage');
    Route::get('mata-pelajaran/detail/{id}/check-usage', [MataPelajaranController::class, 'checkDetailUsage'])->name('mata-pelajaran.detail.check-usage');
    Route::delete('mata-pelajaran/detail/{id}', [MataPelajaranController::class, 'destroyDetail'])->name('mata-pelajaran.detail.destroy');
    Route::resource('mata-pelajaran', MataPelajaranController::class);
    Route::post('mata-pelajaran/detail', [MataPelajaranController::class, 'storeDetail'])->name('mata-pelajaran.detail.store');
    Route::put('mata-pelajaran/detail/{id}', [MataPelajaranController::class, 'updateDetail'])->name('mata-pelajaran.detail.update');
    Route::post('mata-pelajaran/kelas', [MataPelajaranController::class, 'storeKelas'])->name('mata-pelajaran.kelas.store');
    Route::resource('wali-kelas', WaliKelasController::class);
    Route::post('wali-kelas/{id}/reset-password', [WaliKelasController::class, 'resetPassword'])->name('wali-kelas.reset-password');
    Route::resource('wali-kelas-periode', WaliKelasPeriodeController::class);
    Route::get('kelas/{id}/check-usage', [KelasController::class, 'checkUsage'])->name('kelas.check-usage');
    Route::resource('kelas', KelasController::class);
    Route::resource('kepala-sekolah', KepalaSekolahController::class);
    Route::resource('ekstrakulikuler', EkskulController::class);
    Route::resource('pekerjaan', PekerjaanController::class);
    Route::post('siswa/promote', [SiswaController::class, 'promote'])->name('siswa.promote');
    Route::post('siswa/restore', [SiswaController::class, 'restore'])->name('siswa.restore');
    Route::get('siswa/riwayat', [SiswaController::class, 'riwayat'])->name('siswa.riwayat');
    Route::post('siswa/import', [SiswaController::class, 'import'])->name('siswa.import');
    Route::get('siswa/export-excel', [SiswaController::class, 'exportExcel'])->name('siswa.export');
    Route::get('siswa/{id}/check-usage', [SiswaController::class, 'checkUsage'])->name('siswa.check-usage');
    Route::resource('siswa', SiswaController::class);
    Route::get('raport/create/{id}', [RaportController::class, 'create'])->name('raport.create');
    Route::get('raport/{id}/download', [RaportController::class, 'download'])->name('raport.download');
    Route::get('raport/download-bulk/all', [RaportController::class, 'downloadBulk'])->name('raport.downloadBulk');
    Route::resource('raport', RaportController::class);
    Route::post('buku-induk/import', [BukuIndukController::class, 'importNilai'])->name('buku-induk.import');
    Route::post('buku-induk/update-nilai', [BukuIndukController::class, 'updateNilai'])->name('buku-induk.updateNilai');
    Route::delete('buku-induk/delete-all-nilai', [BukuIndukController::class, 'deleteAllNilai'])->name('buku-induk.deleteAllNilai');
    Route::get('buku-induk/download-excel', [BukuIndukController::class, 'downloadExcel'])->name('buku-induk.downloadExcel');
    Route::get('buku-induk/download-pdf', [BukuIndukController::class, 'downloadPDF'])->name('buku-induk.downloadPDF');
    Route::get('buku-induk/download-per-siswa/{siswa_id}', [BukuIndukController::class, 'downloadPerSiswa'])->name('buku-induk.downloadPerSiswa');
    Route::resource('buku-induk', BukuIndukController::class);
    Route::get('rekap-nilai', [RekapNilaiController::class, 'index'])->name('rekap-nilai.index');
    
    Route::get('/profil', [ProfileController::class, 'index'])->name('profil.index');
    Route::post('/profil/update', [ProfileController::class, 'updateProfile'])->name('profil.update');
    Route::post('/profil/change-password', [ProfileController::class, 'changePassword'])->name('profil.change-password');
    
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
