@if ($paginator->hasPages())
    <nav aria-label="Page navigation example">
        <ul class="flex items-center -space-x-px h-8 text-sm">
            {{-- Previous Page Link --}}
            <li>
                <a href="{{ $paginator->previousPageUrl() }}" data-page="{{ $paginator->currentPage() - 1 }}"
                    class="pagination-link flex items-center justify-center px-3 h-8 ms-0 leading-tight 
                          {{ $paginator->onFirstPage() ? 'text-gray-500 bg-white border border-e-0 border-gray-300 cursor-default' : 'text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700' }} 
                          rounded-s-lg">
                    <span class="sr-only">Previous</span>
                    <svg class="w-2.5 h-2.5 rtl:rotate-180" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M5 1 1 5l4 4" />
                    </svg>
                </a>
            </li>

            {{-- Pagination Elements --}}
            @foreach ($elements as $element)
                @if (is_string($element))
                    <li class="disabled"><span class="px-3 h-8 leading-tight text-gray-500">{{ $element }}</span>
                    </li>
                @endif
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        <li>
                            <a href="{{ $url }}" data-page="{{ $page }}"
                                class="pagination-link flex items-center justify-center px-3 h-8 leading-tight {{ $page == $paginator->currentPage() ? 'text-blue-600 bg-blue-50 border border-blue-300' : 'text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700' }}">
                                {{ $page }}
                            </a>
                        </li>
                    @endforeach
                @endif
            @endforeach

            {{-- Next Page Link --}}
            <li>
                <a href="{{ $paginator->nextPageUrl() }}" data-page="{{ $paginator->currentPage() + 1 }}"
                    class="pagination-link flex items-center justify-center px-3 h-8 leading-tight 
                          {{ $paginator->hasMorePages() ? 'text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700' : 'text-gray-500 bg-white border border-gray-300 cursor-default' }} 
                          rounded-e-lg">
                    <span class="sr-only">Next</span>
                    <svg class="w-2.5 h-2.5 rtl:rotate-180" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                </a>
            </li>
        </ul>
    </nav>
@endif
