@if ($paginator->hasPages())
    <nav aria-label="Page navigation example">
        <ul class="flex items-center -space-x-px h-8 text-sm">
            {{-- Previous Page Link --}}
            <li>
                <a href="{{ $paginator->previousPageUrl() }}"
                    class="flex items-center justify-center px-3 h-8 ms-0 leading-tight 
                          {{ $paginator->onFirstPage() ? 'text-gray-500 bg-light dark:bg-dark border border-e-0 border-gray-300 cursor-default' : 'text-gray-500 bg-light dark:bg-dark border border-gray-300 hover:bg-gray-100 hover:text-gray-700' }} 
                          rounded-s-lg">
                    <span class="sr-only">Previous</span>
                    <svg class="w-2.5 h-2.5 rtl:rotate-180" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M5 1 1 5l4 4" />
                    </svg>
                </a>
            </li>

            {{-- Pagination Elements --}}
            @foreach ($elements as $element)
                {{-- "Three Dots" Separator --}}
                @if (is_string($element))
                    <li class="disabled"><span class="px-3 h-8 leading-tight text-gray-500">{{ $element }}</span>
                    </li>
                @endif

                {{-- Array Of Links --}}
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
                            <li>
                                <a href="{{ $url }}" aria-current="page"
                                    class="z-10 flex items-center justify-center px-3 h-8 leading-tight 
                                          text-primary border bg-green-200 dark:bg-gray-700 dark:text-light hover:bg-green-200">
                                    {{ $page }}
                                </a>
                            </li>
                        @elseif ($page <= 3 || $page == $paginator->lastPage())
                            <li>
                                <a href="{{ $url }}"
                                    class="flex items-center justify-center px-3 h-8 leading-tight 
                                          text-gray-500 bg-light dark:bg-dark border border-gray-300 hover:bg-gray-100 hover:text-gray-700">
                                    {{ $page }}
                                </a>
                            </li>
                        @elseif ($page == 4 && $paginator->lastPage() > 4)
                            <li class="disabled"><span class="px-3 h-8 leading-tight text-gray-500  ">...</span></li>
                        @endif
                    @endforeach
                @endif
            @endforeach

            {{-- Next Page Link --}}
            <li>
                <a href="{{ $paginator->nextPageUrl() }}"
                    class="flex items-center justify-center px-3 h-8 leading-tight 
                          {{ $paginator->hasMorePages() ? 'text-gray-500 bg-light dark:bg-dark border border-gray-300 hover:bg-gray-100 hover:text-gray-700' : 'text-gray-500 bg-light dark:bg-dark border border-gray-300 cursor-default' }} 
                          rounded-e-lg">
                    <span class="sr-only">Next</span>
                    <svg class="w-2.5 h-2.5 rtl:rotate-180" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 6 10">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="m1 9 4-4-4-4" />
                    </svg>
                </a>
            </li>
        </ul>
    </nav>
@endif
