<title>Periode Wali Kelas</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="mb-4">
            <h1>
                <div class="flex gap-2">
                    <i class="fa-solid fa-user-clock text-3xl mt-1 font-bold"></i>
                    <div>
                        <p class="text-xl sm:text-2xl font-bold">Periode Wali Kelas</p>
                        <p class="text-xs sm:text-sm ms-[1px] -mt-1">Index</p>
                    </div>
                </div>
            </h1>
        </div>

        <div class="md:flex md:items-start md:gap-4">
            {{-- Add Data --}}
            <div
                class="md:w-[35%] w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary md:block ">
                <div class="flex items-center gap-1 font-semibold">
                    <i class="{{ $waliKelasPeriodeEdit ? 'bi bi-pencil' : 'bi bi-plus-lg' }}"></i>
                    <p>{{ $waliKelasPeriodeEdit ? 'Edit Data' : 'Tambah Data' }}</p>
                </div>

                @if ($waliKelasPeriodeEdit)
                    <form action="{{ route('wali-kelas-periode.update', $waliKelasPeriodeEdit->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                    @else
                        <form action="{{ route('wali-kelas-periode.store') }}" method="POST">
                            @csrf
                @endif
                @php
                    // Prioritas: old() > data edit (thn_ajaran_awal/akhir) > tahun ajaran aktif
                    $selectedTahunAjaran = old('tahun_ajaran');
                    
                    if (!$selectedTahunAjaran && isset($waliKelasPeriodeEdit)) {
                        $selectedTahunAjaran = $waliKelasPeriodeEdit->thn_ajaran_awal . '/' . $waliKelasPeriodeEdit->thn_ajaran_akhir;
                    }
                    
                    // Jika tidak ada old() dan tidak ada edit, cari tahun ajaran aktif
                    if (!$selectedTahunAjaran) {
                        $tahunAjaranAktif = $dataTahunAjaran->firstWhere('status', 'Aktif');
                        if ($tahunAjaranAktif) {
                            $selectedTahunAjaran = $tahunAjaranAktif->tahun_awal . '/' . $tahunAjaranAktif->tahun_akhir;
                        }
                    }
                @endphp

                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Tahun Ajaran</x-label>
                    <x-select name="tahun_ajaran" tabindex="5"
                        class="{{ $errors->first('tahun_ajaran') ? 'border-red-500' : '' }}">
                        <option value="" disabled {{ !$selectedTahunAjaran ? 'selected' : '' }}>-- Pilih Tahun Ajaran --</option>
                        @forelse($dataTahunAjaran as $tahunAjaran)
                            @php
                                $value = $tahunAjaran->tahun_awal . '/' . $tahunAjaran->tahun_akhir;
                            @endphp
                            <option value="{{ $value }}" {{ $value === $selectedTahunAjaran ? 'selected' : '' }}>
                                {{ $value }}
                                {{-- @if($tahunAjaran->status === 'Aktif')
                                    <span>(Aktif)</span>
                                @endif --}}
                            </option>
                        @empty
                            <option value="" disabled>Tidak ada data tahun ajaran</option>
                        @endforelse
                    </x-select>
                    <x-message>{{ $errors->first('tahun_ajaran') }}</x-message>
                </div>
                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Kelas</x-label>
                    <x-select name="kelas_id" tabindex="2"
                        class="{{ $errors->first('kelas_id') ? 'border-red-500' : '' }}">
                        <option value="" selected disabled>-- Pilih Kelas --</option>
                        @forelse($dataKelas as $class)
                            <option value="{{ $class->id }}"
                                {{ old('kelas_id', $waliKelasPeriodeEdit->kelas_id ?? '') == $class->id ? 'selected' : '' }}>
                                {{ $class->nama_kelas_nomor }}{{ $class->nama_kelas_sub ?? '' }}
                            </option>
                        @empty
                            <option value="" disabled>Tidak ada data kelas</option>
                        @endforelse
                    </x-select>
                    <x-message>{{ $errors->first('kelas_id') }}</x-message>
                </div>
                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Wali Kelas</x-label>
                    <x-select name="wali_kelas_id" tabindex="3  "
                        class="{{ $errors->first('wali_kelas_id') ? 'border-red-500' : '' }}">
                        <option value="" selected disabled>-- Pilih Wali Kelas --</option>
                        @forelse($dataWaliKelas as $class)
                            <option value="{{ $class->id }}"
                                {{ old('wali_kelas_id', $waliKelasPeriodeEdit->wali_kelas_id ?? '') == $class->id ? 'selected' : '' }}>
                                {{ $class->nama_guru }}
                            </option>
                        @empty
                            <option value="" disabled>Tidak ada data wali kelas</option>
                        @endforelse
                    </x-select>
                    <x-message>{{ $errors->first('wali_kelas_id') }}</x-message>
                </div>
                <div class="flex justify-end gap-2">
                    @if ($waliKelasPeriodeEdit)
                        <a href="{{ route('wali-kelas-periode.index') }}"
                            class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                            <i class="fa-solid fa-times"></i> Batal
                        </a>
                    @else
                        <div></div>
                    @endif
                    <x-btn-save tabindex="4">
                        <div class="flex items-center gap-1 font-medium">
                            <i class="fa-solid fa-floppy-disk"></i>
                            <p>{{ $waliKelasPeriodeEdit ? 'Update' : 'Simpan' }}</p>
                        </div>
                    </x-btn-save>
                </div>
                </form>
            </div>

            {{-- Detail Data --}}
            <div
                class="md:w-[65%] w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary mt-5 md:mt-0 max-h-[75vh] overflow-y-auto minimal-scroll">
                <form action="#" method="GET" class="inline mt-4">
                    <div class="md:flex justify-between items-center">
                        <div class="flex items-center gap-2">
                            <select name="per_page" id="per_page" onchange="this.form.submit()"
                                class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50">
                                <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20</option>
                                <option value="30" {{ request('per_page') == 30 ? 'selected' : '' }}>30</option>
                                <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                        </div>
                        <div class="flex items-center gap-1 md:mt-0 mt-3">
                            <div class="relative inline-block w-full">
                                <x-search-i></x-search-i>
                                <x-search placeholder="Pencarian..." name="search"
                                    class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                    value="{{ request('search') }}" />
                            </div>
                        </div>
                    </div>
                </form>
                <div class="mb-2 mt-3">
                    <div class="overflow-x-auto">
                        <x-table>
                            <x-thead>
                                <tr>
                                    <x-th class="whitespace-nowrap w-14">No.</x-th>
                                    <x-th class="whitespace-nowrap">Tahun Ajaran</x-th>
                                    <x-th class="whitespace-nowrap">Kelas</x-th>
                                    <x-th class="whitespace-nowrap">Wali Kelas</x-th>
                                    <x-th class="whitespace-nowrap w-32">Aksi</x-th>
                                </tr>
                            </x-thead>
                            <tbody>
                                @php $no = 1; @endphp
                                @forelse ($dataWaliKelasPeriode as $data)
                                    <x-tr>
                                        <x-td class="text-center">
                                            {{ $no++ }}.
                                        </x-td>
                                        <x-td
                                            class="text-center">{{ $data->thn_ajaran_awal }}/{{ $data->thn_ajaran_akhir }}</x-td>
                                        <x-td
                                            class="text-center">{{ $data->kelas->nama_kelas_nomor }}{{ $data->kelas->nama_kelas_sub ?? '' }}</x-td>
                                        <x-td>{{ $data->waliKelas->nama_guru }}</x-td>
                                        <x-td class="text-center whitespace-nowrap">
                                            {{-- Btn Edit --}}
                                            <a href="{{ route('wali-kelas-periode.edit', $data->id) }}">
                                                <x-btn-edit></x-btn-edit>
                                            </a>
                                            {{-- Btn Delete --}}
                                            <x-btn-delete type="button"></x-btn-delete>
                                        </x-td>
                                    </x-tr>
                                @empty
                                    <x-tr>
                                        <x-td colspan="5" class="text-center text-red-600">Data periode tidak
                                            ada!</x-td>
                                    </x-tr>
                                @endforelse
                            </tbody>
                        </x-table>
                        {{-- Pagination --}}
                        <div class="flex justify-between items-center mt-3">
                            <span id="dataInfo" class="text-xs text-dark dark:text-light">
                                Menampilkan <span
                                    class="font-semibold">{{ $dataWaliKelasPeriode->firstItem() ?? 0 }}</span>
                                sampai <span class="font-semibold">{{ $dataWaliKelasPeriode->lastItem() ?? 0 }}</span>
                                dari <span class="font-semibold">{{ $dataWaliKelasPeriode->total() }}</span>
                                data
                            </span>
                            <div id="paginationLinks" class="inline-flex mt-2 xs:mt-0">
                                {{ $dataWaliKelasPeriode->links('vendor.pagination.costum') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>

</x-app-layout>
