<title>Wali Kelas</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="md:flex justify-between mb-4">
            <div>
                <h1>
                    <div class="flex gap-2">
                        <i class="fa-solid fa-user-tie text-3xl mt-1 font-bold"></i>
                        <div>
                            <p class="text-xl sm:text-2xl font-bold">Wali Kelas</p>
                            <p class="text-xs sm:text-sm ms-[1px] -mt-1">Index</p>
                        </div>
                    </div>
                </h1>
            </div>

            <div class="mt-3 md:mt-0">
                <button type="button" data-modal-target="addWaliKelas" data-modal-toggle="addWaliKelas"
                    class="bg-primary py-2 px-4 rounded-md text-white hover:bg-hvPrimary text-sm"><i
                        class="bi bi-plus-lg"></i> Tambah Data</button>
            </div>
        </div>

        {{-- Modal Tambah Data --}}
        <div id="addWaliKelas" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="bi bi-plus-lg"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Tambah Wali Kelas
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="addWaliKelas">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <form action="/wali-kelas" method="POST">
                        @csrf
                        <input type="hidden" name="_form" value="add">
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <x-label>NIP</x-label>
                                    <x-input name="nip" type="number" tabindex="1" value="{{ old('nip') }}"
                                        class="{{ $errors->first('nip') ? 'border-red-400' : '' }}"
                                        placeholder="Masukkan NIP..." />
                                    <x-message>{{ $errors->first('nip') }}</x-message>
                                </div>
                                <div>
                                    <x-label><span class="text-red-500">*</span>Nama Guru</x-label>
                                    <x-input name="nama_guru" type="text" tabindex="2"
                                        value="{{ old('nama_guru') }}"
                                        class="{{ $errors->first('nama_guru') ? 'border-red-400' : '' }} capitalize-input"
                                        placeholder="Masukkan nama guru..." />
                                    <x-message>{{ $errors->first('nama_guru') }}</x-message>
                                </div>
                                <div>
                                    <x-label><span class="text-red-500">*</span>Jenis Kelamin</x-label>
                                    <x-select name="jenis_kelamin" tabindex="3"
                                        class="{{ $errors->first('jenis_kelamin') ? 'border-red-500' : '' }}">
                                        <option value="" selected disabled hidden>-- Pilih Jenis Kelamin --
                                        </option>
                                        <option value="Laki-Laki"
                                            {{ old('jenis_kelamin') == 'Laki-Laki' ? 'selected' : '' }}>
                                            Laki-Laki</option>
                                        <option value="Perempuan"
                                            {{ old('jenis_kelamin') == 'Perempuan' ? 'selected' : '' }}>
                                            Perempuan</option>
                                    </x-select>
                                    <x-message>{{ $errors->first('jenis_kelamin') }}</x-message>
                                </div>
                                <div>
                                    <div class="flex items-center gap-2 mb-1">
                                        <x-label><span class="text-red-500">*</span>No. HP</x-label>
                                        <div class="relative group">
                                            <button type="button"
                                                class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300">
                                                <i class="fa-solid fa-circle-info text-sm"></i>
                                            </button>
                                            <div
                                                class="absolute left-0 top-6 hidden group-hover:block w-64 p-3 bg-blue-50 dark:bg-blue-900/90 border border-blue-200 dark:border-blue-700 rounded-lg shadow-lg z-10">
                                                <p class="text-xs text-blue-800 dark:text-blue-200 font-semibold mb-1">
                                                    <i class="fa-solid fa-key me-1"></i>Info Login
                                                </p>
                                                <p class="text-xs text-blue-700 dark:text-blue-300">
                                                    No. HP akan digunakan sebagai <span
                                                        class="font-bold">Username</span> dan <span
                                                        class="font-bold">Password</span> untuk login pertama kali.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <x-input name="no_hp" type="number" tabindex="4" value="{{ old('no_hp') }}"
                                        class="{{ $errors->first('no_hp') ? 'border-red-400' : '' }}"
                                        placeholder="Masukkan no hp..." />
                                    <x-message>{{ $errors->first('no_hp') }}</x-message>
                                </div>
                                <div class="md:col-span-2">
                                    <x-label>Email</x-label>
                                    <x-input name="email" type="email" tabindex="5" value="{{ old('email') }}"
                                        class="{{ $errors->first('email') ? 'border-red-400' : '' }}"
                                        placeholder="Masukkan email..." />
                                    <x-message>{{ $errors->first('email') }}</x-message>
                                </div>
                                <div class="md:col-span-2">
                                    <x-label>Alamat</x-label>
                                    <x-textarea name="alamat" tabindex="7" rows="3"
                                        class="{{ $errors->first('alamat') ? 'border-red-400' : '' }} capitalize-input"
                                        placeholder="Masukkan alamat...">{{ old('alamat') }}</x-textarea>
                                    <x-message>{{ $errors->first('alamat') }}</x-message>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <x-btn-save tabindex="8">
                                <div class="flex items-center gap-1 font-medium">
                                    <i class="fa-solid fa-floppy-disk"></i>
                                    <p>Simpan</p>
                                </div>
                            </x-btn-save>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- Detail Data --}}
        <div
            class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary mt-5 md:mt-0">
            <form action="#" method="GET" class="inline mt-4">
                <div class="md:flex justify-between items-center">
                    <div class="flex items-center gap-2">
                        <select name="per_page" id="per_page" onchange="this.form.submit()"
                            class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50">
                            <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20</option>
                            <option value="30" {{ request('per_page') == 30 ? 'selected' : '' }}>30</option>
                            <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                            <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100</option>
                        </select>
                    </div>
                    <div class="flex items-center gap-2 mt-3 md:mt-0">
                        <div class="relative inline-block w-full">
                            <x-search-i></x-search-i>
                            <x-search placeholder="Pencarian..." name="search"
                                class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                value="{{ request('search') }}" />
                        </div>
                    </div>
                </div>
            </form>


            <div class="mb-2 mt-3">
                <div class="overflow-x-auto">
                    <x-table>
                        <x-thead>
                            <tr>
                                <x-th class="whitespace-nowrap w-14">No.</x-th>
                                <x-th class="whitespace-nowrap">NIP</x-th>
                                <x-th class="whitespace-nowrap">Nama Guru</x-th>
                                <x-th class="whitespace-nowrap">Jenis Kelamin</x-th>
                                <x-th class="whitespace-nowrap">No. Telepon</x-th>
                                <x-th class="whitespace-nowrap">Status</x-th>
                                <x-th class="whitespace-nowrap w-32">Aksi</x-th>
                            </tr>
                        </x-thead>
                        <tbody>
                            @forelse ($dataWaliKelas as $data)
                                <x-tr>
                                    <x-td class="text-center">
                                        {{ $loop->iteration + $i }}.
                                    </x-td>
                                    <x-td class="text-center">{{ $data->nip ?? '-' }}</x-td>
                                    <x-td>{{ ucwords(strtolower($data->nama_guru)) }}</x-td>
                                    <x-td class="text-center">{{ $data->jenis_kelamin }}</x-td>
                                    <x-td class="text-center">{{ $data->no_hp ?? '-' }}</x-td>
                                    <x-td class="text-center whitespace-nowrap">
                                        @if ($data->status == 'Aktif')
                                            <span class="bg-green-500 text-white px-7 py-1 rounded-full">Aktif</span>
                                        @else
                                            <span class="bg-red-500 text-white px-3 py-1 rounded-full">Non-Aktif</span>
                                        @endif
                                    </x-td>
                                    <x-td class="text-center whitespace-nowrap">
                                        {{-- Btn Reset Password --}}
                                        <button type="button"
                                            data-modal-target="resetPasswordWaliKelas{{ $data->id }}"
                                            data-modal-toggle="resetPasswordWaliKelas{{ $data->id }}"
                                            class="text-white bg-sky-500 hover:bg-sky-600 focus:ring-4 focus:outline-none focus:ring-sky-300 font-medium rounded-lg text-sm py-2 px-3 text-center inline-flex items-center dark:bg-sky-600 dark:hover:bg-sky-700 dark:focus:ring-sky-800">
                                            <i class="fa-solid fa-key"></i>
                                        </button>
                                        {{-- Btn Edit --}}
                                        <x-btn-edit data-modal-target="editWaliKelas{{ $data->id }}"
                                            data-modal-toggle="editWaliKelas{{ $data->id }}" />
                                        {{-- Btn Delete --}}
                                        <x-btn-delete data-modal-target="deleteWaliKelas{{ $data->id }}"
                                            data-modal-toggle="deleteWaliKelas{{ $data->id }}" />
                                    </x-td>
                                </x-tr>

                                {{-- Modal Edit --}}
                                <div id="editWaliKelas{{ $data->id }}" tabindex="-1" aria-hidden="true"
                                    class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                                    <div class="relative p-4 w-full max-w-2xl max-h-full">
                                        <!-- Modal content -->
                                        <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                                            <!-- Modal header -->
                                            <div
                                                class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                                                <div class="flex items-center gap-1">
                                                    <i class="fa-solid fa-pencil"></i>
                                                    <h3 class="text-xl font-semibold text-dark dark:text-light">
                                                        Edit Wali Kelas
                                                    </h3>
                                                </div>
                                                <button type="button"
                                                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                                                    data-modal-hide="editWaliKelas{{ $data->id }}">
                                                    <svg class="w-3 h-3" aria-hidden="true"
                                                        xmlns="http://www.w3.org/2000/svg" fill="none"
                                                        viewBox="0 0 14 14">
                                                        <path stroke="currentColor" stroke-linecap="round"
                                                            stroke-linejoin="round" stroke-width="2"
                                                            d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                                    </svg>
                                                    <span class="sr-only">Close modal</span>
                                                </button>
                                            </div>
                                            <form action="/wali-kelas/{{ $data->id }}" method="POST">
                                                @csrf
                                                @method('PUT')
                                                <input type="hidden" name="_form" value="edit">
                                                <input type="hidden" name="_id" value="{{ $data->id }}">
                                                <!-- Modal body -->
                                                <div class="p-4 md:p-5">
                                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 -mt-5">
                                                        <div>
                                                            <x-label>NIP</x-label>
                                                            <x-input name="nip" type="text" tabindex="1"
                                                                value="{{ old('nip', $data->nip) }}"
                                                                class="{{ $errors->first('nip') ? 'border-red-400' : '' }}"
                                                                placeholder="Masukkan NIP..." />
                                                            <x-message>{{ $errors->first('nip') }}</x-message>
                                                        </div>
                                                        <div>
                                                            <x-label><span class="text-red-500">*</span>Nama
                                                                Guru</x-label>
                                                            <x-input name="nama_guru" type="text" tabindex="2"
                                                                value="{{ old('nama_guru', $data->nama_guru) }}"
                                                                class="{{ $errors->first('nama_guru') ? 'border-red-400' : '' }} capitalize-input"
                                                                placeholder="Masukkan nama guru..." />
                                                            <x-message>{{ $errors->first('nama_guru') }}</x-message>
                                                        </div>
                                                        <div>
                                                            <x-label><span class="text-red-500">*</span>Jenis
                                                                Kelamin</x-label>
                                                            <x-select name="jenis_kelamin" tabindex="3"
                                                                class="{{ $errors->first('jenis_kelamin') ? 'border-red-500' : '' }}"
                                                                required>
                                                                <option value="" selected disabled>-- Pilih Jenis
                                                                    Kelamin --
                                                                </option>
                                                                <option value="Laki-Laki"
                                                                    {{ old('jenis_kelamin', $data->jenis_kelamin) == 'Laki-Laki' ? 'selected' : '' }}>
                                                                    Laki-Laki</option>
                                                                <option value="Perempuan"
                                                                    {{ old('jenis_kelamin', $data->jenis_kelamin) == 'Perempuan' ? 'selected' : '' }}>
                                                                    Perempuan</option>
                                                            </x-select>
                                                            <x-message>{{ $errors->first('jenis_kelamin') }}</x-message>
                                                        </div>
                                                        <div>
                                                            <div class="flex items-center gap-2 mb-1">
                                                                <x-label><span class="text-red-500">*</span>No.
                                                                    HP</x-label>
                                                                <div class="relative group">
                                                                    <button type="button"
                                                                        class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300">
                                                                        <i class="fa-solid fa-circle-info text-sm"></i>
                                                                    </button>
                                                                    <div
                                                                        class="absolute left-0 top-6 hidden group-hover:block w-64 p-3 bg-blue-50 dark:bg-blue-900/90 border border-blue-200 dark:border-blue-700 rounded-lg shadow-lg z-10">
                                                                        <p
                                                                            class="text-xs text-blue-800 dark:text-blue-200 font-semibold mb-1">
                                                                            <i class="fa-solid fa-key me-1"></i>Info Login
                                                                        </p>
                                                                        <p class="text-xs text-blue-700 dark:text-blue-300">
                                                                            Mengubah No. HP akan mengubah <span
                                                                                class="font-bold">Username</span> untuk
                                                                            login. Password tetap sama kecuali direset.
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <x-input name="no_hp" type="number" tabindex="4"
                                                                value="{{ old('no_hp', $data->no_hp) }}"
                                                                class="{{ $errors->first('no_hp') ? 'border-red-400' : '' }}"
                                                                placeholder="Masukkan no hp..." />
                                                            <x-message>{{ $errors->first('no_hp') }}</x-message>
                                                        </div>
                                                        <div class="md:col-span-2">
                                                            <x-label>Email</x-label>
                                                            <x-input name="email" type="email" tabindex="5"
                                                                value="{{ old('email', $data->email) }}"
                                                                class="{{ $errors->first('email') ? 'border-red-400' : '' }}"
                                                                placeholder="Masukkan email..." />
                                                            <x-message>{{ $errors->first('email') }}</x-message>
                                                        </div>
                                                        <div class="md:col-span-2">
                                                            <x-label>Alamat</x-label>
                                                            <x-textarea name="alamat" tabindex="7" rows="3"
                                                                class="{{ $errors->first('alamat') ? 'border-red-400' : '' }} capitalize-input"
                                                                placeholder="Masukkan alamat...">{{ old('alamat', $data->alamat) }}</x-textarea>
                                                            <x-message>{{ $errors->first('alamat') }}</x-message>
                                                        </div>
                                                        <div class="md:col-span-2">
                                                            <x-label><span
                                                                    class="text-red-500">*</span>Status</x-label>
                                                            <x-select name="status" tabindex="6"
                                                                class="{{ $errors->first('status') ? 'border-red-500' : '' }}"
                                                                required>
                                                                <option value="Aktif"
                                                                    {{ old('status', $data->status) == 'Aktif' ? 'selected' : '' }}>
                                                                    Aktif</option>
                                                                <option value="Non-Aktif"
                                                                    {{ old('status', $data->status) == 'Non-Aktif' ? 'selected' : '' }}>
                                                                    Non-Aktif</option>
                                                            </x-select>
                                                            <x-message>{{ $errors->first('status') }}</x-message>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Modal footer -->
                                                <div
                                                    class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                                                    <x-btn-save tabindex="8">
                                                        <div class="flex items-center gap-1 font-medium">
                                                            <i class="fa-solid fa-floppy-disk"></i>
                                                            <p>Simpan</p>
                                                        </div>
                                                    </x-btn-save>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                {{-- Modal Reset Password --}}
                                <div id="resetPasswordWaliKelas{{ $data->id }}" tabindex="-1"
                                    class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                                    <div class="relative p-4 w-full max-w-md max-h-full">
                                        <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                                            <button type="button"
                                                class="absolute top-3 end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white"
                                                data-modal-hide="resetPasswordWaliKelas{{ $data->id }}">
                                                <svg class="w-3 h-3" aria-hidden="true"
                                                    xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 14 14">
                                                    <path stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="2"
                                                        d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                                </svg>
                                                <span class="sr-only">Close modal</span>
                                            </button>
                                            <div class="p-4 md:p-5 text-center">
                                                <i class="fa-solid fa-key text-sky-500 text-5xl mb-4"></i>
                                                <h3 class="mb-5 text-lg font-normal text-gray-500 dark:text-gray-400">
                                                    Apakah Anda yakin ingin mereset password untuk
                                                    <span class="font-bold">{{ $data->nama_guru }}</span>?
                                                </h3>
                                                <p class="mb-5 text-sm text-gray-600 dark:text-gray-300">
                                                    Password akan direset menjadi: <span
                                                        class="font-bold text-sky-600 dark:text-sky-400">Raport123!</span>
                                                </p>
                                                <form action="{{ route('wali-kelas.reset-password', $data->id) }}"
                                                    method="POST" class="inline">
                                                    @csrf
                                                    <button type="submit"
                                                        class="text-white bg-sky-600 hover:bg-sky-800 focus:ring-4 focus:outline-none focus:ring-sky-300 dark:focus:ring-sky-800 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center">
                                                        Ya, Reset Password
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <x-tr>
                                    <x-td colspan="7" class="text-center text-red-600">Data wali kelas tidak
                                        ada!</x-td>
                                </x-tr>
                            @endforelse
                        </tbody>
                    </x-table>
                    {{-- Pagination --}}
                    <div class="flex justify-between items-center mt-3">
                        <span id="dataInfo" class="text-xs text-dark dark:text-light">
                            Menampilkan <span class="font-semibold">{{ $dataWaliKelas->firstItem() ?? 0 }}</span>
                            sampai <span class="font-semibold">{{ $dataWaliKelas->lastItem() ?? 0 }}</span>
                            dari <span class="font-semibold">{{ $dataWaliKelas->total() }}</span>
                            data
                        </span>
                        <div id="paginationLinks" class="inline-flex mt-2 xs:mt-0">
                            {{ $dataWaliKelas->links('vendor.pagination.costum') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
    @push('js')
        {{-- Buka Modal Edit Ketika Tervalidasi --}}
        @foreach ($dataWaliKelas as $data)
            @if (
                $errors->has('nip') ||
                    $errors->has('nama_guru') ||
                    $errors->has('jenis_kelamin') ||
                    $errors->has('email') ||
                    $errors->has('no_hp') ||
                    $errors->has('alamat') ||
                    ($errors->has('status') && old('_form') === 'edit' && old('_id') == $data->id))
                <script>
                    window.onload = function() {
                        setTimeout(function() {
                            document.getElementById('editWaliKelas{{ $data->id }}').classList.remove('hidden');
                            document.getElementById('editWaliKelas{{ $data->id }}').classList.add('flex',
                                'bg-gray-800',
                                'bg-opacity-70');
                        }, 100);
                    };
                </script>
            @endif
        @endforeach

        {{-- Buka Modal Add Ketika Tervalidasi --}}
        @if (
            $errors->has('nip') ||
                $errors->has('nama_guru') ||
                $errors->has('jenis_kelamin') ||
                $errors->has('email') ||
                $errors->has('no_hp') ||
                ($errors->has('alamat') && old('_form') === 'add'))
            <script>
                window.onload = function() {
                    setTimeout(function() {
                        document.getElementById('addWaliKelas').classList.remove('hidden');
                        document.getElementById('addWaliKelas').classList.add('flex', 'bg-gray-800', 'bg-opacity-70');
                    }, 100);
                };
            </script>
        @endif
    @endpush

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Function to convert text to title case
                function toTitleCase(str) {
                    return str.replace(/\w\S*/g, function(txt) {
                        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
                    });
                }

                // Apply title case to all inputs with capitalize-input class
                const capitalizeInputs = document.querySelectorAll('.capitalize-input');

                capitalizeInputs.forEach(function(input) {
                    // Transform existing value to title case on page load
                    if (input.value) {
                        input.value = toTitleCase(input.value);
                    }

                    // Transform input on change/input events
                    input.addEventListener('input', function() {
                        this.value = toTitleCase(this.value);
                    });

                    // Also transform on blur to ensure consistency
                    input.addEventListener('blur', function() {
                        this.value = toTitleCase(this.value);
                    });
                });
            });
        </script>
    @endpush

</x-app-layout>
