<title>Tahun Ajaran</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" style="margin-bottom: 100px;" id="sectionDashboard">
        <div class="mb-4">
            <h1>
                <div class="flex gap-2">
                    <i class="fa-solid fa-calendar-days text-3xl mt-1 font-bold"></i>
                    <div>
                        <p class="text-xl sm:text-2xl font-bold">Tahun Ajaran</p>
                        <p class="text-xs sm:text-sm ms-[1px] -mt-1">Index</p>
                    </div>
                </div>
            </h1>
        </div>

        <div class="md:flex md:items-start md:gap-4">
            {{-- Add Data (Hidden on mobile) --}}
            <div
                class="md:w-[40%] w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary hidden md:block">
                <div class="flex items-center gap-1 font-semibold">
                    <i class="{{ $tahunAjaranEdit ? 'bi bi-pencil' : 'bi bi-plus-lg' }}"></i>
                    <p>{{ $tahunAjaranEdit ? 'Edit Data' : 'Tambah Data' }}</p>
                </div>

                @if ($tahunAjaranEdit)
                    <form action="{{ route('tahun-ajaran.update', $tahunAjaranEdit->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                    @else
                        <form action="{{ route('tahun-ajaran.store') }}" method="POST">
                            @csrf
                @endif
                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Tahun Awal</x-label>
                    <x-input name="tahun_awal" type="number" tabindex="1"
                        value="{{ old('tahun_awal', $tahunAjaranEdit->tahun_awal ?? '') }}"
                        class="{{ $errors->first('tahun_awal') ? 'border-red-400' : '' }}" placeholder="Contoh: 2025" />
                    <x-message>{{ $errors->first('tahun_awal') }}</x-message>
                </div>
                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Tahun Akhir</x-label>
                    <x-input name="tahun_akhir" type="number" tabindex="2"
                        value="{{ old('tahun_akhir', $tahunAjaranEdit->tahun_akhir ?? '') }}"
                        class="{{ $errors->first('tahun_akhir') ? 'border-red-400' : '' }}"
                        placeholder="Contoh: 2026" />
                    <x-message>{{ $errors->first('tahun_akhir') }}</x-message>
                </div>
                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Status</x-label>
                    <select name="status" tabindex="3"
                        class="border border-gray-400 transition rounded-lg py-2 px-3 w-full text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 {{ $errors->first('status') ? 'border-red-400' : '' }}">
                        <option value="">-- Pilih Status --</option>
                        <option value="Aktif"
                            {{ old('status', $tahunAjaranEdit->status ?? '') == 'Aktif' ? 'selected' : '' }}>Aktif
                        </option>
                        <option value="Tidak Aktif"
                            {{ old('status', $tahunAjaranEdit->status ?? '') == 'Tidak Aktif' ? 'selected' : '' }}>
                            Tidak Aktif</option>
                    </select>
                    <x-message>{{ $errors->first('status') }}</x-message>
                </div>
                <div class="flex justify-end gap-2">
                    @if ($tahunAjaranEdit)
                        <a href="{{ route('tahun-ajaran.index') }}"
                            class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                            <i class="fa-solid fa-times"></i> Batal
                        </a>
                    @else
                        <div></div>
                    @endif
                    <x-btn-save tabindex="4">
                        <div class="flex items-center gap-1 font-medium">
                            <i class="fa-solid fa-floppy-disk"></i>
                            <p>{{ $tahunAjaranEdit ? 'Update' : 'Simpan' }}</p>
                        </div>
                    </x-btn-save>
                </div>
                </form>
            </div>

            {{-- Detail Data --}}
            <div
                class="md:w-[60%] w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary mt-5 md:mt-0">
                <form action="#" method="GET" class="inline mt-4">
                    <div class="flex justify-between items-center">
                        <div class="flex items-center gap-2">
                            <select name="per_page" id="per_page" onchange="this.form.submit()"
                                class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50">
                                <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20</option>
                                <option value="30" {{ request('per_page') == 30 ? 'selected' : '' }}>30</option>
                                <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                        </div>
                        <div class="flex items-center gap-1">
                            <div class="relative inline-block w-full">
                                <x-search-i></x-search-i>
                                <x-search placeholder="Pencarian..." name="search"
                                    class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                    value="{{ request('search') }}" />
                            </div>
                        </div>
                    </div>
                </form>
                <div class="mb-2 mt-3">
                    <div class="overflow-x-auto pb-3">
                        <x-table>
                            <x-thead>
                                <tr>
                                    <x-th class="whitespace-nowrap w-14">No.</x-th>
                                    <x-th class="whitespace-nowrap ">Tahun Ajaran</x-th>
                                    <x-th class="whitespace-nowrap ">Status</x-th>
                                    <x-th class="whitespace-nowrap w-32">Aksi</x-th>
                                </tr>
                            </x-thead>
                            <tbody class="text-xs md:text-sm">
                                @forelse ($dataTahunAjaran as $data)
                                    <x-tr>
                                        <x-td class="text-center">
                                            {{ $loop->iteration + $i }}.
                                        </x-td>
                                        <x-td
                                            class="text-center">{{ $data->tahun_awal }}/{{ $data->tahun_akhir }}</x-td>
                                        <x-td class="text-center">
                                            @if ($data->status == 'Aktif')
                                                <span
                                                    class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                            @else
                                                <span
                                                    class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                            @endif
                                        </x-td>
                                        <x-td class="text-center whitespace-nowrap">
                                            {{-- Btn Edit for Desktop --}}
                                            <a href="{{ route('tahun-ajaran.edit', $data->id) }}" class="hidden md:inline-block">
                                                <x-btn-edit></x-btn-edit>
                                            </a>
                                            {{-- Btn Edit for Mobile (Modal) --}}
                                            <button type="button" onclick="openEditModal({{ $data->id }}, '{{ $data->tahun_awal }}', '{{ $data->tahun_akhir }}', '{{ $data->status }}')" 
                                                class="md:hidden inline-block py-2 px-4 rounded-md bg-yellow-400 text-dark hover:bg-yellow-300 transition">
                                                <i class="fa-solid fa-pen-to-square"></i>
                                            </button>
                                            {{-- Btn Delete --}}
                                            <x-btn-delete type="button" onclick="handleDelete({{ $data->id }}, '{{ $data->tahun_awal }}/{{ $data->tahun_akhir }}')"></x-btn-delete>
                                        </x-td>
                                    </x-tr>
                                @empty
                                    <x-tr>
                                        <x-td colspan="4" class="text-center text-red-600">Data tahun ajaran tidak
                                            ada!</x-td>
                                    </x-tr>
                                @endforelse
                            </tbody>
                        </x-table>
                        {{-- Pagination --}}
                        <div class="flex justify-between items-center mt-3">
                            <span id="dataInfo" class="text-xs text-dark dark:text-light">
                                Menampilkan <span class="font-semibold">{{ $dataTahunAjaran->firstItem() ?? 0 }}</span>
                                sampai <span class="font-semibold">{{ $dataTahunAjaran->lastItem() ?? 0 }}</span>
                                dari <span class="font-semibold">{{ $dataTahunAjaran->total() }}</span>
                                data
                            </span>
                            <div id="paginationLinks" class="inline-flex mt-2 xs:mt-0">
                                {{ $dataTahunAjaran->links('vendor.pagination.costum') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Floating Action Button for Mobile -->
        <div class="fixed bottom-6 right-6 z-50 md:hidden">
            <button type="button" onclick="openTambahModal()"
                class="w-14 h-14 rounded-full bg-primary text-white flex items-center justify-center shadow-lg hover:bg-primary-dark transition-colors duration-200">
                <i class="fa-solid fa-plus text-2xl"></i>
            </button>
        </div>
    </section>


    <!-- Modal for Mobile (Tambah) -->
    <div id="tambahModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md max-h-[90vh] overflow-y-auto">
            <div class="p-5">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold">Tambah Tahun Ajaran</h3>
                    <button type="button" onclick="closeTambahModal()" class="text-gray-500 hover:text-gray-700">
                        <i class="fa-solid fa-times text-xl"></i>
                    </button>
                </div>
                <div class="mt-2">
                    <form id="mobileTahunAjaranForm" action="{{ route('tahun-ajaran.store') }}" method="POST">
                        @csrf
                        <div class="my-3">
                            <x-label><span class="text-red-500">*</span>Tahun Awal</x-label>
                            <x-input name="tahun_awal" type="number" required
                                class="w-full {{ $errors->first('tahun_awal') ? 'border-red-400' : '' }}"
                                placeholder="Contoh: 2025" />
                            <x-message>{{ $errors->first('tahun_awal') }}</x-message>
                        </div>
                        <div class="my-3">
                            <x-label><span class="text-red-500">*</span>Tahun Akhir</x-label>
                            <x-input name="tahun_akhir" type="number" required
                                class="w-full {{ $errors->first('tahun_akhir') ? 'border-red-400' : '' }}"
                                placeholder="Contoh: 2026" />
                            <x-message>{{ $errors->first('tahun_akhir') }}</x-message>
                        </div>
                        <div class="my-3">
                            <x-label><span class="text-red-500">*</span>Status</x-label>
                            <select name="status" required
                                class="border border-gray-400 transition rounded-lg py-2 px-3 w-full text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 {{ $errors->first('status') ? 'border-red-400' : '' }}">
                                <option value="">-- Pilih Status --</option>
                                <option value="Aktif">Aktif</option>
                                <option value="Tidak Aktif">Tidak Aktif</option>
                            </select>
                            <x-message>{{ $errors->first('status') }}</x-message>
                        </div>
                        <div class="flex justify-end gap-2 mt-4">
                            <button type="button" onclick="closeTambahModal()"
                                class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg text-sm">
                                Batal
                            </button>
                            <button type="submit"
                                class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-lg text-sm flex items-center gap-1">
                                <i class="fa-solid fa-floppy-disk"></i>
                                <span>Simpan</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Validasi (Data Sudah Digunakan) -->
    <div id="validasiModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md p-6">
            <div class="text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                    <i class="fa-solid fa-exclamation-triangle text-red-600 text-2xl"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2 text-gray-900 dark:text-gray-50">Data Tidak Dapat Dihapus</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
                    Data tahun ajaran <span id="validasiTahunAjaran" class="font-semibold"></span> sudah digunakan pada data siswa atau buku raport dan tidak dapat dihapus.
                </p>
                <button type="button" onclick="closeValidasiModal()"
                    class="w-full bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-lg text-sm">
                    Tutup
                </button>
            </div>
        </div>
    </div>

    <!-- Modal Konfirmasi Delete -->
    <div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md p-6">
            <div class="text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-yellow-100 mb-4">
                    <i class="fa-solid fa-question-circle text-yellow-600 text-2xl"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2 text-gray-900 dark:text-gray-50">Konfirmasi Hapus</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
                    Apakah Anda yakin ingin menghapus data tahun ajaran <span id="deleteTahunAjaran" class="font-semibold"></span>?
                </p>
                <form id="deleteForm" method="POST" action="">
                    @csrf
                    @method('DELETE')
                    <div class="flex gap-3">
                        <button type="button" onclick="closeDeleteModal()"
                            class="flex-1 bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg text-sm">
                            Batal
                        </button>
                        <button type="submit"
                            class="flex-1 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                            Hapus
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal for Mobile (Edit) -->
    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md max-h-[90vh] overflow-y-auto">
            <div class="p-5">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold">Edit Tahun Ajaran</h3>
                    <button type="button" onclick="closeEditModal()" class="text-gray-500 hover:text-gray-700">
                        <i class="fa-solid fa-times text-xl"></i>
                    </button>
                </div>
                <div class="mt-2">
                    <form id="mobileTahunAjaranEditForm" action="" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="my-3">
                            <x-label><span class="text-red-500">*</span>Tahun Awal</x-label>
                            <x-input name="tahun_awal" id="edit_modal_tahun_awal" type="number" required
                                class="w-full {{ $errors->first('tahun_awal') ? 'border-red-400' : '' }}"
                                placeholder="Contoh: 2025" />
                            <x-message>{{ $errors->first('tahun_awal') }}</x-message>
                        </div>
                        <div class="my-3">
                            <x-label><span class="text-red-500">*</span>Tahun Akhir</x-label>
                            <x-input name="tahun_akhir" id="edit_modal_tahun_akhir" type="number" required
                                class="w-full {{ $errors->first('tahun_akhir') ? 'border-red-400' : '' }}"
                                placeholder="Contoh: 2026" />
                            <x-message>{{ $errors->first('tahun_akhir') }}</x-message>
                        </div>
                        <div class="my-3">
                            <x-label><span class="text-red-500">*</span>Status</x-label>
                            <select name="status" id="edit_modal_status" required
                                class="border border-gray-400 transition rounded-lg py-2 px-3 w-full text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 {{ $errors->first('status') ? 'border-red-400' : '' }}">
                                <option value="">-- Pilih Status --</option>
                                <option value="Aktif">Aktif</option>
                                <option value="Tidak Aktif">Tidak Aktif</option>
                            </select>
                            <x-message>{{ $errors->first('status') }}</x-message>
                        </div>
                        <div class="flex justify-end gap-2 mt-4">
                            <button type="button" onclick="closeEditModal()"
                                class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg text-sm">
                                Batal
                            </button>
                            <button type="submit"
                                class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-lg text-sm flex items-center gap-1">
                                <i class="fa-solid fa-floppy-disk"></i>
                                <span>Update</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Handle Delete Button Click
        async function handleDelete(id, tahunAjaran) {
            try {
                // Check if tahun ajaran is being used
                const response = await fetch(`/tahun-ajaran/${id}/check-usage`);
                const data = await response.json();

                if (data.used) {
                    // Show validation modal if data is being used
                    document.getElementById('validasiTahunAjaran').textContent = data.tahun_ajaran;
                    openValidasiModal();
                } else {
                    // Show delete confirmation modal if data is not being used
                    document.getElementById('deleteTahunAjaran').textContent = tahunAjaran;
                    document.getElementById('deleteForm').action = `/tahun-ajaran/${id}`;
                    openDeleteModal();
                }
            } catch (error) {
                console.error('Error checking usage:', error);
                alert('Terjadi kesalahan saat memeriksa data. Silakan coba lagi.');
            }
        }

        // Modal functions for Validasi
        function openValidasiModal() {
            document.getElementById('validasiModal').classList.remove('hidden');
            document.getElementById('validasiModal').classList.add('flex');
            document.body.style.overflow = 'hidden';
        }

        function closeValidasiModal() {
            document.getElementById('validasiModal').classList.add('hidden');
            document.getElementById('validasiModal').classList.remove('flex');
            document.body.style.overflow = 'auto';
        }

        // Modal functions for Delete
        function openDeleteModal() {
            document.getElementById('deleteModal').classList.remove('hidden');
            document.getElementById('deleteModal').classList.add('flex');
            document.body.style.overflow = 'hidden';
        }

        function closeDeleteModal() {
            document.getElementById('deleteModal').classList.add('hidden');
            document.getElementById('deleteModal').classList.remove('flex');
            document.body.style.overflow = 'auto';
        }

        // Modal functions for Tambah
        function openTambahModal() {
            document.getElementById('tambahModal').classList.remove('hidden');
            document.getElementById('tambahModal').classList.add('flex');
            document.body.style.overflow = 'hidden';
        }

        function closeTambahModal() {
            document.getElementById('tambahModal').classList.add('hidden');
            document.getElementById('tambahModal').classList.remove('flex');
            document.body.style.overflow = 'auto';
            // Reset form when closing
            document.getElementById('mobileTahunAjaranForm').reset();
        }

        // Modal functions for Edit
        function openEditModal(id, tahunAwal, tahunAkhir, status) {
            document.getElementById('editModal').classList.remove('hidden');
            document.getElementById('editModal').classList.add('flex');
            document.body.style.overflow = 'hidden';
            
            // Populate form with data
            document.getElementById('edit_modal_tahun_awal').value = tahunAwal;
            document.getElementById('edit_modal_tahun_akhir').value = tahunAkhir;
            document.getElementById('edit_modal_status').value = status;
            
            // Update form action
            const form = document.getElementById('mobileTahunAjaranEditForm');
            form.action = `/tahun-ajaran/${id}`;
        }

        function closeEditModal() {
            document.getElementById('editModal').classList.add('hidden');
            document.getElementById('editModal').classList.remove('flex');
            document.body.style.overflow = 'auto';
            // Reset form when closing
            document.getElementById('mobileTahunAjaranEditForm').reset();
        }

        // Close modal when clicking outside the modal content
        document.addEventListener('DOMContentLoaded', function() {
            const tambahModal = document.getElementById('tambahModal');
            if (tambahModal) {
                tambahModal.addEventListener('click', function(e) {
                    if (e.target === this) {
                        closeTambahModal();
                    }
                });
            }

            const editModal = document.getElementById('editModal');
            if (editModal) {
                editModal.addEventListener('click', function(e) {
                    if (e.target === this) {
                        closeEditModal();
                    }
                });
            }

            const validasiModal = document.getElementById('validasiModal');
            if (validasiModal) {
                validasiModal.addEventListener('click', function(e) {
                    if (e.target === this) {
                        closeValidasiModal();
                    }
                });
            }

            const deleteModal = document.getElementById('deleteModal');
            if (deleteModal) {
                deleteModal.addEventListener('click', function(e) {
                    if (e.target === this) {
                        closeDeleteModal();
                    }
                });
            }
        });
    </script>
</x-app-layout>
