<title>Detail Data Siswa</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16 zoom">
        <div class="mb-3 flex gap-2 items-center justify-between">
            <h1>
                <div class="flex gap-2">
                    <a href="{{ route('siswa.index') }}" class="hover:text-hvPrimary mt-1">
                        <i class="fa-solid fa-arrow-left text-2xl font-bold"></i>
                    </a>
                    <div>
                        <p class="text-2xl font-bold">Detail Data Siswa</p>
                        <p class="text-xs sm:text-sm">Index / Detail Data</p>
                    </div>
                </div>
            </h1>
        </div>

        {{-- Detail Siswa --}}
        <div class="md:flex gap-3">
            <div id="konten-1"
                class="w-full md:h-[100%] my-2 shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary">
                <div class="md:flex gap-8">
                    <div class="flex-col flex gap-2 items-center">
                        <div
                            class="relative w-32 max-w-xs overflow-hidden border aspect-[1/1] rounded-full md:aspect-[3/4] md:rounded-md">
                            <img src="{{ $siswa->foto ? asset('foto_siswa/' . $siswa->foto) : asset('img/profil.webp') }}"
                                class="absolute w-full h-full object-cover" alt="Preview">
                        </div>


                        <div>
                            <h1 class="text-lg font-bold text-center">{{ $siswa->nama_siswa }}</h1>
                            <h1 class="text-sm text-center">{{ $siswa->nis }} / {{ $siswa->nisn }}</h1>
                        </div>
                    </div>

                    <div class="mt-3 md:mt-0">
                        <div>
                            <label class="text-primary text-sm">-- Data Pribadi --</label>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-28">Jenis Kelamin</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->jenis_kelamin }}</div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-28">Tempat Lahir</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->tempat_lahir ?? '-' }}</div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-28">Tanggal Lahir</div>
                                <div class="text-sm sm:text-base">:
                                    {{ $siswa->tanggal_lahir ? $siswa->tanggal_lahir->format('d F Y') : '-' }}
                                </div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-28">Agama</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->agama }}</div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-28">No. HP Siswa</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->no_hp_siswa ?? '-' }}</div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <label class="text-primary text-sm">-- Akademik --</label>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-28">Kelas</div>
                                <div class="text-sm sm:text-base">:
                                    {{ $siswa->kelas->nama_kelas_nomor }}{{ $siswa->kelas->nama_kelas_sub ?? '' }}
                                    ({{ $siswa->kelas->nama_kelas_romawi }}{{ $siswa->kelas->nama_kelas_sub ?? '' }})
                                </div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-28">Angkatan</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->angkatan }}</div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-28">Status</div>
                                <div class="text-sm sm:text-base">:
                                    {{ $siswa->status }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-3 md:mt-0">
                        <div>
                            <label class="text-primary text-sm">-- Alamat --</label>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-36">Alamat</div>
                                <div class="flex-1 flex justify-start">
                                    <div class="text-sm sm:text-base me-1">:</div>
                                    <div class="text-sm sm:text-base">{{ $siswa->alamat ?? '-' }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <label class="text-primary text-sm">-- Data Orang Tua --</label>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-36">Nama Ayah</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->nama_ayah ?? '-' }}</div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-36">Pekerjaan Ayah</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->pekerjaanAyah->nama_pekerjaan ?? '-' }}
                                </div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-36">Nama Ibu</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->nama_ibu ?? '-' }}</div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-36">Pekerjaan Ibu</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->pekerjaanIbu->nama_pekerjaan ?? '-' }}
                                </div>
                            </div>
                            <div class="flex">
                                <div class="w-28 text-sm sm:text-base sm:w-36">No. HP Ortu</div>
                                <div class="text-sm sm:text-base">: {{ $siswa->no_hp_ortu ?? '-' }}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="border border-gray-300 dark:border-gray-600 my-4"></div>
                <div class="flex justify-end mt-5 md:mt-2">
                    <a href="{{ route('siswa.edit', $siswa->id) }}">
                        <x-btn-edit class="text-sm">
                            <span class="ms-1">Edit Data</span>
                        </x-btn-edit>
                    </a>
                </div>
            </div>
        </div>

        {{-- Rekap Nilai Siswa --}}
        @php
            // Define toRoman function once before loop
            if (!function_exists('toRoman')) {
                function toRoman($num)
                {
                    $map = [
                        'X' => 10,
                        'IX' => 9,
                        'V' => 5,
                        'IV' => 4,
                        'I' => 1,
                    ];
                    $returnValue = '';
                    foreach ($map as $roman => $int) {
                        while ($num >= $int) {
                            $returnValue .= $roman;
                            $num -= $int;
                        }
                    }
                    return $returnValue;
                }
            }
        @endphp

        @if ($nilaiData->isNotEmpty())
            @foreach ($nilaiData as $tahunAjaran => $bookHeads)
                @php
                    $ganjil = $bookHeads->where('semester', 'Ganjil')->first();
                    $genap = $bookHeads->where('semester', 'Genap')->first();
                    $angka = $ganjil->nama_kelas_nomor ?? ($genap->nama_kelas_nomor ?? '-');
                @endphp
                <div
                    class="w-full my-4 shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary">
                    {{-- Header --}}
                    <div class="mb-4">
                        <h2 class="font-bold mb-2">Rekap Nilai Kelas
                            {{ is_numeric($angka) ? toRoman((int) $angka) : '-' }}
                            ({{ $ganjil->nama_kelas_nomor ?? ($genap->nama_kelas_nomor ?? '-') }}), Tahun Ajaran
                            {{ $tahunAjaran }}</h2>
                    </div>

                    {{-- Tabs --}}
                    <div class="mb-4">
                        <div class="flex flex-wrap gap-2 border-b border-gray-300 dark:border-gray-600">
                            @if ($ganjil)
                                <button class="tab-btn px-4 py-2 font-semibold border-b-2 border-primary text-primary"
                                    data-tab="ganjil-{{ $loop->index }}">
                                    Semester Ganjil
                                </button>
                            @endif
                            @if ($genap)
                                <button class="tab-btn px-4 py-2 font-semibold border-b-2 border-transparent"
                                    data-tab="genap-{{ $loop->index }}">
                                    Semester Genap
                                </button>
                            @endif
                        </div>
                    </div>

                    {{-- Tab Content Ganjil --}}
                    @if ($ganjil)
                        <div id="ganjil-{{ $loop->index }}" class="tab-content">
                            <div class="overflow-x-auto">
                                <table class="w-full text-sm text-left border border-gray-300 dark:border-gray-600">
                                    <thead class="text-xs uppercase bg-gray-200 dark:bg-opacity-10">
                                        <tr>
                                            <th scope="col"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 w-12 text-center">
                                                No</th>
                                            <th scope="col"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 w-72 text-center">
                                                Mata
                                                Pelajaran</th>
                                            <th scope="col"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 w-24 text-center">
                                                Nilai Akhir</th>
                                            <th scope="col"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center min-w-[500px] md:min-w-auto">
                                                Deskripsi
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $rowNumber = 1;
                                            // Group details by mapel_head_id
                                            $groupedDetails = $ganjil->details->groupBy('mapel_head_id');
                                        @endphp

                                        @forelse($groupedDetails as $mapelHeadId => $details)
                                            @php
                                                $firstDetail = $details->first();

                                                // Get mapel head - if detail has mapel_detail_id, get from mapelDetail->mapelHead
                                                if (
                                                    $firstDetail->mapel_detail_id &&
                                                    $firstDetail->mapelDetail &&
                                                    $firstDetail->mapelDetail->mapelHead
                                                ) {
                                                    $mapelHead = $firstDetail->mapelDetail->mapelHead;
                                                } else {
                                                    $mapelHead = $firstDetail->mapelHead;
                                                }

                                                // Check if this mapel has sub mapel (mapel_detail_id is not null)
                                                $hasSubMapel = $details
                                                    ->where('mapel_detail_id', '!=', null)
                                                    ->isNotEmpty();

                                                if ($hasSubMapel) {
                                                    // Filter only sub mapels
                                                    $subMapels = $details->where('mapel_detail_id', '!=', null);
                                                    $rowspan = $subMapels->count() + 1;
                                                } else {
                                                    $rowspan = 1;
                                                }
                                            @endphp

                                            {{-- Main Mapel Row --}}
                                            <tr
                                                class="border-b border-gray-300 dark:border-gray-700 bg-gray-50 dark:bg-gray-800 font-semibold">
                                                <td class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center align-top"
                                                    rowspan="{{ $rowspan }}">
                                                    {{ $rowNumber++ }}.
                                                </td>
                                                <td
                                                    class="px-4 py-3 border border-gray-300 dark:border-gray-600 whitespace-nowrap">
                                                    {{ $mapelHead->nama_mapel ?? '-' }}
                                                </td>
                                                <td
                                                    class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center whitespace-nowrap">
                                                    @if (!$hasSubMapel)
                                                        {{ $firstDetail->nilai_akhir ?? '-' }}
                                                    @endif
                                                </td>
                                                <td class="px-4 py-3 border border-gray-300 dark:border-gray-600">
                                                    @if (!$hasSubMapel)
                                                        {{ $firstDetail->deskripsi ?? '-' }}
                                                    @endif
                                                </td>
                                            </tr>

                                            {{-- Sub Mapel Rows --}}
                                            @if ($hasSubMapel)
                                                @foreach ($subMapels as $index => $subDetail)
                                                    <tr
                                                        class="border-b border-gray-300 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-800">
                                                        <td
                                                            class="px-4 py-3 border border-gray-300 dark:border-gray-600 pl-8 whitespace-nowrap">
                                                            {{ chr(65 + $index) }}.
                                                            {{ $subDetail->mapelDetail->nama_mapel_detail ?? '-' }}
                                                        </td>
                                                        <td
                                                            class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center whitespace-nowrap">
                                                            {{ $subDetail->nilai_akhir ?? '-' }}
                                                        </td>
                                                        <td
                                                            class="px-4 py-3 border border-gray-300 dark:border-gray-600">
                                                            {{ $subDetail->deskripsi ?? '-' }}
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endif
                                        @empty
                                            <tr>
                                                <td colspan="4"
                                                    class="px-4 py-3 text-center text-gray-500 border border-gray-300 dark:border-gray-600">
                                                    Tidak ada data nilai
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray-200 dark:bg-opacity-10 font-semibold">
                                            <td colspan="2"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-right">
                                                Jumlah Nilai Akhir
                                            </td>
                                            <td
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center whitespace-nowrap">
                                                {{ number_format($ganjil->jml_nilai_akhir) }}
                                            </td>
                                            <td class="px-4 py-3 border border-gray-300 dark:border-gray-600"></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    @endif

                    {{-- Tab Content Genap --}}
                    @if ($genap)
                        <div id="genap-{{ $loop->index }}" class="tab-content hidden">
                            <div class="overflow-x-auto">
                                <table class="w-full text-sm text-left border border-gray-300 dark:border-gray-600">
                                    <thead class="text-xs uppercase bg-gray-200 dark:bg-opacity-10">
                                        <tr>
                                            <th scope="col"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 w-12 text-center">
                                                No</th>
                                            <th scope="col"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 w-72 text-center">
                                                Mata
                                                Pelajaran</th>
                                            <th scope="col"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 w-24 text-center">
                                                Nilai Akhir</th>
                                            <th scope="col"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center min-w-[500px] md:min-w-auto">
                                                Deskripsi
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $rowNumber = 1;
                                            // Group details by mapel_head_id
                                            $groupedDetails = $genap->details->groupBy('mapel_head_id');
                                        @endphp

                                        @forelse($groupedDetails as $mapelHeadId => $details)
                                            @php
                                                $firstDetail = $details->first();

                                                // Get mapel head - if detail has mapel_detail_id, get from mapelDetail->mapelHead
                                                if (
                                                    $firstDetail->mapel_detail_id &&
                                                    $firstDetail->mapelDetail &&
                                                    $firstDetail->mapelDetail->mapelHead
                                                ) {
                                                    $mapelHead = $firstDetail->mapelDetail->mapelHead;
                                                } else {
                                                    $mapelHead = $firstDetail->mapelHead;
                                                }

                                                // Check if this mapel has sub mapel (mapel_detail_id is not null)
                                                $hasSubMapel = $details
                                                    ->where('mapel_detail_id', '!=', null)
                                                    ->isNotEmpty();

                                                if ($hasSubMapel) {
                                                    // Filter only sub mapels
                                                    $subMapels = $details->where('mapel_detail_id', '!=', null);
                                                    $rowspan = $subMapels->count() + 1;
                                                } else {
                                                    $rowspan = 1;
                                                }
                                            @endphp

                                            {{-- Main Mapel Row --}}
                                            <tr
                                                class="border-b border-gray-300 dark:border-gray-700 bg-gray-50 dark:bg-gray-800 font-semibold">
                                                <td class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center align-top"
                                                    rowspan="{{ $rowspan }}">
                                                    {{ $rowNumber++ }}.
                                                </td>
                                                <td
                                                    class="px-4 py-3 border border-gray-300 dark:border-gray-600 whitespace-nowrap">
                                                    {{ $mapelHead->nama_mapel ?? '-' }}
                                                </td>
                                                <td
                                                    class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center whitespace-nowrap">
                                                    @if (!$hasSubMapel)
                                                        {{ $firstDetail->nilai_akhir ?? '-' }}
                                                    @endif
                                                </td>
                                                <td class="px-4 py-3 border border-gray-300 dark:border-gray-600">
                                                    @if (!$hasSubMapel)
                                                        {{ $firstDetail->deskripsi ?? '-' }}
                                                    @endif
                                                </td>
                                            </tr>

                                            {{-- Sub Mapel Rows --}}
                                            @if ($hasSubMapel)
                                                @foreach ($subMapels as $index => $subDetail)
                                                    <tr
                                                        class="border-b border-gray-300 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-800">
                                                        <td
                                                            class="px-4 py-3 border border-gray-300 dark:border-gray-600 pl-8 whitespace-nowrap">
                                                            {{ chr(65 + $index) }}.
                                                            {{ $subDetail->mapelDetail->nama_mapel_detail ?? '-' }}
                                                        </td>
                                                        <td
                                                            class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center whitespace-nowrap">
                                                            {{ $subDetail->nilai_akhir ?? '-' }}
                                                        </td>
                                                        <td
                                                            class="px-4 py-3 border border-gray-300 dark:border-gray-600">
                                                            {{ $subDetail->deskripsi ?? '-' }}
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endif
                                        @empty
                                            <tr>
                                                <td colspan="4"
                                                    class="px-4 py-3 text-center text-gray-500 border border-gray-300 dark:border-gray-600">
                                                    Tidak ada data nilai
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray-200 dark:bg-opacity-10 font-semibold">
                                            <td colspan="2"
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-right">
                                                Jumlah Nilai Akhir
                                            </td>
                                            <td
                                                class="px-4 py-3 border border-gray-300 dark:border-gray-600 text-center whitespace-nowrap">
                                                {{ number_format($genap->jml_nilai_akhir) }}
                                            </td>
                                            <td class="px-4 py-3 border border-gray-300 dark:border-gray-600"></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    @endif
                </div>
            @endforeach
        @else
            <div
                class="w-full my-4 shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary">
                <p class="text-center text-gray-500">Belum ada data nilai untuk siswa ini</p>
            </div>
        @endif
    </section>

    {{-- Tab Switching Script --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const tabButtons = document.querySelectorAll('.tab-btn');

            tabButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const targetTab = this.getAttribute('data-tab');
                    const parentContainer = this.closest('.shadow');

                    // Hide all tab contents in this container
                    parentContainer.querySelectorAll('.tab-content').forEach(content => {
                        content.classList.add('hidden');
                    });

                    // Remove active state from all buttons in this container
                    parentContainer.querySelectorAll('.tab-btn').forEach(btn => {
                        btn.classList.remove('border-primary', 'text-primary');
                        btn.classList.add('border-transparent');
                    });

                    // Show target tab content
                    document.getElementById(targetTab).classList.remove('hidden');

                    // Add active state to clicked button
                    this.classList.add('border-primary', 'text-primary');
                    this.classList.remove('border-transparent');
                });
            });
        });
    </script>
</x-app-layout>
