<title>Riwayat Kenaikan Siswa</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="md:flex justify-between mb-4">
            <div>
                <h1>
                    <div class="flex gap-2 items-start">
                        <a href="{{ route('siswa.index') }}" class="mt-1 hover:text-hvPrimary">
                            <i class="fa-solid fa-arrow-left text-xl"></i>
                        </a>
                        <div>
                            <p class="text-xl sm:text-2xl font-bold">Riwayat Kenaikan Siswa</p>
                            <p class="text-xs sm:text-sm ms-[1px]">Index / Riwayat</p>
                        </div>
                    </div>
                </h1>
            </div>
            <div class="mt-3 md:mt-0 md:text-end">
                <h1 class="font-semibold text-sm md:text-base">Disimpan Pada:</h1>
                <h1 class="text-sm md:text-base">{{ $latestRiwayat?->created_at?->locale('id')->translatedFormat('d F Y') ?? '-' }}</h1>
            </div>
        </div>

        {{-- Modal Konfirmasi Pemulihan Data --}}
        <form action="{{ route('siswa.restore') }}" method="POST">
            @csrf
            <div id="konfirmasiPemulihanData" tabindex="-1" aria-hidden="true"
                class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                <div class="relative p-4 w-full max-w-2xl max-h-full">
                    <!-- Modal content -->
                    <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                        <!-- Modal header -->
                        <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                            <div class="flex items-center gap-1">
                                <i class="fa-solid fa-clock-rotate-left"></i>
                                <h3 class="text-xl font-semibold text-dark dark:text-light">
                                    Pemulihan Data
                                </h3>
                            </div>
                            <button type="button"
                                class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                                data-modal-hide="konfirmasiPemulihanData">
                                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                                    viewBox="0 0 14 14">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                </svg>
                                <span class="sr-only">Close modal</span>
                            </button>
                        </div>
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="w-full">
                                <div class="text-center">
                                    <h1 class="text-red-600 dark:text-red-400 text-center font-bold text-xl">PERHATIAN!
                                    </h1>
                                    <p>
                                        Apakah anda yakin ingin memulihkan atau mengembalikan data riwayat siswa ini?
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <button type="submit"
                                class="text-white bg-primary hover:bg-hvPrimary rounded-lg border border-primary text-sm w-full sm:w-auto px-4 py-2 text-center">
                                Konfirmasi <i class="fa-solid fa-right-from-bracket"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

        {{-- Modal Validasi Pemulihan Data --}}
        <div id="validasiPemulihanData" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="fa-solid fa-clock-rotate-left"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Pemulihan Data
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="validasiPemulihanData">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <!-- Modal body -->
                    <div class="p-4 md:p-5">
                        <div class="w-full">
                            <div class="text-center">
                                <h1 class="text-red-600 dark:text-red-400 text-center font-bold text-xl">PERHATIAN!
                                </h1>
                                <p>
                                    Data riwayat siswa ini tidak dapat dikembalikan dikarenakan data tersebut sudah digunakan untuk pendataan raport pada tahun ajaran saat ini!
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b"></div>
                </div>
            </div>
        </div>

        <div
            class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary">
            <form action="{{ route('siswa.riwayat') }}" method="GET" class="inline mt-4">
                <div class="md:flex justify-between items-center">
                    <div class="flex items-center gap-2">
                        <select name="per_page" id="per_page" onchange="this.form.submit()"
                            class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50">
                            <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20</option>
                            <option value="30" {{ request('per_page') == 30 ? 'selected' : '' }}>30</option>
                            <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                            <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100</option>
                        </select>
                        @if ($hasRaportConflict)
                            <button type="button" data-modal-target="validasiPemulihanData"
                                data-modal-toggle="validasiPemulihanData"
                                class="flex items-center gap-1 px-5 py-2 bg-primary text-txLight hover:bg-hvPrimary text-light transition rounded-lg text-sm"><i
                                    class="fa-solid fa-clock-rotate-left"></i> Kembalikan Data</button>
                        @else
                            <button type="button" data-modal-target="konfirmasiPemulihanData"
                                data-modal-toggle="konfirmasiPemulihanData"
                                class="flex items-center gap-1 px-5 py-2 bg-primary text-txLight hover:bg-hvPrimary text-light transition rounded-lg text-sm"><i
                                    class="fa-solid fa-clock-rotate-left"></i> Kembalikan Data</button>
                        @endif
                    </div>
                    <div class="flex items-center gap-2 mt-3 md:mt-0">
                        <div>
                            <a href="/siswa/riwayat"
                                class="border border-gray-400 hover:bg-primary hover:text-light hover:border-transparent transition rounded-lg py-2 px-4 text-sm flex items-center">
                                <i class="fa-solid fa-arrows-rotate text-sm"></i>
                            </a>
                        </div>
                        <div>
                            <button type="button" id="btnFilters"
                                class="border border-gray-400 hover:bg-primary hover:text-light hover:border-transparent transition rounded-lg py-2 px-5 text-sm flex items-center gap-1 whitespace-nowrap">
                                <i class="fa-solid fa-filter"></i>
                                <span class="hidden md:block">Filter</span>
                            </button>
                        </div>
                        <div class="relative inline-block w-full">
                            <x-search-i></x-search-i>
                            <x-search placeholder="Cari Nama / NIS / NISN..." name="searchNamaSiswa"
                                class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                value="{{ request('searchNamaSiswa') }}" />
                        </div>
                    </div>
                </div>
                <div id="formFilters" class="mt-5 hidden">
                    <div class="border border-gray-400 border-dashed mb-5"></div>
                    <div class="overflow-x-auto lg:overflow-x-auto scrollbar-hide">
                        <div class="flex gap-3 items-end w-max lg:w-full">
                            <div class="w-full">
                                <x-label>Jenis Kelamin</x-label>
                                <x-select name="selectJenisKelamin" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectJenisKelamin') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Jenis Kelamin --</option>
                                    @foreach ($jenisKelaminOptions as $jk)
                                        <option value="{{ $jk }}"
                                            {{ request('selectJenisKelamin') == $jk ? 'selected' : '' }}>
                                            {{ $jk }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectJenisKelamin') }}</x-message>
                            </div>
                            <div class="w-full">
                                <x-label>Kelas</x-label>
                                <x-select name="selectKelas" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectKelas') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Kelas --</option>
                                    @foreach ($kelasOptions as $kelas)
                                        <option value="{{ $kelas->id }}"
                                            {{ request('selectKelas') == $kelas->id ? 'selected' : '' }}>
                                            {{ $kelas->nama_kelas_nomor }}{{ $kelas->nama_kelas_sub ?? '' }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectKelas') }}</x-message>
                            </div>
                            {{-- <div class="w-full">
                                <x-label>Wali Kelas</x-label>
                                <x-select name="waliKelasSelect" onchange="this.form.submit()"
                                    class="{{ $errors->first('waliKelasSelect') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Wali Kelas --</option>
                                    @foreach ($waliKelasOptions as $waliKelas)
                                        <option value="{{ $waliKelas->id }}"
                                            {{ request('waliKelasSelect') == $waliKelas->id ? 'selected' : '' }}>
                                            {{ $waliKelas->nama_guru }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('waliKelasSelect') }}</x-message>
                            </div> --}}
                            <div class="w-full">
                                <x-label>Angkatan</x-label>
                                <x-select name="selectAngkatan" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectAngkatan') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Angkatan --</option>
                                    @foreach ($angkatanOptions as $angkatan)
                                        <option value="{{ $angkatan }}"
                                            {{ request('selectAngkatan') == $angkatan ? 'selected' : '' }}>
                                            {{ $angkatan }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectAngkatan') }}</x-message>
                            </div>
                            <div class="w-full">
                                <x-label>Status Aktif</x-label>
                                <x-select name="selectStatus" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectStatus') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Status --</option>
                                    @foreach ($statusOptions as $status)
                                        <option value="{{ $status }}"
                                            {{ request('selectStatus') == $status ? 'selected' : '' }}>
                                            {{ $status }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectStatus') }}</x-message>
                            </div>
                            <div class="w-full">
                                <x-label>Status Kenaikan</x-label>
                                <x-select name="selectStatusKenaikan" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectStatusKenaikan') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Status --</option>
                                    @foreach ($statusKenaikanOptions as $statusKenaikan)
                                        <option value="{{ $statusKenaikan }}"
                                            {{ request('selectStatusKenaikan') == $statusKenaikan ? 'selected' : '' }}>
                                            {{ $statusKenaikan }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectStatusKenaikan') }}</x-message>
                            </div>
                        </div>
                    </div>

                </div>
            </form>

            <div class="mb-2 mt-5">
                <div class="overflow-x-auto">
                    <x-table>
                        <x-thead>
                            <tr>
                                <x-th class="whitespace-nowrap w-14">No.</x-th>
                                <x-th class="whitespace-nowrap">NISN</x-th>
                                <x-th class="whitespace-nowrap">Nama Siswa</x-th>
                                <x-th class="whitespace-nowrap">Jenis Kelamin</x-th>
                                <x-th class="whitespace-nowrap">Kelas</x-th>
                                <x-th class="whitespace-nowrap">Tahun Ajaran</x-th>
                                {{-- <x-th class="whitespace-nowrap">Wali Kelas</x-th> --}}
                                <x-th class="whitespace-nowrap">Angkatan</x-th>
                                <x-th class="whitespace-nowrap">Status</x-th>
                                {{-- <x-th class="whitespace-nowrap">Keterangan Kenaikan</x-th> --}}
                            </tr>
                        </x-thead>
                        <tbody>
                            @forelse ($riwayatSiswa as $item)
                                <x-tr>
                                    <x-td class="text-center">{{ $loop->iteration + $i }}.</x-td>
                                    <x-td class="text-center">{{ $item->siswa->nisn }}</x-td>
                                    <x-td>{{ optional($item->siswa)->nama_siswa ?? '-' }}</x-td>
                                    <x-td class="text-center">{{ $item->siswa->jenis_kelamin }}</x-td>
                                    <x-td class="text-center">
                                        @php
                                            $kelasNomor =
                                                $item->kelas?->nama_kelas_nomor ??
                                                ($item->siswa?->kelas->nama_kelas_nomor ?? '-');
                                            $kelasSub =
                                                $item->kelas?->nama_kelas_sub ??
                                                ($item->siswa?->kelas->nama_kelas_sub ?? '');
                                        @endphp
                                        {{ $kelasNomor }}{{ $kelasSub }}
                                    </x-td>
                                    <x-td
                                        class="text-center">{{ $item->thn_ajaran_awal }}/{{ $item->thn_ajaran_akhir }}</x-td>
                                    {{-- @php
                                        $namaWaliKelas = $item->nama_wali_kelas ?? $item->siswa?->nama_wali_kelas;
                                    @endphp
                                    @if ($namaWaliKelas)
                                        <x-td>{{ $namaWaliKelas }}</x-td>
                                    @else
                                        <x-td class="text-center text-red-600">
                                            <a href="/wali-kelas-periode" class="hover:underline">Belum di set!</a>
                                        </x-td>
                                    @endif --}}
                                    <x-td class="text-center">{{ $item->siswa->angkatan }}</x-td>
                                    <x-td class="text-center py-2">
                                        @if ($item->status === 'Aktif')
                                            <span
                                                class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                        @elseif ($item->status === 'Non-Aktif')
                                            <span
                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                        @else
                                            <span
                                                class="bg-gray-500 text-white px-6 py-1 rounded-full whitespace-nowrap">Alumni</span>
                                        @endif
                                    </x-td>
                                    {{-- <x-td class="text-center">
                                        @if ($item->keterangan_kenaikan)
                                            <span
                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">{{ $item->keterangan_kenaikan }}</span>
                                        @else
                                            @php
                                                $kelasNomor =
                                                    $item->kelas?->nama_kelas_nomor ??
                                                    ($item->siswa?->kelas->nama_kelas_nomor ?? null);
                                            @endphp
                                            @if ($kelasNomor == 9)
                                                <span
                                                    class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Lulus</span>
                                            @elseif (in_array($kelasNomor, [7, 8]))
                                                <span
                                                    class="bg-green-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Naik
                                                    Kelas</span>
                                            @else
                                                -
                                            @endif
                                        @endif
                                    </x-td> --}}
                                </x-tr>
                            @empty
                                <x-tr>
                                    <x-td colspan="9" class="text-center text-red-600">Riwayat kenaikan belum
                                        tersedia!</x-td>
                                </x-tr>
                            @endforelse
                        </tbody>
                    </x-table>

                    <div class="flex justify-between items-center mt-3">
                        <span id="dataInfo" class="text-xs text-dark dark:text-light">
                            Menampilkan <span class="font-semibold">{{ $riwayatSiswa->firstItem() ?? 0 }}</span>
                            sampai <span class="font-semibold">{{ $riwayatSiswa->lastItem() ?? 0 }}</span>
                            dari <span class="font-semibold">{{ $riwayatSiswa->total() }}</span>
                            data
                        </span>
                        <div id="paginationLinks" class="inline-flex mt-2 xs:mt-0">
                            {{ $riwayatSiswa->links('vendor.pagination.costum') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const btnFilters = document.getElementById('btnFilters');
                const formFilters = document.getElementById('formFilters');

                // Cek URL saat halaman dimuat
                const currentUrl = window.location.href;
                if (currentUrl.includes('siswa/riwayat?')) {
                    formFilters.classList.remove('hidden');
                    btnFilters.classList.add('bg-primary', 'text-light', 'border-transparent');
                } else if (currentUrl.includes('siswa/riwayat')) {
                    formFilters.classList.add('hidden');
                    btnFilters.classList.remove('bg-primary', 'text-light', 'border-transparent');
                }

                // Event klik tombol
                btnFilters.addEventListener('click', function() {
                    // Toggle class pada tombol
                    this.classList.toggle('bg-primary');
                    this.classList.toggle('text-light');
                    this.classList.toggle('border-transparent');

                    // Toggle class hidden pada form
                    formFilters.classList.toggle('hidden');
                });
            });
        </script>
    @endpush
</x-app-layout>
