<title>Data Siswa</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" style="margin-bottom: 100px;" id="sectionDashboard">
        {{-- Alert Success/Error/Warning --}}
        {{-- @if (session('successNotif'))
            <div class="p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400"
                role="alert">
                <span class="font-medium">Berhasil!</span> {{ session('successNotif') }}
            </div>
        @endif

        @if (session('errorNotif'))
            <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400"
                role="alert">
                <span class="font-medium">Error!</span> {{ session('errorNotif') }}
            </div>
        @endif

        @if (session('warningNotif'))
            <div class="p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-400"
                role="alert">
                <span class="font-medium">Peringatan!</span> {{ session('warningNotif') }}
                @if (session('importErrors'))
                    <ul class="mt-2 ml-4 list-disc list-inside">
                        @foreach (session('importErrors') as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif
            </div>
        @endif --}}

        <div class="md:flex justify-between mb-4">
            <div>
                <h1>
                    <div class="flex gap-2">
                        <i class="fa-solid fa-user-graduate text-3xl mt-1 font-bold"></i>
                        <div>
                            <p class="text-xl sm:text-2xl font-bold">Data Siswa</p>
                            <p class="text-xs sm:text-sm ms-[1px] -mt-1">Index</p>
                        </div>
                    </div>
                </h1>
            </div>

            <div class="mt-3 md:mt-0 items-center gap-2 hidden md:flex">
                <a href="{{ route('pekerjaan.index') }}"
                    class="bg-primary py-2 px-2 md:px-4 rounded-md text-white hover:bg-hvPrimary text-xs md:text-sm">
                    <i class="bi bi-plus-lg"></i> Pekerjaan Ortu
                </a>
                <a href="{{ route('siswa.create') }}"
                    class="bg-primary py-2 px-2 md:px-4 rounded-md inline-block text-white hover:bg-hvPrimary text-xs md:text-sm">
                    <i class="bi bi-plus-lg"></i> Tambah Siswa
                </a>
                
                <!-- Dropdown Excel -->
                <div class="relative">
                    <button type="button" id="dropdownExcelButton"
                        class="whitespace-nowrap inline-flex items-center px-2 md:px-5 py-2 bg-primary text-white text-xs md:text-sm rounded-md hover:bg-hvPrimary">
                        <i class="fa-solid fa-file-excel mr-2"></i> Excel
                        <i class="fa-solid fa-chevron-down ml-2 text-xs"></i>
                    </button>
                    
                    <!-- Dropdown Menu -->
                    <div id="dropdownExcelMenu"
                        class="hidden absolute right-0 mt-2 w-48 bg-white dark:bg-gray-800 rounded-lg shadow-lg border border-gray-200 dark:border-gray-600 z-10">
                        <button type="button" data-modal-target="importSiswaModal" data-modal-toggle="importSiswaModal"
                            class="w-full text-left px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-t-lg flex items-center gap-2">
                            <i class="fa-solid fa-file-import text-green-600"></i>
                            <span>Import Excel</span>
                        </button>
                        <a href="{{ route('siswa.export') }}"
                            class="flex items-center gap-2 px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-b-lg">
                            <i class="fa-solid fa-file-export text-blue-600"></i>
                            <span>Export Excel</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        {{-- Modal Update Kenaikan --}}
        <div id="updateKenaikan" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-4xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="fa-solid fa-angles-up"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Kenaikan Kelas
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="updateKenaikan">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <form action="{{ route('siswa.promote') }}" method="POST">
                        @csrf
                        <input type="hidden" name="_form" value="add">
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="w-full">
                                <div>
                                    <h1 class="text-red-600 dark:text-red-400 text-center font-bold text-xl">PERHATIAN!
                                    </h1>
                                    <ul class="list-disc ms-5 mt-2">
                                        <li>“Seluruh data siswa dengan status <span class="font-bold">Aktif</span> dan
                                            pada <span class="font-bold">tahun ajaran saat ini (aktif)</span> akan
                                            diperbarui ke kelas berikutnya dan tahun ajaran baru, kecuali siswa kelas 9
                                            akan menjadi alumni.”
                                        </li>
                                        <li>“Setelah proses pembaruan, Anda masih dapat mengembalikan data ke kondisi
                                            sebelumnya.”</li>
                                        <li>“Namun, jika pembaruan telah dilakukan sebanyak dua kali atau lebih, hanya
                                            pembaruan
                                            terakhir yang dapat dipulihkan.”</li>
                                    </ul>
                                </div>

                                <div class="md:flex justify-between gap-3 mt-3">
                                    <div class="w-full">
                                        <h1 class="font-semibold">Sebelum</h1>
                                        <div class="overflow-x-auto">
                                            <x-table>
                                                <x-thead>
                                                    <tr>
                                                        <x-th class="whitespace-nowrap w-14">No.</x-th>
                                                        <x-th class="whitespace-nowrap">Nama Siswa</x-th>
                                                        <x-th class="whitespace-nowrap">Kelas</x-th>
                                                        <x-th class="whitespace-nowrap">Tahun Ajaran</x-th>
                                                        <x-th class="whitespace-nowrap">Status</x-th>
                                                    </tr>
                                                </x-thead>
                                                <tbody>
                                                    <x-tr>
                                                        <x-td class="text-center">1.</x-td>
                                                        <x-td>Siswa 1</x-td>
                                                        <x-td class="text-center">7</x-td>
                                                        <x-td class="text-center">2025/2026</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">2.</x-td>
                                                        <x-td>Siswa 2</x-td>
                                                        <x-td class="text-center">7</x-td>
                                                        <x-td class="text-center">2025/2026</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">3.</x-td>
                                                        <x-td>Siswa 3</x-td>
                                                        <x-td class="text-center">8</x-td>
                                                        <x-td class="text-center">2025/2026</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">4.</x-td>
                                                        <x-td>Siswa 4</x-td>
                                                        <x-td class="text-center">8</x-td>
                                                        <x-td class="text-center">2025/2026</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">5.</x-td>
                                                        <x-td>Siswa 5</x-td>
                                                        <x-td class="text-center">9</x-td>
                                                        <x-td class="text-center">2025/2026</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">6.</x-td>
                                                        <x-td>Siswa 6</x-td>
                                                        <x-td class="text-center">9</x-td>
                                                        <x-td class="text-center">2025/2026</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                </tbody>
                                            </x-table>
                                        </div>
                                    </div>
                                    <div class="w-full mt-3 md:mt-0">
                                        <h1 class="font-semibold">Sesudah</h1>
                                        <div class="overflow-x-auto">
                                            <x-table>
                                                <x-thead>
                                                    <tr>
                                                        <x-th class="whitespace-nowrap w-14">No.</x-th>
                                                        <x-th class="whitespace-nowrap">Nama Siswa</x-th>
                                                        <x-th class="whitespace-nowrap">Kelas</x-th>
                                                        <x-th class="whitespace-nowrap">Tahun Ajaran</x-th>
                                                        <x-th class="whitespace-nowrap">Status</x-th>
                                                    </tr>
                                                </x-thead>
                                                <tbody>
                                                    <x-tr>
                                                        <x-td class="text-center">1.</x-td>
                                                        <x-td>Siswa 2</x-td>
                                                        <x-td class="text-center">7</x-td>
                                                        <x-td class="text-center">2026/2027</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">2.</x-td>
                                                        <x-td>Siswa 1</x-td>
                                                        <x-td class="text-center">8</x-td>
                                                        <x-td class="text-center">2026/2027</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">3.</x-td>
                                                        <x-td>Siswa 4</x-td>
                                                        <x-td class="text-center">8</x-td>
                                                        <x-td class="text-center">2026/2027</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">4.</x-td>
                                                        <x-td>Siswa 3</x-td>
                                                        <x-td class="text-center">9</x-td>
                                                        <x-td class="text-center">2026/2027</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">5.</x-td>
                                                        <x-td>Siswa 6</x-td>
                                                        <x-td class="text-center">9</x-td>
                                                        <x-td class="text-center">2026/2027</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                        </x-td>
                                                    </x-tr>
                                                    <x-tr>
                                                        <x-td class="text-center">6.</x-td>
                                                        <x-td>Siswa 5</x-td>
                                                        <x-td class="text-center">9</x-td>
                                                        <x-td class="text-center">2025/2026</x-td>
                                                        <x-td class="text-center">
                                                            <span
                                                                class="bg-gray-500 text-white px-6 py-1 rounded-full whitespace-nowrap">Alumni</span>
                                                        </x-td>
                                                    </x-tr>
                                                </tbody>
                                            </x-table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <x-btn-save>
                                <div class="flex items-center gap-1 font-medium">
                                    <p>Konfirmasi</p>
                                    <i class="fa-solid fa-right-from-bracket"></i>
                                </div>
                            </x-btn-save>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- Modal Validasi Update Kenaikan --}}
        <div id="validasiUpdateKenaikan" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="fa-solid fa-angles-up"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Kenaikan Kelas
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="validasiUpdateKenaikan">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <!-- Modal body -->
                    <div class="p-4 md:p-5">
                        <div class="w-full">
                            <div class="text-center">
                                <h1 class="text-red-600 dark:text-red-400 text-center font-bold text-xl">PERHATIAN!
                                </h1>
                                <p>Untuk memperbarui data siswa ke kelas berikutnya dan tahun ajaran baru, seluruh data
                                    <span class="font-bold border-b">Buku Induk</span> pada <span
                                        class="font-bold border-b">tahun ajaran saat ini</span> harus <span
                                        class="font-bold border-b">Sudah Input</span>!
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b"></div>
                </div>
            </div>
        </div>

        {{-- Modal Import Siswa --}}
        <div id="importSiswaModal" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                    <form id="importSiswaForm" action="{{ route('siswa.import') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <!-- Modal header -->
                        <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                            <div class="flex items-center gap-1">
                                <i class="fa-solid fa-file-excel text-primary"></i>
                                <h3 class="text-xl font-semibold text-dark dark:text-light">
                                    Impor Data Siswa Dari Excel
                                </h3>
                            </div>
                            <button type="button"
                                class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                                data-modal-hide="importSiswaModal">
                                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="none" viewBox="0 0 14 14">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                </svg>
                                <span class="sr-only">Close modal</span>
                            </button>
                        </div>
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="w-full">
                                <p class="mb-4 text-base">
                                    Silakan pilih file Excel yang berisi data siswa yang akan diimpor.
                                </p>

                                <div class="mb-4">
                                    <x-label for="excelFileSiswa" class="mb-2">Pilih File Excel <span
                                            class="text-red-500">*</span></x-label>
                                    <input type="file" name="file" id="excelFileSiswa" accept=".xlsx,.xls"
                                        required
                                        class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400">
                                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Format: .xlsx atau .xls
                                        (Max: 10MB)</p>
                                </div>

                                <div
                                    class="p-3 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
                                    <p class="text-xs text-blue-800 dark:text-blue-300">
                                        <i class="fa-solid fa-circle-info mr-1"></i>
                                        <strong>Catatan:</strong> File Excel harus memiliki kolom NISN sebagai acuan.
                                        Data siswa akan dicocokkan atau ditambahkan berdasarkan NISN yang ada di file
                                        Excel.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end gap-2 p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <button type="button"
                                class="px-5 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:bg-gray-600 dark:focus:ring-gray-600"
                                data-modal-hide="importSiswaModal">
                                Batal
                            </button>
                            <button type="submit"
                                class="px-5 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-hvPrimary focus:ring-4 focus:outline-none focus:ring-primary">
                                <i class="fa-solid fa-upload mr-1"></i> Konfirmasi
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- Detail Data --}}
        <div
            class="w-full md:shadow rounded-md md:p-5 md:bg-gray-50 text-gray-900 md:dark:bg-gray-800 dark:text-gray-50 md:border-t-4 md:border-primary mt-5 md:mt-0">
            <form action="{{ route('siswa.index') }}" method="GET" class="inline mt-4">
                <div class="md:flex justify-between items-center">
                    <div class="flex items-center gap-2">
                        <select name="per_page" id="per_page" onchange="this.form.submit()"
                            class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50">
                            <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20</option>
                            <option value="30" {{ request('per_page') == 30 ? 'selected' : '' }}>30</option>
                            <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                            <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100</option>
                        </select>
                        @php
                            $promotionModalTarget = $canTriggerPromotion ? 'updateKenaikan' : 'validasiUpdateKenaikan';
                        @endphp
                        <button type="button" data-modal-target="{{ $promotionModalTarget }}"
                            data-modal-toggle="{{ $promotionModalTarget }}"
                            class="flex items-center gap-1 px-5 py-2 bg-primary text-txLight hover:bg-hvPrimary text-light transition rounded-lg text-sm"><i
                                class="fa-solid fa-angles-up"></i> Kenaikan Kelas</button>
                        @if ($hasTemporaryData)
                            <a href="/siswa/riwayat"
                                class="inline-flex items-center gap-1 px-5 py-3 bg-primary text-txLight hover:bg-hvPrimary text-light transition rounded-lg text-sm"><i
                                    class="fa-solid fa-clock-rotate-left"></i>
                            </a>
                        @endif
                    </div>
                    <div class="flex items-center gap-2 mt-3 md:mt-0">
                        <div class="relative inline-block w-full">
                            <x-search-i></x-search-i>
                            <x-search placeholder="Cari Nama / NIS / NISN..." name="searchNamaSiswa"
                                class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                value="{{ request('searchNamaSiswa') }}" />
                        </div>
                        <div>
                            <button type="button" id="btnFilters"
                                class="border border-gray-400 hover:bg-primary hover:text-light hover:border-transparent transition rounded-lg py-2 px-4 md:px-5 text-sm flex items-center gap-1 whitespace-nowrap">
                                <i class="fa-solid fa-filter text-sm"></i>
                                <span class="hidden md:block">Filter</span>
                            </button>
                        </div>
                        <div>
                            <a href="/siswa"
                                class="border border-gray-400 hover:bg-primary hover:text-light hover:border-transparent transition rounded-lg py-2 px-4 text-sm flex items-center">
                                <i class="fa-solid fa-arrows-rotate text-sm"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div id="formFilters" class="mt-5 hidden">
                    <div class="border border-gray-400 border-dashed mb-5"></div>
                    <div class="overflow-x-auto lg:overflow-x-auto scrollbar-hide">
                        <div class="flex gap-3 items-end w-max lg:w-full">
                            <div class="w-full">
                                <x-label>Jenis Kelamin</x-label>
                                <x-select name="selectJenisKelamin" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectJenisKelamin') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Jenis Kelamin --</option>
                                    @foreach ($jenisKelaminOptions as $jk)
                                        <option value="{{ $jk }}"
                                            {{ request('selectJenisKelamin') == $jk ? 'selected' : '' }}>
                                            {{ $jk }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectJenisKelamin') }}</x-message>
                            </div>
                            <div class="w-full">
                                <x-label>Kelas</x-label>
                                <x-select name="selectKelas" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectKelas') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Kelas --</option>
                                    @foreach ($kelasOptions as $kelas)
                                        <option value="{{ $kelas->id }}"
                                            {{ request('selectKelas') == $kelas->id ? 'selected' : '' }}>
                                            {{ $kelas->nama_kelas_nomor }}{{ $kelas->nama_kelas_sub ?? '' }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectKelas') }}</x-message>
                            </div>
                            {{-- <div class="w-full">
                                <x-label>Wali Kelas</x-label>
                                <x-select name="waliKelasSelect" onchange="this.form.submit()"
                                    class="{{ $errors->first('waliKelasSelect') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Wali Kelas --</option>
                                    @foreach ($waliKelasOptions as $waliKelas)
                                        <option value="{{ $waliKelas->id }}"
                                            {{ request('waliKelasSelect') == $waliKelas->id ? 'selected' : '' }}>
                                            {{ $waliKelas->nama_guru }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('waliKelasSelect') }}</x-message>
                            </div> --}}
                            <div class="w-full">
                                <x-label>Angkatan</x-label>
                                <x-select name="selectAngkatan" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectAngkatan') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Angkatan --</option>
                                    @foreach ($angkatanOptions as $angkatan)
                                        <option value="{{ $angkatan }}"
                                            {{ request('selectAngkatan') == $angkatan ? 'selected' : '' }}>
                                            {{ $angkatan }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectAngkatan') }}</x-message>
                            </div>
                            <div class="w-full">
                                <x-label>Status</x-label>
                                <x-select name="selectStatus" onchange="this.form.submit()"
                                    class="{{ $errors->first('selectStatus') ? 'border-red-500' : '' }}">
                                    <option value="">-- Semua Status --</option>
                                    @foreach ($statusOptions as $status)
                                        <option value="{{ $status }}"
                                            {{ request('selectStatus') == $status ? 'selected' : '' }}>
                                            {{ $status }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-message>{{ $errors->first('selectStatus') }}</x-message>
                            </div>
                        </div>
                    </div>

                </div>
            </form>

            <div class="mb-2 mt-3">
                <!-- Desktop Table View -->
                <div class="hidden md:block overflow-x-auto">
                    <x-table>
                        <x-thead>
                            <tr>
                                <x-th class="whitespace-nowrap w-14">No.</x-th>
                                <x-th class="whitespace-nowrap">NISN</x-th>
                                <x-th class="whitespace-nowrap">Nama Siswa</x-th>
                                <x-th class="whitespace-nowrap">Jenis Kelamin</x-th>
                                <x-th class="whitespace-nowrap">Kelas</x-th>
                                <x-th class="whitespace-nowrap">Tahun Ajaran</x-th>
                                {{-- <x-th class="whitespace-nowrap">Wali Kelas</x-th> --}}
                                <x-th class="whitespace-nowrap">Angkatan</x-th>
                                <x-th class="whitespace-nowrap">Status</x-th>
                                <x-th class="whitespace-nowrap">Aksi</x-th>
                            </tr>
                        </x-thead>
                        <tbody>
                            @forelse ($dataSiswa as $data)
                                <x-tr>
                                    <x-td class="text-center">
                                        {{ $loop->iteration + $i }}.
                                    </x-td>
                                    <x-td class="text-center">{{ $data->nisn }}</x-td>
                                    <x-td>{{ $data->nama_siswa }}</x-td>
                                    <x-td class="text-center">{{ $data->jenis_kelamin }}</x-td>
                                    <x-td
                                        class="text-center">{{ $data->kelas->nama_kelas_nomor }}{{ $data->kelas->nama_kelas_sub ?? '' }}</x-td>
                                    <x-td
                                        class="text-center">{{ $data->thn_ajaran_awal }}/{{ $data->thn_ajaran_akhir }}</x-td>
                                    {{-- @if ($data->nama_wali_kelas)
                                        <x-td>{{ $data->nama_wali_kelas }}</x-td>
                                    @else
                                        <x-td class="text-center text-red-600">
                                            <a href="/wali-kelas-periode" class="hover:underline">Belum di set!</a>
                                        </x-td>
                                    @endif --}}
                                    <x-td class="text-center">{{ $data->angkatan }}</x-td>
                                    <x-td class="text-center">
                                        @if ($data->status == 'Aktif')
                                            <span
                                                class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                        @elseif ($data->status == 'Non-Aktif')
                                            <span
                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                        @else
                                            <span
                                                class="bg-gray-500 text-white px-6 py-1 rounded-full whitespace-nowrap">Alumni</span>
                                        @endif
                                    </x-td>
                                    <x-td class="text-center whitespace-nowrap relative">
                                        <button type="button"
                                            class="download-per-siswa-btn whitespace-nowrap inline-flex items-center px-3 py-1.5 bg-red-600 text-white text-xs rounded hover:bg-red-500"
                                            data-siswa-id="{{ $data->id }}">
                                            <i class="fa-solid fa-download mr-1"></i> PDF
                                        </button>
                                        <x-btn-detail href="{{ route('siswa.show', $data->id) }}"></x-btn-detail>
                                        <button type="button" id="btnAction{{ $data->id }}"
                                            class="py-2 px-4 rounded-md bg-slate-400 dark:text-dark hover:bg-slate-300 transition">
                                            <i class="fa-solid fa-ellipsis-vertical"></i>
                                        </button>
                                        <div id="action{{ $data->id }}"
                                            class="hidden absolute right-[75px] top-0 bg-slate-300 dark:bg-dark rounded-md px-3 py-1 bubble-with-arrow">
                                            <x-btn-delete type="button"
                                                onclick="handleDelete({{ $data->id }}, '{{ $data->nama_siswa }}')"></x-btn-delete>
                                            <a href="{{ route('siswa.edit', $data->id) }}">
                                                <x-btn-edit></x-btn-edit>
                                            </a>
                                        </div>
                                    </x-td>
                                </x-tr>
                            @empty
                                <x-tr>
                                    <x-td colspan="9" class="text-center text-red-600">Data siswa tidak ada!</x-td>
                                </x-tr>
                            @endforelse
                        </tbody>
                    </x-table>
                </div>

                <!-- Mobile Card View -->
                <div class="md:hidden space-y-3">
                    @forelse ($dataSiswa as $data)
                        <div
                            class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4 border border-gray-200 dark:border-gray-600">
                            <!-- Header Card -->
                            <div class="flex justify-between items-start mb-3">
                                <div class="flex-1">
                                    <h3 class="font-semibold text-base text-gray-900 dark:text-gray-100">
                                        {{ $data->nama_siswa }}
                                    </h3>
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                        NISN: {{ $data->nisn }}
                                    </p>
                                </div>
                                <div class="flex items-center gap-2">
                                    @if ($data->status == 'Aktif')
                                        <span
                                            class="bg-green-500 text-white px-3 py-1 rounded-full text-xs whitespace-nowrap">Aktif</span>
                                    @elseif ($data->status == 'Non-Aktif')
                                        <span
                                            class="bg-red-500 text-white px-2 py-1 rounded-full text-xs whitespace-nowrap">Non-Aktif</span>
                                    @else
                                        <span
                                            class="bg-gray-500 text-white px-2 py-1 rounded-full text-xs whitespace-nowrap">Alumni</span>
                                    @endif
                                </div>
                            </div>

                            <!-- Detail Info -->
                            <div class="grid grid-cols-2 gap-2 text-sm mb-3">
                                <div>
                                    <p class="text-gray-500 dark:text-gray-400 text-xs">Jenis Kelamin</p>
                                    <p class="font-medium text-gray-900 dark:text-gray-100">{{ $data->jenis_kelamin }}
                                    </p>
                                </div>
                                <div>
                                    <p class="text-gray-500 dark:text-gray-400 text-xs">Kelas</p>
                                    <p class="font-medium text-gray-900 dark:text-gray-100">
                                        {{ $data->kelas->nama_kelas_nomor }}{{ $data->kelas->nama_kelas_sub ?? '' }}
                                    </p>
                                </div>
                                <div>
                                    <p class="text-gray-500 dark:text-gray-400 text-xs">Tahun Ajaran</p>
                                    <p class="font-medium text-gray-900 dark:text-gray-100">
                                        {{ $data->thn_ajaran_awal }}/{{ $data->thn_ajaran_akhir }}
                                    </p>
                                </div>
                                <div>
                                    <p class="text-gray-500 dark:text-gray-400 text-xs">Angkatan</p>
                                    <p class="font-medium text-gray-900 dark:text-gray-100">{{ $data->angkatan }}</p>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="flex justify-end gap-2 pt-3 border-t border-gray-200 dark:border-gray-600">
                                <button type="button"
                                    class="download-per-siswa-btn whitespace-nowrap inline-flex items-center px-3 py-1.5 bg-red-600 text-white text-xs rounded hover:bg-red-500"
                                    data-siswa-id="{{ $data->id }}">
                                    <i class="fa-solid fa-download mr-1"></i> PDF
                                </button>
                                <a href="{{ route('siswa.show', $data->id) }}"
                                    class="py-1.5 px-3 rounded-md bg-blue-500 text-white hover:bg-blue-600 transition text-xs flex items-center gap-1">
                                    <i class="fa-solid fa-eye"></i>
                                    <span>Detail</span>
                                </a>
                                <a href="{{ route('siswa.edit', $data->id) }}"
                                    class="py-1.5 px-3 rounded-md bg-yellow-400 text-dark hover:bg-yellow-300 transition text-xs flex items-center gap-1">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                    <span>Edit</span>
                                </a>
                                <button type="button"
                                    onclick="handleDelete({{ $data->id }}, '{{ $data->nama_siswa }}')"
                                    class="py-1.5 px-3 rounded-md bg-red-500 text-white hover:bg-red-600 transition text-xs flex items-center gap-1">
                                    <i class="fa-solid fa-trash"></i>
                                    <span>Hapus</span>
                                </button>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                            <i class="fa-solid fa-users text-4xl mb-2"></i>
                            <p>Data siswa tidak ada!</p>
                        </div>
                    @endforelse
                </div>

                {{-- Pagination --}}
                <div class="flex justify-between items-center mt-3">
                    <span id="dataInfo" class="text-xs text-dark dark:text-light">
                        Menampilkan <span class="font-semibold">{{ $dataSiswa->firstItem() ?? 0 }}</span>
                        sampai <span class="font-semibold">{{ $dataSiswa->lastItem() ?? 0 }}</span>
                        dari <span class="font-semibold">{{ $dataSiswa->total() }}</span>
                        data
                    </span>
                    <div id="paginationLinks" class="inline-flex mt-2 xs:mt-0">
                        {{ $dataSiswa->links('vendor.pagination.costum') }}
                    </div>
                </div>
            </div>
        </div>
        <!-- Floating Action Button with Dropdown for Mobile -->
        <div class="fixed bottom-6 right-6 z-50 md:hidden">
            <!-- Dropdown Menu (appears above button) -->
            <div id="dropdownAddDataMobile" class="hidden absolute bottom-full right-0 mb-4">
                <div
                    class="bg-white dark:bg-gray-800 rounded-lg shadow-xl border border-gray-200 dark:border-gray-600 overflow-hidden min-w-[250px]">
                    <a href="{{ route('pekerjaan.index') }}"
                        class="flex items-center gap-3 px-4 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors border-b border-gray-200 dark:border-gray-600">
                        <div
                            class="w-10 h-10 rounded-full bg-blue-100 dark:bg-blue-900 flex items-center justify-center flex-shrink-0">
                            <i class="fa-solid fa-briefcase text-blue-600 dark:text-blue-400"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-900 dark:text-gray-100 text-sm">Pekerjaan Ortu</p>
                            <p class="text-xs text-gray-500 dark:text-gray-400">Tambah data pekerjaan</p>
                        </div>
                    </a>
                    <a href="{{ route('siswa.create') }}"
                        class="flex items-center gap-3 px-4 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors border-b border-gray-200 dark:border-gray-600">
                        <div
                            class="w-10 h-10 rounded-full bg-green-100 dark:bg-green-900 flex items-center justify-center flex-shrink-0">
                            <i class="fa-solid fa-user-plus text-green-600 dark:text-green-400"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-900 dark:text-gray-100 text-sm">Tambah Siswa</p>
                            <p class="text-xs text-gray-500 dark:text-gray-400">Tambah data siswa baru</p>
                        </div>
                    </a>
                    <button type="button" data-modal-target="importSiswaModal" data-modal-toggle="importSiswaModal"
                        class="w-full flex items-center gap-3 px-4 py-3 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors text-left">
                        <div
                            class="w-10 h-10 rounded-full bg-purple-100 dark:bg-purple-900 flex items-center justify-center flex-shrink-0">
                            <i class="fa-solid fa-file-excel text-purple-600 dark:text-purple-400"></i>
                        </div>
                        <div>
                            <p class="font-medium text-gray-900 dark:text-gray-100 text-sm">Impor Siswa</p>
                            <p class="text-xs text-gray-500 dark:text-gray-400">Import dari Excel</p>
                        </div>
                    </button>
                </div>
            </div>

            <!-- Main FAB Button -->
            <button type="button" id="addDataMobile"
                class="w-14 h-14 rounded-full bg-primary text-white flex items-center justify-center shadow-lg hover:bg-hvPrimary transition-all duration-200">
                <i id="fabIcon" class="fa-solid fa-plus text-2xl transition-transform duration-200"></i>
            </button>
        </div>

        <!-- Modal Validasi (Data Sudah Digunakan) -->
        <div id="validasiModal"
            class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
            <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md p-6">
                <div class="text-center">
                    <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                        <i class="fa-solid fa-exclamation-triangle text-red-600 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold mb-2 text-gray-900 dark:text-gray-50">Data Tidak Dapat Dihapus
                    </h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
                        Data siswa <span id="validasiNamaSiswa" class="font-semibold"></span> sudah digunakan pada
                        buku raport dan tidak dapat dihapus.
                    </p>
                    <button type="button" onclick="closeValidasiModal()"
                        class="w-full bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-lg text-sm">
                        Tutup
                    </button>
                </div>
            </div>
        </div>

        <!-- Modal Konfirmasi Delete -->
        <div id="deleteModal"
            class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
            <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md p-6">
                <div class="text-center">
                    <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-yellow-100 mb-4">
                        <i class="fa-solid fa-question-circle text-yellow-600 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-semibold mb-2 text-gray-900 dark:text-gray-50">Konfirmasi Hapus</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
                        Apakah Anda yakin ingin menghapus data siswa <span id="deleteNamaSiswa"
                            class="font-semibold"></span>?
                    </p>
                    <form id="deleteForm" method="POST" action="">
                        @csrf
                        @method('DELETE')
                        <div class="flex gap-3">
                            <button type="button" onclick="closeDeleteModal()"
                                class="flex-1 bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg text-sm">
                                Batal
                            </button>
                            <button type="submit"
                                class="flex-1 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                                Hapus
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </section>

    @push('js')
        <script>
            // Handle Delete Button Click
            async function handleDelete(id, namaSiswa) {
                try {
                    // Check if siswa is being used
                    const response = await fetch(`/siswa/${id}/check-usage`);
                    const data = await response.json();

                    if (data.used) {
                        // Show validation modal if data is being used
                        document.getElementById('validasiNamaSiswa').textContent = data.nama_siswa;
                        openValidasiModal();
                    } else {
                        // Show delete confirmation modal if data is not being used
                        document.getElementById('deleteNamaSiswa').textContent = namaSiswa;
                        document.getElementById('deleteForm').action = `/siswa/${id}`;
                        openDeleteModal();
                    }
                } catch (error) {
                    console.error('Error checking usage:', error);
                    alert('Terjadi kesalahan saat memeriksa data. Silakan coba lagi.');
                }
            }

            // Modal functions for Validasi
            function openValidasiModal() {
                document.getElementById('validasiModal').classList.remove('hidden');
                document.getElementById('validasiModal').classList.add('flex');
                document.body.style.overflow = 'hidden';
            }

            function closeValidasiModal() {
                document.getElementById('validasiModal').classList.add('hidden');
                document.getElementById('validasiModal').classList.remove('flex');
                document.body.style.overflow = 'auto';
            }

            // Modal functions for Delete
            function openDeleteModal() {
                document.getElementById('deleteModal').classList.remove('hidden');
                document.getElementById('deleteModal').classList.add('flex');
                document.body.style.overflow = 'hidden';
            }

            function closeDeleteModal() {
                document.getElementById('deleteModal').classList.add('hidden');
                document.getElementById('deleteModal').classList.remove('flex');
                document.body.style.overflow = 'auto';
            }

            document.addEventListener('DOMContentLoaded', function() {
                // Handle Download Per Siswa Button Click
                document.querySelectorAll('.download-per-siswa-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const siswaId = this.getAttribute('data-siswa-id');

                        if (!siswaId) {
                            alert('Terjadi kesalahan: ID siswa tidak ditemukan');
                            return;
                        }

                        // Build URL - download semua data siswa (semua semester dan tahun ajaran)
                        const url = '{{ route('buku-induk.downloadPerSiswa', ':siswa_id') }}'.replace(
                            ':siswa_id', siswaId);

                        // Redirect to download
                        window.location.href = url;
                    });
                });

                document.querySelectorAll('button[id^="btnAction"]').forEach(button => {
                    button.addEventListener('click', function(e) {
                        e.stopPropagation();

                        const id = this.id.replace('btnAction', '');
                        const menu = document.getElementById('action' + id);
                        if (!menu) return;

                        // 🔒 Tutup semua menu lain dulu
                        document.querySelectorAll('[id^="action"]').forEach(m => {
                            if (m !== menu) m.classList.add('hidden');
                        });

                        // 🔁 Toggle menu yang diklik
                        menu.classList.toggle('hidden');
                    });
                });

                // Klik di luar -> tutup semua menu
                document.addEventListener('click', function(e) {
                    if (e.target.closest('[id^="btnAction"]') || e.target.closest('[id^="action"]')) return;
                    document.querySelectorAll('[id^="action"]').forEach(m => m.classList.add('hidden'));
                });
            });
        </script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const btnFilters = document.getElementById('btnFilters');
                const formFilters = document.getElementById('formFilters');

                // Cek URL saat halaman dimuat
                const currentUrl = window.location.href;
                if (currentUrl.includes('siswa?')) {
                    formFilters.classList.remove('hidden');
                    btnFilters.classList.add('bg-primary', 'text-light', 'border-transparent');
                } else if (currentUrl.includes('siswa')) {
                    formFilters.classList.add('hidden');
                    btnFilters.classList.remove('bg-primary', 'text-light', 'border-transparent');
                }

                // Event klik tombol
                btnFilters.addEventListener('click', function() {
                    // Toggle class pada tombol
                    this.classList.toggle('bg-primary');
                    this.classList.toggle('text-light');
                    this.classList.toggle('border-transparent');

                    // Toggle class hidden pada form
                    formFilters.classList.toggle('hidden');
                });
            });
        </script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Dropdown Excel Toggle
                const dropdownExcelButton = document.getElementById('dropdownExcelButton');
                const dropdownExcelMenu = document.getElementById('dropdownExcelMenu');

                if (dropdownExcelButton && dropdownExcelMenu) {
                    dropdownExcelButton.addEventListener('click', function(e) {
                        e.stopPropagation();
                        dropdownExcelMenu.classList.toggle('hidden');
                    });

                    // Close dropdown when clicking outside
                    document.addEventListener('click', function(e) {
                        if (!dropdownExcelButton.contains(e.target) && !dropdownExcelMenu.contains(e.target)) {
                            dropdownExcelMenu.classList.add('hidden');
                        }
                    });
                }

                const addDataBtn = document.getElementById('addDataMobile');
                const dropdown = document.getElementById('dropdownAddDataMobile');
                const fabIcon = document.getElementById('fabIcon');

                // Toggle dropdown when FAB button is clicked
                addDataBtn.addEventListener('click', function(e) {
                    e.stopPropagation();
                    dropdown.classList.toggle('hidden');

                    // Rotate icon
                    if (dropdown.classList.contains('hidden')) {
                        fabIcon.style.transform = 'rotate(0deg)';
                    } else {
                        fabIcon.style.transform = 'rotate(45deg)';
                    }
                });

                // Close dropdown when clicking outside
                document.addEventListener('click', function(e) {
                    if (!addDataBtn.contains(e.target) && !dropdown.contains(e.target)) {
                        dropdown.classList.add('hidden');
                        fabIcon.style.transform = 'rotate(0deg)';
                    }
                });

                // Close dropdown when clicking on a menu item (except modal trigger)
                dropdown.querySelectorAll('a').forEach(link => {
                    link.addEventListener('click', function() {
                        dropdown.classList.add('hidden');
                        fabIcon.style.transform = 'rotate(0deg)';
                    });
                });

                // Close modal when clicking outside the modal content
                const validasiModal = document.getElementById('validasiModal');
                if (validasiModal) {
                    validasiModal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            closeValidasiModal();
                        }
                    });
                }

                const deleteModal = document.getElementById('deleteModal');
                if (deleteModal) {
                    deleteModal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            closeDeleteModal();
                        }
                    });
                }
            });
        </script>
    @endpush

</x-app-layout>
