<title>Edit Data Siswa</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="md:flex justify-between mb-4">
            <div>
                <h1>
                    <div class="flex gap-2 items-start">
                        <a href="{{ route('siswa.index') }}" class="mt-1 hover:text-hvPrimary">
                            <i class="fa-solid fa-arrow-left text-xl"></i>
                        </a>
                        <div>
                            <p class="text-xl sm:text-2xl font-bold">Data Siswa</p>
                            <p class="text-xs sm:text-sm ms-[1px]">Index / Data Siswa</p>
                        </div>
                    </div>
                </h1>
            </div>
        </div>

        {{-- Form Edit Data --}}
        <div
            class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary">
            <div class="flex items-center gap-1 font-semibold mb-4">
                <i class="fa-solid fa-pencil"></i>
                <p>Form Edit Data Siswa</p>
            </div>

            <form action="{{ route('siswa.update', $siswa->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                {{-- Section 1: Basic Identity --}}
                <div class="mb-6">
                    <h3 class="text-lg font-semibold mb-3 text-primary">Identitas Dasar</h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div>
                            <x-label><span class="text-red-500">*</span>NIS</x-label>
                            <x-input name="nis" type="number" tabindex="1" value="{{ old('nis', $siswa->nis) }}"
                                class="{{ $errors->first('nis') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan NIS..." />
                            <x-message>{{ $errors->first('nis') }}</x-message>
                        </div>

                        <div>
                            <x-label><span class="text-red-500">*</span>NISN</x-label>
                            <x-input name="nisn" type="number" tabindex="2"
                                value="{{ old('nisn', $siswa->nisn) }}"
                                class="{{ $errors->first('nisn') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan NISN..." />
                            <x-message>{{ $errors->first('nisn') }}</x-message>
                        </div>

                        <div>
                            <x-label><span class="text-red-500">*</span>No KIP</x-label>
                            <x-input name="no_kip" type="text" tabindex="3"
                                value="{{ old('no_kip', $siswa->no_kip) }}"
                                class="{{ $errors->first('no_kip') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan No KIP..." />
                            <x-message>{{ $errors->first('no_kip') }}</x-message>
                        </div>

                        <div>
                            <x-label><span class="text-red-500">*</span>No KK</x-label>
                            <x-input name="no_kk" type="text" tabindex="4"
                                value="{{ old('no_kk', $siswa->no_kk) }}"
                                class="{{ $errors->first('no_kk') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan No KK..." />
                            <x-message>{{ $errors->first('no_kk') }}</x-message>
                        </div>

                    </div>
                    <div class="grid grid-cols-2 gap-4 mt-5">
                        <div>
                            <x-label><span class="text-red-500">*</span>Nama Siswa</x-label>
                            <x-input name="nama_siswa" type="text" tabindex="5"
                                value="{{ old('nama_siswa', $siswa->nama_siswa) }}"
                                class="{{ $errors->first('nama_siswa') ? 'border-red-400' : '' }} capitalize-input"
                                placeholder="Masukkan nama siswa..." />
                            <x-message>{{ $errors->first('nama_siswa') }}</x-message>
                        </div>

                        <div>
                            <x-label><span class="text-red-500">*</span>Jenis Kelamin</x-label>
                            <x-select name="jenis_kelamin" tabindex="6"
                                class="{{ $errors->first('jenis_kelamin') ? 'border-red-500' : '' }}">
                                <option value="" selected disabled>-- Pilih Jenis Kelamin --</option>
                                <option value="Laki-Laki"
                                    {{ old('jenis_kelamin', $siswa->jenis_kelamin) == 'Laki-Laki' ? 'selected' : '' }}>
                                    Laki-Laki</option>
                                <option value="Perempuan"
                                    {{ old('jenis_kelamin', $siswa->jenis_kelamin) == 'Perempuan' ? 'selected' : '' }}>
                                    Perempuan</option>
                            </x-select>
                            <x-message>{{ $errors->first('jenis_kelamin') }}</x-message>
                        </div>
                    </div>
                </div>

                {{-- Section 5: Academic Info --}}
                <div class="mb-6">
                    <h3 class="text-lg font-semibold mb-3 text-primary">Informasi Akademik</h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div>
                            <x-label><span class="text-red-500">*</span>Kelas</x-label>
                            <x-select name="kelas_id" tabindex="7"
                                class="{{ $errors->first('kelas_id') ? 'border-red-500' : '' }}">
                                <option value="" selected disabled>-- Pilih Kelas --</option>
                                @forelse($kelas as $class)
                                    <option value="{{ $class->id }}"
                                        {{ old('kelas_id', $siswa->kelas_id) == $class->id ? 'selected' : '' }}>
                                        {{ $class->nama_kelas_nomor }}{{ $class->nama_kelas_sub }}
                                    </option>
                                @empty
                                    <option value="" disabled>Tidak ada data kelas</option>
                                @endforelse
                            </x-select>
                            <x-message>{{ $errors->first('kelas_id') }}</x-message>
                        </div>
                        @php
                            // Prioritas: old() > data edit (thn_ajaran_awal/akhir) > tahun ajaran aktif
                            $selectedTahunAjaran = old('tahun_ajaran');

                            if (!$selectedTahunAjaran && isset($siswa)) {
                                $selectedTahunAjaran = $siswa->thn_ajaran_awal . '/' . $siswa->thn_ajaran_akhir;
                            }

                            // Jika tidak ada old() dan tidak ada edit, cari tahun ajaran aktif
                            if (!$selectedTahunAjaran) {
                                $tahunAjaranAktif = $tahunAjaran->firstWhere('status', 'Aktif');
                                if ($tahunAjaranAktif) {
                                    $selectedTahunAjaran =
                                        $tahunAjaranAktif->tahun_awal . '/' . $tahunAjaranAktif->tahun_akhir;
                                }
                            }
                        @endphp

                        <div>
                            <x-label><span class="text-red-500">*</span>Tahun Ajaran</x-label>
                            <x-select name="tahun_ajaran" tabindex="8"
                                class="{{ $errors->first('tahun_ajaran') ? 'border-red-500' : '' }}">
                                <option value="" disabled {{ !$selectedTahunAjaran ? 'selected' : '' }}>-- Pilih
                                    Tahun Ajaran --</option>
                                @forelse($tahunAjaran as $ta)
                                    @php
                                        $value = $ta->tahun_awal . '/' . $ta->tahun_akhir;
                                    @endphp
                                    <option value="{{ $value }}"
                                        {{ $value === $selectedTahunAjaran ? 'selected' : '' }}>
                                        {{ $value }}
                                    </option>
                                @empty
                                    <option value="" disabled>Tidak ada data tahun ajaran</option>
                                @endforelse
                            </x-select>
                            <x-message>{{ $errors->first('tahun_ajaran') }}</x-message>
                        </div>

                        <div>
                            <x-label><span class="text-red-500">*</span>Angkatan</x-label>
                            @php
                                $tahunSekarang = date('Y');
                                $tahunMulai = $tahunSekarang - 5;
                            @endphp

                            <x-select name="angkatan" tabindex="9"
                                class="{{ $errors->first('angkatan') ? 'border-red-500' : '' }}">
                                @for ($tahun = $tahunSekarang; $tahun >= $tahunMulai; $tahun--)
                                    <option value="{{ $tahun }}"
                                        {{ old('angkatan', $siswa->angkatan) == $tahun ? 'selected' : '' }}>
                                        {{ $tahun }}
                                    </option>
                                @endfor
                            </x-select>

                            <x-message>{{ $errors->first('angkatan') }}</x-message>
                        </div>

                        {{-- <div>
                            <x-label><span class="text-red-500">*</span>Angkatan</x-label>
                            <x-input name="angkatan" type="text" tabindex="6"
                                value="{{ old('angkatan', $siswa->angkatan) }}"
                                class="{{ $errors->first('angkatan') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan angkatan..." />
                            <x-message>{{ $errors->first('angkatan') }}</x-message>
                        </div> --}}

                        <div>
                            <x-label><span class="text-red-500">*</span>Status</x-label>
                            <x-select name="status" tabindex="10"
                                class="{{ $errors->first('status') ? 'border-red-500' : '' }}">
                                <option value="" selected disabled>-- Pilih Status --</option>
                                <option value="Aktif"
                                    {{ old('status', $siswa->status) == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="Non-Aktif"
                                    {{ old('status', $siswa->status) == 'Non-Aktif' ? 'selected' : '' }}>Non-Aktif
                                </option>
                                <option value="Alumni"
                                    {{ old('status', $siswa->status) == 'Alumni' ? 'selected' : '' }}>
                                    Alumni</option>
                            </x-select>
                            <x-message>{{ $errors->first('status') }}</x-message>
                        </div>
                    </div>
                </div>

                {{-- Section 2: Birth Info --}}
                <div class="mb-6">
                    <h3 class="text-lg font-semibold mb-3 text-primary">Informasi Kelahiran</h3>
                    <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                        <div>
                            <x-label>Tempat Lahir</x-label>
                            <x-input name="tempat_lahir" type="text" tabindex="11"
                                value="{{ old('tempat_lahir', $siswa->tempat_lahir) }}"
                                class="{{ $errors->first('tempat_lahir') ? 'border-red-400' : '' }} capitalize-input"
                                placeholder="Masukkan tempat lahir..." />
                            <x-message>{{ $errors->first('tempat_lahir') }}</x-message>
                        </div>

                        <div>
                            <x-label>Tanggal Lahir</x-label>
                            <x-input name="tanggal_lahir" type="date" tabindex="12"
                                value="{{ old('tanggal_lahir', $siswa->tanggal_lahir ? $siswa->tanggal_lahir->format('Y-m-d') : '') }}"
                                class="{{ $errors->first('tanggal_lahir') ? 'border-red-400' : '' }}" />
                            <x-message>{{ $errors->first('tanggal_lahir') }}</x-message>
                        </div>

                        <div class="col-span-2 md:col-auto">
                            <x-label><span class="text-red-500">*</span>Agama</x-label>
                            <x-select name="agama" tabindex="13"
                                class="{{ $errors->first('agama') ? 'border-red-500' : '' }}">
                                <option value="" selected disabled>-- Pilih Agama --</option>
                                <option value="Islam" {{ old('agama', $siswa->agama) == 'Islam' ? 'selected' : '' }}>
                                    Islam</option>
                                <option value="Kristen"
                                    {{ old('agama', $siswa->agama) == 'Kristen' ? 'selected' : '' }}>Kristen</option>
                                <option value="Hindu" {{ old('agama', $siswa->agama) == 'Hindu' ? 'selected' : '' }}>
                                    Hindu</option>
                                <option value="Buddha"
                                    {{ old('agama', $siswa->agama) == 'Buddha' ? 'selected' : '' }}>
                                    Buddha</option>
                                <option value="Konghucu"
                                    {{ old('agama', $siswa->agama) == 'Konghucu' ? 'selected' : '' }}>Konghucu</option>
                            </x-select>
                            <x-message>{{ $errors->first('agama') }}</x-message>
                        </div>
                    </div>
                </div>

                {{-- Section 3: Contact Info --}}
                <div class="mb-6">
                    <h3 class="text-lg font-semibold mb-3 text-primary">Informasi Kontak</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <x-label>Alamat</x-label>
                            <x-textarea name="alamat" tabindex="14"
                                class="{{ $errors->first('alamat') ? 'border-red-400' : '' }} capitalize-input"
                                placeholder="Masukkan alamat lengkap...">{{ old('alamat', $siswa->alamat) }}</x-textarea>
                            <x-message>{{ $errors->first('alamat') }}</x-message>
                        </div>

                        <div>
                            <x-label>No HP Siswa</x-label>
                            <x-input name="no_hp_siswa" type="number" tabindex="15"
                                value="{{ old('no_hp_siswa', $siswa->no_hp_siswa) }}"
                                class="{{ $errors->first('no_hp_siswa') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan no HP siswa..." />
                            <x-message>{{ $errors->first('no_hp_siswa') }}</x-message>
                        </div>
                    </div>
                </div>

                {{-- Section 4: Parent Info --}}
                <div class="mb-6">
                    <h3 class="text-lg font-semibold mb-3 text-primary">Informasi Orang Tua</h3>
                    <div class="grid grid-cols-2 md:grid-cols-2 gap-4">
                        <div>
                            <x-label>Nama Ayah</x-label>
                            <x-input name="nama_ayah" type="text" tabindex="16"
                                value="{{ old('nama_ayah', $siswa->nama_ayah) }}"
                                class="{{ $errors->first('nama_ayah') ? 'border-red-400' : '' }} capitalize-input"
                                placeholder="Masukkan nama ayah..." />
                            <x-message>{{ $errors->first('nama_ayah') }}</x-message>
                        </div>

                        <div>
                            <x-label>Pekerjaan Ayah</x-label>
                            <x-select name="pekerjaan_ayah_id" tabindex="17"
                                class="{{ $errors->first('pekerjaan_ayah_id') ? 'border-red-500' : '' }}">
                                <option value="" selected disabled>-- Pilih Pekerjaan Ayah --</option>
                                @forelse($pekerjaan as $job)
                                    <option value="{{ $job->id }}"
                                        {{ old('pekerjaan_ayah_id', $siswa->pekerjaan_ayah_id) == $job->id ? 'selected' : '' }}>
                                        {{ $job->nama_pekerjaan }}
                                    </option>
                                @empty
                                    <option value="" disabled>Tidak ada data pekerjaan</option>
                                @endforelse
                            </x-select>
                            <x-message>{{ $errors->first('pekerjaan_ayah_id') }}</x-message>
                        </div>

                        <div>
                            <x-label>Nama Ibu</x-label>
                            <x-input name="nama_ibu" type="text" tabindex="18"
                                value="{{ old('nama_ibu', $siswa->nama_ibu) }}"
                                class="{{ $errors->first('nama_ibu') ? 'border-red-400' : '' }} capitalize-input"
                                placeholder="Masukkan nama ibu..." />
                            <x-message>{{ $errors->first('nama_ibu') }}</x-message>
                        </div>

                        <div>
                            <x-label>Pekerjaan Ibu</x-label>
                            <x-select name="pekerjaan_ibu_id" tabindex="19"
                                class="{{ $errors->first('pekerjaan_ibu_id') ? 'border-red-500' : '' }}">
                                <option value="" selected disabled>-- Pilih Pekerjaan Ibu --</option>
                                @forelse($pekerjaan as $job)
                                    <option value="{{ $job->id }}"
                                        {{ old('pekerjaan_ibu_id', $siswa->pekerjaan_ibu_id) == $job->id ? 'selected' : '' }}>
                                        {{ $job->nama_pekerjaan }}
                                    </option>
                                @empty
                                    <option value="" disabled>Tidak ada data pekerjaan</option>
                                @endforelse
                            </x-select>
                            <x-message>{{ $errors->first('pekerjaan_ibu_id') }}</x-message>
                        </div>

                        <div class="col-span-2">
                            <x-label>No HP Orang Tua</x-label>
                            <x-input name="no_hp_ortu" type="number" tabindex="20"
                                value="{{ old('no_hp_ortu', $siswa->no_hp_ortu) }}"
                                class="{{ $errors->first('no_hp_ortu') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan no HP orang tua..." />
                            <x-message>{{ $errors->first('no_hp_ortu') }}</x-message>
                        </div>
                    </div>
                </div>

                {{-- Section: Photo --}}
                <div class="mb-6">
                    <h3 class="text-lg font-semibold mb-3 text-primary">Foto Siswa</h3>
                    <div class="md:flex gap-4">
                        <div class="w-full">
                            <x-label>Pilih Foto</x-label>
                            <input type="file" name="foto" accept="image/*"
                                class="w-full text-sm border rounded-md border-gray-400 shadow-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                id="foto-input" onchange="previewImage(this)">
                            <x-message>{{ $errors->first('foto') }}</x-message>
                            <p class="text-sm text-gray-500 mt-1">Format: jpg, jpeg, png. Ukuran maks: 2MB</p>
                        </div>
                        <div class="mt-3 md:mt-0 flex flex-col md:items-start items-center">
                            <x-label>Preview</x-label>
                            <div class="relative w-48 pb-64 overflow-hidden rounded-md border">
                                <img id="foto-preview"
                                    src="{{ $siswa->foto ? asset('foto_siswa/' . $siswa->foto) : asset('img/profil.webp') }}"
                                    class="absolute w-full h-full object-cover" alt="Preview">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex justify-end mt-12">
                    <x-btn-save tabindex="21">
                        <div class="flex items-center gap-1 font-medium">
                            <i class="fa-solid fa-floppy-disk"></i>
                            <p>Update</p>
                        </div>
                    </x-btn-save>
                </div>
            </form>
        </div>
    </section>

    @push('js')
        <script>
            // Image preview function
            function previewImage(input) {
                const preview = document.getElementById('foto-preview');
                const file = input.files[0];

                if (file) {
                    // Validate file size (2MB)
                    if (file.size > 2 * 1024 * 1024) {
                        alert('Ukuran file terlalu besar. Maksimal 2MB');
                        input.value = '';
                        return;
                    }

                    // Validate file type
                    if (!file.type.match('image.*')) {
                        alert('File harus berupa gambar');
                        input.value = '';
                        return;
                    }

                    const reader = new FileReader();
                    reader.onload = function(e) {
                        preview.src = e.target.result;
                    }
                    reader.readAsDataURL(file);
                }
            }

            document.addEventListener('DOMContentLoaded', function() {
                // Function to convert text to title case
                function toTitleCase(str) {
                    return str.replace(/\w\S*/g, function(txt) {
                        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
                    });
                }

                // Apply title case to all inputs with capitalize-input class
                const capitalizeInputs = document.querySelectorAll('.capitalize-input');

                capitalizeInputs.forEach(function(input) {
                    // Transform existing value to title case on page load
                    if (input.value) {
                        input.value = toTitleCase(input.value);
                    }

                    // Transform input on change/input events
                    input.addEventListener('input', function() {
                        this.value = toTitleCase(this.value);
                    });

                    // Also transform on blur to ensure consistency
                    input.addEventListener('blur', function() {
                        this.value = toTitleCase(this.value);
                    });
                });
            });
        </script>
    @endpush

</x-app-layout>
