<title>Rekap Nilai Siswa</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <style>
        .mapel-scroll {
            overflow-x: auto;
            scrollbar-width: thin;
            scrollbar-color: rgba(0, 0, 0, 0.4) transparent;
        }

        .dark .mapel-scroll {
            overflow-x: auto;
            scrollbar-width: thin;
            scrollbar-color: rgba(255, 255, 255, 0.5) transparent;
        }

        .mapel-scroll::-webkit-scrollbar {
            height: 6px;
        }

        .mapel-scroll::-webkit-scrollbar-thumb {
            background-color: #c4c4c4;
            border-radius: 10px;
        }

        .mapel-scroll::-webkit-scrollbar-thumb:hover {
            background-color: #a1a1a1;
        }

        .mapel-scroll::-webkit-scrollbar-track {
            background-color: #f4f4f4;
            border-radius: 10px;
        }

        .dark .mapel-scroll::-webkit-scrollbar-thumb {
            background-color: #6b7280;
        }

        .dark .mapel-scroll::-webkit-scrollbar-thumb:hover {
            background-color: #4b5563;
        }

        .dark .mapel-scroll::-webkit-scrollbar-track {
            background-color: #1f2937;
        }

        .mapel-col {
            min-width: 100px;
            width: 100px;
        }
    </style>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        
        <div class="mb-2 md:mb-4 -mt-3">
            <h1 class="md:flex justify-between items-center">
                <div class="flex gap-2 mt-3 md:mt-0">
                    <i class="fa-solid fa-file-lines text-3xl mt-1 font-bold"></i>
                    <div>
                        <p class="text-xl sm:text-2xl font-bold">Rekap Nilai Siswa</p>
                        <p class="text-xs sm:text-sm ms-[1px] -mt-1">Nilai Kelas 7 - 9 (Semua Semester)</p>
                    </div>
                </div>
            </h1>
        </div>

        <div class="border border-gray-400 mb-5 border-dashed"></div>

        {{-- Form Pilih Siswa --}}
        <div class="mb-6">
            <div class="bg-gray-50 dark:bg-gray-800 rounded-lg p-5 shadow border-t-4 border-primary">
                <form method="GET" action="{{ route('rekap-nilai.index') }}" id="siswaForm">
                    <x-label class="font-semibold mb-2">Pilih Siswa Berdasarkan NISN</x-label>
                    <div class="flex gap-2 items-end">
                        <div class="flex-1">
                            <x-select name="nisn" id="nisnSelect" class="w-full" required>
                                <option value="">-- Pilih Siswa --</option>
                                @foreach($allStudents as $student)
                                    <option value="{{ $student->nisn }}" {{ $selectedNisn == $student->nisn ? 'selected' : '' }}>
                                        {{ $student->nisn }} - {{ $student->nama_siswa }} 
                                        @if($student->kelas)
                                            (Kelas {{ $student->kelas->nama_kelas_nomor }}{{ $student->kelas->nama_kelas_sub }})
                                        @endif
                                    </option>
                                @endforeach
                            </x-select>
                        </div>
                        <button type="submit" class="px-5 py-2 bg-primary text-white rounded-lg hover:bg-hvPrimary transition whitespace-nowrap">
                            <i class="fa-solid fa-search me-1"></i> Tampilkan
                        </button>
                        @if($selectedNisn)
                            <a href="{{ route('rekap-nilai.index') }}" class="px-5 py-2 bg-gray-500 text-white rounded-lg hover:bg-gray-600 transition whitespace-nowrap">
                                <i class="fa-solid fa-arrows-rotate me-1"></i> Reset
                            </a>
                        @endif
                    </div>
                </form>
            </div>
        </div>

        @if($siswaData)
            {{-- Info Siswa --}}
            <div class="bg-gradient-to-r from-emerald-50 to-blue-50 dark:from-gray-800 dark:to-gray-800 rounded-lg p-5 mb-6 shadow border-t-4 border-emerald-500">
                <h3 class="font-bold text-lg mb-3 text-emerald-700 dark:text-emerald-200">
                    <i class="fa-solid fa-user-circle me-2"></i>Informasi Siswa
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div class="bg-white dark:bg-gray-700 rounded p-3 shadow-sm">
                        <p class="text-xs text-gray-600 dark:text-gray-400 font-semibold">NISN</p>
                        <p class="text-base font-bold text-gray-900 dark:text-gray-100">{{ $siswaData->nisn }}</p>
                    </div>
                    <div class="bg-white dark:bg-gray-700 rounded p-3 shadow-sm">
                        <p class="text-xs text-gray-600 dark:text-gray-400 font-semibold">NIS</p>
                        <p class="text-base font-bold text-gray-900 dark:text-gray-100">{{ $siswaData->nis }}</p>
                    </div>
                    <div class="bg-white dark:bg-gray-700 rounded p-3 shadow-sm">
                        <p class="text-xs text-gray-600 dark:text-gray-400 font-semibold">Nama Lengkap</p>
                        <p class="text-base font-bold text-gray-900 dark:text-gray-100">{{ $siswaData->nama_siswa }}</p>
                    </div>
                    <div class="bg-white dark:bg-gray-700 rounded p-3 shadow-sm">
                        <p class="text-xs text-gray-600 dark:text-gray-400 font-semibold">Kelas Saat Ini</p>
                        <p class="text-base font-bold text-gray-900 dark:text-gray-100">
                            @if($siswaData->kelas)
                                {{ $siswaData->kelas->nama_kelas_romawi }} ({{ $siswaData->kelas->nama_kelas_nomor }}{{ $siswaData->kelas->nama_kelas_sub }})
                            @else
                                -
                            @endif
                        </p>
                    </div>
                </div>
            </div>

            {{-- Rekap Nilai per Kelas & Semester --}}
            @forelse($rekapData as $data)
                <div class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary mb-5">
                    <div class="flex justify-between items-center mb-4">
                        <div>
                            <h3 class="text-xl font-bold text-emerald-700 dark:text-emerald-200">
                                <i class="fa-solid fa-book-open me-2"></i>Kelas {{ $data['kelas_display'] }} - Semester {{ $data['semester'] }}
                            </h3>
                            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                                <i class="fa-solid fa-calendar me-1"></i>Tahun Ajaran: {{ $data['tahun_ajaran'] }}
                            </p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs text-gray-600 dark:text-gray-400">Total Nilai Akhir</p>
                            <p class="text-2xl font-bold text-primary dark:text-hvPrimary">
                                {{ number_format($data['book_head']->jml_nilai_akhir ?? 0, 2) }}
                            </p>
                        </div>
                    </div>

                    <div class="border border-gray-400 border-dashed my-4"></div>

                    {{-- Table Nilai --}}
                    <div class="mapel-scroll pb-2">
                        <x-table>
                            <x-thead>
                                <tr>
                                    <x-th rowspan="3" class="whitespace-nowrap align-middle" style="min-width: 200px; width: 200px;">Mata Pelajaran</x-th>
                                    @if(isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                        @php
                                            $hasDetails = false;
                                            foreach($data['mapel_heads'] as $mapelHead) {
                                                if($mapelHead->details->isNotEmpty()) {
                                                    $hasDetails = true;
                                                    break;
                                                }
                                            }
                                        @endphp
                                        @if($hasDetails)
                                            <x-th rowspan="3" class="text-center whitespace-nowrap align-middle">Sub Mata Pelajaran</x-th>
                                        @endif
                                    @endif
                                    <x-th rowspan="3" class="text-center whitespace-nowrap align-middle mapel-col">Nilai Akhir</x-th>
                                    <x-th rowspan="3" class="text-center whitespace-nowrap align-middle" style="min-width: 300px;">Deskripsi</x-th>
                                </tr>
                            </x-thead>
                            <tbody>
                                @if(isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                    @foreach($data['mapel_heads'] as $mapelHead)
                                        @if($mapelHead->details->isNotEmpty())
                                            {{-- Mapel dengan sub detail --}}
                                            @foreach($mapelHead->details as $index => $detail)
                                                @php
                                                    $detailData = $data['book_details']->get($detail->id);
                                                @endphp
                                                <x-tr>
                                                    @if($index === 0)
                                                        <x-td rowspan="{{ $mapelHead->details->count() }}" class="font-semibold align-top py-2">
                                                            {{ $mapelHead->nama_mapel }}
                                                        </x-td>
                                                    @endif
                                                    <x-td class="py-2">{{ $detail->nama_mapel_detail }}</x-td>
                                                    <x-td class="text-center py-2 mapel-col">
                                                        <span class="font-bold text-emerald-700 dark:text-emerald-200">
                                                            {{ $detailData ? $detailData->nilai_akhir : '-' }}
                                                        </span>
                                                    </x-td>
                                                    <x-td class="py-2 text-sm">
                                                        {{ $detailData ? $detailData->deskripsi : '-' }}
                                                    </x-td>
                                                </x-tr>
                                            @endforeach
                                        @else
                                            {{-- Mapel tanpa sub detail --}}
                                            @php
                                                $headData = $data['book_details']->get('head_' . $mapelHead->id);
                                            @endphp
                                            <x-tr>
                                                <x-td class="font-semibold py-2">{{ $mapelHead->nama_mapel }}</x-td>
                                                <x-td class="text-center py-2 mapel-col">
                                                    <span class="font-bold text-emerald-700 dark:text-emerald-200">
                                                        {{ $headData ? $headData->nilai_akhir : '-' }}
                                                    </span>
                                                </x-td>
                                                <x-td class="py-2 text-sm">
                                                    {{ $headData ? $headData->deskripsi : '-' }}
                                                </x-td>
                                            </x-tr>
                                        @endif
                                    @endforeach
                                @else
                                    <x-tr>
                                        <x-td colspan="4" class="text-center text-gray-500 py-4">
                                            Tidak ada data mata pelajaran
                                        </x-td>
                                    </x-tr>
                                @endif
                            </tbody>
                        </x-table>
                    </div>
                </div>
            @empty
                <div class="w-full shadow rounded-md p-8 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-gray-400 text-center">
                    <i class="fa-solid fa-inbox text-6xl mb-4 text-gray-400"></i>
                    <p class="text-xl font-semibold text-gray-600 dark:text-gray-400">Tidak Ada Data Nilai</p>
                    <p class="text-sm text-gray-500 dark:text-gray-500 mt-2">
                        Siswa ini belum memiliki data nilai pada Buku Induk untuk kelas 7, 8, atau 9.
                    </p>
                </div>
            @endforelse
        @else
            @if($selectedNisn)
                <div class="w-full shadow rounded-md p-8 bg-red-50 dark:bg-red-900/20 text-red-900 dark:text-red-100 border-t-4 border-red-500 text-center">
                    <i class="fa-solid fa-exclamation-circle text-6xl mb-4 text-red-500"></i>
                    <p class="text-xl font-semibold">Siswa Tidak Ditemukan</p>
                    <p class="text-sm mt-2">NISN yang Anda pilih tidak ditemukan dalam database.</p>
                </div>
            @else
                <div class="w-full shadow rounded-md p-8 bg-blue-50 dark:bg-blue-900/20 text-blue-900 dark:text-blue-100 border-t-4 border-blue-500 text-center">
                    <i class="fa-solid fa-info-circle text-6xl mb-4 text-blue-500"></i>
                    <p class="text-xl font-semibold">Pilih Siswa</p>
                    <p class="text-sm mt-2">Silakan pilih siswa dari dropdown di atas untuk melihat rekap nilai.</p>
                </div>
            @endif
        @endif

    </section>

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Auto-submit form when NISN is selected
                const nisnSelect = document.getElementById('nisnSelect');
                
                if (nisnSelect) {
                    nisnSelect.addEventListener('change', function() {
                        if (this.value) {
                            document.getElementById('siswaForm').submit();
                        }
                    });
                }
            });
        </script>
    @endpush

</x-app-layout>
