<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Raport - {{ $siswa->nama_siswa }}</title>
    <style>
        @page {
            size: A4;
            margin: 2cm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 10pt;
            line-height: 1.3;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 5px;
            /* border-bottom: 3px solid #000; */
            padding-bottom: 8px;
        }
        
        .header-logos {
            display: table;
            width: 100%;
            margin-bottom: 5px;
        }
        
        .header-logo-left,
        .header-logo-right {
            display: table-cell;
            width: 80px;
            vertical-align: middle;
        }
        
        .header-content {
            display: table-cell;
            vertical-align: middle;
            text-align: center;
        }
        
        .header img {
            width: 80px;
            height: 80px;
            object-fit: contain;
        }
        
        .header h1 {
            font-size: 14pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 3px 0;
            letter-spacing: 0.5px;
        }
        
        .header p {
            font-size: 9pt;
            margin: 1px 0;
        }
        
        .header .subtitle {
            font-size: 10pt;
            font-style: italic;
        }
        
        .info-section {
            margin: 3px 0;
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
            padding: 8px 0;
        }
        
        .info-table {
            width: 100%;
            border: none;
        }
        
        .info-table td {
            border: none;
            padding: 1px 5px;
            font-size: 9pt;
            vertical-align: top;
        }
        
        .info-label {
            width: 80px;
            font-weight: normal;
        }
        
        .info-separator {
            width: 10px;
        }
        
        .info-value {
            font-weight: normal;
        }
        
        .section-title {
            font-weight: bold;
            font-size: 11pt;
            margin: 12px 0 3px 0;
            text-align: start;
            letter-spacing: 0.5px;
        }
        
        table.data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        
        table.data-table, 
        table.data-table th, 
        table.data-table td {
            border: 1px solid #000;
        }
        
        table.data-table th {
            background-color: #fff;
            font-weight: bold;
            padding: 5px 3px;
            text-align: center;
            font-size: 9pt;
            vertical-align: middle;
        }
        
        table.data-table td {
            padding: 4px 5px;
            font-size: 9pt;
            vertical-align: top;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-left {
            text-align: left;
        }
        
        .text-right {
            text-align: right;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .indent {
            padding-left: 20px;
        }
        
        .catatan-box {
            border: 1px solid #000;
            padding: 8px;
            min-height: 70px;
            margin-bottom: 20px;
            font-size: 9pt;
        }
        
        .kenaikan-box {
            border: 1px solid #000;
            padding: 6px;
            margin-bottom: 30px;
            font-size: 9pt;
        }
        
        .signature-section {
            margin-top: 15px;
            display: table;
            width: 100%;
        }
        
        .signature-col {
            display: table-cell;
            width: 33.33%;
            text-align: center;
            vertical-align: top;
            padding: 0 5px;
        }
        
        .signature-title {
            font-weight: normal;
            margin-bottom: 70px;
            font-size: 9pt;
        }
        
        .signature-name {
            font-weight: bold;
            border-bottom: 1px solid #000;
            padding-bottom: 2px;
            margin: 0 15px;
            font-size: 9pt;
        }
        
        .signature-nip {
            font-size: 8pt;
            margin-top: 2px;
        }
        
        .date-section {
            text-align: right;
            margin-bottom: 8px;
            font-size: 9pt;
        }
        
        .page-break {
            page-break-after: always;
        }
        
        .bg-gray {
            background-color: #f5f5f5;
        }
    </style>
</head>
<body style="margin: 1cm;">
    @php
        $madrasahName = 'MTsS Al Ikhlas Panganten';
        $alamatMadrasah = 'Kp. Panganten';
    @endphp

    <div class="header">
        <div class="header-logos">
            <div class="header-logo-left">
                <img src="{{ public_path('img/logoUtama.png') }}" alt="Logo Kiri" />
            </div>
            <div class="header-content">
                <p style="font-weight: bold;">KEMENTERIAN AGAMA REPUBLIK INDONESIA</p>
                <h1 style="margin-top: -3px;">MTSS AL IKHLAS PANGANTEN</h1>
                <p class="subtitle" style="margin-top: -2px;">KP. Panganten</p>
                <p class="subtitle">Kecamatan Cigalontang, Kabupaten Tasikmalaya - Jawa Barat</p>
            </div>
            <div class="header-logo-right">
                <img src="{{ public_path('img/logoKedua.png') }}" alt="Logo Kanan" />
            </div>
        </div>
    </div>

    <div class="info-section">
        <table class="info-table">
            <tr>
                <td class="info-label">Nama</td>
                <td class="info-separator">:</td>
                <td class="info-value">{{ strtoupper($siswa->nama_siswa) }}</td>
                <td class="info-label">Kelas</td>
                <td class="info-separator">:</td>
                <td class="info-value">{{ $kelasDisplay }}</td>
            </tr>
            <tr>
                <td class="info-label">NIS/NISN</td>
                <td class="info-separator">:</td>
                <td class="info-value">{{ $siswa->nis }} / {{ $siswa->nisn }}</td>
                <td class="info-label">Fase</td>
                <td class="info-separator">:</td>
                <td class="info-value">{{ $raportHead->fase }}</td>
            </tr>
            <tr>
                <td class="info-label">Madrasah</td>
                <td class="info-separator">:</td>
                <td class="info-value">{{ $madrasahName }}</td>
                <td class="info-label">Semester</td>
                <td class="info-separator">:</td>
                <td class="info-value">{{ $raportHead->semester }}</td>
            </tr>
            <tr>
                <td class="info-label">Alamat</td>
                <td class="info-separator">:</td>
                <td class="info-value">{{ $alamatMadrasah }}</td>
                <td class="info-label">Tahun Ajaran</td>
                <td class="info-separator">:</td>
                <td class="info-value">{{ $raportHead->thn_ajaran_awal }}/{{ $raportHead->thn_ajaran_akhir }}</td>
            </tr>
        </table>
    </div>

    <div class="section-title" style="text-align: center !important;">CAPAIAN HASIL BELAJAR</div>
    <table class="data-table">
        <thead>
            <tr>
                <th style="width: 25px; text-align: center;">No</th>
                <th style="text-align: center; width: 250px;">Mata Pelajaran</th>
                <th style="text-align: center; width: 70px;">Nilai Akhir</th>
                <th style="text-align: center;">Capaian Kompetensi</th>
            </tr>
        </thead>
        <tbody>
            @php $rowNumber = 1; @endphp
            @foreach ($mapelHeads as $head)
                @php
                    $headScore = $headScores->get($head->id);
                    $details = $head->details;
                    $detailsCount = $details->count();
                    $rowspan = $detailsCount > 0 ? $detailsCount + 1 : 1;
                @endphp
                <tr>
                    <td class="text-center" style="vertical-align: top !important;" rowspan="{{ $rowspan }}">{{ $rowNumber++ }}</td>
                    <td style="vertical-align: middle !important;">{{ $head->nama_mapel }}</td>
                    <td class="text-center" style="vertical-align: middle !important;">{{ optional($headScore)->nilai_akhir ?? '' }}</td>
                    <td style="text-align: justify; vertical-align: middle !important;">{{ optional($headScore)->deskripsi ?? '' }}</td>
                </tr>
                @foreach ($details as $detailIndex => $detail)
                    @php
                        $detailScore = $detailScores->get($detail->id);
                    @endphp
                    <tr>
                        <td class="indent" style="vertical-align: middle !important;">{{ chr(65 + $detailIndex) }}. {{ $detail->nama_mapel_detail }}</td>
                        <td class="text-center" style="vertical-align: middle !important;">{{ optional($detailScore)->nilai_akhir ?? '-' }}</td>
                        <td style="text-align: justify; vertical-align: middle !important;">{{ optional($detailScore)->deskripsi ?? '-' }}</td>
                    </tr>
                @endforeach
            @endforeach
        </tbody>
        <tfoot>
            <tr style="font-weight: bold;">
                <td colspan="2" class="text-right font-bold">Jumlah</td>
                <td class="text-center font-bold">{{ number_format((float) ($raportHead->jml_nilai_akhir ?? 0), 0) }}</td>
                <td></td>
            </tr>
        </tfoot>
    </table>

    <div class="page-break"></div>

    <div class="section-title">Ekstrakurikuler</div>
    <table class="data-table">
        <thead>
            <tr>
                <th style="width: 25px;">No</th>
                <th>Kegiatan Ekstrakurikuler</th>
                <th style="width: 70px;">Nilai</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($ekskulPengisian as $row)
                <tr>
                    <td class="text-center">{{ $loop->iteration }}</td>
                    <td>{{ optional($row->ekskul)->nama_ekskul ?? '-' }}</td>
                    <td class="text-center">{{ optional($row->ketNilai)->nama_keterangan ?? '-' }}</td>
                    <td>{{ $row->keterangan ?? '-' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="text-center">Belum ada data ekstrakurikuler</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="section-title">Prestasi</div>
    <table class="data-table">
        <thead>
            <tr>
                <th style="width: 25px;">No</th>
                <th>Jenis Prestasi</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($prestasiPengisian as $row)
                <tr>
                    <td class="text-center">{{ $loop->iteration }}</td>
                    <td>{{ $row->jenis_prestasi ?? '-' }}</td>
                    <td>{{ $row->keterangan ?? '-' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="3" class="text-center">Belum ada data prestasi</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="section-title">Ketidakhadiran</div>
    <table class="data-table">
        <tbody>
            @php
                $ketidakhadiranLabels = [
                    'sakit' => 'Sakit',
                    'izin' => 'Izin',
                    'alpa' => 'Alpa',
                ];
            @endphp
            @foreach ($ketidakhadiranLabels as $key => $label)
                <tr>
                    <td class="font-bold">{{ $label }}</td>
                    <td class="text-center" style="width: 60px;">{{ $ketidakhadiran[$key] ?? 0 }}</td>
                    <td class="text-center" style="width: 60px;">Hari</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="section-title">Catatan Pendidik</div>
    <div class="catatan-box">
        @if (filled($raportHead->catatan_pendidik))
            {!! nl2br(e($raportHead->catatan_pendidik)) !!}
        @else
            -
        @endif
    </div>

    @if ($raportHead->semester === 'Genap')
        <div class="kenaikan-box">
            <strong>Keterangan Kenaikan Kelas:</strong> {{ $raportHead->keterangan_kenaikan ?? '-' }}
        </div>
    @endif

    <div class="date-section">
        Tasikmalaya, {{ $formattedTanggal ?? '-' }}
    </div>

    <div class="signature-section">
        <div class="signature-col">
            <div class="signature-title">Orang Tua/Wali</div>
            <div class="signature-name"></div>
        </div>
        <div class="signature-col">
        </div>
        <div class="signature-col">
            <div class="signature-title">Wali Kelas</div>
            <div class="signature-name">{{ optional($raportHead->waliKelas)->nama_guru ?? '-' }}</div>
            <div class="signature-nip">NIP. {{ optional($raportHead->waliKelas)->nip ?? '-' }}</div>
        </div>
    </div>

    <div class="signature-section" style="margin-top: 10px;">
        <div class="signature-col">
        </div>
        <div class="signature-col">
            <div class="signature-title">Mengetahui<br>Kepala Madrasah</div>
            <div class="signature-name">{{ optional($raportHead->kepalaSekolah)->nama_lengkap ?? '-' }}</div>
            <div class="signature-nip">NIP. {{ optional($raportHead->kepalaSekolah)->nip ?? '-' }}</div>
        </div>
        <div class="signature-col">
        </div>
    </div>
</body>
</html>
