@php
    $madrasahName = 'MTsS Al Ikhlas Panganten';
    $alamatMadrasah = 'Kp. Panganten';
@endphp

<div class="header">
    <div class="header-logos">
        <div class="header-logo-left">
            <img src="{{ public_path('img/logoUtama.png') }}" alt="Logo Kiri" />
        </div>
        <div class="header-content">
            <p style="font-weight: bold;">KEMENTERIAN AGAMA REPUBLIK INDONESIA</p>
            <h1 style="margin-top: -3px;">MTSS AL IKHLAS PANGANTEN</h1>
            <p class="subtitle" style="margin-top: -2px;">KP. Panganten</p>
            <p class="subtitle">Kecamatan Cigalontang, Kabupaten Tasikmalaya - Jawa Barat</p>
        </div>
        <div class="header-logo-right">
            <img src="{{ public_path('img/logoKedua.png') }}" alt="Logo Kanan" />
        </div>
    </div>
</div>

<div class="info-section">
    <table class="info-table">
        <tr>
            <td class="info-label">Nama</td>
            <td class="info-separator">:</td>
            <td class="info-value">{{ strtoupper($siswa->nama_siswa) }}</td>
            <td class="info-label">Kelas</td>
            <td class="info-separator">:</td>
            <td class="info-value">{{ $kelasDisplay }}</td>
        </tr>
        <tr>
            <td class="info-label">NIS/NISN</td>
            <td class="info-separator">:</td>
            <td class="info-value">{{ $siswa->nis }} / {{ $siswa->nisn }}</td>
            <td class="info-label">Fase</td>
            <td class="info-separator">:</td>
            <td class="info-value">{{ $raportHead->fase }}</td>
        </tr>
        <tr>
            <td class="info-label">Madrasah</td>
            <td class="info-separator">:</td>
            <td class="info-value">{{ $madrasahName }}</td>
            <td class="info-label">Semester</td>
            <td class="info-separator">:</td>
            <td class="info-value">{{ $raportHead->semester }}</td>
        </tr>
        <tr>
            <td class="info-label">Alamat</td>
            <td class="info-separator">:</td>
            <td class="info-value">{{ $alamatMadrasah }}</td>
            <td class="info-label">Tahun Ajaran</td>
            <td class="info-separator">:</td>
            <td class="info-value">{{ $raportHead->thn_ajaran_awal }}/{{ $raportHead->thn_ajaran_akhir }}</td>
        </tr>
    </table>
</div>

<div class="section-title" style="text-align: center !important;">CAPAIAN HASIL BELAJAR</div>
<table class="data-table">
    <thead>
        <tr>
            <th style="width: 25px; text-align: center;">No.</th>
            <th style="text-align: center; width: 250px;">Mata Pelajaran</th>
            <th style="text-align: center; width: 70px;">Nilai Akhir</th>
            <th style="text-align: center;">Capaian Kompetensi</th>
        </tr>
    </thead>
    <tbody>
        @php $rowNumber = 1; @endphp
        @foreach ($mapelHeads as $head)
            @php
                $headScore = $headScores->get($head->id);
                $details = $head->details;
                $detailsCount = $details->count();
                $rowspan = $detailsCount > 0 ? $detailsCount + 1 : 1;
            @endphp
            <tr>
                <td class="text-center" style="vertical-align: top !important;" rowspan="{{ $rowspan }}">{{ $rowNumber++ }}</td>
                <td style="vertical-align: middle !important;">{{ $head->nama_mapel }}</td>
                <td class="text-center" style="vertical-align: middle !important;">{{ optional($headScore)->nilai_akhir ?? '' }}</td>
                <td style="text-align: justify; vertical-align: middle !important;">{{ optional($headScore)->deskripsi ?? '' }}</td>
            </tr>
            @foreach ($details as $detailIndex => $detail)
                @php
                    $detailScore = $detailScores->get($detail->id);
                @endphp
                <tr>
                    <td class="indent" style="vertical-align: middle !important;">{{ chr(65 + $detailIndex) }}. {{ $detail->nama_mapel_detail }}</td>
                    <td class="text-center" style="vertical-align: middle !important;">{{ optional($detailScore)->nilai_akhir ?? '-' }}</td>
                    <td style="text-align: justify; vertical-align: middle !important;">{{ optional($detailScore)->deskripsi ?? '-' }}</td>
                </tr>
            @endforeach
        @endforeach
    </tbody>
    <tfoot>
        <tr style="font-weight: bold;">
            <td colspan="2" class="text-right font-bold">Jumlah</td>
            <td class="text-center font-bold">{{ number_format((float) ($raportHead->jml_nilai_akhir ?? 0), 0) }}</td>
            <td></td>
        </tr>
    </tfoot>
</table>

<div style="page-break-after: always;"></div>

<div class="section-title">EKSTRAKURIKULER</div>
<table class="data-table">
    <thead>
        <tr>
            <th style="width: 25px;">No.</th>
            <th>Kegiatan Ekstrakurikuler</th>
            <th style="width: 70px;">Nilai</th>
            <th>Keterangan</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($ekskulPengisian as $row)
            <tr>
                <td class="text-center">{{ $loop->iteration }}</td>
                <td>{{ optional($row->ekskul)->nama_ekskul ?? '-' }}</td>
                <td class="text-center">{{ optional($row->ketNilai)->nama_keterangan ?? '-' }}</td>
                <td>{{ $row->keterangan ?? '-' }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="4" class="text-center">-</td>
            </tr>
        @endforelse
    </tbody>
</table>

<div class="section-title">PRESTASI</div>
<table class="data-table">
    <thead>
        <tr>
            <th style="width: 25px;">No.</th>
            <th>Jenis Prestasi</th>
            <th>Keterangan</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($prestasiPengisian as $row)
            <tr>
                <td class="text-center">{{ $loop->iteration }}</td>
                <td>{{ $row->jenis_prestasi ?? '-' }}</td>
                <td>{{ $row->keterangan ?? '-' }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="3" class="text-center">-</td>
            </tr>
        @endforelse
    </tbody>
</table>

<div class="section-title">KETIDAKHADIRAN</div>
<table class="data-table">
    <tbody>
        @php
            $ketidakhadiranLabels = [
                'sakit' => 'Sakit',
                'izin' => 'Izin',
                'alpa' => 'Alpa',
            ];
        @endphp
        @foreach ($ketidakhadiranLabels as $key => $label)
            <tr>
                <td class="font-bold">{{ $label }}</td>
                <td class="text-center" style="width: 60px;">{{ $ketidakhadiran[$key] ?? 0 }}</td>
                <td class="text-center" style="width: 60px;">Hari</td>
            </tr>
        @endforeach
    </tbody>
</table>

<div class="section-title">CATATAN PENDIDIK</div>
<div class="catatan-box">
    @if (filled($raportHead->catatan_pendidik))
        {!! nl2br(e($raportHead->catatan_pendidik)) !!}
    @else
        -
    @endif
</div>

@if ($raportHead->semester === 'Genap')
    <div class="kenaikan-box">
        <strong>Keterangan Kenaikan Kelas:</strong> {{ $raportHead->keterangan_kenaikan ?? '-' }}
    </div>
@endif

<div class="date-section">
    Tasikmalaya, {{ $formattedTanggal ?? '-' }}
</div>

<div class="signature-section">
    <div class="signature-col">
        <div class="signature-title">Orang Tua/Wali</div>
        <div class="signature-name"></div>
    </div>
    <div class="signature-col">
    </div>
    <div class="signature-col">
        <div class="signature-title">Wali Kelas</div>
        <div class="signature-name">{{ optional($raportHead->waliKelas)->nama_guru ?? '-' }}</div>
        <div class="signature-nip">NIP. {{ optional($raportHead->waliKelas)->nip ?? '-' }}</div>
    </div>
</div>

<div class="signature-section" style="margin-top: 10px;">
    <div class="signature-col">
    </div>
    <div class="signature-col">
        <div class="signature-title">Mengetahui<br>Kepala Madrasah</div>
        <div class="signature-name">{{ optional($raportHead->kepalaSekolah)->nama_lengkap ?? '-' }}</div>
        <div class="signature-nip">NIP. {{ optional($raportHead->kepalaSekolah)->nip ?? '-' }}</div>
    </div>
    <div class="signature-col">
    </div>
</div>
