<title>Input Raport</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="mb-2 md:mb-4 -mt-3">
            <h1 class="md:flex justify-between items-center">
                <div class="flex gap-2 mt-3 md:mt-0">
                    <i class="fa-solid fa-book text-3xl mt-1 font-bold"></i>
                    <div>
                        <p class="text-xl sm:text-2xl font-bold">Raport</p>
                        <p class="text-xs sm:text-sm ms-[1px] -mt-1">Index</p>
                    </div>
                </div>
                @can('Admin')
                    <div class="flex items-center gap-2">
                        <div class="flex mt-4">
                            <form id="tahunAjaranForm" action="{{ route('raport.index') }}" method="GET"
                                class="flex gap-2 items-center">
                                <div>
                                    <x-label class="whitespace-nowrap font-semibold text-xs">Tahun Ajaran</x-label>
                                    <x-select name="tahun_ajaran"
                                        class="{{ $errors->first('tahun_ajaran') ? 'border-red-500' : '' }} text-xs">
                                        @forelse($dataTahunAjaran as $tahunAjaran)
                                            @php
                                                $value = $tahunAjaran->tahun_awal . '/' . $tahunAjaran->tahun_akhir;
                                            @endphp
                                            <option value="{{ $value }}"
                                                {{ $value === $selectedTahunAjaran ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @empty
                                            <option value="" disabled>Tidak ada data tahun ajaran</option>
                                        @endforelse
                                    </x-select>
                                </div>
                                <div>
                                    <x-label class="whitespace-nowrap font-semibold text-xs">Kelas</x-label>
                                    <x-select name="kelasSelect"
                                        class="{{ $errors->first('kelasSelect') ? 'border-red-500' : '' }} text-xs">
                                        <option value="all" {{ ($selectedKelas ?? 'all') === 'all' ? 'selected' : '' }}>
                                            Semua Kelas</option>
                                        <option value="7" {{ ($selectedKelas ?? '') === '7' ? 'selected' : '' }}>VII
                                            (7)</option>
                                        <option value="8" {{ ($selectedKelas ?? '') === '8' ? 'selected' : '' }}>VIII
                                            (8)</option>
                                        <option value="9" {{ ($selectedKelas ?? '') === '9' ? 'selected' : '' }}>IX (9)
                                        </option>
                                    </x-select>
                                </div>
                                <div>
                                    <x-label class="whitespace-nowrap font-semibold text-xs">Semester</x-label>
                                    <x-select name="semesterSelect"
                                        class="{{ $errors->first('semesterSelect') ? 'border-red-500' : '' }} text-xs">
                                        <option value="all"
                                            {{ ($selectedSemester ?? 'all') === 'all' ? 'selected' : '' }}>Semua Semester
                                        </option>
                                        <option value="ganjil"
                                            {{ ($selectedSemester ?? '') === 'ganjil' ? 'selected' : '' }}>Semester Ganjil
                                        </option>
                                        <option value="genap"
                                            {{ ($selectedSemester ?? '') === 'genap' ? 'selected' : '' }}>Semester Genap
                                        </option>
                                    </x-select>
                                </div>
                            </form>
                        </div>
                        <div>
                            <x-label class="whitespace-nowrap font-semibold text-xs">Reset</x-label>
                            <a href="/raport"
                                class="border border-gray-400 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 hover:bg-primary dark:hover:bg-primary hover:text-light hover:border-transparent rounded-lg py-2 px-4 text-sm flex items-center">
                                <i class="fa-solid fa-arrows-rotate text-xs"></i>
                            </a>
                        </div>
                        <div class="flex-col flex">
                            <x-label class="whitespace-nowrap font-semibold text-transparent text-xs">Unduh</x-label>
                            <button type="button" id="downloadAllRaport"
                                class="whitespace-nowrap inline-block px-3 py-2 bg-indigo-500 text-white text-xs rounded hover:bg-indigo-600">
                                <i class="fa-solid fa-download"></i> Unduh Semua
                            </button>
                        </div>
                    </div>
                @endcan
            </h1>
        </div>

        {{-- Card Progress Wali Kelas (hanya untuk role Wali) --}}
        @if (Auth::user()->role === 'Wali' && $waliKelasProgress)
            <div class="mb-6 flex gap-5">
                <div
                    class="bg-gray-50 dark:bg-gray-800 rounded-lg p-4 shadow shadow-gray-300 dark:shadow-gray-700 border-t-2 border-primary w-full">
                    @php
                        $percentageGanjil = $waliKelasProgress['ganjil']['progress_percentage'];
                        $isCompleteGanjil = $percentageGanjil >= 100;
                        $isHighGanjil = $percentageGanjil >= 75 && $percentageGanjil < 100;
                        $isMediumGanjil = $percentageGanjil >= 50 && $percentageGanjil < 75;

                        if ($isCompleteGanjil) {
                            $progressColorGanjil = 'text-emerald-700 dark:text-emerald-200';
                        } elseif ($isHighGanjil) {
                            $progressColorGanjil = 'text-yellow-600 dark:text-yellow-300';
                        } elseif ($isMediumGanjil) {
                            $progressColorGanjil = 'text-yellow-600 dark:text-yellow-300';
                        } else {
                            $progressColorGanjil = 'text-red-600 dark:text-red-300';
                        }
                    @endphp

                    <h1 class="text-primary dark:text-hvPrimary font-bold">Semester Ganjil</h1>
                    <div class="border border-gray-400 border-dashed mb-3 mt-2"></div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="relative w-16 h-16">
                                <svg class="w-16 h-16 transform -rotate-90">
                                    <circle cx="32" cy="32" r="28" stroke="currentColor" stroke-width="6"
                                        fill="none" class="text-gray-300 dark:text-gray-600" />
                                    <circle cx="32" cy="32" r="28" stroke="currentColor" stroke-width="6"
                                        fill="none" class="{{ $progressColorGanjil }}"
                                        stroke-dasharray="{{ 2 * 3.14159 * 28 }}"
                                        stroke-dashoffset="{{ 2 * 3.14159 * 28 * (1 - $percentageGanjil / 100) }}"
                                        stroke-linecap="round" />
                                </svg>
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <span
                                        class="text-sm font-bold {{ $progressColorGanjil }}">{{ number_format($percentageGanjil, 0) }}%</span>
                                </div>
                            </div>
                            <div>
                                <p class="text-xs md:text-base text-gray-600 dark:text-gray-300 font-medium">Progress Input</p>
                                <p class="text-xl md:text-2xl font-bold {{ $progressColorGanjil }}">
                                    {{ $waliKelasProgress['ganjil']['sudah_input'] }}/{{ $waliKelasProgress['ganjil']['harus_input'] }}
                                </p>
                            </div>
                        </div>
                    </div>

                </div>
                <div
                    class="bg-gray-50 dark:bg-gray-800 rounded-lg p-4 shadow shadow-gray-300 dark:shadow-gray-700 border-t-2 border-primary w-full">

                    @php
                        $percentageGenap = $waliKelasProgress['genap']['progress_percentage'];
                        $isCompleteGenap = $percentageGenap >= 100;
                        $isHighGenap = $percentageGenap >= 75 && $percentageGenap < 100;
                        $isMediumGenap = $percentageGenap >= 50 && $percentageGenap < 75;

                        if ($isCompleteGenap) {
                            $progressColorGenap = 'text-emerald-700 dark:text-emerald-200';
                        } elseif ($isHighGenap) {
                            $progressColorGenap = 'text-yellow-600 dark:text-yellow-300';
                        } elseif ($isMediumGenap) {
                            $progressColorGenap = 'text-yellow-600 dark:text-yellow-300';
                        } else {
                            $progressColorGenap = 'text-red-600 dark:text-red-300';
                        }
                    @endphp

                    <h1 class="text-primary dark:text-hvPrimary font-bold">Semester Genap</h1>
                    <div class="border border-gray-400 border-dashed mb-3 mt-2"></div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="relative w-16 h-16">
                                <svg class="w-16 h-16 transform -rotate-90">
                                    <circle cx="32" cy="32" r="28" stroke="currentColor" stroke-width="6"
                                        fill="none" class="text-gray-300 dark:text-gray-600" />
                                    <circle cx="32" cy="32" r="28" stroke="currentColor" stroke-width="6"
                                        fill="none" class="{{ $progressColorGenap }}"
                                        stroke-dasharray="{{ 2 * 3.14159 * 28 }}"
                                        stroke-dashoffset="{{ 2 * 3.14159 * 28 * (1 - $percentageGenap / 100) }}"
                                        stroke-linecap="round" />
                                </svg>
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <span
                                        class="text-sm font-bold {{ $progressColorGenap }}">{{ number_format($percentageGenap, 0) }}%</span>
                                </div>
                            </div>
                            <div>
                                <p class="text-xs md:text-base text-gray-600 dark:text-gray-300 font-medium">Progress Input</p>
                                <p class="text-xl md:text-2xl font-bold {{ $progressColorGenap }}">
                                    {{ $waliKelasProgress['genap']['sudah_input'] }}/{{ $waliKelasProgress['genap']['harus_input'] }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        {{-- Detail Data Cards --}}
        <div id="kelasCardsContainer">
            @if (isset($kelasData) && count($kelasData) > 0)
                @foreach ($kelasData as $index => $data)
                    @php
                        $groupKey = $data['group_key'] ?? 'group-' . $loop->index;
                    @endphp
                    <div class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary {{ $index > 0 ? 'mt-5' : '' }} raport-card"
                        data-group-key="{{ $groupKey }}">
                        <div class="md:flex justify-between items-center mb-4 gap-6">
                            <div>
                                <h1 class="font-bold flex text-sm">
                                    <div class="@if ($data['group_label'] == 'Kelas') w-24 @endif">
                                        {{ $data['group_label'] ?? 'Kelas' }}</div>
                                    <div>: {{ $data['group_value'] ?? '-' }}</div>
                                </h1>
                                {{-- @if (!$isAlumniMode)
                                    <h1 class="font-bold flex text-sm">
                                        <div class="w-24">Angkatan</div>
                                        <div>: {{ $data['angkatan'] ?? '-' }}</div>
                                    </h1>
                                @endif --}}
                                @if (!empty($data['wali_kelas']) && $data['wali_kelas'] !== '-')
                                    <h1 class="font-bold flex text-sm">
                                        <div class="w-24">Wali Kelas</div>
                                        <div>: {{ $data['wali_kelas'] }}</div>
                                    </h1>
                                @endif
                            </div>
                            <div class="flex items-end gap-3 mt-3 md:mt-0">
                                <div>
                                    <x-label class="whitespace-nowrap font-semibold text-xs">Raport
                                        {{ $data['group_value'] ?? '-' }}</x-label>
                                    <x-select name="downloadRaportSelect" data-group-key="{{ $groupKey }}"
                                        class="download-raport-select {{ $errors->first('downloadRaportSelect') ? 'border-red-500' : '' }} text-xs">
                                        <option value="all">Semua Semester</option>
                                        <option value="Ganjil">Semester Ganjil</option>
                                        <option value="Genap">Semester Genap</option>
                                    </x-select>
                                </div>
                                <div>
                                    <button type="button" data-group-key="{{ $groupKey }}"
                                        class="download-raport-btn whitespace-nowrap inline-block px-3 py-2 bg-indigo-500 text-white text-xs rounded hover:bg-indigo-600">
                                        <i class="fa-solid fa-download"></i> Unduh Per-Kelas
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="border border-gray-400 border-dashed my-5"></div>

                        <div class="mb-2 kelasCardsContainer" id="kelasCardsContainer-{{ $groupKey }}">
                            <div class="md:flex gap-5 mb-3 justify-between items-center">
                                <div class="flex gap-5">
                                    <button type="button"
                                        class="semester-tab tab-active font-semibold text-primary dark:text-hvPrimary border-hvPrimary"
                                        data-tab="ganjil">Semester Ganjil</button>
                                    <button type="button"
                                        class="semester-tab tab-inactive border-primary text-gray-600 dark:text-gray-400"
                                        data-tab="genap">Semester Genap</button>
                                </div>
                                <div class="flex items-center gap-2 mt-3 md:mt-0">
                                    <div class="relative inline-block w-full max-w-md">
                                        <x-search-i></x-search-i>
                                        <x-search placeholder="Cari Nama Siswa..."
                                            class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 kelas-search"
                                            data-group-key="{{ $groupKey }}" />
                                    </div>
                                </div>
                            </div>
                            <div class="tab-content" data-tab="ganjil">
                                <div class="overflow-x-auto">
                                    <x-table>
                                        <x-thead>
                                            <tr>
                                                <x-th class="whitespace-nowrap w-14">No.</x-th>
                                                {{-- <x-th class="whitespace-nowrap">NIS / NISN</x-th> --}}
                                                <x-th class="whitespace-nowrap">Nama Siswa</x-th>
                                                <x-th class="whitespace-nowrap">Jenis Kelamin</x-th>
                                                <x-th class="whitespace-nowrap">Status Input</x-th>
                                                <x-th class="whitespace-nowrap">Aksi</x-th>
                                            </tr>
                                        </x-thead>
                                        <tbody id="tbody-ganjil-{{ $groupKey }}">
                                            @forelse($data['students'] as $key => $siswa)
                                                <tr class="student-row"
                                                    data-nama="{{ strtolower($siswa->nama_siswa) }}"
                                                    data-nis="{{ $siswa->nis }}" data-nisn="{{ $siswa->nisn }}">
                                                    <x-td class="text-center py-2">{{ $key + 1 }}</x-td>
                                                    {{-- <x-td class="text-center py-2">{{ $siswa->nis }} /
                                                        {{ $siswa->nisn }}</x-td> --}}
                                                    <x-td class="py-2">{{ $siswa->nama_siswa }}</x-td>
                                                    <x-td class="text-center py-2">{{ $siswa->jenis_kelamin }}</x-td>
                                                    @php
                                                        $ganjilStatus = data_get(
                                                            $siswa->raport_status ?? [],
                                                            'Ganjil',
                                                            false,
                                                        );
                                                        $ganjilHeadId = data_get(
                                                            $siswa->raport_head_ids ?? [],
                                                            'Ganjil',
                                                        );
                                                        $ganjilDetailUrl =
                                                            $ganjilStatus && $ganjilHeadId
                                                                ? route('raport.show', $ganjilHeadId)
                                                                : route('raport.show', [
                                                                    'raport' => $siswa->id,
                                                                    'semester' => 'Ganjil',
                                                                ]);
                                                    @endphp
                                                    <x-td class="text-center py-2 whitespace-nowrap">
                                                        @if ($ganjilStatus)
                                                            <span
                                                                class="px-2 py-1 text-xs rounded-full font-semibold bg-green-200 text-green-700">
                                                                Sudah Input
                                                            </span>
                                                        @else
                                                            <span
                                                                class="px-2 py-1 text-xs rounded-full font-semibold bg-red-200 text-red-700">
                                                                Belum Input
                                                            </span>
                                                        @endif
                                                    </x-td>
                                                    <x-td class="text-center py-2 whitespace-nowrap">
                                                        @if ($ganjilStatus && $ganjilHeadId)
                                                            <a href="{{ route('raport.edit', $ganjilHeadId) }}"
                                                                class="whitespace-nowrap px-3 py-1 bg-amber-500 text-white text-xs rounded hover:bg-amber-600">
                                                                <i class="fa-solid fa-pen"></i> Edit
                                                            </a>
                                                        @else
                                                            @if (!empty($data['wali_kelas']) && $data['wali_kelas'] !== '-' && $data['wali_kelas'] !== 'Belum Ditentukan')
                                                                <a href="{{ route('raport.create', [$siswa->id, 'semester' => 'Ganjil']) }}"
                                                                    class="whitespace-nowrap px-3 py-1 bg-green-500 text-white text-xs rounded hover:bg-green-600">
                                                                    <i class="fa-solid fa-plus"></i> Input
                                                                </a>
                                                            @else
                                                                <button type="button"
                                                                    data-modal-target="validasiWaliKelas"
                                                                    data-modal-toggle="validasiWaliKelas"
                                                                    class="whitespace-nowrap px-3 py-1 bg-green-500 text-white text-xs rounded hover:bg-green-600">
                                                                    <i class="fa-solid fa-plus"></i> Input
                                                                </button>
                                                            @endif
                                                        @endif
                                                        @if ($ganjilStatus && $ganjilHeadId)
                                                            <a href="{{ $ganjilDetailUrl }}"
                                                                class="whitespace-nowrap px-3 py-1 mx-1 bg-sky-500 text-white text-xs rounded hover:bg-sky-600">
                                                                <i class="fa-solid fa-eye"></i> Lihat
                                                            </a>
                                                        @else
                                                            <button type="button" disabled
                                                                class="whitespace-nowrap px-3 py-1 mx-1 bg-gray-400 text-white text-xs rounded cursor-not-allowed"
                                                                title="Raport belum tersedia">
                                                                <i class="fa-solid fa-eye"></i> Lihat
                                                            </button>
                                                        @endif
                                                        @if ($ganjilStatus && $ganjilHeadId)
                                                            <a href="{{ route('raport.download', $ganjilHeadId) }}"
                                                                class="whitespace-nowrap px-3 py-1 bg-indigo-500 text-white text-xs rounded hover:bg-indigo-600">
                                                                <i class="fa-solid fa-download"></i> Unduh
                                                            </a>
                                                        @else
                                                            <button type="button" disabled
                                                                class="whitespace-nowrap px-3 py-1 bg-gray-400 text-white text-xs rounded cursor-not-allowed"
                                                                title="Raport belum tersedia">
                                                                <i class="fa-solid fa-download"></i> Unduh
                                                            </button>
                                                        @endif
                                                    </x-td>
                                                </tr>
                                            @empty
                                                <tr class="no-data-row">
                                                    <x-td colspan="7" class="text-center text-gray-500">
                                                        Tidak ada siswa ditemukan
                                                    </x-td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </x-table>
                                </div>
                            </div>
                            <div class="tab-content hidden" data-tab="genap">
                                <div class="overflow-x-auto">
                                    <x-table>
                                        <x-thead>
                                            <tr>
                                                <x-th class="whitespace-nowrap w-14">No.</x-th>
                                                {{-- <x-th class="whitespace-nowrap">NIS / NISN</x-th> --}}
                                                <x-th class="whitespace-nowrap">Nama Siswa</x-th>
                                                <x-th class="whitespace-nowrap">Jenis Kelamin</x-th>
                                                <x-th class="whitespace-nowrap">Status Input</x-th>
                                                <x-th class="whitespace-nowrap">Keterangan</x-th>

                                                <x-th class="whitespace-nowrap">Aksi</x-th>
                                            </tr>
                                        </x-thead>
                                        <tbody id="tbody-genap-{{ $groupKey }}">
                                            @forelse($data['students'] as $key => $siswa)
                                                <tr class="student-row"
                                                    data-nama="{{ strtolower($siswa->nama_siswa) }}"
                                                    data-nis="{{ $siswa->nis }}" data-nisn="{{ $siswa->nisn }}">
                                                    <x-td class="text-center py-2">{{ $key + 1 }}</x-td>
                                                    {{-- <x-td class="text-center py-2">{{ $siswa->nis }} /
                                                        {{ $siswa->nisn }}</x-td> --}}
                                                    <x-td class="py-2">{{ $siswa->nama_siswa }}</x-td>
                                                    <x-td class="text-center py-2">{{ $siswa->jenis_kelamin }}</x-td>
                                                    @php
                                                        $genapStatus = data_get(
                                                            $siswa->raport_status ?? [],
                                                            'Genap',
                                                            false,
                                                        );
                                                        $genapHeadId = data_get($siswa->raport_head_ids ?? [], 'Genap');
                                                        $genapDetailUrl =
                                                            $genapStatus && $genapHeadId
                                                                ? route('raport.show', $genapHeadId)
                                                                : route('raport.show', [
                                                                    'raport' => $siswa->id,
                                                                    'semester' => 'Genap',
                                                                ]);
                                                    @endphp
                                                    <x-td class="text-center py-2 whitespace-nowrap">
                                                        @if ($genapStatus)
                                                            <span
                                                                class="px-2 py-1 text-xs rounded-full font-semibold bg-green-200 text-green-700">
                                                                Sudah Input
                                                            </span>
                                                        @else
                                                            <span
                                                                class="px-2 py-1 text-xs rounded-full font-semibold bg-red-200 text-red-700">
                                                                Belum Input
                                                            </span>
                                                        @endif
                                                    </x-td>
                                                    @php
                                                        $badgeLabel = '-';
                                                        $badgeClass = '';
                                                        if ($genapStatus) {
                                                            $keteranganKenaikan = $siswa->keterangan_kenaikan;
                                                            if (is_null($keteranganKenaikan)) {
                                                                $kelasNomor = $siswa->kelas->nama_kelas_nomor ?? null;
                                                                $keteranganKenaikan =
                                                                    $kelasNomor === 9 ? 'Lulus' : 'Naik Kelas';
                                                            }

                                                            $badgeLabel = $keteranganKenaikan;
                                                            $positives = ['Naik Kelas', 'Lulus'];
                                                            $negatives = ['Tidak Naik Kelas', 'Tidak Lulus'];

                                                            if (in_array($keteranganKenaikan, $positives, true)) {
                                                                $badgeClass = 'bg-green-200 text-green-700';
                                                            } elseif (in_array($keteranganKenaikan, $negatives, true)) {
                                                                $badgeClass = 'bg-red-200 text-red-700';
                                                            } else {
                                                                $badgeClass = 'bg-gray-200 text-gray-700';
                                                            }
                                                        }
                                                    @endphp
                                                    <x-td class="text-center py-2 whitespace-nowrap">
                                                        @if ($genapStatus)
                                                            <span
                                                                class="px-2 py-1 text-xs rounded-full font-semibold {{ $badgeClass }}">
                                                                {{ $badgeLabel }}
                                                            </span>
                                                        @else
                                                            -
                                                        @endif
                                                    </x-td>
                                                    <x-td class="text-center py-2 whitespace-nowrap">
                                                        @if ($genapStatus && $genapHeadId)
                                                            <a href="{{ route('raport.edit', $genapHeadId) }}"
                                                                class="whitespace-nowrap px-3 py-1 bg-amber-500 text-white text-xs rounded hover:bg-amber-600">
                                                                <i class="fa-solid fa-pen"></i> Edit
                                                            </a>
                                                        @else
                                                            @if (!empty($data['wali_kelas']) && $data['wali_kelas'] !== '-' && $data['wali_kelas'] !== 'Belum Ditentukan')
                                                                <a href="{{ route('raport.create', [$siswa->id, 'semester' => 'Genap']) }}"
                                                                    class="whitespace-nowrap px-3 py-1 bg-green-500 text-white text-xs rounded hover:bg-green-600">
                                                                    <i class="fa-solid fa-plus"></i> Input
                                                                </a>
                                                            @else
                                                                <button type="button"
                                                                    data-modal-target="validasiWaliKelas"
                                                                    data-modal-toggle="validasiWaliKelas"
                                                                    class="whitespace-nowrap px-3 py-1 bg-green-500 text-white text-xs rounded hover:bg-green-600">
                                                                    <i class="fa-solid fa-plus"></i> Input
                                                                </button>
                                                            @endif
                                                        @endif
                                                        @if ($genapStatus && $genapHeadId)
                                                            <a href="{{ $genapDetailUrl }}"
                                                                class="whitespace-nowrap px-3 py-1 mx-1 bg-sky-500 text-white text-xs rounded hover:bg-sky-600">
                                                                <i class="fa-solid fa-eye"></i> Lihat
                                                            </a>
                                                        @else
                                                            <button type="button" disabled
                                                                class="whitespace-nowrap px-3 py-1 mx-1 bg-gray-400 text-white text-xs rounded cursor-not-allowed"
                                                                title="Raport belum tersedia">
                                                                <i class="fa-solid fa-eye"></i> Lihat
                                                            </button>
                                                        @endif
                                                        @if ($genapStatus && $genapHeadId)
                                                            <a href="{{ route('raport.download', $genapHeadId) }}"
                                                                class="whitespace-nowrap px-3 py-1 bg-indigo-500 text-white text-xs rounded hover:bg-indigo-600">
                                                                <i class="fa-solid fa-download"></i> Unduh
                                                            </a>
                                                        @else
                                                            <button type="button" disabled
                                                                class="whitespace-nowrap px-3 py-1 bg-gray-400 text-white text-xs rounded cursor-not-allowed"
                                                                title="Raport belum tersedia">
                                                                <i class="fa-solid fa-download"></i> Unduh
                                                            </button>
                                                        @endif
                                                    </x-td>
                                                </tr>
                                            @empty
                                                <tr class="no-data-row">
                                                    <x-td colspan="6" class="text-center text-gray-500">
                                                        Tidak ada siswa ditemukan
                                                    </x-td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </x-table>
                                </div>
                            </div>
                        </div>

                    </div>
                @endforeach
            @else
                <div
                    class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-gray-400 text-center">
                    <p class="text-gray-500">Tidak ada data siswa untuk tahun ajaran ini!</p>
                </div>
            @endif
        </div>

        {{-- Modal Validasi Wali Kelas --}}
        <div id="validasiWaliKelas" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="fa-solid fa-triangle-exclamation text-red-600"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Peringatan
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="validasiWaliKelas">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <!-- Modal body -->
                    <div class="p-4 md:p-5">
                        <div class="w-full">
                            <div class="text-center">
                                <h1 class="text-red-600 dark:text-red-400 text-center font-bold text-xl">PERHATIAN!
                                </h1>
                                <p class="mt-2">Tentukan <span class="font-bold">Wali Kelas</span> terlebih dahulu
                                    untuk kelas dan tahun ajaran ini sebelum melakukan input raport!
                                </p>
                                <a href="/wali-kelas-periode"
                                    class="inline-block mt-4 px-5 py-2 bg-primary text-white rounded-lg hover:bg-hvPrimary transition">
                                    <i class="fa-solid fa-user-tie"></i> Kelola Wali Kelas
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b"></div>
                </div>
            </div>
        </div>

    </section>

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const tahunAjaranSelect = document.querySelector('select[name="tahun_ajaran"]');
                const kelasSelect = document.querySelector('select[name="kelasSelect"]');
                const semesterSelect = document.querySelector('select[name="semesterSelect"]');
                const tahunAjaranForm = document.getElementById('tahunAjaranForm');

                if (tahunAjaranSelect && tahunAjaranForm) {
                    tahunAjaranSelect.addEventListener('change', function() {
                        tahunAjaranForm.submit();
                    });
                }

                if (kelasSelect && tahunAjaranForm) {
                    kelasSelect.addEventListener('change', function() {
                        tahunAjaranForm.submit();
                    });
                }

                if (semesterSelect && tahunAjaranForm) {
                    semesterSelect.addEventListener('change', function() {
                        tahunAjaranForm.submit();
                    });
                }

                // Initialize tab switching first
                initializeTabSwitching();
                initializeKelasSearch();
                initializeWaliProgressTab();

                // Set active tab based on selected semester after initialization
                const selectedSemester = '{{ $selectedSemester ?? 'all' }}';

                setTimeout(() => {
                    if (selectedSemester === 'ganjil') {
                        // Activate Ganjil tab for all cards
                        document.querySelectorAll('.raport-card').forEach(card => {
                            const ganjilBtn = card.querySelector('.semester-tab[data-tab="ganjil"]');
                            if (ganjilBtn) {
                                ganjilBtn.click();
                            }
                        });
                    } else if (selectedSemester === 'genap') {
                        // Activate Genap tab for all cards
                        document.querySelectorAll('.raport-card').forEach(card => {
                            const genapBtn = card.querySelector('.semester-tab[data-tab="genap"]');
                            if (genapBtn) {
                                genapBtn.click();
                            }
                        });
                    }
                }, 100);

                function initializeKelasSearch() {
                    document.querySelectorAll('.kelas-search').forEach(searchInput => {
                        searchInput.addEventListener('input', function() {
                            const groupKey = this.getAttribute('data-group-key');
                            const searchTerm = this.value.toLowerCase();
                            const activeTable = document.querySelector(
                                `.raport-card[data-group-key="${groupKey}"] .tab-content:not(.hidden) tbody`
                            );

                            if (activeTable) {
                                const rows = activeTable.querySelectorAll('.student-row');
                                let visibleCount = 0;

                                rows.forEach(row => {
                                    const nama = row.getAttribute('data-nama');
                                    const nis = row.getAttribute('data-nis');
                                    const nisn = row.getAttribute('data-nisn');

                                    const isVisible = nama.includes(searchTerm) ||
                                        nis.includes(searchTerm) ||
                                        nisn.includes(searchTerm);

                                    if (isVisible) {
                                        row.style.display = '';
                                        const numberCell = row.querySelector('td:first-child');
                                        if (numberCell) {
                                            numberCell.textContent = visibleCount + 1;
                                        }
                                        visibleCount++;
                                    } else {
                                        row.style.display = 'none';
                                    }
                                });

                                const noDataRow = activeTable.querySelector('.no-data-row');
                                if (noDataRow) {
                                    noDataRow.style.display = visibleCount === 0 ? '' : 'none';
                                }
                            }
                        });
                    });
                }

                function initializeTabSwitching() {
                    document.querySelectorAll('.raport-card').forEach(card => {
                        const tabs = card.querySelectorAll('.semester-tab');
                        const tabContents = card.querySelectorAll('.tab-content');
                        const searchInput = card.querySelector('.kelas-search');

                        tabs.forEach(tabButton => {
                            tabButton.addEventListener('click', function() {
                                const selectedTab = this.getAttribute('data-tab');

                                tabs.forEach(btn => {
                                    if (btn.getAttribute('data-tab') === selectedTab) {
                                        btn.classList.add('tab-active',
                                            'border-hvPrimary', 'font-semibold',
                                            'text-primary', 'dark:text-hvPrimary',
                                            'border-b-2');
                                        btn.classList.remove('tab-inactive',
                                            'text-gray-600', 'dark:text-gray-400');
                                    } else {
                                        btn.classList.remove('tab-active',
                                            'border-hvPrimary', 'font-semibold',
                                            'text-primary', 'dark:text-hvPrimary',
                                            'border-b-2');
                                        btn.classList.add('tab-inactive',
                                            'text-gray-600', 'dark:text-gray-400');
                                    }
                                });

                                tabContents.forEach(content => {
                                    if (content.getAttribute('data-tab') ===
                                        selectedTab) {
                                        content.classList.remove('hidden');
                                    } else {
                                        content.classList.add('hidden');
                                    }
                                });

                                if (searchInput) {
                                    const event = new Event('input');
                                    searchInput.dispatchEvent(event);
                                }
                            });
                        });
                    });
                }
            });
        </script>

        <script>
            document.querySelectorAll('.kelasCardsContainer').forEach(container => {
                const groupKey = container.id;
                const tabs = container.querySelectorAll('.semester-tab');
                const contents = container.querySelectorAll('.tab-content');

                const activeTab = localStorage.getItem('activeTab_' + groupKey) || 'ganjil';

                function activateTab(tabName) {
                    tabs.forEach(tab => {
                        const isActive = tab.dataset.tab === tabName;

                        tab.classList.toggle('tab-active', isActive);
                        tab.classList.toggle('tab-inactive', !isActive);

                        // Tambahkan class aktif
                        tab.classList.toggle('text-primary', isActive);
                        tab.classList.toggle('dark:text-hvPrimary', isActive);
                        tab.classList.toggle('font-semibold', isActive);

                        // Hapus class aktif ketika nonaktif
                        tab.classList.toggle('text-gray-600', !isActive);
                        tab.classList.toggle('dark:text-gray-400', !isActive);
                        tab.classList.toggle('font-normal', !isActive);
                    });

                    contents.forEach(content => {
                        content.classList.toggle('hidden', content.dataset.tab !== tabName);
                    });
                }

                // Aktifkan tab tersimpan
                activateTab(activeTab);

                tabs.forEach(tab => {
                    tab.addEventListener('click', () => {
                        const selectedTab = tab.dataset.tab;
                        activateTab(selectedTab);
                        localStorage.setItem('activeTab_' + groupKey, selectedTab);
                    });
                });
            });
        </script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Handle download raport button click
                document.querySelectorAll('.download-raport-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const groupKey = this.getAttribute('data-group-key');
                        const selectElement = document.querySelector(
                            `.download-raport-select[data-group-key="${groupKey}"]`
                        );

                        if (!selectElement) {
                            alert('Terjadi kesalahan: Select tidak ditemukan');
                            return;
                        }

                        const semesterOption = selectElement.value;
                        const card = this.closest('.raport-card');

                        if (!card) {
                            alert('Terjadi kesalahan: Card tidak ditemukan');
                            return;
                        }

                        // Get all students in this card
                        const studentRows = card.querySelectorAll('.student-row');
                        const raportHeadIds = [];

                        studentRows.forEach(row => {
                            // Cari tombol download yang aktif (tidak disabled) di row ini
                            let downloadLinks;

                            if (semesterOption === 'all') {
                                // Ambil semua tombol download yang tidak disabled
                                downloadLinks = row.querySelectorAll(
                                    'a[href*="raport"][href*="download"]:not([disabled])');
                            } else {
                                // Tentukan tab yang sesuai dengan semester
                                const tabContent = row.closest('.tab-content');
                                const tabSemester = tabContent ? tabContent.getAttribute(
                                    'data-tab') : null;

                                // Hanya ambil jika semester sesuai dengan pilihan
                                if ((semesterOption === 'Ganjil' && tabSemester === 'ganjil') ||
                                    (semesterOption === 'Genap' && tabSemester === 'genap')) {
                                    downloadLinks = row.querySelectorAll(
                                        'a[href*="raport"][href*="download"]:not([disabled])'
                                    );
                                }
                            }

                            if (downloadLinks && downloadLinks.length > 0) {
                                downloadLinks.forEach(link => {
                                    const href = link.getAttribute('href');
                                    // Extract raport head id from URL
                                    const matches = href.match(
                                        /raport\/(\d+)\/download/);
                                    if (matches && matches[1]) {
                                        raportHeadIds.push(matches[1]);
                                    }
                                });
                            }
                        });

                        if (raportHeadIds.length === 0) {
                            alert(
                                'Tidak ada raport yang tersedia untuk diunduh dengan filter yang dipilih.'
                            );
                            return;
                        }

                        // Redirect to download route with raport head ids and semester
                        const url = new URL('{{ route('raport.downloadBulk') }}', window.location
                            .origin);
                        url.searchParams.append('ids', raportHeadIds.join(','));
                        url.searchParams.append('semester', semesterOption);
                        url.searchParams.append('group_key', groupKey);

                        window.location.href = url.toString();
                    });
                });

                // Handle download all raport button in header
                const downloadAllBtn = document.getElementById('downloadAllRaport');
                if (downloadAllBtn) {
                    downloadAllBtn.addEventListener('click', function() {
                        const raportHeadIds = [];
                        const selectedSemesterFilter = '{{ $selectedSemester ?? 'all' }}';

                        // Get all raport cards
                        const allCards = document.querySelectorAll('.raport-card');

                        allCards.forEach(card => {
                            const studentRows = card.querySelectorAll('.student-row');

                            studentRows.forEach(row => {
                                let downloadLinks;

                                if (selectedSemesterFilter === 'all') {
                                    // Get all download links
                                    downloadLinks = row.querySelectorAll(
                                        'a[href*="raport"][href*="download"]:not([disabled])'
                                    );
                                } else {
                                    // Get download links based on selected semester
                                    const tabContent = row.closest('.tab-content');
                                    const tabSemester = tabContent ? tabContent.getAttribute(
                                        'data-tab') : null;

                                    if ((selectedSemesterFilter === 'ganjil' && tabSemester ===
                                            'ganjil') ||
                                        (selectedSemesterFilter === 'genap' && tabSemester ===
                                            'genap')) {
                                        downloadLinks = row.querySelectorAll(
                                            'a[href*="raport"][href*="download"]:not([disabled])'
                                        );
                                    }
                                }

                                if (downloadLinks && downloadLinks.length > 0) {
                                    downloadLinks.forEach(link => {
                                        const href = link.getAttribute('href');
                                        const matches = href.match(
                                            /raport\/(\d+)\/download/);
                                        if (matches && matches[1]) {
                                            raportHeadIds.push(matches[1]);
                                        }
                                    });
                                }
                            });
                        });

                        if (raportHeadIds.length === 0) {
                            alert('Tidak ada raport yang tersedia untuk diunduh dengan filter yang dipilih.');
                            return;
                        }

                        // Redirect to download route
                        const url = new URL('{{ route('raport.downloadBulk') }}', window.location.origin);
                        url.searchParams.append('ids', raportHeadIds.join(','));
                        url.searchParams.append('semester', selectedSemesterFilter);

                        window.location.href = url.toString();
                    });
                }

                // Initialize Wali Progress Tab Switching
                function initializeWaliProgressTab() {
                    const waliProgressTabs = document.querySelectorAll('.semester-tab-wali-progress');

                    waliProgressTabs.forEach(tab => {
                        tab.addEventListener('click', function() {
                            const semester = this.getAttribute('data-semester');
                            const card = this.closest('.bg-gray-50');

                            // Update tab styles
                            card.querySelectorAll('.semester-tab-wali-progress').forEach(t => {
                                t.classList.remove('text-primary', 'dark:text-hvPrimary',
                                    'border-primary');
                                t.classList.add('text-gray-600', 'dark:text-gray-400',
                                    'border-transparent');
                            });

                            this.classList.remove('text-gray-600', 'dark:text-gray-400',
                                'border-transparent');
                            this.classList.add('text-primary', 'dark:text-hvPrimary', 'border-primary');

                            // Show/hide content
                            card.querySelectorAll('.semester-content-wali-progress').forEach(
                                content => {
                                    const contentSemester = content.getAttribute('data-semester');

                                    if (contentSemester === semester) {
                                        content.classList.remove('hidden');
                                    } else {
                                        content.classList.add('hidden');
                                    }
                                });
                        });
                    });
                }
            });
        </script>
    @endpush

</x-app-layout>
