<title>Detail Raport</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="md:flex justify-between mb-4">
            <div>
                <h1>
                    <div class="flex gap-2 items-start">
                        <a href="{{ route('raport.index') }}" class="mt-1 hover:text-hvPrimary">
                            <i class="fa-solid fa-arrow-left text-xl"></i>
                        </a>
                        <div>
                            <p class="text-xl sm:text-2xl font-bold">Data Raport</p>
                            <p class="text-xs sm:text-sm ms-[1px]">Index / Detail Data Raport</p>
                        </div>
                    </div>
                </h1>
            </div>
        </div>

        @if (!$raportHead)
            <div class="bg-yellow-100 border border-yellow-300 text-yellow-800 px-4 py-3 rounded relative">
                <strong class="font-bold">Data raport belum tersedia.</strong>
                <span class="block sm:inline">Silakan lakukan input raport terlebih dahulu.</span>
            </div>
        @else
            @php
                $madrasahName = 'MTSS Al Ikhlas Panganten';
                $alamatMadrasah = 'Kp. Panganten';
            @endphp

            <div
                class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary">
                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
                    <div class="flex justify-center sm:justify-start sm:w-32">
                        <img src="{{ asset('img/logoUtama.png') }}" alt="Logo Kiri" class="w-24 h-24 object-contain" />
                    </div>
                    <div class="text-center flex-1">
                        <p class="text-xs sm:text-sm font-semibold uppercase tracking-wide">Kementerian Agama Republik
                            Indonesia</p>
                        <p class="text-lg sm:text-xl font-bold uppercase">MTSS Al Ikhlas Panganten</p>
                        <p class="italic text-xs sm:text-sm">KP. Panganten</p>
                        <p class="italic text-[11px] sm:text-xs">Kecamatan Cigalontang, Kabupaten Tasikmalaya - Jawa
                            Barat</p>
                    </div>
                    <div class="flex justify-center sm:justify-end sm:w-32">
                        <img src="{{ asset('img/logoKedua.png') }}" alt="Logo Kanan" class="w-24 h-24 object-contain" />
                    </div>
                </div>

                <div class="border-y-2 border-gray-600 py-4 text-xs sm:text-sm">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-y-1 md:gap-y-2 gap-x-6">
                        <div class="flex items-start gap-2">
                            <span class="w-28 md:w-24 font-semibold uppercase">Nama</span>
                            <span>:</span>
                            <span class="flex-1 font-semibold uppercase">{{ $siswa->nama_siswa }}</span>
                        </div>
                        <div class="flex items-start gap-2">
                            <span class="w-28 md:w-28 font-semibold uppercase">Kelas</span>
                            <span>:</span>
                            <span class="flex-1 uppercase">{{ $kelasDisplay }}</span>
                        </div>
                        <div class="flex items-start gap-2">
                            <span class="w-28 md:w-24 font-semibold uppercase">NIS / NISN</span>
                            <span>:</span>
                            <span class="flex-1 uppercase">{{ $siswa->nis }} / {{ $siswa->nisn }}</span>
                        </div>
                        <div class="flex items-start gap-2">
                            <span class="w-28 md:w-28 font-semibold uppercase">Fase</span>
                            <span>:</span>
                            <span class="flex-1 uppercase">{{ $raportHead->fase }}</span>
                        </div>
                        <div class="flex items-start gap-2">
                            <span class="w-28 md:w-24 font-semibold uppercase">Madrasah</span>
                            <span>:</span>
                            <span class="flex-1 uppercase">{{ $madrasahName }}</span>
                        </div>
                        <div class="flex items-start gap-2">
                            <span class="w-28 md:w-28 font-semibold uppercase">Semester</span>
                            <span>:</span>
                            <span class="flex-1 uppercase">{{ $raportHead->semester }}</span>
                        </div>
                        <div class="flex items-start gap-2">
                            <span class="w-28 md:w-24 font-semibold uppercase">Alamat</span>
                            <span>:</span>
                            <span class="flex-1 uppercase">{{ $alamatMadrasah }}</span>
                        </div>
                        <div class="flex items-start gap-2">
                            <span class="w-28 md:w-28 font-semibold uppercase">Tahun Ajaran</span>
                            <span>:</span>
                            <span
                                class="flex-1 uppercase">{{ $raportHead->thn_ajaran_awal }}/{{ $raportHead->thn_ajaran_akhir }}</span>
                        </div>
                    </div>
                </div>

                <div class="mt-8">
                    <h3 class="font-bold uppercase text-sm text-center sm:text-base mb-2">CAPAIAN HASIL BELAJAR</h3>
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-600 border-collapse text-xs sm:text-sm">
                            <x-thead>
                                <x-tr>
                                    <x-th class="w-12 text-center">No.</x-th>
                                    <x-th class="text-center" style="width: 300px;">Mata Pelajaran</x-th>
                                    <x-th class="text-center" style="width: 100px;">Nilai Akhir</x-th>
                                    <x-th class="text-center">Capaian Kompetensi</x-th>
                                </x-tr>
                            </x-thead>
                            <tbody>
                                @php $rowNumber = 1; @endphp
                                @foreach ($mapelHeads as $head)
                                    @php
                                        $headScore = $headScores->get($head->id);
                                        $details = $head->details;
                                        $detailsCount = $details->count();
                                        $rowspan = $detailsCount > 0 ? $detailsCount + 1 : 1;
                                    @endphp
                                    <x-tr class="bg-gray-100 dark:bg-gray-700">
                                        <x-td class="px-3 py-2 text-center font-semibold align-top"
                                            rowspan="{{ $rowspan }}">{{ $rowNumber++ }}</x-td>
                                        <x-td class="px-3 py-2 font-semibold uppercase whitespace-nowrap">{{ $head->nama_mapel }}</x-td>
                                        <x-td
                                            class="px-3 py-2 text-center font-semibold">{{ optional($headScore)->nilai_akhir ?? '' }}</x-td>
                                        <x-td class="px-3 py-2">{{ optional($headScore)->deskripsi ?? '' }}</x-td>
                                    </x-tr>

                                    @foreach ($details as $detailIndex => $detail)
                                        @php
                                            $detailScore = $detailScores->get($detail->id);
                                        @endphp
                                        <tr>
                                            <x-td class="px-3 py-2 pl-6 whitespace-nowrap">
                                                <span>{{ chr(65 + $detailIndex) }}. {{ $detail->nama_mapel_detail }}</span>
                                            </x-td>
                                            <x-td
                                                class="px-3 py-2 text-center">{{ optional($detailScore)->nilai_akhir ?? '-' }}</x-td>
                                            <x-td
                                                class="px-3 py-2">{{ optional($detailScore)->deskripsi ?? '-' }}</x-td>
                                        </tr>
                                    @endforeach
                                @endforeach
                            </tbody>
                            <tfoot>
                                <x-tr class="font-semibold">
                                    <x-td colspan="2" class="px-3 py-2 text-right">Jumlah</x-td>
                                    <x-td
                                        class="px-3 py-2 text-center">{{ number_format((float) ($raportHead->jml_nilai_akhir ?? 0)) }}</x-td>
                                    <x-td class="px-3 py-2"></x-td>
                                </x-tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                <div class="mt-8 space-y-8">
                    <div>
                        <h3 class="font-bold uppercase text-sm sm:text-base mb-2">Ekstrakurikuler</h3>
                        <div class="overflow-x-auto">
                            <table class="w-full border border-gray-600 border-collapse text-xs sm:text-sm">
                                <x-thead>
                                    <x-tr>
                                        <x-th class="w-12 text-center">No.</x-th>
                                        <x-th class="text-center">Kegiatan Ekstrakurikuler</x-th>
                                        <x-th class="text-center">Nilai</x-th>
                                        <x-th class="text-center">Keterangan</x-th>
                                    </x-tr>
                                </x-thead>
                                <tbody>
                                    @forelse ($ekskulPengisian as $row)
                                        <tr>
                                            <x-td class="px-3 py-2 text-center">{{ $loop->iteration }}</x-td>
                                            <x-td
                                                class="px-3 py-2">{{ optional($row->ekskul)->nama_ekskul ?? '-' }}</x-td>
                                            <x-td
                                                class="px-3 py-2 text-center">{{ optional($row->ketNilai)->nama_keterangan ?? '-' }}</x-td>
                                            <x-td class="px-3 py-2">{{ $row->keterangan ?? '-' }}</x-td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <x-td colspan="4" class="px-3 py-4 text-center text-gray-500">-</x-td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div>
                        <h3 class="font-bold uppercase text-sm sm:text-base mb-2">Prestasi</h3>
                        <div class="overflow-x-auto">
                            <table class="w-full border border-gray-600 border-collapse text-xs sm:text-sm">
                                <x-thead>
                                    <x-tr>
                                        <x-th class="w-12 text-center">No.</x-th>
                                        <x-th class="text-center">Jenis Prestasi</x-th>
                                        <x-th class="text-center">Keterangan</x-th>
                                    </x-tr>
                                </x-thead>
                                <tbody>
                                    @forelse ($prestasiPengisian as $row)
                                        <tr>
                                            <x-td class="px-3 py-2 text-center">{{ $loop->iteration }}</x-td>
                                            <x-td class="px-3 py-2">{{ $row->jenis_prestasi ?? '-' }}</x-td>
                                            <x-td class="px-3 py-2">{{ $row->keterangan ?? '-' }}</x-td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <x-td colspan="3" class="px-3 py-4 text-center text-gray-500">-</x-td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div>
                        <h3 class="font-bold uppercase text-sm sm:text-base mb-2">Ketidakhadiran</h3>
                        <div class="overflow-x-auto">
                            <table class="w-full border border-gray-600 border-collapse text-xs sm:text-sm">
                                <tbody>
                                    @php
                                        $ketidakhadiranLabels = [
                                            'sakit' => 'Sakit',
                                            'izin' => 'Izin',
                                            'alpa' => 'Alpa',
                                        ];
                                    @endphp
                                    @foreach ($ketidakhadiranLabels as $key => $label)
                                        <x-tr>
                                            <x-td class="px-3 py-2 font-semibold">{{ $label }}</x-td>
                                            <x-td
                                                class="px-3 py-2 w-32 text-center">{{ $ketidakhadiran[$key] ?? 0 }}</x-td>
                                            <x-td class="px-3 py-2 w-24 text-center">Hari</x-td>
                                        </x-tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div>
                        <h3 class="font-bold uppercase text-sm sm:text-base mb-2">Catatan Pendidik</h3>
                        <div class="border border-gray-600 p-3 min-h-[120px]">
                            @if (filled($raportHead->catatan_pendidik))
                                {!! nl2br(e($raportHead->catatan_pendidik)) !!}
                            @else
                                -
                            @endif
                        </div>
                    </div>

                    @if ($raportHead->semester === 'Genap')
                        <div>
                            <h3 class="font-bold uppercase text-sm sm:text-base mb-2">Keterangan Kenaikan Kelas</h3>
                            <div
                                class="border border-gray-600 p-3 flex flex-col sm:flex-row sm:items-center gap-2 text-xs sm:text-sm">
                                <span class="font-semibold">Keterangan Kenaikan Kelas:</span>
                                <span class="flex-1">{{ $raportHead->keterangan_kenaikan ?? '-' }}</span>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="flex mt-8">
                    <div class="w-full"></div>
                    <div class="w-full"></div>
                    <div class="flex gap-2 items-center justify-end mb-5 w-full">
                        <div>Tasikmalaya,</div>
                        <div>{{ $formattedTanggal ?? '-' }}</div>
                    </div>
                </div>
                <div class="flex mx-20">
                    <div class="w-full text-center">
                        <h1>Orang Tua/Wali</h1>
                        <div class="border border-gray-400 mt-28 mx-12 border-dashed"></div>
                    </div>
                    <div class="w-full"></div>
                    <div class="w-full text-center">
                        <h1>Wali Kelas</h1>
                        <div class="mt-24">
                            <div class="font-bold">{{ optional($raportHead->waliKelas)->nama_guru ?? '-' }}</div>
                            <div>NIP. {{ optional($raportHead->waliKelas)->nip ?? '-' }}</div>
                        </div>
                    </div>
                </div>
                <div class="flex mx-20">
                    <div class="w-full"></div>
                    <div class="w-full text-center">
                        <h1>Mengetahui</h1>
                        <h1>Kepala Madrasah</h1>
                        <div class="mt-24">
                            <div class="font-bold">{{ optional($raportHead->kepalaSekolah)->nama_lengkap ?? '-' }}
                            </div>
                            <div>NIP. {{ optional($raportHead->kepalaSekolah)->nip ?? '-' }}</div>
                        </div>
                    </div>
                    <div class="w-full"></div>
                </div>
            </div>
        @endif
    </section>
</x-app-layout>
