<title>Profil</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="mb-4">
            <h1>
                <div class="flex gap-2">
                    <i class="fa-solid fa-user-circle text-3xl mt-1 font-bold"></i>
                    <div>
                        <p class="text-xl sm:text-2xl font-bold">Profil</p>
                        <p class="text-xs sm:text-sm ms-[1px] -mt-1">Pengaturan Akun</p>
                    </div>
                </div>
            </h1>
        </div>

        {{-- Alert Success/Error --}}
        @if (session('success'))
            <div class="p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400"
                role="alert">
                <span class="font-medium">Berhasil!</span> {{ session('success') }}
            </div>
        @endif

        @if (session('error'))
            <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400"
                role="alert">
                <span class="font-medium">Error!</span> {{ session('error') }}
            </div>
        @endif

        {{-- Info Tambahan untuk Wali Kelas --}}
        @if ($user->role === 'Wali' && $waliKelas)
            <div class="mb-6 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                <div class="flex items-start gap-3">
                    <i class="fa-solid fa-info-circle text-blue-600 dark:text-blue-400 text-xl mt-1"></i>
                    <div>
                        <h3 class="font-bold text-blue-800 dark:text-blue-200 mb-2">Informasi Akun Wali Kelas</h3>
                        <div class="text-sm text-blue-700 dark:text-blue-300 space-y-1">
                            <p><span class="font-semibold">NIP:</span> {{ $waliKelas->nip ?? '-' }}</p>
                            <p><span class="font-semibold">Status:</span>
                                <span
                                    class="px-2 py-1 rounded-full text-xs {{ $waliKelas->status === 'Aktif' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200' }}">
                                    {{ $waliKelas->status }}
                                </span>
                            </p>
                            <p class="mt-2 text-xs">
                                <i class="fa-solid fa-exclamation-triangle me-1"></i>
                                Perubahan data profil akan otomatis tersinkronisasi dengan data wali kelas.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <div class="flex flex-col md:flex-row gap-6">
            {{-- Card Informasi Profil --}}
            <div class="bg-gray-50 dark:bg-gray-800 rounded-lg shadow-md p-6 w-full md:w-[60%] h-[100%]">
                <div class="flex items-center gap-3 mb-4">
                    <i class="fa-solid fa-user text-2xl text-primary dark:text-hvPrimary"></i>
                    <h2 class="text-xl font-bold text-gray-800 dark:text-gray-100">Informasi Profil</h2>
                </div>

                <form action="{{ route('profil.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div>
                        {{-- Section: Data Login --}}
                        <div class="border-b border-gray-300 dark:border-gray-600 pb-2 mb-3">
                            <h3 class="text-sm font-bold text-gray-700 dark:text-gray-300 uppercase">
                                <i class="fa-solid fa-user-lock mr-1"></i> Data Login
                            </h3>
                        </div>

                        <div class="mt-2">
                            <x-label><span class="text-red-500">*</span> Nama Lengkap</x-label>
                            <x-input name="name" type="text" value="{{ old('name', $user->name) }}"
                                class="{{ $errors->first('name') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan nama lengkap..." required />
                            <x-message>{{ $errors->first('name') }}</x-message>
                        </div>

                        <div class="mt-2">
                            <x-label><span class="text-red-500">*</span> Username</x-label>
                            <x-input name="email" type="text" value="{{ old('email', $user->email) }}"
                                class="{{ $errors->first('email') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan email..." required />
                            <x-message>{{ $errors->first('email') }}</x-message>
                        </div>

                        {{-- Section: Data Laporan --}}
                        <div class="border-b border-gray-300 dark:border-gray-600 pb-2 mb-3 mt-8">
                            <h3 class="text-sm font-bold text-gray-700 dark:text-gray-300 uppercase">
                                <i class="fa-solid fa-file-alt mr-1"></i> Data Laporan
                            </h3>
                        </div>

                        <div>
                            <x-label><span class="text-red-500">*</span> Nama Sekolah</x-label>
                            <x-input name="nama_sekolah" type="text" value="{{ old('nama_sekolah', $user->nama_sekolah) }}"
                                class="uppercase {{ $errors->first('nama_sekolah') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan nama sekolah..." required />
                            <x-message>{{ $errors->first('nama_sekolah') }}</x-message>
                        </div>

                        <div class="mt-2">
                            <x-label><span class="text-red-500">*</span> Alamat Sekolah</x-label>
                            <x-textarea name="alamat_sekolah" rows="3"
                                class="capitalize {{ $errors->first('alamat_sekolah') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan alamat sekolah..." required>{{ old('alamat_sekolah', $user->alamat_sekolah) }}</x-textarea>
                            <x-message>{{ $errors->first('alamat_sekolah') }}</x-message>
                        </div>

                        <div class="mt-2">
                            <x-label><span class="text-red-500">*</span> Logo Sekolah</x-label>
                            <div class="flex items-start gap-4">
                                {{-- Preview Logo --}}
                                <div class="flex-shrink-0">
                                    <div class="w-24 h-24 border-2 border-gray-300 dark:border-gray-600 rounded-lg overflow-hidden bg-gray-100 dark:bg-gray-700 flex items-center justify-center">
                                        @if($user->logo)
                                            <img id="logoPreview" src="/logo_app/{{ $user->logo }}" alt="Logo" class="w-full h-full object-cover">
                                        @else
                                            <img id="logoPreview" src="" alt="Preview" class="w-full h-full object-cover hidden">
                                            <span id="logoPlaceholder" class="text-gray-400 dark:text-gray-500 text-xs text-center px-2">Belum ada logo</span>
                                        @endif
                                    </div>
                                </div>
                                {{-- Input File --}}
                                <div class="flex-1">
                                    <input type="file" name="logo" id="logoInput" accept="image/*"
                                        class="block w-full text-sm text-gray-900 dark:text-gray-100 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer bg-gray-50 dark:bg-gray-700 focus:outline-none {{ $errors->first('logo') ? 'border-red-400' : '' }}" {{ !$user->logo ? 'required' : '' }}>
                                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                                        <i class="fa-solid fa-info-circle"></i> Format: JPG, PNG, GIF (Max: 2MB). Rasio 1:1 disarankan.
                                    </p>
                                    <x-message>{{ $errors->first('logo') }}</x-message>
                                </div>
                            </div>
                        </div>

                        @if ($user->role === 'Wali' && $waliKelas)
                            <div>
                                <x-label>No. HP</x-label>
                                <x-input name="no_hp" type="text"
                                    value="{{ old('no_hp', $waliKelas->no_hp ?? '') }}"
                                    class="{{ $errors->first('no_hp') ? 'border-red-400' : '' }}"
                                    placeholder="Masukkan no hp..." />
                                <x-message>{{ $errors->first('no_hp') }}</x-message>
                            </div>
                            <div>
                                <x-label>Email</x-label>
                                <x-input name="email_wali" type="email"
                                    value="{{ old('email_wali', $waliKelas->email ?? '') }}"
                                    class="{{ $errors->first('email_wali') ? 'border-red-400' : '' }}"
                                    placeholder="Masukkan email..." />
                                <x-message>{{ $errors->first('email_wali') }}</x-message>
                            </div>

                            <div>
                                <x-label>Alamat</x-label>
                                <x-textarea name="alamat" rows="3"
                                    class="{{ $errors->first('alamat') ? 'border-red-400' : '' }}"
                                    placeholder="Masukkan alamat...">{{ old('alamat', $waliKelas->alamat ?? '') }}</x-textarea>
                                <x-message>{{ $errors->first('alamat') }}</x-message>
                            </div>
                        @endif

                        {{-- <div>
                            <x-label>Role</x-label>
                            <x-input type="text" value="{{ $user->role }}" disabled
                                class="bg-gray-200 dark:bg-gray-700 cursor-not-allowed" />
                        </div> --}}

                        <div class="flex justify-end">
                            <button type="submit"
                                class="bg-primary hover:bg-hvPrimary text-white font-medium py-2 px-4 rounded-lg text-sm">
                                <i class="fa-solid fa-save me-1"></i> Simpan Perubahan
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            {{-- Card Ganti Password --}}
            <div class="bg-gray-50 dark:bg-gray-800 rounded-lg shadow-md p-6 w-full md:w-[40%] h-[100%]">
                <div class="flex items-center gap-3 mb-4">
                    <i class="fa-solid fa-key text-2xl text-primary dark:text-hvPrimary"></i>
                    <h2 class="text-xl font-bold text-gray-800 dark:text-gray-100">Ganti Password</h2>
                </div>

                <form action="{{ route('profil.change-password') }}" method="POST">
                    @csrf
                    <div class="space-y-4">
                        <div>
                            <x-label><span class="text-red-500">*</span> Password Lama</x-label>
                            <x-input name="current_password" type="password"
                                class="{{ $errors->first('current_password') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan password lama..." required />
                            <x-message>{{ $errors->first('current_password') }}</x-message>
                        </div>

                        <div>
                            <x-label><span class="text-red-500">*</span> Password Baru</x-label>
                            <x-input name="new_password" type="password"
                                class="{{ $errors->first('new_password') ? 'border-red-400' : '' }}"
                                placeholder="Masukkan password baru (min. 8 karakter)..." required />
                            <x-message>{{ $errors->first('new_password') }}</x-message>
                        </div>

                        <div>
                            <x-label><span class="text-red-500">*</span> Konfirmasi Password Baru</x-label>
                            <x-input name="new_password_confirmation" type="password"
                                class="{{ $errors->first('new_password_confirmation') ? 'border-red-400' : '' }}"
                                placeholder="Konfirmasi password baru..." required />
                            <x-message>{{ $errors->first('new_password_confirmation') }}</x-message>
                        </div>

                        <div
                            class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-3">
                            <p class="text-xs text-yellow-800 dark:text-yellow-200">
                                <i class="fa-solid fa-info-circle me-1"></i>
                                Password minimal 8 karakter. Pastikan password baru dan konfirmasi password sama.
                            </p>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit"
                                class="bg-sky-600 hover:bg-sky-700 text-white font-medium py-2 px-4 rounded-lg text-sm">
                                <i class="fa-solid fa-key me-1"></i> Ubah Password
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </section>

    @push('scripts')
        <script>
            // Preview logo when file is selected
            document.getElementById('logoInput').addEventListener('change', function(e) {
                const file = e.target.files[0];
                const preview = document.getElementById('logoPreview');
                const placeholder = document.getElementById('logoPlaceholder');
                
                if (file) {
                    const reader = new FileReader();
                    
                    reader.onload = function(e) {
                        preview.src = e.target.result;
                        preview.classList.remove('hidden');
                        if (placeholder) {
                            placeholder.classList.add('hidden');
                        }
                    }
                    
                    reader.readAsDataURL(file);
                } else {
                    preview.src = '';
                    preview.classList.add('hidden');
                    if (placeholder) {
                        placeholder.classList.remove('hidden');
                    }
                }
            });

            // Handle remove logo checkbox
            const removeLogo = document.getElementById('removeLogo');
            if (removeLogo) {
                removeLogo.addEventListener('change', function() {
                    const logoInput = document.getElementById('logoInput');
                    if (this.checked) {
                        // Remove required attribute when checkbox is checked
                        logoInput.removeAttribute('required');
                    } else {
                        // Add required attribute back when checkbox is unchecked (if no logo exists)
                        @if(!$user->logo)
                            logoInput.setAttribute('required', 'required');
                        @endif
                    }
                });
            }

            // Auto uppercase for nama_sekolah
            const namaSekolahInput = document.querySelector('input[name="nama_sekolah"]');
            if (namaSekolahInput) {
                namaSekolahInput.addEventListener('input', function(e) {
                    this.value = this.value.toUpperCase();
                });
            }

            // Auto capitalize each word for alamat_sekolah
            const alamatSekolahInput = document.querySelector('textarea[name="alamat_sekolah"]');
            if (alamatSekolahInput) {
                alamatSekolahInput.addEventListener('input', function(e) {
                    const words = this.value.split(' ');
                    const capitalizedWords = words.map(word => {
                        if (word.length === 0) return word;
                        return word.charAt(0).toUpperCase() + word.slice(1).toLowerCase();
                    });
                    this.value = capitalizedWords.join(' ');
                });
            }
        </script>
    @endpush
</x-app-layout>
