<title>Mata Pelajaran</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" style="margin-bottom: 100px;" id="sectionDashboard">
        <div class="md:flex justify-between mb-4">
            <div>
                <h1>
                    <div class="flex gap-2">
                        <i class="fa-solid fa-scroll text-3xl mt-1 font-bold"></i>
                        <div>
                            <p class="text-xl sm:text-2xl font-bold">Mata Pelajaran</p>
                            <p class="text-xs sm:text-sm ms-[1px] -mt-1">Index</p>
                        </div>
                    </div>
                </h1>
            </div>

            <div class="mt-3 md:mt-0 hidden md:block">
                <button type="button" data-modal-target="addMapel" data-modal-toggle="addMapel"
                    class="bg-primary py-2 px-4 rounded-md text-white hover:bg-hvPrimary text-sm"><i
                        class="bi bi-plus-lg"></i> Tambah Mata Pelajaran</button>
            </div>
        </div>

        {{-- Modal Tambah Data Head --}}
        <div id="addMapel" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-lg max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="bi bi-plus-lg"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Tambah Mata Pelajaran
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="addMapel">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <form action="/mata-pelajaran" method="POST">
                        @csrf
                        <input type="hidden" name="_form" value="add">
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="w-full">
                                <div>
                                    <x-label><span class="text-red-500">*</span>Nama Mata Pelajaran</x-label>
                                    <x-input name="nama_mapel" type="text" tabindex="1"
                                        value="{{ old('nama_mapel') }}"
                                        class="{{ $errors->first('nama_mapel') ? 'border-red-400' : '' }} capitalize-input"
                                        placeholder="Masukkan nama mapel..." />
                                    <x-message>{{ $errors->first('nama_mapel') }}</x-message>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <x-btn-save tabindex="7">
                                <div class="flex items-center gap-1 font-medium">
                                    <i class="fa-solid fa-floppy-disk"></i>
                                    <p>Simpan</p>
                                </div>
                            </x-btn-save>
                        </div>
                    </form>

                </div>
            </div>
        </div>

        {{-- Tab Navigation --}}
        <div class="flex gap-5 border-b border-gray-300 dark:border-gray-600 mb-5">
            <button type="button" id="tabSettingMapel" onclick="switchTab('setting')"
                class="mapel-tab tab-active pb-2 font-semibold text-primary dark:text-hvPrimary border-b-2 border-hvPrimary transition-all duration-200">
                <i class="fa-solid fa-gear mr-2"></i>Setting Mapel
            </button>
            <button type="button" id="tabRekapMapel" onclick="switchTab('rekap')"
                class="mapel-tab tab-inactive pb-2 text-gray-600 dark:text-gray-400 transition-all duration-200">
                <i class="fa-solid fa-table-list mr-2"></i>Rekap Mapel
            </button>
        </div>

        {{-- Tab Content: Setting Mapel --}}
        <div id="contentSettingMapel" class="tab-content">
            {{-- Detail Data --}}
            <div
                class="w-full md:shadow rounded-md md:p-5 md:bg-gray-50 text-gray-900 md:dark:bg-gray-800 dark:text-gray-50 md:border-t-4 md:border-primary">
                <form action="#" method="GET" class="inline mt-4">
                    <div class="flex justify-between items-center">
                        <div class="flex items-center gap-2">
                            <select name="per_page" id="per_page" onchange="this.form.submit()"
                                class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50">
                                <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20</option>
                                <option value="30" {{ request('per_page') == 30 ? 'selected' : '' }}>30</option>
                                <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                        </div>
                        <div class="flex items-center gap-2">
                            <div class="relative inline-block w-full">
                                <x-search-i></x-search-i>
                                <x-search placeholder="Cari Mata Pelajaran..." name="search"
                                    class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                    value="{{ request('search') }}" />
                            </div>
                        </div>
                    </div>
                </form>

                <div class="mb-2 mt-3">
                    <!-- Desktop Table View -->
                    <div class="hidden md:block overflow-x-auto">
                        <x-table>
                            <x-thead>
                                <tr>
                                    <x-th class="whitespace-nowrap w-14">No.</x-th>
                                    <x-th class="whitespace-nowrap">Mata Pelajaran</x-th>
                                    <x-th class="whitespace-nowrap">Status Mapel</x-th>
                                    <x-th class="whitespace-nowrap">Kelas</x-th>
                                    <x-th class="whitespace-nowrap w-14">Aksi</x-th>
                                    <x-th class="whitespace-nowrap">Sub Mata Pelajaran</x-th>
                                    <x-th class="whitespace-nowrap">Status Sub Mapel</x-th>
                                    <x-th class="whitespace-nowrap">Kelas</x-th>
                                    <x-th class="whitespace-nowrap w-14">Aksi</x-th>
                                </tr>
                            </x-thead>
                            <tbody>
                                @forelse ($dataMapel as $data)
                                    @php
                                        $detailCount = $data->details->count();
                                        $rowspan = $detailCount > 0 ? $detailCount : 1;
                                    @endphp

                                    @if ($detailCount > 0)
                                        @foreach ($data->details as $detailIndex => $detail)
                                            <x-tr>
                                                @if ($detailIndex == 0)
                                                    <x-td class="text-center" rowspan="{{ $rowspan }}">
                                                        {{ $loop->parent->iteration + $i }}.
                                                    </x-td>
                                                    <x-td
                                                        rowspan="{{ $rowspan }}">{{ ucwords(strtolower($data->nama_mapel)) }}</x-td>
                                                    <x-td class="text-center whitespace-nowrap"
                                                        rowspan="{{ $rowspan }}">
                                                        @if ($data->status == 'Aktif')
                                                            <span
                                                                class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                                        @else
                                                            <span
                                                                class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                        @endif
                                                    </x-td>
                                                    <x-td class="text-center" rowspan="{{ $rowspan }}">
                                                        @if ($data->mapelKelas->count() > 0)
                                                            <div class="flex flex-wrap gap-1 justify-center">
                                                                @foreach ($data->mapelKelas as $mk)
                                                                    @php
                                                                        $kelasLabel = trim(
                                                                            ($mk->kelas->nama_kelas_nomor ?? '') .
                                                                                ($mk->kelas->nama_kelas_sub ?? ''),
                                                                        );
                                                                    @endphp
                                                                    <span
                                                                        class="bg-blue-100 text-blue-800 text-xs font-medium px-2 py-0.5 rounded dark:bg-blue-900 dark:text-blue-300">
                                                                        {{ $kelasLabel !== '' ? $kelasLabel : '-' }}
                                                                    </span>
                                                                @endforeach
                                                            </div>
                                                        @else
                                                            <span class="text-gray-400 text-sm">-</span>
                                                        @endif
                                                    </x-td>
                                                    <x-td class="text-center whitespace-nowrap relative"
                                                        rowspan="{{ $rowspan }}">
                                                        <button type="button" id="btnActionMapel{{ $data->id }}"
                                                            class="py-2 px-4 rounded-md bg-slate-400 dark:text-dark hover:bg-slate-300 transition">
                                                            <i class="fa-solid fa-ellipsis-vertical"></i>
                                                        </button>
                                                        <div id="actionMapel{{ $data->id }}"
                                                            class="hidden absolute right-[75px] top-1/2 -translate-y-1/2 bg-slate-300 dark:bg-dark rounded-md px-3 py-1 bubble-with-arrow z-10">
                                                            {{-- Btn Delete --}}
                                                            <button type="button"
                                                                onclick="handleDeleteMapel({{ $data->id }}, '{{ $data->nama_mapel }}')"
                                                                class="bg-red-500 hover:bg-red-600 text-white py-2 px-3 rounded-md text-sm"
                                                                title="Hapus">
                                                                <i class="fa-solid fa-trash"></i>
                                                            </button>
                                                            {{-- Btn Edit --}}
                                                            <x-btn-edit
                                                                data-modal-target="editMapel{{ $data->id }}"
                                                                data-modal-toggle="editMapel{{ $data->id }}" />
                                                            <button type="button"
                                                                data-modal-target="addMapelDetail{{ $data->id }}"
                                                                data-modal-toggle="addMapelDetail{{ $data->id }}"
                                                                class="bg-primary py-1 px-3 rounded-md text-white hover:bg-hvPrimary text-sm"
                                                                title="Tambah Sub Mapel"><i class="bi bi-plus-lg"></i>
                                                                Sub Mapel</button>
                                                            <button type="button"
                                                                data-modal-target="addKelasMapel{{ $data->id }}"
                                                                data-modal-toggle="addKelasMapel{{ $data->id }}"
                                                                class="bg-green-600 py-1 px-3 rounded-md text-white hover:bg-green-700 text-sm"
                                                                title="Tambah Kelas"><i class="bi bi-plus-lg"></i>
                                                                Kelas</button>

                                                        </div>
                                                    </x-td>
                                                @endif

                                                <x-td>{{ ucwords(strtolower($detail->nama_mapel_detail)) }}</x-td>
                                                <x-td class="text-center">
                                                    @if ($detail->status == 'Aktif')
                                                        <span
                                                            class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                                    @else
                                                        <span
                                                            class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                    @endif
                                                </x-td>
                                                <x-td class="text-center">
                                                    @if ($detail->mapelKelas->count() > 0)
                                                        <div class="flex flex-wrap gap-1 justify-center">
                                                            @foreach ($detail->mapelKelas as $mkd)
                                                                @php
                                                                    $kelasLabelDetail = trim(
                                                                        ($mkd->kelas->nama_kelas_nomor ?? '') .
                                                                            ($mkd->kelas->nama_kelas_sub ?? ''),
                                                                    );
                                                                @endphp
                                                                <span
                                                                    class="bg-blue-100 text-blue-800 text-xs font-medium px-2 py-0.5 rounded dark:bg-blue-900 dark:text-blue-300">
                                                                    {{ $kelasLabelDetail !== '' ? $kelasLabelDetail : '-' }}
                                                                </span>
                                                            @endforeach
                                                        </div>
                                                    @else
                                                        <span class="text-gray-400 text-sm">-</span>
                                                    @endif
                                                </x-td>
                                                <x-td class="text-center whitespace-nowrap relative">
                                                    <button type="button"
                                                        id="btnActionMapelDetail{{ $detail->id }}"
                                                        class="py-2 px-4 rounded-md bg-slate-400 dark:text-dark hover:bg-slate-300 transition">
                                                        <i class="fa-solid fa-ellipsis-vertical"></i>
                                                    </button>
                                                    <div id="actionMapelDetail{{ $detail->id }}"
                                                        class="hidden absolute right-[75px] top-1/2 -translate-y-1/2 bg-slate-300 dark:bg-dark rounded-md px-3 py-1 bubble-with-arrow z-10">
                                                        {{-- Btn Delete --}}
                                                        <button type="button"
                                                            onclick="handleDeleteMapelDetail({{ $detail->id }}, '{{ $detail->nama_mapel_detail }}')"
                                                            class="bg-red-500 hover:bg-red-600 text-white py-2 px-3 rounded-md text-sm"
                                                            title="Hapus">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </button>
                                                        {{-- Btn Edit --}}
                                                        <x-btn-edit
                                                            data-modal-target="editMapelDetail{{ $detail->id }}"
                                                            data-modal-toggle="editMapelDetail{{ $detail->id }}" />

                                                        <button type="button"
                                                            data-modal-target="addKelasMapelDetail{{ $detail->id }}"
                                                            data-modal-toggle="addKelasMapelDetail{{ $detail->id }}"
                                                            class="bg-green-600 py-1 px-3 rounded-md text-white hover:bg-green-700 text-sm"
                                                            title="Tambah Kelas"><i class="bi bi-plus-lg"></i>
                                                            Kelas</button>

                                                    </div>
                                                </x-td>
                                            </x-tr>
                                        @endforeach
                                    @else
                                        <x-tr>
                                            <x-td class="text-center">
                                                {{ $loop->iteration + $i }}.
                                            </x-td>
                                            <x-td>{{ ucwords(strtolower($data->nama_mapel)) }}</x-td>
                                            <x-td class="text-center whitespace-nowrap">
                                                @if ($data->status == 'Aktif')
                                                    <span
                                                        class="bg-green-500 text-white px-7 py-1 rounded-full whitespace-nowrap">Aktif</span>
                                                @else
                                                    <span
                                                        class="bg-red-500 text-white px-3 py-1 rounded-full whitespace-nowrap">Non-Aktif</span>
                                                @endif
                                            </x-td>
                                            <x-td class="text-center">
                                                @if ($data->mapelKelas->count() > 0)
                                                    <div class="flex flex-wrap gap-1 justify-center">
                                                        @foreach ($data->mapelKelas as $mk)
                                                            @php
                                                                $kelasLabel = trim(
                                                                    ($mk->kelas->nama_kelas_nomor ?? '') .
                                                                        ($mk->kelas->nama_kelas_sub ?? ''),
                                                                );
                                                            @endphp
                                                            <span
                                                                class="bg-blue-100 text-blue-800 text-xs font-medium px-2 py-0.5 rounded dark:bg-blue-900 dark:text-blue-300">
                                                                {{ $kelasLabel !== '' ? $kelasLabel : '-' }}
                                                            </span>
                                                        @endforeach
                                                    </div>
                                                @else
                                                    <span class="text-gray-400 text-sm">-</span>
                                                @endif
                                            </x-td>
                                            <x-td class="text-center whitespace-nowrap relative">
                                                <button type="button" id="btnActionMapel{{ $data->id }}"
                                                    class="py-2 px-4 rounded-md bg-slate-400 dark:text-dark hover:bg-slate-300 transition">
                                                    <i class="fa-solid fa-ellipsis-vertical"></i>
                                                </button>
                                                <div id="actionMapel{{ $data->id }}"
                                                    class="hidden absolute right-[75px] top-1/2 -translate-y-1/2 bg-slate-300 dark:bg-dark rounded-md px-3 py-1 bubble-with-arrow z-10">
                                                    {{-- Btn Delete --}}
                                                    <button type="button"
                                                        onclick="handleDeleteMapel({{ $data->id }}, '{{ $data->nama_mapel }}')"
                                                        class="bg-red-500 hover:bg-red-600 text-white py-2 px-3 rounded-md text-sm"
                                                        title="Hapus">
                                                        <i class="fa-solid fa-trash"></i>
                                                    </button>
                                                    {{-- Btn Edit --}}
                                                    <x-btn-edit data-modal-target="editMapel{{ $data->id }}"
                                                        data-modal-toggle="editMapel{{ $data->id }}" />
                                                    <button type="button"
                                                        data-modal-target="addMapelDetail{{ $data->id }}"
                                                        data-modal-toggle="addMapelDetail{{ $data->id }}"
                                                        class="bg-primary py-2 px-3 rounded-md text-white hover:bg-hvPrimary text-sm"
                                                        title="Tambah Sub Mapel"><i class="bi bi-plus-lg"></i> Sub
                                                        Mapel</button>
                                                    <button type="button"
                                                        data-modal-target="addKelasMapel{{ $data->id }}"
                                                        data-modal-toggle="addKelasMapel{{ $data->id }}"
                                                        class="bg-green-600 py-2 px-3 rounded-md text-white hover:bg-green-700 text-sm"
                                                        title="Tambah Kelas"><i class="bi bi-plus-lg"></i>
                                                        Kelas</button>
                                                </div>
                                            </x-td>
                                            <x-td class="text-center">-</x-td>
                                            <x-td class="text-center">-</x-td>
                                            <x-td class="text-center">-</x-td>
                                            <x-td class="text-center">-</x-td>
                                        </x-tr>
                                    @endif

                                @empty
                                    <x-tr>
                                        <x-td colspan="9" class="text-center text-red-600">Data mapel tidak
                                            ada!</x-td>
                                    </x-tr>
                                @endforelse
                            </tbody>
                        </x-table>
                    </div>

                    <!-- Mobile Card View -->
                    <div class="md:hidden space-y-4">
                        @forelse ($dataMapel as $data)
                            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-4">
                                <!-- Mapel Header -->
                                <div class="flex justify-between items-start">
                                    <div class="flex-1">
                                        <h3 class="font-semibold text-lg">{{ ucwords(strtolower($data->nama_mapel)) }}
                                        </h3>
                                        <div class="flex items-center gap-2 mt-1">
                                            @if ($data->status == 'Aktif')
                                                <span
                                                    class="bg-green-500 text-white px-3 py-0.5 text-xs rounded-full whitespace-nowrap">Aktif</span>
                                            @else
                                                <span
                                                    class="bg-red-500 text-white px-2 py-0.5 text-xs rounded-full whitespace-nowrap">Non-Aktif</span>
                                            @endif

                                            @if ($data->mapelKelas->count() > 0)
                                                <div class="flex flex-wrap gap-1">
                                                    @foreach ($data->mapelKelas as $mk)
                                                        @php
                                                            $kelasLabel = trim(
                                                                ($mk->kelas->nama_kelas_nomor ?? '') .
                                                                    ($mk->kelas->nama_kelas_sub ?? ''),
                                                            );
                                                        @endphp
                                                        <span
                                                            class="bg-blue-100 text-blue-800 text-xs px-2 py-0.5 rounded dark:bg-blue-900 dark:text-blue-300">
                                                            {{ $kelasLabel ?: '-' }}
                                                        </span>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <x-btn-edit data-modal-target="editMapel{{ $data->id }}"
                                            data-modal-toggle="editMapel{{ $data->id }}"
                                            class="!p-2 !w-8 !h-8" />
                                        <button type="button"
                                            onclick="handleDeleteMapel({{ $data->id }}, '{{ $data->nama_mapel }}')"
                                            class="bg-red-500 hover:bg-red-600 text-white py-2 px-3 rounded-md"
                                            title="Hapus">
                                            <i class="fa-solid fa-trash text-xs"></i>
                                        </button>
                                    </div>
                                </div>

                                <!-- Sub Mapel Accordion -->
                                @if ($data->details->count() > 0)
                                    <div class="mt-3 space-y-2">
                                        <button type="button"
                                            onclick="toggleSubMapel('subMapel{{ $data->id }}')"
                                            class="flex items-center justify-between w-full text-left text-sm font-medium text-primary dark:text-hvPrimary focus:outline-none">
                                            <span>Lihat Sub Mata Pelajaran ({{ $data->details->count() }})</span>
                                            <i class="fas fa-chevron-down transition-transform duration-200"
                                                id="subMapel{{ $data->id }}-icon"></i>
                                        </button>

                                        <div id="subMapel{{ $data->id }}"
                                            class="hidden space-y-3 mt-2 pl-4 border-l-2 border-gray-200 dark:border-gray-600">
                                            @foreach ($data->details as $detail)
                                                <div class="bg-gray-50 dark:bg-gray-700 p-3 rounded-lg">
                                                    <div class="flex justify-between items-start">
                                                        <div>
                                                            <h4 class="font-medium">
                                                                {{ ucwords(strtolower($detail->nama_mapel_detail)) }}
                                                            </h4>
                                                            <div class="flex items-center gap-2 mt-1">
                                                                @if ($detail->status == 'Aktif')
                                                                    <span
                                                                        class="bg-green-500 text-white px-2 py-0.5 text-xs rounded-full whitespace-nowrap">Aktif</span>
                                                                @else
                                                                    <span
                                                                        class="bg-red-500 text-white px-2 py-0.5 text-xs rounded-full whitespace-nowrap">Non-Aktif</span>
                                                                @endif

                                                                @if ($detail->mapelKelas->count() > 0)
                                                                    <div class="flex flex-wrap gap-1">
                                                                        @foreach ($detail->mapelKelas as $mkd)
                                                                            @php
                                                                                $kelasLabel = trim(
                                                                                    ($mkd->kelas->nama_kelas_nomor ??
                                                                                        '') .
                                                                                        ($mkd->kelas->nama_kelas_sub ??
                                                                                            ''),
                                                                                );
                                                                            @endphp
                                                                            <span
                                                                                class="bg-blue-100 text-blue-800 text-xs px-1.5 py-0.5 rounded dark:bg-blue-900 dark:text-blue-300">
                                                                                {{ $kelasLabel ?: '-' }}
                                                                            </span>
                                                                        @endforeach
                                                                    </div>
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <div class="flex items-center gap-1">
                                                            <button type="button"
                                                                data-modal-target="addKelasMapelDetail{{ $detail->id }}"
                                                                data-modal-toggle="addKelasMapelDetail{{ $detail->id }}"
                                                                class="bg-green-600 py-1 px-3 rounded-md text-white hover:bg-green-700 text-xs whitespace-nowrap"
                                                                title="Tambah Kelas"><i class="bi bi-plus-lg"></i>
                                                                Kelas</button>
                                                            <x-btn-edit
                                                                data-modal-target="editMapelDetail{{ $detail->id }}"
                                                                data-modal-toggle="editMapelDetail{{ $detail->id }}"
                                                                class="!p-1.5 !w-7 !h-7" />
                                                            <button type="button"
                                                                onclick="handleDeleteMapelDetail({{ $detail->id }}, '{{ $detail->nama_mapel_detail }}')"
                                                                class="bg-red-500 hover:bg-red-600 text-white py-2 px-3 rounded-md"
                                                                title="Hapus">
                                                                <i class="fa-solid fa-trash text-xs"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @else
                                    <div class="mt-3 text-sm text-gray-500 dark:text-gray-400">
                                        Tidak ada sub mata pelajaran
                                    </div>
                                @endif

                                <!-- Action Buttons -->
                                <div
                                    class="mt-3 pt-3 border-t border-gray-200 dark:border-gray-700 flex justify-end gap-3">
                                    <button type="button" data-modal-target="addMapelDetail{{ $data->id }}"
                                        data-modal-toggle="addMapelDetail{{ $data->id }}"
                                        class="text-xs bg-primary hover:bg-hvPrimary text-white px-3 py-1.5 rounded-md flex items-center gap-1">
                                        <i class="fas fa-plus text-xs"></i>
                                        <span>Sub Mapel</span>
                                    </button>
                                    <button type="button" data-modal-target="addKelasMapel{{ $data->id }}"
                                        data-modal-toggle="addKelasMapel{{ $data->id }}"
                                        class="text-xs bg-green-600 hover:bg-green-700 text-white px-3 py-1.5 rounded-md flex items-center gap-1">
                                        <i class="fas fa-plus text-xs"></i>
                                        <span>Kelas</span>
                                    </button>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-4 text-gray-500 dark:text-gray-400">
                                Data mata pelajaran tidak ditemukan
                            </div>
                        @endforelse
                    </div>
                    {{-- Pagination --}}
                    <div class="flex justify-between items-center mt-3">
                        <span id="dataInfo" class="text-xs text-dark dark:text-light">
                            Menampilkan <span class="font-semibold">{{ $dataMapel->firstItem() }}</span>
                            sampai <span class="font-semibold">{{ $dataMapel->lastItem() }}</span>
                            dari <span class="font-semibold">{{ $dataMapel->total() }}</span>
                            data
                        </span>
                        <div id="paginationLinks" class="inline-flex mt-2 xs:mt-0">
                            {{ $dataMapel->links('vendor.pagination.costum') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {{-- End Tab Content: Setting Mapel --}}

        {{-- Tab Content: Rekap Mapel --}}
        <div id="contentRekapMapel" class="tab-content hidden">
            <div
                class="w-full md:shadow rounded-md p-1 md:p-5 md:bg-gray-50 text-gray-900 md:dark:bg-gray-800 dark:text-gray-50 md:border-t-4 md:border-primary">
                <h2 class="text-xl font-bold mb-4">
                    <i class="fa-solid fa-table-list mr-2"></i>Rekap Mata Pelajaran per Kelas
                </h2>

                <!-- Desktop Table View -->
                <div class="hidden md:block overflow-x-auto">
                    <x-table>
                        <x-thead>
                            <tr>
                                <x-th class="whitespace-nowrap w-14">No.</x-th>
                                <x-th class="whitespace-nowrap">Kelas</x-th>
                                <x-th class="whitespace-nowrap">Mata Pelajaran</x-th>
                                <x-th class="whitespace-nowrap">Sub Mata Pelajaran</x-th>
                            </tr>
                        </x-thead>
                        <tbody>
                            @forelse ($dataKelas as $kelasIndex => $kelas)
                                @php
                                    // Get mapel heads for this kelas
                                    $mapelHeadsForKelas = \App\Models\MapelHead::with([
                                        'mapelKelas' => function ($q) use ($kelas) {
                                            $q->where('kelas_id', $kelas->id)->where('mapel_type', 'head');
                                        },
                                    ])
                                        ->whereHas('mapelKelas', function ($q) use ($kelas) {
                                            $q->where('kelas_id', $kelas->id)->where('mapel_type', 'head');
                                        })
                                        ->where('status', 'Aktif')
                                        ->where('deleted', '0')
                                        ->orderBy('nama_mapel')
                                        ->get();

                                    // Get mapel details for this kelas grouped by mapel_head_id
                                    $mapelDetailsForKelas = \App\Models\MapelDetail::with([
                                        'mapelHead',
                                        'mapelKelas' => function ($q) use ($kelas) {
                                            $q->where('kelas_id', $kelas->id)->where('mapel_type', 'detail');
                                        },
                                    ])
                                        ->whereHas('mapelKelas', function ($q) use ($kelas) {
                                            $q->where('kelas_id', $kelas->id)->where('mapel_type', 'detail');
                                        })
                                        ->where('status', 'Aktif')
                                        ->where('deleted', '0')
                                        ->orderBy('nama_mapel_detail')
                                        ->get()
                                        ->groupBy('mapel_head_id');

                                    // Calculate total rows for this kelas
                                    $totalRows = 0;
                                    foreach ($mapelHeadsForKelas as $mapelHead) {
                                        $details = $mapelDetailsForKelas->get($mapelHead->id, collect());
                                        $totalRows += max(1, $details->count());
                                    }
                                    $totalRows = max($totalRows, 1);
                                @endphp

                                @if ($mapelHeadsForKelas->count() > 0)
                                    @php $rowCounter = 0; @endphp
                                    @foreach ($mapelHeadsForKelas as $mapelHead)
                                        @php
                                            $details = $mapelDetailsForKelas->get($mapelHead->id, collect());
                                            $detailCount = max(1, $details->count());
                                        @endphp

                                        @if ($details->count() > 0)
                                            {{-- Mapel with sub mapel --}}
                                            @foreach ($details as $detailIndex => $detail)
                                                <x-tr>
                                                    @if ($rowCounter === 0)
                                                        <x-td class="text-center" rowspan="{{ $totalRows }}">
                                                            {{ $kelasIndex + 1 }}.
                                                        </x-td>
                                                        <x-td class="font-semibold text-center"
                                                            rowspan="{{ $totalRows }}">
                                                            {{ $kelas->nama_kelas_romawi }}{{ $kelas->nama_kelas_sub ?? '' }}
                                                            ({{ $kelas->nama_kelas_nomor }}{{ $kelas->nama_kelas_sub ?? '' }})
                                                        </x-td>
                                                    @endif

                                                    @if ($detailIndex === 0)
                                                        <x-td rowspan="{{ $detailCount }}">
                                                            <span
                                                                class="font-medium">{{ ucwords(strtolower($mapelHead->nama_mapel)) }}</span>
                                                        </x-td>
                                                    @endif

                                                    <x-td>
                                                        <span
                                                            class="text-sm">{{ ucwords(strtolower($detail->nama_mapel_detail)) }}</span>
                                                    </x-td>
                                                </x-tr>
                                                @php $rowCounter++; @endphp
                                            @endforeach
                                        @else
                                            {{-- Mapel without sub mapel --}}
                                            <x-tr>
                                                @if ($rowCounter === 0)
                                                    <x-td class="text-center" rowspan="{{ $totalRows }}">
                                                        {{ $kelasIndex + 1 }}.
                                                    </x-td>
                                                    <x-td class="font-semibold text-center"
                                                        rowspan="{{ $totalRows }}">
                                                        {{ $kelas->nama_kelas_romawi }}{{ $kelas->nama_kelas_sub ?? '' }}
                                                        ({{ $kelas->nama_kelas_nomor }}{{ $kelas->nama_kelas_sub ?? '' }})
                                                    </x-td>
                                                @endif

                                                <x-td>
                                                    <span
                                                        class="font-medium">{{ ucwords(strtolower($mapelHead->nama_mapel)) }}</span>
                                                </x-td>
                                                <x-td class="text-gray-400">
                                                    <span class="text-sm">-</span>
                                                </x-td>
                                            </x-tr>
                                            @php $rowCounter++; @endphp
                                        @endif
                                    @endforeach
                                @else
                                    <x-tr>
                                        <x-td class="text-center">{{ $kelasIndex + 1 }}.</x-td>
                                        <x-td class="font-semibold text-center">
                                            {{ $kelas->nama_kelas_romawi }}{{ $kelas->nama_kelas_sub ?? '' }}
                                            ({{ $kelas->nama_kelas_nomor }}{{ $kelas->nama_kelas_sub ?? '' }})
                                        </x-td>
                                        <x-td colspan="2" class="text-center text-gray-400">
                                            <i class="fa-solid fa-circle-info mr-1"></i>Belum ada mata pelajaran
                                        </x-td>
                                    </x-tr>
                                @endif
                            @empty
                                <x-tr>
                                    <x-td colspan="4" class="text-center text-red-600">Data kelas tidak ada!</x-td>
                                </x-tr>
                            @endforelse
                        </tbody>
                    </x-table>
                </div>

                <!-- Mobile Card View -->
                <div class="md:hidden space-y-4 mt-4">
                    @forelse ($dataKelas as $kelasIndex => $kelas)
                        @php
                            // Get mapel heads for this kelas
                            $mapelHeadsForKelas = \App\Models\MapelHead::with([
                                'mapelKelas' => function ($q) use ($kelas) {
                                    $q->where('kelas_id', $kelas->id)->where('mapel_type', 'head');
                                },
                                'details' => function ($q) use ($kelas) {
                                    $q->whereHas('mapelKelas', function ($q) use ($kelas) {
                                        $q->where('kelas_id', $kelas->id)->where('mapel_type', 'detail');
                                    });
                                },
                                'details.mapelKelas',
                            ])
                                ->whereHas('mapelKelas', function ($q) use ($kelas) {
                                    $q->where('kelas_id', $kelas->id)->where('mapel_type', 'head');
                                })
                                ->where('status', 'Aktif')
                                ->where('deleted', '0')
                                ->orderBy('nama_mapel')
                                ->get();
                        @endphp

                        <div class="bg-white dark:bg-gray-800 shadow rounded-lg overflow-hidden">
                            <!-- Kelas Header -->
                            <div class="bg-primary p-4">
                                <div class="flex justify-between items-center">
                                    <h3 class="text-lg font-semibold text-white dark:text-gray-100">
                                        {{ $kelas->nama_kelas_romawi }}{{ $kelas->nama_kelas_sub ?? '' }}
                                        <span
                                            class="text-sm font-normal">({{ $kelas->nama_kelas_nomor }}{{ $kelas->nama_kelas_sub ?? '' }})</span>
                                    </h3>
                                    <span class="text-xs bg-white/20 text-white px-2 py-1 rounded-full">
                                        {{ $mapelHeadsForKelas->count() }} Mapel
                                    </span>
                                </div>
                            </div>

                            <!-- Mapel List -->
                            <div class="divide-y divide-gray-200 dark:divide-gray-700">
                                @forelse ($mapelHeadsForKelas as $mapelHead)
                                    @php
                                        $details = $mapelHead->details->filter(function ($detail) use ($kelas) {
                                            return $detail->mapelKelas->contains('kelas_id', $kelas->id);
                                        });
                                    @endphp

                                    <div class="p-4">
                                        <!-- Mapel Header -->
                                        @if ($details->count() > 0)
                                            <button type="button" class="w-full"
                                                onclick="toggleSubMapel('subMapelRekap-{{ $kelas->id }}-{{ $mapelHead->id }}')">
                                        @endif
                                        <div class="flex justify-between items-center">
                                            <h4 class="font-medium text-gray-900 dark:text-white">
                                                {{ $mapelHead->nama_mapel }}
                                                @if ($details->count() > 0)
                                                    <span class="text-xs text-gray-500 dark:text-gray-400">
                                                        ({{ $details->count() }} sub mapel)
                                                    </span>
                                                @endif
                                            </h4>
                                            @if ($details->count() > 0)
                                                <i class="fas fa-chevron-down text-primary dark:text-hvPrimary hover:text-hvPrimaryDark focus:outline-none transition-transform duration-200"
                                                    id="iconSubMapelRekap-{{ $kelas->id }}-{{ $mapelHead->id }}"></i>
                                            @endif
                                        </div>
                                        @if ($details->count() > 0)
                                            </button>
                                        @endif
                                        <!-- Sub Mapel List -->
                                        @if ($details->count() > 0)
                                            <div id="subMapelRekap-{{ $kelas->id }}-{{ $mapelHead->id }}"
                                                class="hidden mt-2 pl-4 border-l-2 border-gray-200 dark:border-gray-600 space-y-2">
                                                @foreach ($details as $detail)
                                                    <div class="py-1 text-sm text-gray-700 dark:text-gray-300">
                                                        <i class="fas fa-chevron-right text-xs text-gray-400 mr-2"></i>
                                                        {{ $detail->nama_mapel_detail }}
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                @empty
                                    <div class="p-4 text-center text-gray-500 dark:text-gray-400">
                                        Tidak ada mata pelajaran untuk kelas ini
                                    </div>
                                @endforelse
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                            <i class="fas fa-inbox text-4xl mb-2"></i>
                            <p>Data kelas tidak tersedia</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
        {{-- End Tab Content: Rekap Mapel --}}

        <div class="fixed bottom-6 right-6 z-50 md:hidden">
            <button type="button" data-modal-target="addMapel" data-modal-toggle="addMapel"
                class="w-14 h-14 rounded-full bg-primary text-white flex items-center justify-center shadow-lg hover:bg-primary-dark transition-colors duration-200">
                <i class="fa-solid fa-plus text-2xl"></i>
            </button>
        </div>
    </section>

    <!-- Modal Validasi (Data Sudah Digunakan) -->
    <div id="validasiModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md p-6">
            <div class="text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                    <i class="fa-solid fa-exclamation-triangle text-red-600 text-2xl"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2 text-gray-900 dark:text-gray-50">Data Tidak Dapat Dihapus</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
                    Data mata pelajaran <span id="validasiNamaMapel" class="font-semibold"></span> sudah digunakan
                    pada buku induk dan tidak dapat dihapus.
                </p>
                <button type="button" onclick="closeValidasiModal()"
                    class="w-full bg-primary hover:bg-hvPrimary text-white px-4 py-2 rounded-lg text-sm">
                    Tutup
                </button>
            </div>
        </div>
    </div>

    <!-- Modal Konfirmasi Delete -->
    <div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md p-6">
            <div class="text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-yellow-100 mb-4">
                    <i class="fa-solid fa-question-circle text-yellow-600 text-2xl"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2 text-gray-900 dark:text-gray-50">Konfirmasi Hapus</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
                    Apakah Anda yakin ingin menghapus <span id="deleteNamaMapel" class="font-semibold"></span>?
                </p>
                <form id="deleteForm" method="POST" action="">
                    @csrf
                    @method('DELETE')
                    <div class="flex gap-3">
                        <button type="button" onclick="closeDeleteModal()"
                            class="flex-1 bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg text-sm">
                            Batal
                        </button>
                        <button type="submit"
                            class="flex-1 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                            Hapus
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    {{-- Modal Edit Mapel --}}
    @foreach ($dataMapel as $data)
        <div id="editMapel{{ $data->id }}" tabindex="-1" aria-hidden="true"
            class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-lg max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="fa-solid fa-pencil"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Edit Mapel
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="editMapel{{ $data->id }}">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <form action="/mata-pelajaran/{{ $data->id }}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="_form" value="edit">
                        <input type="hidden" name="_id" value="{{ $data->id }}">
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="grid gap-4 mb-4 grid-cols-1">
                                <div>
                                    <x-label><span class="text-red-500">*</span>Nama Mata Pelajaran</x-label>
                                    <x-input name="nama_mapel" type="text" tabindex="1"
                                        value="{{ old('nama_mapel', $data->nama_mapel) }}"
                                        class="w-full {{ $errors->first('nama_mapel') ? 'border-red-400' : '' }} capitalize-input"
                                        placeholder="Masukkan nama mapel..." />
                                    <x-message>{{ $errors->first('nama_mapel') }}</x-message>
                                </div>
                                <div>
                                    <x-label><span class="text-red-500">*</span>Status</x-label>
                                    <x-select name="status" tabindex="2"
                                        class="{{ $errors->first('status') ? 'border-red-500' : '' }}" required>
                                        <option value="" disabled>-- Pilih Status --</option>
                                        <option value="Aktif"
                                            {{ old('status', $detail->status) == 'Aktif' ? 'selected' : '' }}>
                                            Aktif</option>
                                        <option value="Non-Aktif"
                                            {{ old('status', $detail->status) == 'Non-Aktif' ? 'selected' : '' }}>
                                            Non-Aktif</option>
                                    </x-select>
                                    <x-message>{{ $errors->first('status') }}</x-message>
                                    {{-- <x-textarea name="keterangan" tabindex="2"
                                        class="w-full {{ $errors->first('keterangan') ? 'border-red-400' : '' }}"
                                        placeholder="Masukkan keterangan (opsional)...">{{ old('keterangan', $data->keterangan) }}</x-textarea>
                                    <x-message>{{ $errors->first('keterangan') }}</x-message> --}}
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <x-btn-save tabindex="3">
                                <div class="flex items-center gap-1 font-medium">
                                    <i class="fa-solid fa-floppy-disk"></i>
                                    <p>Update</p>
                                </div>
                            </x-btn-save>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach

    {{-- Modal Tambah Kelas untuk Mapel --}}
    @foreach ($dataMapel as $data)
        <div id="addKelasMapel{{ $data->id }}" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="bi bi-plus-lg"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Tambah Kelas - {{ $data->nama_mapel }}
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="addKelasMapel{{ $data->id }}">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <form action="{{ route('mata-pelajaran.kelas.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="mapel_id" value="{{ $data->id }}">
                        <input type="hidden" name="mapel_type" value="head">
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="w-full">
                                <div class="flex items-center justify-between">
                                    <x-label class="mb-2"><span class="text-red-500">*</span>Pilih
                                        Kelas</x-label>
                                    @php
                                        $existingKelasHead = $data->mapelKelas->pluck('kelas_id')->toArray();
                                        $isAllKelasSelectedHead =
                                            count($existingKelasHead) === $dataKelas->count() &&
                                            $dataKelas->count() > 0;
                                    @endphp
                                    <div class="flex items-center gap-1">
                                        <input type="checkbox" id="selectAllKelas{{ $data->id }}"
                                            class="w-3.5 h-3.5 text-primary bg-gray-100 border-gray-300 rounded focus:ring-primary dark:focus:ring-primary dark:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500"
                                            data-select-all="mapel-head-{{ $data->id }}"
                                            {{ $isAllKelasSelectedHead ? 'checked' : '' }}>
                                        <label for="selectAllKelas{{ $data->id }}"
                                            class="text-xs text-gray-500 dark:text-gray-300 cursor-pointer">Pilih
                                            Semua</label>
                                    </div>
                                </div>
                                <div
                                    class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-2 max-h-60 overflow-y-auto p-2 border rounded-md">
                                    @foreach ($dataKelas as $kelas)
                                        <div class="flex items-center">
                                            <input id="kelas-{{ $data->id }}-{{ $kelas->id }}"
                                                type="checkbox" name="kelas_id[]" value="{{ $kelas->id }}"
                                                class="w-3.5 h-3.5 text-primary bg-gray-100 border-gray-300 rounded focus:ring-primary dark:focus:ring-primary dark:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500"
                                                data-select-group="mapel-head-{{ $data->id }}"
                                                {{ in_array($kelas->id, $existingKelasHead) ? 'checked' : '' }}>
                                            <label for="kelas-{{ $data->id }}-{{ $kelas->id }}"
                                                class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300 cursor-pointer">
                                                {{ $kelas->nama_kelas_romawi }}{{ $kelas->nama_kelas_sub ?? '' }}
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                                <x-message>{{ $errors->first('kelas_id') }}</x-message>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <x-btn-save tabindex="1">
                                <div class="flex items-center gap-1 font-medium">
                                    <i class="fa-solid fa-floppy-disk"></i>
                                    <p>Simpan</p>
                                </div>
                            </x-btn-save>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach

    {{-- Modal Tambah Detail Mapel --}}
    @foreach ($dataMapel as $data)
        <div id="addMapelDetail{{ $data->id }}" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-lg max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="bi bi-plus-lg"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Tambah Sub Mapel - {{ $data->nama_mapel }}
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white"
                            data-modal-hide="addMapelDetail{{ $data->id }}">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <form action="{{ route('mata-pelajaran.detail.store') }}" method="POST">
                        @csrf
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <input type="hidden" name="mapel_head_id" value="{{ $data->id }}">
                            <input type="hidden" name="_form" value="add_detail">
                            <input type="hidden" name="_id" value="{{ $data->id }}">

                            <div class="grid gap-4 mb-4 grid-cols-1">
                                <div>
                                    <x-label><span class="text-red-500">*</span>Nama Sub Mata Pelajaran</x-label>
                                    <x-input name="nama_mapel_detail" type="text" tabindex="1"
                                        value="{{ old('nama_mapel_detail') }}"
                                        class="{{ $errors->first('nama_mapel_detail') ? 'border-red-400' : '' }} capitalize-input"
                                        placeholder="Masukkan nama sub mapel..." />
                                    <x-message>{{ $errors->first('nama_mapel_detail') }}</x-message>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <x-btn-save tabindex="3">
                                <div class="flex items-center gap-1 font-medium">
                                    <i class="fa-solid fa-floppy-disk"></i>
                                    <p>Simpan</p>
                                </div>
                            </x-btn-save>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach

    {{-- Modal Edit Detail Mapel --}}
    @foreach ($dataMapel as $data)
        @foreach ($data->details as $detail)
            <div id="editMapelDetail{{ $detail->id }}" tabindex="-1" aria-hidden="true"
                class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                <div class="relative p-4 w-full max-w-lg max-h-full">
                    <!-- Modal content -->
                    <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                        <!-- Modal header -->
                        <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                            <div class="flex items-center gap-1">
                                <i class="fa-solid fa-pencil"></i>
                                <h3 class="text-xl font-semibold text-dark dark:text-light">
                                    Edit Sub Mapel - {{ $data->nama_mapel }}
                                </h3>
                            </div>
                            <button type="button"
                                class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white"
                                data-modal-hide="editMapelDetail{{ $detail->id }}">
                                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="none" viewBox="0 0 14 14">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                </svg>
                                <span class="sr-only">Close modal</span>
                            </button>
                        </div>
                        <form action="{{ route('mata-pelajaran.detail.update', $detail->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <!-- Modal body -->
                            <div class="p-4 md:p-5">
                                <input type="hidden" name="_form" value="edit_detail">
                                <input type="hidden" name="_id" value="{{ $detail->id }}">

                                <div class="grid gap-4 mb-4 grid-cols-1">
                                    <div>
                                        <x-label><span class="text-red-500">*</span>Nama Sub Mata Pelajaran</x-label>
                                        <x-input name="nama_mapel_detail" type="text" tabindex="1"
                                            value="{{ old('nama_mapel_detail', $detail->nama_mapel_detail) }}"
                                            class="{{ $errors->first('nama_mapel_detail') ? 'border-red-400' : '' }} capitalize-input"
                                            placeholder="Masukkan nama sub mapel..." />
                                        <x-message>{{ $errors->first('nama_mapel_detail') }}</x-message>
                                    </div>
                                    <div>
                                        <x-label><span class="text-red-500">*</span>Status</x-label>
                                        <x-select name="status" tabindex="2"
                                            class="{{ $errors->first('status') ? 'border-red-500' : '' }}" required>
                                            <option value="" disabled>-- Pilih Status --</option>
                                            <option value="Aktif"
                                                {{ old('status', $detail->status) == 'Aktif' ? 'selected' : '' }}>
                                                Aktif</option>
                                            <option value="Non-Aktif"
                                                {{ old('status', $detail->status) == 'Non-Aktif' ? 'selected' : '' }}>
                                                Non-Aktif</option>
                                        </x-select>
                                        <x-message>{{ $errors->first('status') }}</x-message>
                                    </div>
                                </div>
                            </div>
                            <!-- Modal footer -->
                            <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                                <x-btn-save tabindex="3">
                                    <div class="flex items-center gap-1 font-medium">
                                        <i class="fa-solid fa-floppy-disk"></i>
                                        <p>Update</p>
                                    </div>
                                </x-btn-save>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- Modal Tambah Kelas untuk Sub Mapel --}}
            <div id="addKelasMapelDetail{{ $detail->id }}" tabindex="-1" aria-hidden="true"
                class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                <div class="relative p-4 w-full max-w-2xl max-h-full">
                    <!-- Modal content -->
                    <div class="relative bg-light dark:bg-gray-700 rounded-lg shadow">
                        <!-- Modal header -->
                        <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                            <div class="flex items-center gap-1">
                                <i class="fa-solid fa-border-all"></i>
                                <h3 class="text-xl font-semibold text-dark dark:text-light">
                                    Tambah Kelas - {{ $detail->nama_mapel_detail }}
                                </h3>
                            </div>
                            <button type="button"
                                class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                                data-modal-hide="addKelasMapelDetail{{ $detail->id }}">
                                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="none" viewBox="0 0 14 14">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                </svg>
                                <span class="sr-only">Close modal</span>
                            </button>
                        </div>
                        <form action="{{ route('mata-pelajaran.kelas.store') }}" method="POST">
                            @csrf
                            <input type="hidden" name="mapel_id" value="{{ $detail->id }}">
                            <input type="hidden" name="mapel_type" value="detail">
                            <!-- Modal body -->
                            <div class="p-4 md:p-5">
                                <div class="w-full">
                                    <div class="flex items-center justify-between">
                                        <x-label class="mb-2"><span class="text-red-500">*</span>Pilih
                                            Kelas</x-label>
                                        @php
                                            $selectedKelasIdsDetail = $detail->mapelKelas->pluck('kelas_id')->toArray();
                                            $isAllKelasSelectedDetail =
                                                count($selectedKelasIdsDetail) === $dataKelas->count() &&
                                                $dataKelas->count() > 0;
                                        @endphp
                                        <div class="flex items-center mb-3">
                                            <input type="checkbox" id="selectAllKelasMapelDetail{{ $detail->id }}"
                                                class="w-4 h-4 text-primary bg-gray-100 border-gray-300 rounded focus:ring-primary focus:ring-2"
                                                data-select-all="mapel-detail-{{ $detail->id }}"
                                                {{ $isAllKelasSelectedDetail ? 'checked' : '' }}>
                                            <label for="selectAllKelasMapelDetail{{ $detail->id }}"
                                                class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300 cursor-pointer">
                                                Pilih Semua
                                            </label>
                                        </div>
                                    </div>
                                    <div
                                        class="grid grid-cols-2 md:grid-cols-3 gap-3 max-h-96 overflow-y-auto p-2 border border-gray-300 rounded-lg">
                                        @foreach ($dataKelas as $kelas)
                                            <div class="flex items-center">
                                                <input type="checkbox" name="kelas_id[]"
                                                    value="{{ $kelas->id }}"
                                                    id="kelasMapelDetail{{ $detail->id }}_{{ $kelas->id }}"
                                                    {{ in_array($kelas->id, $selectedKelasIdsDetail) ? 'checked' : '' }}
                                                    class="w-4 h-4 text-primary bg-gray-100 border-gray-300 rounded focus:ring-primary focus:ring-2"
                                                    data-select-group="mapel-detail-{{ $detail->id }}">
                                                <label
                                                    for="kelasMapelDetail{{ $detail->id }}_{{ $kelas->id }}"
                                                    class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300 cursor-pointer">
                                                    {{ $kelas->nama_kelas_romawi }}{{ $kelas->nama_kelas_sub ?? '' }}
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <!-- Modal footer -->
                            <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b">
                                <x-btn-save tabindex="1">
                                    <div class="flex items-center gap-1 font-medium">
                                        <i class="fa-solid fa-floppy-disk"></i>
                                        <p>Simpan</p>
                                    </div>
                                </x-btn-save>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endforeach
    @endforeach

    @push('js')
        <script>
            // Toggle sub mapel accordion
            function toggleSubMapel(id) {
                const element = document.getElementById(id);
                const icon = document.getElementById(`${id}-icon`);

                if (element.classList.contains('hidden')) {
                    element.classList.remove('hidden');
                    icon.classList.add('rotate-180');
                } else {
                    element.classList.add('hidden');
                    icon.classList.remove('rotate-180');
                }
            }
        </script>

        {{-- Buka Modal Edit Ketika Tervalidasi --}}
        @foreach ($dataMapel as $data)
            @if ($errors->has('nama_mapel') && old('_form') === 'edit' && old('_id') == $data->id)
                <script>
                    window.onload = function() {
                        setTimeout(function() {
                            document.getElementById('editMapel{{ $data->id }}').classList.remove('hidden');
                            document.getElementById('editMapel{{ $data->id }}').classList.add('flex', 'bg-gray-800',
                                'bg-opacity-70');
                        }, 100);
                    };
                </script>
            @endif
        @endforeach

        {{-- Buka Modal Add Ketika Tervalidasi --}}
        @if ($errors->has('nama_mapel') && old('_form') === 'add')
            <script>
                window.onload = function() {
                    setTimeout(function() {
                        document.getElementById('addMapel').classList.remove('hidden');
                        document.getElementById('addMapel').classList.add('flex', 'bg-gray-800', 'bg-opacity-70');
                    }, 100);
                };
            </script>
        @endif

        {{-- Buka Modal Add Detail Ketika Tervalidasi --}}
        @foreach ($dataMapel as $data)
            @if (
                ($errors->has('nama_mapel_detail') || $errors->has('status')) &&
                    old('_form') === 'add_detail' &&
                    old('_id') == $data->id)
                <script>
                    window.onload = function() {
                        setTimeout(function() {
                            document.getElementById('addMapelDetail{{ $data->id }}').classList.remove('hidden');
                            document.getElementById('addMapelDetail{{ $data->id }}').classList.add('flex',
                                'bg-gray-800', 'bg-opacity-70');
                        }, 100);
                    };
                </script>
            @endif
        @endforeach

        {{-- Buka Modal Edit Detail Ketika Tervalidasi --}}
        @foreach ($dataMapel as $data)
            @foreach ($data->details as $detail)
                @if (
                    ($errors->has('nama_mapel_detail') || $errors->has('status')) &&
                        old('_form') === 'edit_detail' &&
                        old('_id') == $detail->id)
                    <script>
                        window.onload = function() {
                            setTimeout(function() {
                                document.getElementById('editMapelDetail{{ $detail->id }}').classList.remove('hidden');
                                document.getElementById('editMapelDetail{{ $detail->id }}').classList.add('flex',
                                    'bg-gray-800', 'bg-opacity-70');
                            }, 100);
                        };
                    </script>
                @endif
            @endforeach
        @endforeach
    @endpush

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Function to convert text to title case
                function toTitleCase(str) {
                    return str.replace(/\w\S*/g, function(txt) {
                        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
                    });
                }

                // Apply title case to all inputs with capitalize-input class
                const capitalizeInputs = document.querySelectorAll('.capitalize-input');

                capitalizeInputs.forEach(function(input) {
                    // Transform existing value to title case on page load
                    if (input.value) {
                        input.value = toTitleCase(input.value);
                    }

                    // Transform input on change/input events
                    input.addEventListener('input', function() {
                        this.value = toTitleCase(this.value);
                    });

                    // Also transform on blur to ensure consistency
                    input.addEventListener('blur', function() {
                        this.value = toTitleCase(this.value);
                    });
                });
            });
        </script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.querySelectorAll('[data-select-all]').forEach(function(selectAllCheckbox) {
                    const group = selectAllCheckbox.getAttribute('data-select-all');
                    const itemCheckboxes = document.querySelectorAll(`[data-select-group="${group}"]`);

                    const updateSelectAllState = () => {
                        const total = itemCheckboxes.length;
                        const checked = Array.from(itemCheckboxes).filter(checkbox => checkbox.checked)
                            .length;

                        if (total === 0) {
                            selectAllCheckbox.checked = false;
                            selectAllCheckbox.indeterminate = false;
                            return;
                        }

                        selectAllCheckbox.checked = checked === total;
                        selectAllCheckbox.indeterminate = checked > 0 && checked < total;
                    };

                    selectAllCheckbox.addEventListener('change', function() {
                        const shouldCheck = selectAllCheckbox.checked;
                        itemCheckboxes.forEach(function(checkbox) {
                            checkbox.checked = shouldCheck;
                        });
                        selectAllCheckbox.indeterminate = false;
                    });

                    itemCheckboxes.forEach(function(checkbox) {
                        checkbox.addEventListener('change', updateSelectAllState);
                    });

                    updateSelectAllState();
                });
            });
        </script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Handle all action buttons
                document.querySelectorAll('button[id^="btnAction"]').forEach(button => {
                    button.addEventListener('click', function(e) {
                        e.stopPropagation();

                        let menuId;

                        // Determine which menu to show based on button ID
                        if (this.id.includes('btnActionMapelDetail')) {
                            const id = this.id.replace('btnActionMapelDetail', '');
                            menuId = 'actionMapelDetail' + id;
                        } else if (this.id.includes('btnActionMapel')) {
                            const id = this.id.replace('btnActionMapel', '');
                            menuId = 'actionMapel' + id;
                        }

                        const menu = document.getElementById(menuId);
                        if (!menu) return;

                        // Close all other menus first
                        document.querySelectorAll('[id^="actionMapel"]').forEach(m => {
                            if (m !== menu) m.classList.add('hidden');
                        });

                        // Toggle clicked menu
                        menu.classList.toggle('hidden');
                    });
                });

                // Click outside to close all menus
                document.addEventListener('click', function(e) {
                    if (e.target.closest('[id^="btnAction"]') ||
                        e.target.closest('[id^="actionMapel"]')) return;
                    document.querySelectorAll('[id^="actionMapel"]').forEach(m => m.classList.add('hidden'));
                });
            });

            // Tab Switching Function
            function switchTab(tab) {
                // Get all tab buttons and contents
                const tabButtons = document.querySelectorAll('.mapel-tab');
                const tabContents = document.querySelectorAll('.tab-content');

                // Update all buttons
                tabButtons.forEach(btn => {
                    const isActive = (tab === 'setting' && btn.id === 'tabSettingMapel') ||
                        (tab === 'rekap' && btn.id === 'tabRekapMapel');

                    if (isActive) {
                        // Active state
                        btn.classList.add('tab-active', 'font-semibold', 'text-primary', 'dark:text-hvPrimary',
                            'border-b-2', 'border-hvPrimary');
                        btn.classList.remove('tab-inactive', 'text-gray-600', 'dark:text-gray-400');
                    } else {
                        // Inactive state
                        btn.classList.remove('tab-active', 'font-semibold', 'text-primary', 'dark:text-hvPrimary',
                            'border-b-2', 'border-hvPrimary');
                        btn.classList.add('tab-inactive', 'text-gray-600', 'dark:text-gray-400');
                    }
                });

                // Show/hide content
                tabContents.forEach(content => {
                    if ((tab === 'setting' && content.id === 'contentSettingMapel') ||
                        (tab === 'rekap' && content.id === 'contentRekapMapel')) {
                        content.classList.remove('hidden');
                    } else {
                        content.classList.add('hidden');
                    }
                });
            }

            // Handle Delete Mapel Head
            async function handleDeleteMapel(id, namaMapel) {
                try {
                    // Check if mapel is being used
                    const response = await fetch(`/mata-pelajaran/${id}/check-usage`);
                    const data = await response.json();

                    if (data.used) {
                        // Show validation modal if data is being used
                        document.getElementById('validasiNamaMapel').textContent = data.nama_mapel;
                        openValidasiModal();
                    } else {
                        // Show delete confirmation modal if data is not being used
                        document.getElementById('deleteNamaMapel').textContent = 'mata pelajaran "' + namaMapel + '"';
                        document.getElementById('deleteForm').action = `/mata-pelajaran/${id}`;
                        openDeleteModal();
                    }
                } catch (error) {
                    console.error('Error checking usage:', error);
                    alert('Terjadi kesalahan saat memeriksa data. Silakan coba lagi.');
                }
            }

            // Handle Delete Mapel Detail
            async function handleDeleteMapelDetail(id, namaMapelDetail) {
                try {
                    // Check if mapel detail is being used
                    const response = await fetch(`/mata-pelajaran/detail/${id}/check-usage`);
                    const data = await response.json();

                    if (data.used) {
                        // Show validation modal if data is being used
                        document.getElementById('validasiNamaMapel').textContent = data.nama_mapel;
                        openValidasiModal();
                    } else {
                        // Show delete confirmation modal if data is not being used
                        document.getElementById('deleteNamaMapel').textContent = 'detail mata pelajaran "' +
                            namaMapelDetail + '"';
                        document.getElementById('deleteForm').action = `/mata-pelajaran/detail/${id}`;
                        openDeleteModal();
                    }
                } catch (error) {
                    console.error('Error checking usage:', error);
                    alert('Terjadi kesalahan saat memeriksa data. Silakan coba lagi.');
                }
            }

            // Modal functions for Validasi
            function openValidasiModal() {
                document.getElementById('validasiModal').classList.remove('hidden');
                document.getElementById('validasiModal').classList.add('flex');
                document.body.style.overflow = 'hidden';
            }

            function closeValidasiModal() {
                document.getElementById('validasiModal').classList.add('hidden');
                document.getElementById('validasiModal').classList.remove('flex');
                document.body.style.overflow = 'auto';
            }

            // Modal functions for Delete
            function openDeleteModal() {
                document.getElementById('deleteModal').classList.remove('hidden');
                document.getElementById('deleteModal').classList.add('flex');
                document.body.style.overflow = 'hidden';
            }

            function closeDeleteModal() {
                document.getElementById('deleteModal').classList.add('hidden');
                document.getElementById('deleteModal').classList.remove('flex');
                document.body.style.overflow = 'auto';
            }

            // Close modals when clicking outside
            document.addEventListener('DOMContentLoaded', function() {
                const validasiModal = document.getElementById('validasiModal');
                const deleteModal = document.getElementById('deleteModal');

                if (validasiModal) {
                    validasiModal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            closeValidasiModal();
                        }
                    });
                }

                if (deleteModal) {
                    deleteModal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            closeDeleteModal();
                        }
                    });
                }
            });
        </script>
    @endpush
</x-app-layout>
