<title>Data Kepala Sekolah</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="md:flex justify-between mb-4">
            <div>
                <h1>
                    <div class="flex gap-2">
                        <i class="fa-solid fa-user-shield text-3xl mt-1"></i>
                        <div>
                            <p class="text-xl sm:text-2xl font-bold">Data Kepala Sekolah</p>
                            <p class="text-xs sm:text-sm ms-[1px]">Index</p>
                        </div>
                    </div>
                </h1>
            </div>
        </div>

        <div class="md:flex md:items-start md:gap-4">
            {{-- Add Data --}}
            <div
                class="md:w-[35%] w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary md:block ">
                <div class="flex items-center gap-1 font-semibold">
                    <i class="{{ $kepalaSekolahEdit ? 'bi bi-pencil' : 'bi bi-plus-lg' }}"></i>
                    <p>{{ $kepalaSekolahEdit ? 'Edit Data' : 'Tambah Data' }}</p>
                </div>

                @if ($kepalaSekolahEdit)
                    <form action="{{ route('kepala-sekolah.update', $kepalaSekolahEdit->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                    @else
                        <form action="{{ route('kepala-sekolah.store') }}" method="POST">
                            @csrf
                @endif
                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Nama Lengkap</x-label>
                    <x-input name="nama_lengkap" type="text" tabindex="1"
                        value="{{ old('nama_lengkap', $kepalaSekolahEdit->nama_lengkap ?? '') }}"
                        class="{{ $errors->first('nama_lengkap') ? 'border-red-400' : '' }} capitalize-input"
                        placeholder="Masukkan nama lengkap..." />
                    <x-message>{{ $errors->first('nama_lengkap') }}</x-message>
                </div>
                <div class="my-2">
                    <x-label>NIP</x-label>
                    <x-input name="nip" type="text" tabindex="2"
                        value="{{ old('nip', $kepalaSekolahEdit->nip ?? '') }}"
                        class="{{ $errors->first('nip') ? 'border-red-400' : '' }}"
                        placeholder="Masukkan NIP..." />
                    <x-message>{{ $errors->first('nip') }}</x-message>
                </div>
                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Status</x-label>
                    <select name="status" tabindex="3"
                        class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 w-full {{ $errors->first('status') ? 'border-red-400' : '' }}">
                        <option value="">-- Pilih Status --</option>
                        <option value="Aktif" {{ old('status', $kepalaSekolahEdit->status ?? '') == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                        <option value="Non-Aktif" {{ old('status', $kepalaSekolahEdit->status ?? '') == 'Non-Aktif' ? 'selected' : '' }}>Non-Aktif</option>
                    </select>
                    <x-message>{{ $errors->first('status') }}</x-message>
                </div>
                <div class="flex justify-end gap-2">
                    @if ($kepalaSekolahEdit)
                        <a href="{{ route('kepala-sekolah.index') }}"
                            class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                            <i class="fa-solid fa-times"></i> Batal
                        </a>
                    @else
                        <div></div>
                    @endif
                    <x-btn-save tabindex="4">
                        <div class="flex items-center gap-1 font-medium">
                            <i class="fa-solid fa-floppy-disk"></i>
                            <p>{{ $kepalaSekolahEdit ? 'Update' : 'Simpan' }}</p>
                        </div>
                    </x-btn-save>
                </div>
                </form>
            </div>

            {{-- Detail Data --}}
            <div
                class="md:w-[65%] w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary mt-5 md:mt-0 max-h-[75vh] overflow-y-auto minimal-scroll">
                <form action="#" method="GET" class="inline mt-4">
                    <div class="md:flex justify-between items-center">
                        <div class="flex items-center gap-2">
                            <select name="per_page" id="per_page" onchange="this.form.submit()"
                                class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50">
                                <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20</option>
                                <option value="30" {{ request('per_page') == 30 ? 'selected' : '' }}>30</option>
                                <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                        </div>
                        <div class="flex items-center gap-2 mt-3 md:mt-0">
                            <div class="relative inline-block w-full">
                                <x-search-i></x-search-i>
                                <x-search placeholder="Pencarian..." name="search"
                                    class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                    value="{{ request('search') }}" />
                            </div>
                        </div>
                    </div>
                </form>
                <div class="mb-2 mt-3">
                    <div class="overflow-x-auto">
                        <x-table>
                            <x-thead>
                                <tr>
                                    <x-th class="whitespace-nowrap w-14">No.</x-th>
                                    <x-th class="whitespace-nowrap">Nama Lengkap</x-th>
                                    <x-th class="whitespace-nowrap">NIP</x-th>
                                    <x-th class="whitespace-nowrap">Status</x-th>
                                    <x-th class="whitespace-nowrap w-32">Aksi</x-th>
                                </tr>
                            </x-thead>
                            <tbody>
                                @forelse ($dataKepalaSekolah as $data)
                                    <x-tr>
                                        <x-td class="text-center">
                                            {{ $loop->iteration + $i }}.
                                        </x-td>
                                        <x-td>{{ ucwords(strtolower($data->nama_lengkap)) }}</x-td>
                                        <x-td class="text-center">{{ $data->nip ?? '-' }}</x-td>
                                        <x-td class="text-center">
                                            @if($data->status == 'Aktif')
                                                <span class="bg-green-500 text-white px-7 py-1 rounded-full">Aktif</span>
                                            @else
                                                <span class="bg-red-500 text-white px-3 py-1 rounded-full">Non-Aktif</span>
                                            @endif
                                        </x-td>
                                        <x-td class="text-center whitespace-nowrap">
                                            {{-- Btn Edit --}}
                                            <a href="{{ route('kepala-sekolah.edit', $data->id) }}">
                                                <x-btn-edit></x-btn-edit>
                                            </a>
                                            {{-- Btn Delete --}}
                                            <x-btn-delete type="button"></x-btn-delete>
                                        </x-td>
                                    </x-tr>
                                @empty
                                    <x-tr>
                                        <x-td colspan="5" class="text-center text-red-600">Data kepala sekolah tidak
                                            ada!</x-td>
                                    </x-tr>
                                @endforelse
                            </tbody>
                        </x-table>
                        {{-- Pagination --}}
                        <div class="flex justify-between items-center mt-3">
                            <span id="dataInfo" class="text-xs text-dark dark:text-light">
                                Menampilkan <span class="font-semibold">{{ $dataKepalaSekolah->firstItem() ?? 0 }}</span>
                                sampai <span class="font-semibold">{{ $dataKepalaSekolah->lastItem() ?? 0 }}</span>
                                dari <span class="font-semibold">{{ $dataKepalaSekolah->total() }}</span>
                                data
                            </span>
                            <div id="paginationLinks" class="inline-flex mt-2 xs:mt-0">
                                {{ $dataKepalaSekolah->links('vendor.pagination.costum') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Function to convert text to title case
                function toTitleCase(str) {
                    return str.replace(/\w\S*/g, function(txt) {
                        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
                    });
                }

                // Apply title case to all inputs with capitalize-input class
                const capitalizeInputs = document.querySelectorAll('.capitalize-input');

                capitalizeInputs.forEach(function(input) {
                    // Transform existing value to title case on page load
                    if (input.value) {
                        input.value = toTitleCase(input.value);
                    }

                    // Transform input on change/input events
                    input.addEventListener('input', function() {
                        this.value = toTitleCase(this.value);
                    });

                    // Also transform on blur to ensure consistency
                    input.addEventListener('blur', function() {
                        this.value = toTitleCase(this.value);
                    });
                });
            });
        </script>
    @endpush

</x-app-layout>
