<title>Data Kelas</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" style="margin-bottom: 100px;" id="sectionDashboard">
        <div class="mb-4">
            <h1>
                <div class="flex gap-2">
                    <i class="fa-solid fa-border-all text-3xl mt-1 font-bold"></i>
                    <div>
                        <p class="text-xl sm:text-2xl font-bold">Data Kelas</p>
                        <p class="text-xs sm:text-sm ms-[1px] -mt-1">Index</p>
                    </div>
                </div>
            </h1>
        </div>

        <div class="md:flex md:items-start md:gap-4">
            {{-- Add Data (Hidden on mobile) --}}
            <div
                class="md:w-[40%] w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary hidden md:block">
                <div class="flex items-center gap-1 font-semibold">
                    <i class="{{ $kelasEdit ? 'bi bi-pencil' : 'bi bi-plus-lg' }}"></i>
                    <p>{{ $kelasEdit ? 'Edit Data' : 'Tambah Data' }}</p>
                </div>

                @if ($kelasEdit)
                    <form action="{{ route('kelas.update', $kelasEdit->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                    @else
                        <form action="{{ route('kelas.store') }}" method="POST">
                            @csrf
                @endif
                <div class="my-2">
                    <div class="flex gap-2">
                        <div class="w-full">
                            <x-label><span class="text-red-500">*</span>Nama Kelas (Angka)</x-label>
                            <x-input name="nama_kelas_nomor" id="nama_kelas_nomor" type="number" tabindex="1"
                                value="{{ old('nama_kelas_nomor', $kelasEdit->nama_kelas_nomor ?? '') }}"
                                class="{{ $errors->first('nama_kelas_nomor') ? 'border-red-400' : '' }}"
                                placeholder="Contoh: 7" />
                        </div>
                        <div class="w-full">
                            <x-label>Sub Kelas (Opsional)</x-label>
                            <x-input name="nama_kelas_sub" type="text" tabindex="2"
                                value="{{ old('nama_kelas_sub', $kelasEdit->nama_kelas_sub ?? '') }}"
                                class="{{ $errors->first('nama_kelas_sub') ? 'border-red-400' : '' }}"
                                placeholder="Contoh: A" oninput="this.value = this.value.toUpperCase()" />
                        </div>
                    </div>
                    <x-message class="basis-full">{{ $errors->first('nama_kelas_nomor') }}</x-message>
                </div>
                <div class="my-2">
                    <x-label><span class="text-red-500">*</span>Nama Kelas (Romawi)</x-label>
                    <x-input name="nama_kelas_romawi" id="nama_kelas_romawi" type="text" readonly
                        value="{{ old('nama_kelas_romawi', $kelasEdit->nama_kelas_romawi ?? '') }}"
                        class="bg-gray-400 dark:bg-gray-900 {{ $errors->first('nama_kelas_romawi') ? 'border-red-400' : '' }}"
                        placeholder="Input Nama Kelas Angka" />
                    <x-message>{{ $errors->first('nama_kelas_romawi') }}</x-message>
                </div>
                <div class="flex justify-end gap-2">
                    @if ($kelasEdit)
                        <a href="{{ route('kelas.index') }}"
                            class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                            <i class="fa-solid fa-times"></i> Batal
                        </a>
                    @else
                        <div></div>
                    @endif
                    <x-btn-save tabindex="3">
                        <div class="flex items-center gap-1 font-medium">
                            <i class="fa-solid fa-floppy-disk"></i>
                            <p>{{ $kelasEdit ? 'Update' : 'Simpan' }}</p>
                        </div>
                    </x-btn-save>
                </div>
                </form>
            </div>

            {{-- Detail Data --}}
            <div
                class="md:w-[60%] w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary mt-5 md:mt-0 md:max-h-[75vh] md:overflow-y-auto md:minimal-scroll">
                <form action="#" method="GET" class="inline mt-4">
                    <div class="flex justify-between items-center">
                        <div class="flex items-center gap-2">
                            <select name="per_page" id="per_page" onchange="this.form.submit()"
                                class="border border-gray-400 transition rounded-lg py-2 px-5 text-sm bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50">
                                <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20</option>
                                <option value="30" {{ request('per_page') == 30 ? 'selected' : '' }}>30</option>
                                <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                        </div>
                        <div class="flex items-center gap-1">
                            <div class="relative inline-block w-full">
                                <x-search-i></x-search-i>
                                <x-search placeholder="Pencarian..." name="search"
                                    class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50"
                                    value="{{ request('search') }}" />
                            </div>
                        </div>
                    </div>
                </form>
                <div class="mb-2 mt-3">
                    <div class="overflow-x-auto pb-3">
                        <x-table>
                            <x-thead>
                                <tr>
                                    <x-th class="whitespace-nowrap w-14">No.</x-th>
                                    <x-th class="whitespace-nowrap ">Kelas</x-th>
                                    <x-th class="whitespace-nowrap w-32">Aksi</x-th>
                                </tr>
                            </x-thead>
                            <tbody>
                                @forelse ($dataKelas as $data)
                                    <x-tr>
                                        <x-td class="text-center">
                                            {{ $loop->iteration + $i }}.
                                        </x-td>
                                        <x-td class="text-center">{{ $data->nama_kelas_romawi }}
                                            {{ $data->nama_kelas_sub ?? '' }} -
                                            ({{ $data->nama_kelas_nomor }}{{ $data->nama_kelas_sub ?? '' }})
                                        </x-td>
                                        <x-td class="text-center whitespace-nowrap">
                                            {{-- Btn Edit for Desktop --}}
                                            <a href="{{ route('kelas.edit', $data->id) }}" class="hidden md:inline-block">
                                                <x-btn-edit></x-btn-edit>
                                            </a>
                                            {{-- Btn Edit for Mobile (Modal) --}}
                                            <button type="button" onclick="openEditModal({{ $data->id }}, '{{ $data->nama_kelas_nomor }}', '{{ $data->nama_kelas_sub }}', '{{ $data->nama_kelas_romawi }}')" 
                                                class="md:hidden inline-block py-2 px-4 rounded-md bg-yellow-400 text-dark hover:bg-yellow-300 transition">
                                                <i class="fa-solid fa-pen-to-square"></i>
                                            </button>
                                            {{-- Btn Delete --}}
                                            <x-btn-delete type="button" onclick="handleDelete({{ $data->id }}, '{{ $data->nama_kelas_romawi }}{{ $data->nama_kelas_sub ?? '' }}')"></x-btn-delete>
                                        </x-td>
                                    </x-tr>
                                @empty
                                    <x-tr>
                                        <x-td colspan="4" class="text-center text-red-600">Data kelas tidak
                                            ada!</x-td>
                                    </x-tr>
                                @endforelse
                            </tbody>
                        </x-table>
                        {{-- Pagination --}}
                        <div class="flex justify-between items-center mt-3">
                            <span id="dataInfo" class="text-xs text-dark dark:text-light">
                                Menampilkan <span class="font-semibold">{{ $dataKelas->firstItem() ?? 0 }}</span>
                                sampai <span class="font-semibold">{{ $dataKelas->lastItem() ?? 0 }}</span>
                                dari <span class="font-semibold">{{ $dataKelas->total() }}</span>
                                data
                            </span>
                            <div id="paginationLinks" class="inline-flex mt-2 xs:mt-0">
                                {{ $dataKelas->links('vendor.pagination.costum') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Floating Action Button for Mobile -->
        <div class="fixed bottom-6 right-6 z-50 md:hidden">
            <button type="button" onclick="openTambahModal()"
                class="w-14 h-14 rounded-full bg-primary text-white flex items-center justify-center shadow-lg hover:bg-primary-dark transition-colors duration-200">
                <i class="fa-solid fa-plus text-2xl"></i>
            </button>
        </div>
    </section>


    <!-- Modal for Mobile (Tambah) -->
    <div id="tambahModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md max-h-[90vh] overflow-y-auto">
            <div class="p-5">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold">Tambah Data Kelas</h3>
                    <button type="button" onclick="closeTambahModal()" class="text-gray-500 hover:text-gray-700">
                        <i class="fa-solid fa-times text-xl"></i>
                    </button>
                </div>
                <div class="mt-2">
                    <form id="mobileKelasForm" action="{{ route('kelas.store') }}" method="POST">
                        @csrf
                        <div class="my-3">
                            <div class="flex gap-2">
                                <div class="w-full">
                                    <x-label><span class="text-red-500">*</span>Nama Kelas (Angka)</x-label>
                                    <x-input name="nama_kelas_nomor" id="modal_nama_kelas_nomor" type="number"
                                        required
                                        class="w-full {{ $errors->first('nama_kelas_nomor') ? 'border-red-400' : '' }}"
                                        placeholder="Contoh: 7" />
                                </div>
                                <div class="w-full">
                                    <x-label>Sub Kelas (Opsional)</x-label>
                                    <x-input name="nama_kelas_sub" id="modal_nama_kelas_sub" type="text"
                                        class="w-full {{ $errors->first('nama_kelas_sub') ? 'border-red-400' : '' }}"
                                        placeholder="Contoh: A" oninput="this.value = this.value.toUpperCase()" />
                                </div>
                            </div>
                            <x-message class="basis-full">{{ $errors->first('nama_kelas_nomor') }}</x-message>
                        </div>
                        <div class="my-3">
                            <x-label><span class="text-red-500">*</span>Nama Kelas (Romawi)</x-label>
                            <x-input name="nama_kelas_romawi" id="modal_nama_kelas_romawi" type="text" readonly
                                class="w-full bg-gray-400 dark:bg-gray-900 {{ $errors->first('nama_kelas_romawi') ? 'border-red-400' : '' }}"
                                placeholder="Input Nama Kelas Angka" />
                            <x-message>{{ $errors->first('nama_kelas_romawi') }}</x-message>
                        </div>
                        <div class="flex justify-end gap-2 mt-4">
                            <button type="button" onclick="closeTambahModal()"
                                class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg text-sm">
                                Batal
                            </button>
                            <button type="submit"
                                class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-lg text-sm flex items-center gap-1">
                                <i class="fa-solid fa-floppy-disk"></i>
                                <span>Simpan</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for Mobile (Edit) -->
    <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md max-h-[90vh] overflow-y-auto">
            <div class="p-5">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold">Edit Data Kelas</h3>
                    <button type="button" onclick="closeEditModal()" class="text-gray-500 hover:text-gray-700">
                        <i class="fa-solid fa-times text-xl"></i>
                    </button>
                </div>
                <div class="mt-2">
                    <form id="mobileKelasEditForm" action="" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="my-3">
                            <div class="flex gap-2">
                                <div class="w-full">
                                    <x-label><span class="text-red-500">*</span>Nama Kelas (Angka)</x-label>
                                    <x-input name="nama_kelas_nomor" id="edit_modal_nama_kelas_nomor" type="number"
                                        required
                                        class="w-full {{ $errors->first('nama_kelas_nomor') ? 'border-red-400' : '' }}"
                                        placeholder="Contoh: 7" />
                                </div>
                                <div class="w-full">
                                    <x-label>Sub Kelas (Opsional)</x-label>
                                    <x-input name="nama_kelas_sub" id="edit_modal_nama_kelas_sub" type="text"
                                        class="w-full {{ $errors->first('nama_kelas_sub') ? 'border-red-400' : '' }}"
                                        placeholder="Contoh: A" oninput="this.value = this.value.toUpperCase()" />
                                </div>
                            </div>
                            <x-message class="basis-full">{{ $errors->first('nama_kelas_nomor') }}</x-message>
                        </div>
                        <div class="my-3">
                            <x-label><span class="text-red-500">*</span>Nama Kelas (Romawi)</x-label>
                            <x-input name="nama_kelas_romawi" id="edit_modal_nama_kelas_romawi" type="text" readonly
                                class="w-full bg-gray-400 dark:bg-gray-900 {{ $errors->first('nama_kelas_romawi') ? 'border-red-400' : '' }}"
                                placeholder="Input Nama Kelas Angka" />
                            <x-message>{{ $errors->first('nama_kelas_romawi') }}</x-message>
                        </div>
                        <div class="flex justify-end gap-2 mt-4">
                            <button type="button" onclick="closeEditModal()"
                                class="bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg text-sm">
                                Batal
                            </button>
                            <button type="submit"
                                class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-lg text-sm flex items-center gap-1">
                                <i class="fa-solid fa-floppy-disk"></i>
                                <span>Update</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Validasi (Data Sudah Digunakan) -->
    <div id="validasiModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md p-6">
            <div class="text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                    <i class="fa-solid fa-exclamation-triangle text-red-600 text-2xl"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2 text-gray-900 dark:text-gray-50">Data Tidak Dapat Dihapus</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
                    Data kelas <span id="validasiNamaKelas" class="font-semibold"></span> sudah digunakan pada data siswa atau buku raport dan tidak dapat dihapus.
                </p>
                <button type="button" onclick="closeValidasiModal()"
                    class="w-full bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-lg text-sm">
                    Tutup
                </button>
            </div>
        </div>
    </div>

    <!-- Modal Konfirmasi Delete -->
    <div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white dark:bg-gray-800 rounded-lg w-full max-w-md p-6">
            <div class="text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-yellow-100 mb-4">
                    <i class="fa-solid fa-question-circle text-yellow-600 text-2xl"></i>
                </div>
                <h3 class="text-lg font-semibold mb-2 text-gray-900 dark:text-gray-50">Konfirmasi Hapus</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">
                    Apakah Anda yakin ingin menghapus data kelas <span id="deleteNamaKelas" class="font-semibold"></span>?
                </p>
                <form id="deleteForm" method="POST" action="">
                    @csrf
                    @method('DELETE')
                    <div class="flex gap-3">
                        <button type="button" onclick="closeDeleteModal()"
                            class="flex-1 bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded-lg text-sm">
                            Batal
                        </button>
                        <button type="submit"
                            class="flex-1 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg text-sm">
                            Hapus
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('js')
        <script>
            // Handle Delete Button Click
            async function handleDelete(id, namaKelas) {
                try {
                    // Check if kelas is being used
                    const response = await fetch(`/kelas/${id}/check-usage`);
                    const data = await response.json();

                    if (data.used) {
                        // Show validation modal if data is being used
                        document.getElementById('validasiNamaKelas').textContent = data.nama_kelas;
                        openValidasiModal();
                    } else {
                        // Show delete confirmation modal if data is not being used
                        document.getElementById('deleteNamaKelas').textContent = namaKelas;
                        document.getElementById('deleteForm').action = `/kelas/${id}`;
                        openDeleteModal();
                    }
                } catch (error) {
                    console.error('Error checking usage:', error);
                    alert('Terjadi kesalahan saat memeriksa data. Silakan coba lagi.');
                }
            }

            // Modal functions for Validasi
            function openValidasiModal() {
                document.getElementById('validasiModal').classList.remove('hidden');
                document.getElementById('validasiModal').classList.add('flex');
                document.body.style.overflow = 'hidden';
            }

            function closeValidasiModal() {
                document.getElementById('validasiModal').classList.add('hidden');
                document.getElementById('validasiModal').classList.remove('flex');
                document.body.style.overflow = 'auto';
            }

            // Modal functions for Delete
            function openDeleteModal() {
                document.getElementById('deleteModal').classList.remove('hidden');
                document.getElementById('deleteModal').classList.add('flex');
                document.body.style.overflow = 'hidden';
            }

            function closeDeleteModal() {
                document.getElementById('deleteModal').classList.add('hidden');
                document.getElementById('deleteModal').classList.remove('flex');
                document.body.style.overflow = 'auto';
            }

            document.getElementById('nama_kelas_nomor').addEventListener('input', function() {
                const number = parseInt(this.value);
                const romawiInput = document.getElementById('nama_kelas_romawi');
                romawiInput.value = number ? toRoman(number) : '';
            });

            function toRoman(num) {
                if (isNaN(num)) return '';
                const roman = {
                    M: 1000,
                    CM: 900,
                    D: 500,
                    CD: 400,
                    C: 100,
                    XC: 90,
                    L: 50,
                    XL: 40,
                    X: 10,
                    IX: 9,
                    V: 5,
                    IV: 4,
                    I: 1
                };
                let str = '';
                for (let i in roman) {
                    while (num >= roman[i]) {
                        str += i;
                        num -= roman[i];
                    }
                }
                return str;
            }

            // Modal functions for Tambah
            function openTambahModal() {
                document.getElementById('tambahModal').classList.remove('hidden');
                document.getElementById('tambahModal').classList.add('flex');
                document.body.style.overflow = 'hidden';
            }

            function closeTambahModal() {
                document.getElementById('tambahModal').classList.add('hidden');
                document.getElementById('tambahModal').classList.remove('flex');
                document.body.style.overflow = 'auto';
                // Reset form when closing
                document.getElementById('mobileKelasForm').reset();
                document.getElementById('modal_nama_kelas_romawi').value = '';
            }

            // Modal functions for Edit
            function openEditModal(id, namaKelasNomor, namaKelasSub, namaKelasRomawi) {
                document.getElementById('editModal').classList.remove('hidden');
                document.getElementById('editModal').classList.add('flex');
                document.body.style.overflow = 'hidden';
                
                // Populate form with data
                document.getElementById('edit_modal_nama_kelas_nomor').value = namaKelasNomor;
                document.getElementById('edit_modal_nama_kelas_sub').value = namaKelasSub || '';
                document.getElementById('edit_modal_nama_kelas_romawi').value = namaKelasRomawi;
                
                // Update form action
                const form = document.getElementById('mobileKelasEditForm');
                form.action = `/kelas/${id}`;
            }

            function closeEditModal() {
                document.getElementById('editModal').classList.add('hidden');
                document.getElementById('editModal').classList.remove('flex');
                document.body.style.overflow = 'auto';
                // Reset form when closing
                document.getElementById('mobileKelasEditForm').reset();
            }

            // Close modal when clicking outside the modal content
            document.addEventListener('DOMContentLoaded', function() {
                // Roman numeral conversion for modal tambah
                document.getElementById('modal_nama_kelas_nomor').addEventListener('input', function() {
                    const number = parseInt(this.value);
                    const romawiInput = document.getElementById('modal_nama_kelas_romawi');
                    romawiInput.value = number ? toRoman(number) : '';
                });

                // Roman numeral conversion for modal edit
                document.getElementById('edit_modal_nama_kelas_nomor').addEventListener('input', function() {
                    const number = parseInt(this.value);
                    const romawiInput = document.getElementById('edit_modal_nama_kelas_romawi');
                    romawiInput.value = number ? toRoman(number) : '';
                });

                // Close modal when clicking outside
                const tambahModal = document.getElementById('tambahModal');
                if (tambahModal) {
                    tambahModal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            closeTambahModal();
                        }
                    });
                }

                const editModal = document.getElementById('editModal');
                if (editModal) {
                    editModal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            closeEditModal();
                        }
                    });
                }

                const validasiModal = document.getElementById('validasiModal');
                if (validasiModal) {
                    validasiModal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            closeValidasiModal();
                        }
                    });
                }

                const deleteModal = document.getElementById('deleteModal');
                if (deleteModal) {
                    deleteModal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            closeDeleteModal();
                        }
                    });
                }
            });
        </script>
    @endpush

</x-app-layout>
