<title>Dashboard</title>
<x-app-layout>
    <style>
        .custom-scrollbar {
            scrollbar-width: thin;
            scrollbar-color: rgba(0, 0, 0, 0.4) transparent;
        }

        .custom-scrollbar::-webkit-scrollbar {
            height: 6px;
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: transparent;
            border-radius: 9999px;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: rgba(0, 0, 0, 0.4);
            border-radius: 9999px;
        }

        .dark .custom-scrollbar {
            scrollbar-color: rgba(255, 255, 255, 0.5) transparent;
        }

        .dark .custom-scrollbar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.5);
        }

        .dark .custom-scrollbar::-webkit-scrollbar-track {
            background: transparent;
        }
    </style>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="mb-5">
            <div class="flex justify-between items-center gap-4">
                <h1 class="text-2xl font-bold">
                    <i class="fa-solid fa-house"></i> Dashboard
                </h1>
                <span class="font-semibold">{{ $selectedTahunAjaran }}</span>
                {{-- Filter Tahun Ajaran --}}
                {{-- <div class="flex items-center gap-2">
                    <form id="tahunAjaranForm" action="{{ route('dashboard') }}" method="GET" class="flex gap-2 items-center">
                        <x-label class="whitespace-nowrap font-semibold text-xs">Tahun Ajaran</x-label>
                        @php
                            $tahunSekarang = date('Y');
                            $jumlahTahun = 6;
                            $selectedTahunAjaran = $selectedTahunAjaran ?? $tahunSekarang . '/' . ($tahunSekarang + 1);
                        @endphp

                        <x-select name="tahun_ajaran" class="text-xs">
                            @for ($i = 0; $i < $jumlahTahun; $i++)
                                @php
                                    $tahunAwal = $tahunSekarang - $i;
                                    $tahunAkhir = $tahunAwal + 1;
                                    $value = $tahunAwal . '/' . $tahunAkhir;
                                @endphp
                                <option value="{{ $value }}" {{ $value === $selectedTahunAjaran ? 'selected' : '' }}>
                                    {{ $value }}
                                </option>
                            @endfor
                        </x-select>
                    </form>
                </div> --}}
            </div>
        </div>
        <div class="border border-gray-400 mb-5 border-dashed"></div>

        {{-- Card 1: Total Siswa Aktif Per Kelas --}}
        <div class="md:flex justify-between gap-2 items-center mb-2">
            <h2 class="text-xl font-bold text-gray-800 dark:text-gray-100">
                <i class="fa-solid fa-users"></i> Total Siswa Aktif Per Kelas
            </h2>
            <div class="mt-1 md:mt-0">
                <span class="text-lg font-semibold text-gray-700 dark:text-gray-300">Total Keseluruhan:</span>
                <span class="text-lg font-bold text-hvPrimary">
                    {{ $siswaPerKelas->sum('total') }} Siswa
                </span>
            </div>
            {{-- <p class="text-sm text-gray-600 dark:text-gray-400 mt-2 md:mt-0">
                Tahun Ajaran: <span class="font-semibold">{{ $selectedTahunAjaran }}</span>
            </p> --}}
        </div>

        {{-- Card Siswa --}}
        @if ($siswaPerKelas->isNotEmpty())
            <div class="flex gap-4 overflow-x-auto pb-2 custom-scrollbar">
                @foreach ($siswaPerKelas as $data)
                    <div
                        class="bg-gray-50 dark:bg-gray-800 rounded-lg p-4 shadow shadow-gray-300 dark:shadow-gray-700 border-t-2 border-primary flex-shrink-0 w-52">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-600 dark:text-gray-300 font-medium">Kelas</p>
                                <p class="text-2xl font-bold text-emerald-700 dark:text-emerald-200">
                                    {{ $data['kelas_display'] }}</p>
                            </div>
                            <div class="text-right">
                                <p class="text-3xl font-bold text-emerald-600 dark:text-emerald-300">
                                    {{ $data['total'] }}</p>
                                <p class="text-xs text-gray-600 dark:text-gray-400">Siswa</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            {{-- Total Keseluruhan --}}
            {{-- <div class="mt-3">
                <div class="flex justify-between md:justify-start gap-3 items-center">
                    <span class="text-lg font-semibold text-gray-700 dark:text-gray-300">Total Keseluruhan:</span>
                    <span class="text-lg font-bold text-hvPrimary">
                        {{ $siswaPerKelas->sum('total') }} Siswa
                    </span>
                </div>
            </div> --}}
        @else
            <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                <i class="fa-solid fa-inbox text-4xl mb-2"></i>
                <p>Tidak ada data siswa aktif pada tahun ajaran ini</p>
            </div>
        @endif

        {{-- Card 3: Ranking Siswa Per Kelas --}}
        <div class="mt-8 mb-2">
            <h2 class="text-xl font-bold text-gray-800 dark:text-gray-100">
                <i class="fa-solid fa-trophy"></i> Ranking Siswa Per Kelas
            </h2>
        </div>

        @if ($rankingPerKelas->isNotEmpty())
            @foreach ($rankingPerKelas as $kelasRanking)
                <div
                    class="bg-gray-50 dark:bg-gray-800 rounded-lg p-5 shadow shadow-gray-300 dark:shadow-gray-700 border-t-4 border-primary mb-5">
                    <h3 class="text-lg font-bold text-emerald-700 dark:text-emerald-200">
                        Kelas {{ $kelasRanking['kelas_display'] }}
                    </h3>
                    <div class="my-3 border border-gray-400 border-dashed"></div>

                    {{-- Grid 2 Kolom: Ganjil & Genap --}}
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                        {{-- Semester Ganjil --}}
                        <div>
                            <h4 class="font-bold text-primary dark:text-hvPrimary mb-1 text-center">Semester Ganjil
                            </h4>
                            <div class="overflow-x-auto">
                                <x-table>
                                    <x-thead>
                                        <tr>
                                            <x-th class="w-12 text-center">Rank</x-th>
                                            {{-- <x-th class="w-20">NIS</x-th> --}}
                                            <x-th>Nama Siswa</x-th>
                                            <x-th class="w-24 text-center">Nilai</x-th>
                                        </tr>
                                    </x-thead>
                                    <tbody>
                                        @forelse ($kelasRanking['ranking_ganjil'] as $student)
                                            <x-tr>
                                                <x-td class="text-center">
                                                    @if ($student['has_raport'])
                                                        <span
                                                            class="inline-flex items-center justify-center w-7 h-7 rounded-full font-bold text-xs
                                                            {{ $student['rank'] == 1 ? 'bg-yellow-400 text-yellow-900' : ($student['rank'] == 2 ? 'bg-gray-300 text-gray-900' : ($student['rank'] == 3 ? 'bg-orange-400 text-orange-900' : 'bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-300')) }}">
                                                            {{ $student['rank'] }}
                                                        </span>
                                                    @else
                                                        <span class="text-gray-400 dark:text-gray-500 text-xs">-</span>
                                                    @endif
                                                </x-td>
                                                {{-- <x-td class="text-xs">{{ $student['nis'] }}</x-td> --}}
                                                <x-td class="text-xs">{{ $student['nama'] }}</x-td>
                                                <x-td class="text-center">
                                                    @if ($student['has_raport'])
                                                        <span
                                                            class="font-bold text-emerald-700 dark:text-emerald-200 text-xs">
                                                            {{ number_format($student['jml_nilai_akhir']) }}
                                                        </span>
                                                    @else
                                                        <span class="text-red-500 text-xs italic">Belum</span>
                                                    @endif
                                                </x-td>
                                            </x-tr>
                                        @empty
                                            <x-tr>
                                                <x-td colspan="4" class="text-center text-gray-500 text-xs">Tidak
                                                    ada data</x-td>
                                            </x-tr>
                                        @endforelse
                                    </tbody>
                                </x-table>
                            </div>
                        </div>

                        {{-- Semester Genap --}}
                        <div>
                            <h4 class="font-bold text-primary dark:text-hvPrimary mb-1 text-center">Semester Genap</h4>
                            <div class="overflow-x-auto">
                                <x-table>
                                    <x-thead>
                                        <tr>
                                            <x-th class="w-12 text-center">Rank</x-th>
                                            {{-- <x-th class="w-20">NIS</x-th> --}}
                                            <x-th>Nama Siswa</x-th>
                                            <x-th class="w-24 text-center">Nilai</x-th>
                                        </tr>
                                    </x-thead>
                                    <tbody>
                                        @forelse ($kelasRanking['ranking_genap'] as $student)
                                            <x-tr>
                                                <x-td class="text-center">
                                                    @if ($student['has_raport'])
                                                        <span
                                                            class="inline-flex items-center justify-center w-7 h-7 rounded-full font-bold text-xs
                                                            {{ $student['rank'] == 1 ? 'bg-yellow-400 text-yellow-900' : ($student['rank'] == 2 ? 'bg-gray-300 text-gray-900' : ($student['rank'] == 3 ? 'bg-orange-400 text-orange-900' : 'bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-300')) }}">
                                                            {{ $student['rank'] }}
                                                        </span>
                                                    @else
                                                        <span class="text-gray-400 dark:text-gray-500 text-xs">-</span>
                                                    @endif
                                                </x-td>
                                                {{-- <x-td class="text-xs">{{ $student['nis'] }}</x-td> --}}
                                                <x-td class="text-xs">{{ $student['nama'] }}</x-td>
                                                <x-td class="text-center">
                                                    @if ($student['has_raport'])
                                                        <span
                                                            class="font-bold text-emerald-700 dark:text-emerald-200 text-xs">
                                                            {{ number_format($student['jml_nilai_akhir']) }}
                                                        </span>
                                                    @else
                                                        <span class="text-red-500 text-xs italic">Belum</span>
                                                    @endif
                                                </x-td>
                                            </x-tr>
                                        @empty
                                            <x-tr>
                                                <x-td colspan="4" class="text-center text-gray-500 text-xs">Tidak
                                                    ada data</x-td>
                                            </x-tr>
                                        @endforelse
                                    </tbody>
                                </x-table>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @else
            <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                <i class="fa-solid fa-inbox text-4xl mb-2"></i>
                <p>Tidak ada data ranking siswa per kelas</p>
            </div>
        @endif

        @can('Admin')
            {{-- Card 4: Ranking Umum --}}
            <div class="mt-8 mb-2">
                <h2 class="text-xl font-bold text-gray-800 dark:text-gray-100 mb-4">
                    <i class="fa-solid fa-crown"></i> Ranking Umum (Top 5)
                </h2>
            </div>

            @if ($rankingUmumGanjil->isNotEmpty() || $rankingUmumGenap->isNotEmpty())
                <div
                    class="bg-gray-50 dark:bg-gray-800 rounded-lg p-5 shadow shadow-gray-300 dark:shadow-gray-700 border-t-4 border-primary">
                    {{-- Grid 2 Kolom: Ganjil & Genap --}}
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                        {{-- Semester Ganjil --}}
                        <div>
                            <h4 class="font-bold text-primary dark:text-hvPrimary mb-3 text-center">Semester Ganjil</h4>
                            @if ($rankingUmumGanjil->isNotEmpty())
                                <div class="space-y-3">
                                    @foreach ($rankingUmumGanjil as $student)
                                        <div
                                            class="flex items-center justify-between p-3 bg-gray-100 dark:bg-gray-700 rounded-lg">
                                            <div class="flex items-center gap-3">
                                                <span
                                                    class="flex items-center justify-center w-9 h-9 rounded-full 
                                                {{ $student['rank'] == 1 ? 'bg-yellow-400 text-yellow-900' : ($student['rank'] == 2 ? 'bg-gray-300 text-gray-900' : ($student['rank'] == 3 ? 'bg-orange-400 text-orange-900' : 'bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-300')) }} 
                                                font-bold text-base">
                                                    {{ $student['rank'] }}
                                                </span>
                                                <div>
                                                    <p class="font-bold text-sm text-gray-900 dark:text-gray-100">
                                                        {{ $student['nama'] }}</p>
                                                    <p class="text-xs text-gray-600 dark:text-gray-400">
                                                        {{ $student['kelas_display'] }}</p>
                                                </div>
                                            </div>
                                            <div class="text-right">
                                                <p class="font-bold text-base text-emerald-700 dark:text-emerald-200">
                                                    {{ number_format($student['jml_nilai_akhir']) }}</p>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                                    <i class="fa-solid fa-inbox text-2xl mb-2"></i>
                                    <p class="text-sm">Tidak ada data</p>
                                </div>
                            @endif
                        </div>

                        {{-- Semester Genap --}}
                        <div>
                            <h4 class="font-bold text-primary dark:text-hvPrimary mb-3 text-center">Semester Genap</h4>
                            @if ($rankingUmumGenap->isNotEmpty())
                                <div class="space-y-3">
                                    @foreach ($rankingUmumGenap as $student)
                                        <div
                                            class="flex items-center justify-between p-3 bg-gray-100 dark:bg-gray-700 rounded-lg">
                                            <div class="flex items-center gap-3">
                                                <span
                                                    class="flex items-center justify-center w-9 h-9 rounded-full 
                                                {{ $student['rank'] == 1 ? 'bg-yellow-400 text-yellow-900' : ($student['rank'] == 2 ? 'bg-gray-300 text-gray-900' : ($student['rank'] == 3 ? 'bg-orange-400 text-orange-900' : 'bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-300')) }} 
                                                font-bold text-base">
                                                    {{ $student['rank'] }}
                                                </span>
                                                <div>
                                                    <p class="font-bold text-sm text-gray-900 dark:text-gray-100">
                                                        {{ $student['nama'] }}</p>
                                                    <p class="text-xs text-gray-600 dark:text-gray-400">
                                                        {{ $student['kelas_display'] }}</p>
                                                </div>
                                            </div>
                                            <div class="text-right">
                                                <p class="font-bold text-base text-emerald-700 dark:text-emerald-200">
                                                    {{ number_format($student['jml_nilai_akhir']) }}</p>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                                    <i class="fa-solid fa-inbox text-2xl mb-2"></i>
                                    <p class="text-sm">Tidak ada data</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                    <i class="fa-solid fa-inbox text-4xl mb-2"></i>
                    <p>Tidak ada data ranking umum</p>
                </div>
            @endif
        @endcan

    </section>

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const tahunAjaranSelect = document.querySelector('select[name="tahun_ajaran"]');
                const tahunAjaranForm = document.getElementById('tahunAjaranForm');

                if (tahunAjaranSelect && tahunAjaranForm) {
                    tahunAjaranSelect.addEventListener('change', function() {
                        tahunAjaranForm.submit();
                    });
                }

                // Handle tab switching for progress wali kelas
                const progressTabs = document.querySelectorAll('.semester-tab-progress');

                // Function to switch tab
                function switchProgressTab(waliIndex, semester) {
                    const waliCard = document.querySelector(`.semester-tab-progress[data-wali="${waliIndex}"]`)
                        ?.closest('.bg-gray-50');
                    if (!waliCard) return;

                    // Update tab styles
                    waliCard.querySelectorAll('.semester-tab-progress').forEach(t => {
                        t.classList.remove('text-primary', 'dark:text-hvPrimary', 'border-primary');
                        t.classList.add('text-gray-600', 'dark:text-gray-400', 'border-transparent');
                    });

                    const activeTab = waliCard.querySelector(
                        `.semester-tab-progress[data-wali="${waliIndex}"][data-semester="${semester}"]`);
                    if (activeTab) {
                        activeTab.classList.remove('text-gray-600', 'dark:text-gray-400', 'border-transparent');
                        activeTab.classList.add('text-primary', 'dark:text-hvPrimary', 'border-primary');
                    }

                    // Show/hide content
                    waliCard.querySelectorAll('.semester-content-progress').forEach(content => {
                        const contentWali = content.getAttribute('data-wali');
                        const contentSemester = content.getAttribute('data-semester');

                        if (contentWali === waliIndex && contentSemester === semester) {
                            content.classList.remove('hidden');
                        } else {
                            content.classList.add('hidden');
                        }
                    });

                    // Save to localStorage
                    localStorage.setItem(`progressTab_${waliIndex}`, semester);
                }

                // Restore saved tab state on page load
                progressTabs.forEach(tab => {
                    const waliIndex = tab.getAttribute('data-wali');
                    const savedSemester = localStorage.getItem(`progressTab_${waliIndex}`);

                    if (savedSemester) {
                        switchProgressTab(waliIndex, savedSemester);
                    }
                });

                // Add click event listeners
                progressTabs.forEach(tab => {
                    tab.addEventListener('click', function() {
                        const waliIndex = this.getAttribute('data-wali');
                        const semester = this.getAttribute('data-semester');
                        switchProgressTab(waliIndex, semester);
                    });
                });
            });
        </script>
    @endpush

</x-app-layout>
