<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buku Induk - {{ $kelasName }}</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 1cm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 8pt;
            line-height: 1.2;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 10px;
        }
        
        .header h1 {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 3px;
        }
        
        .header p {
            font-size: 9pt;
            margin: 2px 0;
        }
        
        table.data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        
        table.data-table, 
        table.data-table th, 
        table.data-table td {
            border: 1px solid #000;
        }
        
        table.data-table th {
            background-color: #e2e8f0;
            font-weight: bold;
            padding: 4px 2px;
            text-align: center;
            font-size: 7pt;
            vertical-align: middle;
        }
        
        table.data-table td {
            padding: 3px 2px;
            font-size: 7pt;
            vertical-align: middle;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-left {
            text-align: left;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .col-no {
            width: 20px;
        }
        
        .col-nisn {
            width: 60px;
        }
        
        .col-nama {
            width: 100px;
        }
        
        .col-status {
            width: 50px;
        }
        
        .col-nilai {
            width: 30px;
        }
        
        .col-deskripsi {
            width: 120px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>BUKU INDUK NILAI SISWA</h1>
        <p><strong>Kelas:</strong> {{ $kelasName }}</p>
        <p><strong>Semester:</strong> {{ $semester }} | <strong>Tahun Ajaran:</strong> {{ $tahunAjaran }}</p>
    </div>

    <table class="data-table">
        <thead>
            {{-- Row 1: Mapel Head names with colspan --}}
            <tr>
                <th rowspan="3" class="col-no">No.</th>
                <th rowspan="3" class="col-nisn">NISN</th>
                <th rowspan="3" class="col-nama">Nama Siswa</th>
                <th rowspan="3" class="col-status">Status Input</th>
                @foreach ($mapelHeads as $mapelHead)
                    @if ($mapelHead->details->isNotEmpty())
                        <th colspan="{{ $mapelHead->details->count() * 1 }}">{{ $mapelHead->nama_mapel }}</th>
                    @else
                        <th rowspan="2" colspan="1">{{ $mapelHead->nama_mapel }}</th>
                    @endif
                @endforeach
            </tr>
            
            {{-- Row 2: Mapel Detail names with colspan --}}
            <tr>
                @foreach ($mapelHeads as $mapelHead)
                    @if ($mapelHead->details->isNotEmpty())
                        @foreach ($mapelHead->details as $detail)
                            <th colspan="1" class="col-deskripsi">{{ $detail->nama_mapel_detail }}</th>
                        @endforeach
                    @endif
                @endforeach
            </tr>
            
            {{-- Row 3: Nilai & Deskripsi labels --}}
            <tr>
                @foreach ($mapelHeads as $mapelHead)
                    @if ($mapelHead->details->isNotEmpty())
                        @foreach ($mapelHead->details as $detail)
                            <th class="col-nilai">Nilai</th>
                            {{-- <th class="col-deskripsi">Deskripsi</th> --}}
                        @endforeach
                    @else
                        <th class="col-nilai">Nilai</th>
                        {{-- <th class="col-deskripsi">Deskripsi</th> --}}
                    @endif
                @endforeach
            </tr>
        </thead>
        <tbody>
            @forelse($students as $key => $siswa)
                @php
                    $bookHead = $bookHeads->get($siswa->id);
                    $bookDetails = $bookHead ? $bookHead->details->keyBy(function ($detail) {
                        return $detail->mapel_detail_id ?? 'head_' . $detail->mapel_head_id;
                    }) : collect();

                    // Determine status input
                    $statusInput = 'Belum Input';
                    if ($bookHead && $mapelHeads->isNotEmpty()) {
                        $allFilled = true;
                        foreach ($mapelHeads as $mapelHead) {
                            if ($mapelHead->details->isNotEmpty()) {
                                foreach ($mapelHead->details as $detail) {
                                    $detailData = $bookDetails->get($detail->id);
                                    if (!$detailData || empty($detailData->nilai_akhir) || empty($detailData->deskripsi)) {
                                        $allFilled = false;
                                        break 2;
                                    }
                                }
                            } else {
                                $headData = $bookDetails->get('head_' . $mapelHead->id);
                                if (!$headData || empty($headData->nilai_akhir) || empty($headData->deskripsi)) {
                                    $allFilled = false;
                                    break;
                                }
                            }
                        }
                        if ($allFilled) {
                            $statusInput = 'Sudah Input';
                        }
                    }
                @endphp
                <tr>
                    <td class="text-center">{{ $key + 1 }}</td>
                    <td class="text-center">{{ $siswa->nisn }}</td>
                    <td>{{ $siswa->nama_siswa }}</td>
                    <td class="text-center">{{ $statusInput }}</td>
                    @foreach ($mapelHeads as $mapelHead)
                        @if ($mapelHead->details->isNotEmpty())
                            @foreach ($mapelHead->details as $detail)
                                @php
                                    $detailData = $bookDetails->get($detail->id);
                                @endphp
                                <td class="text-center">{{ $detailData ? $detailData->nilai_akhir : '-' }}</td>
                                {{-- <td>{{ $detailData ? $detailData->deskripsi : '-' }}</td> --}}
                            @endforeach
                        @else
                            @php
                                $headData = $bookDetails->get('head_' . $mapelHead->id);
                            @endphp
                            <td class="text-center">{{ $headData ? $headData->nilai_akhir : '-' }}</td>
                            {{-- <td>{{ $headData ? $headData->deskripsi : '-' }}</td> --}}
                        @endif
                    @endforeach
                </tr>
            @empty
                <tr>
                    <td colspan="{{ 4 + ($mapelHeads->sum(function($m) { return $m->details->isNotEmpty() ? $m->details->count() * 2 : 2; })) }}" class="text-center">
                        Tidak ada siswa ditemukan
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>
