<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Nilai Siswa - {{ $siswa->nama_siswa }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #000;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }

        .header h1 {
            font-size: 16px;
            margin-bottom: 5px;
        }

        .header p {
            font-size: 10px;
        }

        .section {
            margin-bottom: 20px;
            border: 1px solid #ddd;
            padding: 15px;
        }

        .section-title {
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #000;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }

        .info-grid {
            display: table;
            width: 100%;
        }

        .info-grid.info-grid-photo {
            display: table;
        }

        .info-grid.info-grid-photo .info-photo-cell {
            display: table-cell;
            width: 90px;
            padding-right: 15px;
            vertical-align: top;
        }

        .info-grid.info-grid-photo .info-photo-wrapper {
            width: 90px;
            height: 120px;
            border: 1px solid #ddd;
            overflow: hidden;
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        .info-grid.info-grid-photo .info-details-cell {
            display: table-cell;
            vertical-align: top;
        }

        .info-grid.info-grid-photo .info-details-table {
            display: table;
            width: 100%;
        }

        .info-row {
            display: table-row;
        }

        .info-label {
            display: table-cell;
            width: 150px;
            padding: 3px 0;
            font-weight: normal;
        }

        .info-separator {
            display: table-cell;
            width: 10px;
            padding: 3px 0;
        }

        .info-value {
            display: table-cell;
            padding: 3px 0;
        }

        .nilai-section {
            margin-top: 20px;
        }

        .nilai-header {
            font-size: 13px;
            font-weight: bold;
            margin-bottom: 10px;
            padding: 8px;
            background-color: #f3f4f6;
            border-left: 4px solid #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }

        table th,
        table td {
            border: 1px solid #000;
            padding: 6px 8px;
            text-align: left;
        }

        table th {
            background-color: #e5e7eb;
            font-weight: bold;
            text-align: center;
            font-size: 10px;
        }

        table td {
            font-size: 10px;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        .font-semibold {
            font-weight: 600;
        }

        .bg-gray {
            background-color: #f9fafb;
        }

        .sub-mapel {
            padding-left: 20px;
        }

        .no-data {
            text-align: center;
            color: #6b7280;
            font-style: italic;
            padding: 20px;
        }

        .page-break {
            page-break-after: always;
        }

        tfoot td {
            font-weight: bold;
            background-color: #e5e7eb;
        }

        .header-logos {
            display: table;
            width: 100%;
            margin-bottom: 5px;
        }

        .header-logo-left,
        .header-logo-right {
            display: table-cell;
            width: 80px;
            vertical-align: middle;
        }

        .header-content {
            display: table-cell;
            vertical-align: middle;
            text-align: center;
        }

        .header img {
            width: 80px;
            height: 80px;
            object-fit: contain;
        }

        .header h1 {
            font-size: 14pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 3px 0;
            letter-spacing: 0.5px;
        }

        .header p {
            font-size: 9pt;
            margin: 1px 0;
        }

        .header .subtitle {
            font-size: 10pt;
            font-style: italic;
        }
    </style>
</head>

<body>
    {{-- Header --}}
    <div class="header">
        {{-- <h1>DETAIL NILAI SISWA</h1>
        <p>Sistem Informasi Raport</p> --}}
        <div class="header-logos">
            <div class="header-logo-left">
                <img src="{{ public_path('img/logoUtama.png') }}" alt="Logo Kiri" />
            </div>
            <div class="header-content">
                <p style="font-weight: bold;">KEMENTERIAN AGAMA REPUBLIK INDONESIA</p>
                <h1 style="margin-top: -2px;">{{ Auth::user()->nama_sekolah }}</h1>
                <p class="subtitle" style="margin-top: -3px;">{{ Auth::user()->alamat_sekolah }}</p>
            </div>
            <div class="header-logo-right">
                <img src="{{ public_path('logo_app/' . Auth::user()->logo) }}" alt="Logo Kanan" />
            </div>
        </div>
    </div>

    <div style="text-align: center; margin-bottom: 20px;">
        <h2>BIODATA SISWA</h2>
        <h2>DAN REKAP NILAI</h2>
    </div>
    {{-- Detail Siswa --}}
    <div class="section">
        @php
            $fotoPath = $siswa->foto ? public_path('foto_siswa/' . $siswa->foto) : public_path('img/profil.webp');
            $fotoPath = str_replace('\\', '/', $fotoPath);
        @endphp
        <div class="section-title">Data Pribadi Siswa</div>
        <div class="info-grid info-grid-photo">
            <div class="info-details-cell">
                <div class="info-details-table">
                    <div class="info-row">
                        <div class="info-label">NIS / NISN</div>
                        <div class="info-separator">:</div>
                        <div class="info-value">{{ $siswa->nis }} / {{ $siswa->nisn }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Nama Siswa</div>
                        <div class="info-separator">:</div>
                        <div class="info-value">{{ $siswa->nama_siswa }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Kelas</div>
                        <div class="info-separator">:</div>
                        <div class="info-value">
                            {{ $siswa->kelas->nama_kelas_nomor }}{{ $siswa->kelas->nama_kelas_sub ?? '' }}
                            ({{ $siswa->kelas->nama_kelas_romawi }} {{ $siswa->kelas->nama_kelas_sub ?? '' }})
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Angkatan</div>
                        <div class="info-separator">:</div>
                        <div class="info-value">{{ $siswa->angkatan }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Jenis Kelamin</div>
                        <div class="info-separator">:</div>
                        <div class="info-value">{{ $siswa->jenis_kelamin }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Tempat, Tanggal Lahir</div>
                        <div class="info-separator">:</div>
                        <div class="info-value">
                            {{ $siswa->tempat_lahir ?? '-' }},
                            {{ $siswa->tanggal_lahir ? $siswa->tanggal_lahir->format('d F Y') : '-' }}
                        </div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Agama</div>
                        <div class="info-separator">:</div>
                        <div class="info-value">{{ $siswa->agama }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Alamat</div>
                        <div class="info-separator">:</div>
                        <div class="info-value">{{ $siswa->alamat ?? '-' }}</div>
                    </div>
                </div>
            </div>
            <div class="info-photo-cell">
                <div class="info-photo-wrapper" style="background-image: url('{{ $fotoPath }}');"></div>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">Data Orang Tua</div>
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Nama Ayah</div>
                <div class="info-separator">:</div>
                <div class="info-value">{{ $siswa->nama_ayah ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Pekerjaan Ayah</div>
                <div class="info-separator">:</div>
                <div class="info-value">{{ $siswa->pekerjaanAyah->nama_pekerjaan ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Nama Ibu</div>
                <div class="info-separator">:</div>
                <div class="info-value">{{ $siswa->nama_ibu ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Pekerjaan Ibu</div>
                <div class="info-separator">:</div>
                <div class="info-value">{{ $siswa->pekerjaanIbu->nama_pekerjaan ?? '-' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">No. HP Ortu</div>
                <div class="info-separator">:</div>
                <div class="info-value">{{ $siswa->no_hp_ortu ?? '-' }}</div>
            </div>
        </div>
    </div>

    <div class="page-break"></div>

    {{-- Rekap Nilai Siswa --}}
    @php
        // Define toRoman function
        if (!function_exists('toRoman')) {
            function toRoman($num)
            {
                $map = [
                    'X' => 10,
                    'IX' => 9,
                    'V' => 5,
                    'IV' => 4,
                    'I' => 1,
                ];
                $returnValue = '';
                foreach ($map as $roman => $int) {
                    while ($num >= $int) {
                        $returnValue .= $roman;
                        $num -= $int;
                    }
                }
                return $returnValue;
            }
        }
    @endphp

    @if ($nilaiData->isNotEmpty())
        @foreach ($nilaiData as $tahunAjaran => $bookHeads)
            @php
                $ganjil = $bookHeads->where('semester', 'Ganjil')->first();
                $genap = $bookHeads->where('semester', 'Genap')->first();
                $angka = $ganjil->nama_kelas_nomor ?? ($genap->nama_kelas_nomor ?? '-');
            @endphp

            <div class="nilai-section">
                {{-- Semester Ganjil --}}
                @if ($ganjil)
                    <div class="nilai-header">
                        Rekap Nilai Kelas {{ is_numeric($angka) ? toRoman((int) $angka) : '-' }}
                        ({{ $ganjil->nama_kelas_nomor ?? ($genap->nama_kelas_nomor ?? '-') }})
                        Semester Ganjil
                        ,
                        Tahun Ajaran {{ $tahunAjaran }}
                    </div>
                    <table>
                        <thead>
                            <tr>
                                <th style="width: 40px;">No</th>
                                <th style="width: 200px;">Mata Pelajaran</th>
                                <th style="width: 80px;">Nilai Akhir</th>
                                <th>Deskripsi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $rowNumber = 1;
                                $groupedDetails = $ganjil->details->groupBy('mapel_head_id');
                            @endphp

                            @forelse($groupedDetails as $mapelHeadId => $details)
                                @php
                                    $firstDetail = $details->first();

                                    if (
                                        $firstDetail->mapel_detail_id &&
                                        $firstDetail->mapelDetail &&
                                        $firstDetail->mapelDetail->mapelHead
                                    ) {
                                        $mapelHead = $firstDetail->mapelDetail->mapelHead;
                                    } else {
                                        $mapelHead = $firstDetail->mapelHead;
                                    }

                                    $hasSubMapel = $details->where('mapel_detail_id', '!=', null)->isNotEmpty();

                                    if ($hasSubMapel) {
                                        $subMapels = $details->where('mapel_detail_id', '!=', null);
                                        $rowspan = $subMapels->count() + 1;
                                    } else {
                                        $rowspan = 1;
                                    }
                                @endphp

                                {{-- Main Mapel Row --}}
                                <tr class="bg-gray">
                                    <td class="text-center" rowspan="{{ $rowspan }}">
                                        {{ $rowNumber++ }}.
                                    </td>
                                    <td>{{ $mapelHead->nama_mapel ?? '-' }}</td>
                                    <td class="text-center">
                                        @if (!$hasSubMapel)
                                            {{ $firstDetail->nilai_akhir ?? '-' }}
                                        @endif
                                    </td>
                                    <td>
                                        @if (!$hasSubMapel)
                                            {{ $firstDetail->deskripsi ?? '-' }}
                                        @endif
                                    </td>
                                </tr>

                                {{-- Sub Mapel Rows --}}
                                @if ($hasSubMapel)
                                    @foreach ($subMapels as $index => $subDetail)
                                        <tr>
                                            <td class="sub-mapel">
                                                {{ chr(65 + $index) }}.
                                                {{ $subDetail->mapelDetail->nama_mapel_detail ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                {{ $subDetail->nilai_akhir ?? '-' }}
                                            </td>
                                            <td>
                                                {{ $subDetail->deskripsi ?? '-' }}
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            @empty
                                <tr>
                                    <td colspan="4" class="no-data">
                                        Tidak ada data nilai
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-right">Jumlah Nilai Akhir</td>
                                <td class="text-center">{{ number_format($ganjil->jml_nilai_akhir) }}</td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                @endif

                <div class="page-break"></div>

                {{-- Semester Genap --}}
                @if ($genap)
                    <div class="nilai-header">
                        Rekap Nilai Kelas {{ is_numeric($angka) ? toRoman((int) $angka) : '-' }}
                        ({{ $ganjil->nama_kelas_nomor ?? ($genap->nama_kelas_nomor ?? '-') }})
                        Semester Genap
                        ,
                        Tahun Ajaran {{ $tahunAjaran }}
                    </div>
                    <table>
                        <thead>
                            <tr>
                                <th style="width: 40px;">No</th>
                                <th style="width: 200px;">Mata Pelajaran</th>
                                <th style="width: 80px;">Nilai Akhir</th>
                                <th>Deskripsi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $rowNumber = 1;
                                $groupedDetails = $genap->details->groupBy('mapel_head_id');
                            @endphp

                            @forelse($groupedDetails as $mapelHeadId => $details)
                                @php
                                    $firstDetail = $details->first();

                                    if (
                                        $firstDetail->mapel_detail_id &&
                                        $firstDetail->mapelDetail &&
                                        $firstDetail->mapelDetail->mapelHead
                                    ) {
                                        $mapelHead = $firstDetail->mapelDetail->mapelHead;
                                    } else {
                                        $mapelHead = $firstDetail->mapelHead;
                                    }

                                    $hasSubMapel = $details->where('mapel_detail_id', '!=', null)->isNotEmpty();

                                    if ($hasSubMapel) {
                                        $subMapels = $details->where('mapel_detail_id', '!=', null);
                                        $rowspan = $subMapels->count() + 1;
                                    } else {
                                        $rowspan = 1;
                                    }
                                @endphp

                                {{-- Main Mapel Row --}}
                                <tr class="bg-gray">
                                    <td class="text-center" rowspan="{{ $rowspan }}">
                                        {{ $rowNumber++ }}.
                                    </td>
                                    <td>{{ $mapelHead->nama_mapel ?? '-' }}</td>
                                    <td class="text-center">
                                        @if (!$hasSubMapel)
                                            {{ $firstDetail->nilai_akhir ?? '-' }}
                                        @endif
                                    </td>
                                    <td>
                                        @if (!$hasSubMapel)
                                            {{ $firstDetail->deskripsi ?? '-' }}
                                        @endif
                                    </td>
                                </tr>

                                {{-- Sub Mapel Rows --}}
                                @if ($hasSubMapel)
                                    @foreach ($subMapels as $index => $subDetail)
                                        <tr>
                                            <td class="sub-mapel">
                                                {{ chr(65 + $index) }}.
                                                {{ $subDetail->mapelDetail->nama_mapel_detail ?? '-' }}
                                            </td>
                                            <td class="text-center">
                                                {{ $subDetail->nilai_akhir ?? '-' }}
                                            </td>
                                            <td>
                                                {{ $subDetail->deskripsi ?? '-' }}
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            @empty
                                <tr>
                                    <td colspan="4" class="no-data">
                                        Tidak ada data nilai
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-right">Jumlah Nilai Akhir</td>
                                <td class="text-center">{{ number_format($genap->jml_nilai_akhir) }}</td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                @endif
            </div>

            @if (!$loop->last)
                <div class="page-break"></div>
            @endif
        @endforeach
    @else
        <div class="nilai-section">
            <div class="no-data">
                Belum ada data nilai untuk siswa ini
            </div>
        </div>
    @endif
</body>

</html>
