<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Raport Bulk</title>
    <style>
        @page {
            size: A4;
            margin: 2cm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 10pt;
            line-height: 1.3;
            color: #000;
        }
        
        .header {
            text-align: center;
            margin-bottom: 5px;
            padding-bottom: 8px;
        }
        
        .header-logos {
            display: table;
            width: 100%;
            margin-bottom: 5px;
        }
        
        .header-logo-left,
        .header-logo-right {
            display: table-cell;
            width: 80px;
            vertical-align: middle;
        }
        
        .header-content {
            display: table-cell;
            vertical-align: middle;
            text-align: center;
        }
        
        .header img {
            width: 80px;
            height: 80px;
            object-fit: contain;
        }
        
        .header h1 {
            font-size: 14pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 3px 0;
            letter-spacing: 0.5px;
        }
        
        .header p {
            font-size: 9pt;
            margin: 1px 0;
        }
        
        .header .subtitle {
            font-size: 10pt;
            font-style: italic;
        }
        
        .info-section {
            margin: 3px 0;
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
            padding: 8px 0;
        }
        
        .info-table {
            width: 100%;
            border: none;
        }
        
        .info-table td {
            border: none;
            padding: 1px 5px;
            font-size: 9pt;
            vertical-align: top;
        }
        
        .info-label {
            width: 80px;
            font-weight: normal;
        }
        
        .info-separator {
            width: 10px;
        }
        
        .info-value {
            font-weight: normal;
        }
        
        .section-title {
            font-weight: bold;
            font-size: 11pt;
            margin: 12px 0 3px 0;
            text-align: start;
            letter-spacing: 0.5px;
        }
        
        table.data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        
        table.data-table, 
        table.data-table th, 
        table.data-table td {
            border: 1px solid #000;
        }
        
        table.data-table th {
            background-color: #fff;
            font-weight: bold;
            padding: 5px 3px;
            text-align: center;
            font-size: 9pt;
            vertical-align: middle;
        }
        
        table.data-table td {
            padding: 4px 5px;
            font-size: 9pt;
            vertical-align: top;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-left {
            text-align: left;
        }
        
        .text-right {
            text-align: right;
        }
        
        .font-bold {
            font-weight: bold;
        }
        
        .indent {
            padding-left: 20px;
        }
        
        .catatan-box {
            border: 1px solid #000;
            padding: 8px;
            min-height: 70px;
            margin-bottom: 20px;
            font-size: 9pt;
        }
        
        .kenaikan-box {
            border: 1px solid #000;
            padding: 6px;
            margin-bottom: 30px;
            font-size: 9pt;
        }
        
        .signature-section {
            margin-top: 15px;
            display: table;
            width: 100%;
        }
        
        .signature-col {
            display: table-cell;
            width: 33.33%;
            text-align: center;
            vertical-align: top;
            padding: 0 5px;
        }
        
        .signature-title {
            font-weight: normal;
            margin-bottom: 70px;
            font-size: 9pt;
        }
        
        .signature-name {
            font-weight: bold;
            border-bottom: 1px solid #000;
            padding-bottom: 2px;
            margin: 0 15px;
            font-size: 9pt;
        }
        
        .signature-nip {
            font-size: 8pt;
            margin-top: 2px;
        }
        
        .date-section {
            text-align: right;
            margin-bottom: 8px;
            font-size: 9pt;
        }
        
        .page-break {
            page-break-after: always;
        }
        
        .bg-gray {
            background-color: #f5f5f5;
        }
        
        .raport-container {
            page-break-inside: avoid;
        }
        
        .raport-container:not(:first-child) {
            page-break-before: always;
        }
    </style>
</head>
<body style="margin: 1cm;">
    @foreach($raportList as $index => $raportData)
        <div class="raport-container">
            @include('pages.raport.pdf-single', $raportData)
        </div>
    @endforeach
</body>
</html>
