<title>Buku Induk</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <style>
        .mapel-scroll {
            overflow-x: auto;
            scrollbar-width: thin;
            scrollbar-color: rgba(0, 0, 0, 0.4) transparent;
        }

        .dark .mapel-scroll {
            overflow-x: auto;
            scrollbar-width: thin;
            scrollbar-color: rgba(255, 255, 255, 0.5) transparent;
        }

        .mapel-scroll::-webkit-scrollbar {
            height: 6px;
        }

        .mapel-scroll::-webkit-scrollbar-thumb {
            background-color: #c4c4c4;
            border-radius: 10px;
        }

        .mapel-scroll::-webkit-scrollbar-thumb:hover {
            background-color: #a1a1a1;
        }

        .mapel-scroll::-webkit-scrollbar-track {
            background-color: #f4f4f4;
            border-radius: 10px;
        }

        /* Dark mode scrollbar */
        .dark .mapel-scroll::-webkit-scrollbar-thumb {
            background-color: #6b7280;
        }

        .dark .mapel-scroll::-webkit-scrollbar-thumb:hover {
            background-color: #4b5563;
        }

        .dark .mapel-scroll::-webkit-scrollbar-track {
            background-color: #1f2937;
        }

        .mapel-col {
            min-width: 100px;
            width: 100px;
        }
    </style>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        {{-- Alert Success/Error/Warning --}}
        {{-- @if (session('successNotif'))
            <div class="p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400"
                role="alert">
                <span class="font-medium">Berhasil!</span> {{ session('successNotif') }}
            </div>
        @endif

        @if (session('errorNotif'))
            <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400"
                role="alert">
                <span class="font-medium">Error!</span> {{ session('errorNotif') }}
            </div>
        @endif

        @if (session('warningNotif'))
            <div class="p-4 mb-4 text-sm text-yellow-800 rounded-lg bg-yellow-50 dark:bg-gray-800 dark:text-yellow-400"
                role="alert">
                <span class="font-medium">Peringatan!</span> {{ session('warningNotif') }}
                @if (session('importErrors'))
                    <ul class="mt-2 ml-4 list-disc list-inside">
                        @foreach (session('importErrors') as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif
            </div>
        @endif --}}

        <div class="mb-2 md:mb-4 -mt-3">
            <h1 class="md:flex justify-between items-center">
                <div class="flex gap-2 mt-3 md:mt-0">
                    <i class="fa-solid fa-book-open text-3xl mt-1 font-bold"></i>
                    <div>
                        <p class="text-xl sm:text-2xl font-bold">Buku Induk</p>
                        <p class="text-xs sm:text-sm ms-[1px] -mt-1">Index</p>
                    </div>
                </div>
                @can('Admin')
                    <div class="flex items-center gap-2">
                        <div class="flex mt-4">
                            <form id="tahunAjaranForm" action="{{ route('buku-induk.index') }}" method="GET"
                                class="flex gap-2 items-center">
                                <div>
                                    <x-label class="whitespace-nowrap font-semibold text-xs">Tahun Ajaran</x-label>
                                    <x-select name="tahun_ajaran"
                                        class="{{ $errors->first('tahun_ajaran') ? 'border-red-500' : '' }} text-xs">
                                        @forelse($dataTahunAjaran as $tahunAjaran)
                                            @php
                                                $value = $tahunAjaran->tahun_awal . '/' . $tahunAjaran->tahun_akhir;
                                            @endphp
                                            <option value="{{ $value }}"
                                                {{ $value === $selectedTahunAjaran ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @empty
                                            <option value="" disabled>Tidak ada data tahun ajaran</option>
                                        @endforelse
                                    </x-select>
                                </div>
                                <div>
                                    <x-label class="whitespace-nowrap font-semibold text-xs">Kelas</x-label>
                                    <x-select name="kelasSelect"
                                        class="{{ $errors->first('kelasSelect') ? 'border-red-500' : '' }} text-xs">
                                        <option value="all" {{ ($selectedKelas ?? 'all') === 'all' ? 'selected' : '' }}>
                                            Semua Kelas</option>
                                        <option value="7" {{ ($selectedKelas ?? '') === '7' ? 'selected' : '' }}>VII
                                            (7)</option>
                                        <option value="8" {{ ($selectedKelas ?? '') === '8' ? 'selected' : '' }}>VIII
                                            (8)</option>
                                        <option value="9" {{ ($selectedKelas ?? '') === '9' ? 'selected' : '' }}>IX
                                            (9)
                                        </option>
                                    </x-select>
                                </div>
                                {{-- <div>
                                    <x-label class="whitespace-nowrap font-semibold text-xs">Semester</x-label>
                                    <x-select name="semesterSelect"
                                        class="{{ $errors->first('semesterSelect') ? 'border-red-500' : '' }} text-xs">
                                        <option value="all"
                                            {{ ($selectedSemester ?? 'all') === 'all' ? 'selected' : '' }}>Semua Semester
                                        </option>
                                        <option value="ganjil"
                                            {{ ($selectedSemester ?? '') === 'ganjil' ? 'selected' : '' }}>Semester Ganjil
                                        </option>
                                        <option value="genap"
                                            {{ ($selectedSemester ?? '') === 'genap' ? 'selected' : '' }}>Semester Genap
                                        </option>
                                    </x-select>
                                </div> --}}
                            </form>
                        </div>
                        <div>
                            <x-label class="whitespace-nowrap font-semibold text-xs">Reset</x-label>
                            <a href="/buku-induk"
                                class="border border-gray-400 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 hover:bg-primary dark:hover:bg-primary hover:text-light hover:border-transparent rounded-lg py-2 px-4 text-sm flex items-center">
                                <i class="fa-solid fa-arrows-rotate text-xs"></i>
                            </a>
                        </div>
                        {{-- <div class="flex-col flex">
                            <x-label class="whitespace-nowrap font-semibold text-transparent text-xs">Unduh</x-label>
                            <button type="button" id="downloadAllRaport"
                                class="whitespace-nowrap inline-block px-3 py-2 bg-indigo-500 text-white text-xs rounded hover:bg-indigo-600">
                                <i class="fa-solid fa-download"></i> Unduh Semua
                            </button>
                        </div> --}}
                    </div>
                @endcan
            </h1>
        </div>

        {{-- Card Progress Wali Kelas (hanya untuk role Wali) --}}
        @if (Auth::user()->role === 'Wali' && $waliKelasProgress)
            <div class="mb-6 flex gap-5">
                <div
                    class="bg-gray-50 dark:bg-gray-800 rounded-lg p-4 shadow shadow-gray-300 dark:shadow-gray-700 border-t-2 border-primary w-full">
                    @php
                        $percentageGanjil = $waliKelasProgress['ganjil']['progress_percentage'];
                        $isCompleteGanjil = $percentageGanjil >= 100;
                        $isHighGanjil = $percentageGanjil >= 75 && $percentageGanjil < 100;
                        $isMediumGanjil = $percentageGanjil >= 50 && $percentageGanjil < 75;

                        if ($isCompleteGanjil) {
                            $progressColorGanjil = 'text-emerald-700 dark:text-emerald-200';
                        } elseif ($isHighGanjil) {
                            $progressColorGanjil = 'text-yellow-600 dark:text-yellow-300';
                        } elseif ($isMediumGanjil) {
                            $progressColorGanjil = 'text-yellow-600 dark:text-yellow-300';
                        } else {
                            $progressColorGanjil = 'text-red-600 dark:text-red-300';
                        }
                    @endphp

                    <h1 class="text-primary dark:text-hvPrimary font-bold">Semester Ganjil</h1>
                    <div class="border border-gray-400 border-dashed mb-3 mt-2"></div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="relative w-16 h-16">
                                <svg class="w-16 h-16 transform -rotate-90">
                                    <circle cx="32" cy="32" r="28" stroke="currentColor" stroke-width="6"
                                        fill="none" class="text-gray-300 dark:text-gray-600" />
                                    <circle cx="32" cy="32" r="28" stroke="currentColor" stroke-width="6"
                                        fill="none" class="{{ $progressColorGanjil }}"
                                        stroke-dasharray="{{ 2 * 3.14159 * 28 }}"
                                        stroke-dashoffset="{{ 2 * 3.14159 * 28 * (1 - $percentageGanjil / 100) }}"
                                        stroke-linecap="round" />
                                </svg>
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <span
                                        class="text-sm font-bold {{ $progressColorGanjil }}">{{ number_format($percentageGanjil, 0) }}%</span>
                                </div>
                            </div>
                            <div>
                                <p class="text-xs md:text-base text-gray-600 dark:text-gray-300 font-medium">Progress
                                    Input</p>
                                <p class="text-xl md:text-2xl font-bold {{ $progressColorGanjil }}">
                                    {{ $waliKelasProgress['ganjil']['sudah_input'] }}/{{ $waliKelasProgress['ganjil']['harus_input'] }}
                                </p>
                            </div>
                        </div>
                    </div>

                </div>
                <div
                    class="bg-gray-50 dark:bg-gray-800 rounded-lg p-4 shadow shadow-gray-300 dark:shadow-gray-700 border-t-2 border-primary w-full">

                    @php
                        $percentageGenap = $waliKelasProgress['genap']['progress_percentage'];
                        $isCompleteGenap = $percentageGenap >= 100;
                        $isHighGenap = $percentageGenap >= 75 && $percentageGenap < 100;
                        $isMediumGenap = $percentageGenap >= 50 && $percentageGenap < 75;

                        if ($isCompleteGenap) {
                            $progressColorGenap = 'text-emerald-700 dark:text-emerald-200';
                        } elseif ($isHighGenap) {
                            $progressColorGenap = 'text-yellow-600 dark:text-yellow-300';
                        } elseif ($isMediumGenap) {
                            $progressColorGenap = 'text-yellow-600 dark:text-yellow-300';
                        } else {
                            $progressColorGenap = 'text-red-600 dark:text-red-300';
                        }
                    @endphp

                    <h1 class="text-primary dark:text-hvPrimary font-bold">Semester Genap</h1>
                    <div class="border border-gray-400 border-dashed mb-3 mt-2"></div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="relative w-16 h-16">
                                <svg class="w-16 h-16 transform -rotate-90">
                                    <circle cx="32" cy="32" r="28" stroke="currentColor" stroke-width="6"
                                        fill="none" class="text-gray-300 dark:text-gray-600" />
                                    <circle cx="32" cy="32" r="28" stroke="currentColor" stroke-width="6"
                                        fill="none" class="{{ $progressColorGenap }}"
                                        stroke-dasharray="{{ 2 * 3.14159 * 28 }}"
                                        stroke-dashoffset="{{ 2 * 3.14159 * 28 * (1 - $percentageGenap / 100) }}"
                                        stroke-linecap="round" />
                                </svg>
                                <div class="absolute inset-0 flex items-center justify-center">
                                    <span
                                        class="text-sm font-bold {{ $progressColorGenap }}">{{ number_format($percentageGenap, 0) }}%</span>
                                </div>
                            </div>
                            <div>
                                <p class="text-xs md:text-base text-gray-600 dark:text-gray-300 font-medium">Progress
                                    Input</p>
                                <p class="text-xl md:text-2xl font-bold {{ $progressColorGenap }}">
                                    {{ $waliKelasProgress['genap']['sudah_input'] }}/{{ $waliKelasProgress['genap']['harus_input'] }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        {{-- Detail Data Cards --}}
        <div id="kelasCardsContainer">
            @if (isset($kelasData) && count($kelasData) > 0)
                @foreach ($kelasData as $index => $data)
                    @php
                        $groupKey = $data['group_key'] ?? 'group-' . $loop->index;
                    @endphp
                    <div class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary {{ $index > 0 ? 'mt-5' : '' }} raport-card"
                        data-group-key="{{ $groupKey }}">
                        <div class="md:flex justify-between items-center mb-4 gap-6">
                            <div>
                                <h1 class="font-bold flex text-sm">
                                    <div class="">
                                        {{ $data['group_label'] ?? 'Kelas' }}</div>
                                    <div>: {{ $data['group_value'] ?? '-' }}</div>
                                </h1>
                            </div>
                            <div class="flex items-end gap-3 mt-3 md:mt-0">
                                <div>
                                    <div class="relative inline-block w-full max-w-md">
                                        <x-search-i></x-search-i>
                                        <x-search placeholder="Cari Nama Siswa..."
                                            class="w-full bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 kelas-search"
                                            data-group-key="{{ $groupKey }}" />
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="border border-gray-400 border-dashed my-5"></div>

                        <div class="mb-2 kelasCardsContainer" id="kelasCardsContainer-{{ $groupKey }}">
                            <div class="md:flex gap-5 mb-3 justify-between items-center">
                                <div class="flex gap-5">
                                    <button type="button"
                                        class="semester-tab tab-active font-semibold text-primary dark:text-hvPrimary border-hvPrimary"
                                        data-tab="ganjil">Semester Ganjil</button>
                                    <button type="button"
                                        class="semester-tab tab-inactive border-primary text-gray-600 dark:text-gray-400"
                                        data-tab="genap">Semester Genap</button>
                                </div>
                                <div class="flex items-center gap-2 mt-3 md:mt-0">
                                    @php
                                        $hasDataGanjil =
                                            isset($data['book_heads_ganjil']) &&
                                            $data['book_heads_ganjil']->isNotEmpty();
                                        $hasDataGenap =
                                            isset($data['book_heads_genap']) && $data['book_heads_genap']->isNotEmpty();
                                    @endphp

                                    {{-- Button for Semester Ganjil --}}
                                    <div class="semester-buttons" data-semester="ganjil">
                                        <button type="button"
                                            class="edit-nilai-btn whitespace-nowrap inline-block px-3 py-2 bg-yellow-600 text-white text-xs rounded hover:bg-yellow-500"
                                            data-group-key="{{ $groupKey }}">
                                            <i class="fa-solid fa-pen-to-square"></i> Edit Nilai
                                        </button>
                                        <button type="button"
                                            class="cancel-edit-btn hidden whitespace-nowrap px-3 py-2 bg-red-600 text-white text-xs rounded hover:bg-red-700"
                                            data-group-key="{{ $groupKey }}">
                                            <i class="fa-solid fa-xmark"></i> Batalkan
                                        </button>
                                        <button type="button"
                                            class="save-nilai-btn hidden whitespace-nowrap px-3 py-2 bg-primary text-white text-xs rounded hover:bg-hvPrimary"
                                            data-group-key="{{ $groupKey }}">
                                            <i class="fa-solid fa-save"></i> Simpan Perubahan
                                        </button>
                                        @if ($hasDataGanjil)
                                            <button type="button"
                                                class="delete-nilai-btn whitespace-nowrap inline-block px-3 py-2 bg-red-600 text-white text-xs rounded hover:bg-red-700"
                                                data-modal-target="deleteNilaiModal"
                                                data-modal-toggle="deleteNilaiModal"
                                                data-group-key="{{ $groupKey }}"
                                                data-kelas-name="{{ $data['group_value'] ?? '-' }}"
                                                data-semester="Ganjil">
                                                <i class="fa-solid fa-trash"></i> Delete Semua Nilai
                                            </button>
                                        @else
                                            <button type="button"
                                                class="import-nilai-btn whitespace-nowrap inline-block px-3 py-2 bg-primary text-white text-xs rounded hover:bg-hvPrimary"
                                                data-modal-target="importNilaiModal"
                                                data-modal-toggle="importNilaiModal"
                                                data-group-key="{{ $groupKey }}"
                                                data-kelas-name="{{ $data['group_value'] ?? '-' }}"
                                                data-semester="ganjil">
                                                <i class="fa-solid fa-file-excel"></i> Impor Nilai Dari Excel
                                            </button>
                                        @endif
                                        <div class="relative inline-block text-left">
                                            <button type="button"
                                                class="download-dropdown-btn whitespace-nowrap inline-flex items-center px-3 py-2 bg-indigo-500 text-white text-xs rounded hover:bg-indigo-600"
                                                data-group-key="{{ $groupKey }}" data-semester="ganjil"
                                                data-kelas-id="{{ $data['kelas']->id ?? '' }}"
                                                data-kelas-name="{{ $data['group_value'] ?? '-' }}">
                                                <i class="fa-solid fa-download mr-1"></i>
                                                <i class="fa-solid fa-chevron-down ml-1 text-xs"></i>
                                            </button>
                                            <div class="download-dropdown-menu hidden absolute right-0 z-10 mt-2 w-48 origin-top-right rounded-md bg-white dark:bg-gray-900 shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                                                data-group-key="{{ $groupKey }}" data-semester="ganjil">
                                                <div class="py-1">
                                                    <a href="#"
                                                        class="download-excel-btn block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600"
                                                        data-group-key="{{ $groupKey }}" data-semester="ganjil"
                                                        data-kelas-id="{{ $data['kelas']->id ?? '' }}"
                                                        data-kelas-name="{{ $data['group_value'] ?? '-' }}">
                                                        <i class="fa-solid fa-file-excel text-green-600 mr-2"></i>
                                                        Download ke Excel
                                                    </a>
                                                    {{-- <a href="#"
                                                        class="download-pdf-btn block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600"
                                                        data-group-key="{{ $groupKey }}" data-semester="ganjil"
                                                        data-kelas-id="{{ $data['kelas']->id ?? '' }}"
                                                        data-kelas-name="{{ $data['group_value'] ?? '-' }}">
                                                        <i class="fa-solid fa-file-pdf text-red-600 mr-2"></i> Download
                                                        ke PDF
                                                    </a> --}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Button for Semester Genap --}}
                                    <div class="semester-buttons hidden" data-semester="genap">
                                        <button type="button"
                                            class="edit-nilai-btn whitespace-nowrap inline-block px-3 py-2 bg-yellow-600 text-white text-xs rounded hover:bg-yellow-500"
                                            data-group-key="{{ $groupKey }}">
                                            <i class="fa-solid fa-pen-to-square"></i> Edit Nilai
                                        </button>
                                        <button type="button"
                                            class="cancel-edit-btn hidden whitespace-nowrap px-3 py-2 bg-red-600 text-white text-xs rounded hover:bg-red-700"
                                            data-group-key="{{ $groupKey }}">
                                            <i class="fa-solid fa-xmark"></i> Batalkan
                                        </button>
                                        <button type="button"
                                            class="save-nilai-btn hidden whitespace-nowrap px-3 py-2 bg-primary text-white text-xs rounded hover:bg-hvPrimary"
                                            data-group-key="{{ $groupKey }}">
                                            <i class="fa-solid fa-save"></i> Simpan Perubahan
                                        </button>
                                        @if ($hasDataGenap)
                                            <button type="button"
                                                class="delete-nilai-btn whitespace-nowrap inline-block px-3 py-2 bg-red-600 text-white text-xs rounded hover:bg-red-700"
                                                data-modal-target="deleteNilaiModal"
                                                data-modal-toggle="deleteNilaiModal"
                                                data-group-key="{{ $groupKey }}"
                                                data-kelas-name="{{ $data['group_value'] ?? '-' }}"
                                                data-semester="Genap">
                                                <i class="fa-solid fa-trash"></i> Delete Semua Nilai
                                            </button>
                                        @else
                                            <button type="button"
                                                class="import-nilai-btn whitespace-nowrap inline-block px-3 py-2 bg-primary text-white text-xs rounded hover:bg-hvPrimary"
                                                data-modal-target="importNilaiModal"
                                                data-modal-toggle="importNilaiModal"
                                                data-group-key="{{ $groupKey }}"
                                                data-kelas-name="{{ $data['group_value'] ?? '-' }}"
                                                data-semester="genap">
                                                <i class="fa-solid fa-file-excel"></i> Impor Nilai Dari Excel
                                            </button>
                                        @endif
                                        <div class="relative inline-block text-left">
                                            <button type="button"
                                                class="download-dropdown-btn whitespace-nowrap inline-flex items-center px-3 py-2 bg-indigo-500 text-white text-xs rounded hover:bg-indigo-600"
                                                data-group-key="{{ $groupKey }}" data-semester="genap"
                                                data-kelas-id="{{ $data['kelas']->id ?? '' }}"
                                                data-kelas-name="{{ $data['group_value'] ?? '-' }}">
                                                <i class="fa-solid fa-download mr-1"></i>
                                                <i class="fa-solid fa-chevron-down ml-1 text-xs"></i>
                                            </button>
                                            <div class="download-dropdown-menu hidden absolute right-0 z-10 mt-2 w-48 origin-top-right rounded-md bg-white dark:bg-gray-900 shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                                                data-group-key="{{ $groupKey }}" data-semester="genap">
                                                <div class="py-1">
                                                    <a href="#"
                                                        class="download-excel-btn block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600"
                                                        data-group-key="{{ $groupKey }}" data-semester="genap"
                                                        data-kelas-id="{{ $data['kelas']->id ?? '' }}"
                                                        data-kelas-name="{{ $data['group_value'] ?? '-' }}">
                                                        <i class="fa-solid fa-file-excel text-green-600 mr-2"></i>
                                                        Download ke Excel
                                                    </a>
                                                    {{-- <a href="#"
                                                        class="download-pdf-btn block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-600"
                                                        data-group-key="{{ $groupKey }}" data-semester="genap"
                                                        data-kelas-id="{{ $data['kelas']->id ?? '' }}"
                                                        data-kelas-name="{{ $data['group_value'] ?? '-' }}">
                                                        <i class="fa-solid fa-file-pdf text-red-600 mr-2"></i> Download
                                                        ke PDF
                                                    </a> --}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-content" data-tab="ganjil">
                                <div class="mapel-scroll pb-2">
                                    {{-- Tabel Nilai Siswa --}}
                                    <x-table>
                                        <x-thead>
                                            <tr>
                                                <x-th rowspan="3"
                                                    class="whitespace-nowrap w-14 align-middle">No.</x-th>
                                                <x-th rowspan="3"
                                                    class="whitespace-nowrap w-14 align-middle">NISN</x-th>
                                                <x-th rowspan="3" class="whitespace-nowrap align-middle"
                                                    style="min-width: 200px; width: 200px;">Nama Siswa</x-th>
                                                <x-th rowspan="3"
                                                    class="whitespace-nowrap w-14 align-middle">Status Input</x-th>
                                                @if (isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                                    @foreach ($data['mapel_heads'] as $mapelHead)
                                                        @if ($mapelHead->details->isNotEmpty())
                                                            <x-th colspan="{{ $mapelHead->details->count() * 2 }}"
                                                                class="text-center">
                                                                {{ $mapelHead->nama_mapel }}
                                                            </x-th>
                                                        @else
                                                            <x-th rowspan="2" colspan="2" class="text-center">
                                                                {{ $mapelHead->nama_mapel }}
                                                            </x-th>
                                                        @endif
                                                    @endforeach
                                                @endif
                                            </tr>
                                            <tr>
                                                @if (isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                                    @foreach ($data['mapel_heads'] as $mapelHead)
                                                        @if ($mapelHead->details->isNotEmpty())
                                                            @foreach ($mapelHead->details as $detail)
                                                                <x-th colspan="2"
                                                                    class="text-center mapel-col">{{ $detail->nama_mapel_detail }}</x-th>
                                                            @endforeach
                                                        @endif
                                                    @endforeach
                                                @endif
                                            </tr>
                                            <tr>
                                                @if (isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                                    @foreach ($data['mapel_heads'] as $mapelHead)
                                                        @if ($mapelHead->details->isNotEmpty())
                                                            @foreach ($mapelHead->details as $detail)
                                                                <x-th class="text-center mapel-col">Nilai</x-th>
                                                                <x-th class="text-center mapel-col">Deskripsi</x-th>
                                                            @endforeach
                                                        @else
                                                            <x-th class="text-center mapel-col">Nilai</x-th>
                                                            <x-th class="text-center mapel-col">Deskripsi</x-th>
                                                        @endif
                                                    @endforeach
                                                @endif
                                            </tr>
                                        </x-thead>
                                        <tbody id="tbody-ganjil-{{ $groupKey }}">
                                            @forelse($data['students'] as $key => $siswa)
                                                @php
                                                    $bookHead = isset($data['book_heads_ganjil'])
                                                        ? $data['book_heads_ganjil']->get($siswa->id)
                                                        : null;
                                                    $bookDetails = $bookHead
                                                        ? $bookHead->details->keyBy(function ($detail) {
                                                            return $detail->mapel_detail_id ??
                                                                'head_' . $detail->mapel_head_id;
                                                        })
                                                        : collect();

                                                    // Tentukan status input
                                                    $statusInput = 'Belum Input';
                                                    $statusClass = 'text-red-600 dark:text-red-400';

                                                    if (
                                                        $bookHead &&
                                                        isset($data['mapel_heads']) &&
                                                        $data['mapel_heads']->isNotEmpty()
                                                    ) {
                                                        $allFilled = true;

                                                        foreach ($data['mapel_heads'] as $mapelHead) {
                                                            if ($mapelHead->details->isNotEmpty()) {
                                                                foreach ($mapelHead->details as $detail) {
                                                                    $detailData = $bookDetails->get($detail->id);
                                                                    if (
                                                                        !$detailData ||
                                                                        empty($detailData->nilai_akhir) ||
                                                                        empty($detailData->deskripsi)
                                                                    ) {
                                                                        $allFilled = false;
                                                                        break 2;
                                                                    }
                                                                }
                                                            } else {
                                                                $headData = $bookDetails->get('head_' . $mapelHead->id);
                                                                if (
                                                                    !$headData ||
                                                                    empty($headData->nilai_akhir) ||
                                                                    empty($headData->deskripsi)
                                                                ) {
                                                                    $allFilled = false;
                                                                    break;
                                                                }
                                                            }
                                                        }

                                                        if ($allFilled) {
                                                            $statusInput = 'Sudah Input';
                                                            $statusClass = 'text-green-600 dark:text-green-400';
                                                        }
                                                    }
                                                @endphp
                                                <tr class="student-row"
                                                    data-nama="{{ strtolower($siswa->nama_siswa) }}"
                                                    data-nis="{{ $siswa->nis }}" data-nisn="{{ $siswa->nisn }}">
                                                    <x-td class="text-center py-2">{{ $key + 1 }}</x-td>
                                                    <x-td class="text-center py-2">{{ $siswa->nisn }}</x-td>
                                                    <x-td class="py-2">{{ $siswa->nama_siswa }}</x-td>
                                                    <x-td class="text-center py-2">
                                                        <span
                                                            class="font-semibold {{ $statusClass }}">{{ $statusInput }}</span>
                                                    </x-td>
                                                    @if (isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                                        @foreach ($data['mapel_heads'] as $mapelHead)
                                                            @if ($mapelHead->details->isNotEmpty())
                                                                @foreach ($mapelHead->details as $detail)
                                                                    @php
                                                                        $detailData = $bookDetails->get($detail->id);
                                                                    @endphp
                                                                    <x-td class="text-center py-2 mapel-col">
                                                                        <input type="number"
                                                                            class="nilai-input w-full text-center border-0 bg-transparent focus:ring-1 focus:ring-primary focus:border-primary disabled:bg-transparent"
                                                                            value="{{ $detailData ? $detailData->nilai_akhir : '' }}"
                                                                            placeholder="-"
                                                                            data-book-detail-id="{{ $detailData ? $detailData->id : '' }}"
                                                                            data-book-head-id="{{ $bookHead ? $bookHead->id : '' }}"
                                                                            data-siswa-id="{{ $siswa->id }}"
                                                                            data-mapel-detail-id="{{ $detail->id }}"
                                                                            data-type="detail" disabled readonly>
                                                                    </x-td>
                                                                    <x-td class="text-center py-2 mapel-col">
                                                                        <textarea
                                                                            class="deskripsi-input w-full min-w-[200px] border-0 bg-transparent focus:ring-1 focus:ring-primary focus:border-primary disabled:bg-transparent"
                                                                            placeholder="-" data-book-detail-id="{{ $detailData ? $detailData->id : '' }}"
                                                                            data-book-head-id="{{ $bookHead ? $bookHead->id : '' }}" data-siswa-id="{{ $siswa->id }}"
                                                                            data-mapel-detail-id="{{ $detail->id }}" data-type="detail" rows="1" disabled readonly>{{ $detailData ? $detailData->deskripsi : '' }}</textarea>
                                                                    </x-td>
                                                                @endforeach
                                                            @else
                                                                @php
                                                                    $headData = $bookDetails->get(
                                                                        'head_' . $mapelHead->id,
                                                                    );
                                                                @endphp
                                                                <x-td class="text-center py-2 mapel-col">
                                                                    <input type="number"
                                                                        class="nilai-input w-full text-center border-0 bg-transparent focus:ring-1 focus:ring-primary focus:border-primary disabled:bg-transparent"
                                                                        value="{{ $headData ? $headData->nilai_akhir : '' }}"
                                                                        placeholder="-"
                                                                        data-book-detail-id="{{ $headData ? $headData->id : '' }}"
                                                                        data-book-head-id="{{ $bookHead ? $bookHead->id : '' }}"
                                                                        data-siswa-id="{{ $siswa->id }}"
                                                                        data-mapel-head-id="{{ $mapelHead->id }}"
                                                                        data-type="head" disabled readonly>
                                                                </x-td>
                                                                <x-td class="text-center py-2 mapel-col">
                                                                    <textarea
                                                                        class="deskripsi-input w-full min-w-[200px] border-0 bg-transparent focus:ring-1 focus:ring-primary focus:border-primary disabled:bg-transparent"
                                                                        placeholder="-" data-book-detail-id="{{ $headData ? $headData->id : '' }}"
                                                                        data-book-head-id="{{ $bookHead ? $bookHead->id : '' }}" data-siswa-id="{{ $siswa->id }}"
                                                                        data-mapel-head-id="{{ $mapelHead->id }}" data-type="head" rows="1" disabled readonly>{{ $headData ? $headData->deskripsi : '' }}</textarea>
                                                                </x-td>
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                </tr>
                                            @empty
                                                <tr class="no-data-row">
                                                    <x-td
                                                        colspan="{{ 3 +(isset($data['mapel_heads'])? $data['mapel_heads']->sum(function ($m) {return $m->details->isNotEmpty() ? $m->details->count() * 2 : 2;}): 0) }}"
                                                        class="text-center text-gray-500">
                                                        Tidak ada siswa ditemukan
                                                    </x-td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </x-table>
                                </div>
                            </div>
                            <div class="tab-content hidden" data-tab="genap">
                                <div class="mapel-scroll pb-2">
                                    {{-- Tabel Nilai Siswa --}}
                                    <x-table>
                                        <x-thead>
                                            <tr>
                                                <x-th rowspan="3"
                                                    class="whitespace-nowrap w-14 align-middle">No.</x-th>
                                                <x-th rowspan="3"
                                                    class="whitespace-nowrap w-14 align-middle">NISN</x-th>
                                                <x-th rowspan="3" class="whitespace-nowrap align-middle"
                                                    style="min-width: 200px; width: 200px;">Nama Siswa</x-th>
                                                <x-th rowspan="3"
                                                    class="whitespace-nowrap w-14 align-middle">Status Input</x-th>
                                                @if (isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                                    @foreach ($data['mapel_heads'] as $mapelHead)
                                                        @if ($mapelHead->details->isNotEmpty())
                                                            <x-th colspan="{{ $mapelHead->details->count() * 2 }}"
                                                                class="text-center">
                                                                {{ $mapelHead->nama_mapel }}
                                                            </x-th>
                                                        @else
                                                            <x-th rowspan="2" colspan="2" class="text-center">
                                                                {{ $mapelHead->nama_mapel }}
                                                            </x-th>
                                                        @endif
                                                    @endforeach
                                                @endif
                                            </tr>
                                            <tr>
                                                @if (isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                                    @foreach ($data['mapel_heads'] as $mapelHead)
                                                        @if ($mapelHead->details->isNotEmpty())
                                                            @foreach ($mapelHead->details as $detail)
                                                                <x-th colspan="2"
                                                                    class="text-center mapel-col">{{ $detail->nama_mapel_detail }}</x-th>
                                                            @endforeach
                                                        @endif
                                                    @endforeach
                                                @endif
                                            </tr>
                                            <tr>
                                                @if (isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                                    @foreach ($data['mapel_heads'] as $mapelHead)
                                                        @if ($mapelHead->details->isNotEmpty())
                                                            @foreach ($mapelHead->details as $detail)
                                                                <x-th class="text-center mapel-col">Nilai</x-th>
                                                                <x-th class="text-center mapel-col">Deskripsi</x-th>
                                                            @endforeach
                                                        @else
                                                            <x-th class="text-center mapel-col">Nilai</x-th>
                                                            <x-th class="text-center mapel-col">Deskripsi</x-th>
                                                        @endif
                                                    @endforeach
                                                @endif
                                            </tr>
                                        </x-thead>
                                        <tbody id="tbody-genap-{{ $groupKey }}">
                                            @forelse($data['students'] as $key => $siswa)
                                                @php
                                                    $bookHead = isset($data['book_heads_genap'])
                                                        ? $data['book_heads_genap']->get($siswa->id)
                                                        : null;
                                                    $bookDetails = $bookHead
                                                        ? $bookHead->details->keyBy(function ($detail) {
                                                            return $detail->mapel_detail_id ??
                                                                'head_' . $detail->mapel_head_id;
                                                        })
                                                        : collect();

                                                    // Tentukan status input
                                                    $statusInput = 'Belum Input';
                                                    $statusClass = 'text-red-600 dark:text-red-400';

                                                    if (
                                                        $bookHead &&
                                                        isset($data['mapel_heads']) &&
                                                        $data['mapel_heads']->isNotEmpty()
                                                    ) {
                                                        $allFilled = true;

                                                        foreach ($data['mapel_heads'] as $mapelHead) {
                                                            if ($mapelHead->details->isNotEmpty()) {
                                                                foreach ($mapelHead->details as $detail) {
                                                                    $detailData = $bookDetails->get($detail->id);
                                                                    if (
                                                                        !$detailData ||
                                                                        empty($detailData->nilai_akhir) ||
                                                                        empty($detailData->deskripsi)
                                                                    ) {
                                                                        $allFilled = false;
                                                                        break 2;
                                                                    }
                                                                }
                                                            } else {
                                                                $headData = $bookDetails->get('head_' . $mapelHead->id);
                                                                if (
                                                                    !$headData ||
                                                                    empty($headData->nilai_akhir) ||
                                                                    empty($headData->deskripsi)
                                                                ) {
                                                                    $allFilled = false;
                                                                    break;
                                                                }
                                                            }
                                                        }

                                                        if ($allFilled) {
                                                            $statusInput = 'Sudah Input';
                                                            $statusClass = 'text-green-600 dark:text-green-400';
                                                        }
                                                    }
                                                @endphp
                                                <tr class="student-row"
                                                    data-nama="{{ strtolower($siswa->nama_siswa) }}"
                                                    data-nis="{{ $siswa->nis }}"
                                                    data-nisn="{{ $siswa->nisn }}">
                                                    <x-td class="text-center py-2">{{ $key + 1 }}</x-td>
                                                    <x-td class="text-center py-2">{{ $siswa->nisn }}</x-td>
                                                    <x-td class="py-2">{{ $siswa->nama_siswa }}</x-td>
                                                    <x-td class="text-center py-2">
                                                        <span
                                                            class="font-semibold {{ $statusClass }}">{{ $statusInput }}</span>
                                                    </x-td>
                                                    @if (isset($data['mapel_heads']) && $data['mapel_heads']->isNotEmpty())
                                                        @foreach ($data['mapel_heads'] as $mapelHead)
                                                            @if ($mapelHead->details->isNotEmpty())
                                                                @foreach ($mapelHead->details as $detail)
                                                                    @php
                                                                        $detailData = $bookDetails->get($detail->id);
                                                                    @endphp
                                                                    <x-td class="text-center py-2 mapel-col">
                                                                        <input type="number"
                                                                            class="nilai-input w-full text-center border-0 bg-transparent focus:ring-1 focus:ring-primary focus:border-primary disabled:bg-transparent"
                                                                            value="{{ $detailData ? $detailData->nilai_akhir : '' }}"
                                                                            placeholder="-"
                                                                            data-book-detail-id="{{ $detailData ? $detailData->id : '' }}"
                                                                            data-book-head-id="{{ $bookHead ? $bookHead->id : '' }}"
                                                                            data-siswa-id="{{ $siswa->id }}"
                                                                            data-mapel-detail-id="{{ $detail->id }}"
                                                                            data-type="detail" disabled readonly>
                                                                    </x-td>
                                                                    <x-td class="text-center py-2 mapel-col">
                                                                        <textarea
                                                                            class="deskripsi-input w-full min-w-[200px] border-0 bg-transparent focus:ring-1 focus:ring-primary focus:border-primary disabled:bg-transparent"
                                                                            placeholder="-" data-book-detail-id="{{ $detailData ? $detailData->id : '' }}"
                                                                            data-book-head-id="{{ $bookHead ? $bookHead->id : '' }}" data-siswa-id="{{ $siswa->id }}"
                                                                            data-mapel-detail-id="{{ $detail->id }}" data-type="detail" rows="1" disabled readonly>{{ $detailData ? $detailData->deskripsi : '' }}</textarea>
                                                                    </x-td>
                                                                @endforeach
                                                            @else
                                                                @php
                                                                    $headData = $bookDetails->get(
                                                                        'head_' . $mapelHead->id,
                                                                    );
                                                                @endphp
                                                                <x-td class="text-center py-2 mapel-col">
                                                                    <input type="number"
                                                                        class="nilai-input w-full text-center border-0 bg-transparent focus:ring-1 focus:ring-primary focus:border-primary disabled:bg-transparent"
                                                                        value="{{ $headData ? $headData->nilai_akhir : '' }}"
                                                                        placeholder="-"
                                                                        data-book-detail-id="{{ $headData ? $headData->id : '' }}"
                                                                        data-book-head-id="{{ $bookHead ? $bookHead->id : '' }}"
                                                                        data-siswa-id="{{ $siswa->id }}"
                                                                        data-mapel-head-id="{{ $mapelHead->id }}"
                                                                        data-type="head" disabled readonly>
                                                                </x-td>
                                                                <x-td class="text-center py-2 mapel-col">
                                                                    <textarea
                                                                        class="deskripsi-input w-full min-w-[200px] border-0 bg-transparent focus:ring-1 focus:ring-primary focus:border-primary disabled:bg-transparent"
                                                                        placeholder="-" data-book-detail-id="{{ $headData ? $headData->id : '' }}"
                                                                        data-book-head-id="{{ $bookHead ? $bookHead->id : '' }}" data-siswa-id="{{ $siswa->id }}"
                                                                        data-mapel-head-id="{{ $mapelHead->id }}" data-type="head" rows="1" disabled readonly>{{ $headData ? $headData->deskripsi : '' }}</textarea>
                                                                </x-td>
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                </tr>
                                            @empty
                                                <tr class="no-data-row">
                                                    <x-td
                                                        colspan="{{ 3 +(isset($data['mapel_heads'])? $data['mapel_heads']->sum(function ($m) {return $m->details->isNotEmpty() ? $m->details->count() * 2 : 2;}): 0) }}"
                                                        class="text-center text-gray-500">
                                                        Tidak ada siswa ditemukan
                                                    </x-td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </x-table>
                                </div>
                            </div>

                        </div>

                    </div>
                @endforeach
            @else
                <div
                    class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-gray-400 text-center">
                    <p class="text-gray-500">Tidak ada data siswa untuk tahun ajaran ini!</p>
                </div>
            @endif
        </div>

        {{-- Modal Import Nilai --}}
        <div id="importNilaiModal" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                    <form id="importNilaiForm" action="{{ route('buku-induk.import') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <!-- Modal header -->
                        <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                            <div class="flex items-center gap-1">
                                <i class="fa-solid fa-file-excel text-primary"></i>
                                <h3 class="text-xl font-semibold text-dark dark:text-light">
                                    Import Nilai Dari Excel
                                </h3>
                            </div>
                            <button type="button"
                                class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                                data-modal-hide="importNilaiModal">
                                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="none" viewBox="0 0 14 14">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                </svg>
                                <span class="sr-only">Close modal</span>
                            </button>
                        </div>
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="w-full">
                                <p class="mb-4 text-base" id="importNilaiMessage">
                                    <!-- Message will be inserted here by JavaScript -->
                                </p>

                                <div class="mb-4">
                                    <x-label for="excelFile" class="mb-2">Pilih File Excel <span
                                            class="text-red-500">*</span></x-label>
                                    <input type="file" name="file" id="excelFile" accept=".xlsx,.xls" required
                                        class="block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400">
                                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Format: .xlsx atau .xls
                                        (Max:
                                        10MB)</p>
                                </div>

                                <input type="hidden" name="semester" id="importSemester">
                                <input type="hidden" name="kelas_id" id="importKelasId">
                                <input type="hidden" name="tahun_ajaran" id="importTahunAjaran"
                                    value="{{ $selectedTahunAjaran }}">

                                <div
                                    class="p-3 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
                                    <p class="text-xs text-blue-800 dark:text-blue-300">
                                        <i class="fa-solid fa-circle-info mr-1"></i>
                                        <strong>Catatan:</strong> File Excel harus memiliki format yang sama dengan
                                        tabel
                                        nilai siswa. Kolom NISN akan dicocokkan dengan data siswa yang ada.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end gap-2 p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <button type="button"
                                class="px-5 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:bg-gray-600 dark:focus:ring-gray-600"
                                data-modal-hide="importNilaiModal">
                                Batal
                            </button>
                            <button type="submit"
                                class="px-5 py-2 text-sm font-medium text-white bg-primary rounded-lg hover:bg-hvPrimary focus:ring-4 focus:outline-none focus:ring-primary">
                                <i class="fa-solid fa-upload mr-1"></i> Import
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- Modal Delete Semua Nilai --}}
        <div id="deleteNilaiModal" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                    <form id="deleteNilaiForm" action="{{ route('buku-induk.deleteAllNilai') }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <!-- Modal header -->
                        <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                            <div class="flex items-center gap-1">
                                <i class="fa-solid fa-triangle-exclamation text-red-600"></i>
                                <h3 class="text-xl font-semibold text-dark dark:text-light">
                                    Konfirmasi Hapus Nilai
                                </h3>
                            </div>
                            <button type="button"
                                class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                                data-modal-hide="deleteNilaiModal">
                                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="none" viewBox="0 0 14 14">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                </svg>
                                <span class="sr-only">Close modal</span>
                            </button>
                        </div>
                        <!-- Modal body -->
                        <div class="p-4 md:p-5">
                            <div class="w-full">
                                <p class="mb-4 text-base text-gray-700 dark:text-gray-300" id="deleteNilaiMessage">
                                    <!-- Message will be inserted here by JavaScript -->
                                </p>

                                <input type="hidden" name="kelas_id" id="deleteKelasId">
                                <input type="hidden" name="semester" id="deleteSemester">
                                <input type="hidden" name="tahun_ajaran" id="deleteTahunAjaran">

                                <div
                                    class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
                                    <p class="text-sm text-red-800 dark:text-red-300">
                                        <i class="fa-solid fa-exclamation-triangle mr-2"></i>
                                        <strong>Peringatan:</strong> Tindakan ini akan menghapus semua data nilai siswa
                                        secara permanen dan tidak dapat dikembalikan!
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="flex items-center justify-end gap-2 p-4 md:p-5 border-t border-gray-200 rounded-b">
                            <button type="button"
                                class="px-5 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:bg-gray-600 dark:focus:ring-gray-600"
                                data-modal-hide="deleteNilaiModal">
                                Batal
                            </button>
                            <button type="submit"
                                class="px-5 py-2 text-sm font-medium text-white bg-red-600 rounded-lg hover:bg-red-700 focus:ring-4 focus:outline-none focus:ring-red-300">
                                <i class="fa-solid fa-trash mr-1"></i> Ya, Hapus Semua
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- Modal Validasi Wali Kelas --}}
        <div id="validasiWaliKelas" tabindex="-1" aria-hidden="true"
            class="zoom hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-[70] justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
            <div class="relative p-4 w-full max-w-2xl max-h-full">
                <!-- Modal content -->
                <div class="relative bg-light dark:bg-gray-800 rounded-lg shadow">
                    <!-- Modal header -->
                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t">
                        <div class="flex items-center gap-1">
                            <i class="fa-solid fa-triangle-exclamation text-red-600"></i>
                            <h3 class="text-xl font-semibold text-dark dark:text-light">
                                Peringatan
                            </h3>
                        </div>
                        <button type="button"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center"
                            data-modal-hide="validasiWaliKelas">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                    </div>
                    <!-- Modal body -->
                    <div class="p-4 md:p-5">
                        <div class="w-full">
                            <div class="text-center">
                                <h1 class="text-red-600 dark:text-red-400 text-center font-bold text-xl">PERHATIAN!
                                </h1>
                                <p class="mt-2">Tentukan <span class="font-bold">Wali Kelas</span> terlebih dahulu
                                    untuk kelas dan tahun ajaran ini sebelum melakukan input raport!
                                </p>
                                <a href="/wali-kelas-periode"
                                    class="inline-block mt-4 px-5 py-2 bg-primary text-white rounded-lg hover:bg-hvPrimary transition">
                                    <i class="fa-solid fa-user-tie"></i> Kelola Wali Kelas
                                </a>
                            </div>
                        </div>
                    </div>
                    <!-- Modal footer -->
                    <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b"></div>
                </div>
            </div>
        </div>

    </section>

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const tahunAjaranSelect = document.querySelector('select[name="tahun_ajaran"]');
                const kelasSelect = document.querySelector('select[name="kelasSelect"]');
                const semesterSelect = document.querySelector('select[name="semesterSelect"]');
                const tahunAjaranForm = document.getElementById('tahunAjaranForm');

                if (tahunAjaranSelect && tahunAjaranForm) {
                    tahunAjaranSelect.addEventListener('change', function() {
                        tahunAjaranForm.submit();
                    });
                }

                if (kelasSelect && tahunAjaranForm) {
                    kelasSelect.addEventListener('change', function() {
                        tahunAjaranForm.submit();
                    });
                }

                if (semesterSelect && tahunAjaranForm) {
                    semesterSelect.addEventListener('change', function() {
                        tahunAjaranForm.submit();
                    });
                }

                // Initialize tab switching first
                initializeTabSwitching();
                initializeKelasSearch();
                initializeWaliProgressTab();

                // Set active tab based on selected semester after initialization
                const selectedSemester = '{{ $selectedSemester ?? 'all' }}';

                setTimeout(() => {
                    if (selectedSemester === 'ganjil') {
                        // Activate Ganjil tab for all cards
                        document.querySelectorAll('.raport-card').forEach(card => {
                            const ganjilBtn = card.querySelector('.semester-tab[data-tab="ganjil"]');
                            if (ganjilBtn) {
                                ganjilBtn.click();
                            }
                        });
                    } else if (selectedSemester === 'genap') {
                        // Activate Genap tab for all cards
                        document.querySelectorAll('.raport-card').forEach(card => {
                            const genapBtn = card.querySelector('.semester-tab[data-tab="genap"]');
                            if (genapBtn) {
                                genapBtn.click();
                            }
                        });
                    }
                }, 100);

                function initializeKelasSearch() {
                    document.querySelectorAll('.kelas-search').forEach(searchInput => {
                        searchInput.addEventListener('input', function() {
                            const groupKey = this.getAttribute('data-group-key');
                            const searchTerm = this.value.toLowerCase();
                            const activeTable = document.querySelector(
                                `.raport-card[data-group-key="${groupKey}"] .tab-content:not(.hidden) tbody`
                            );

                            if (activeTable) {
                                const rows = activeTable.querySelectorAll('.student-row');
                                let visibleCount = 0;

                                rows.forEach(row => {
                                    const nama = (row.getAttribute('data-nama') || '')
                                        .toLowerCase();
                                    const nis = (row.getAttribute('data-nis') || '')
                                        .toLowerCase();
                                    const nisn = (row.getAttribute('data-nisn') || '')
                                        .toLowerCase();

                                    const isVisible = nama.includes(searchTerm) ||
                                        nis.includes(searchTerm) ||
                                        nisn.includes(searchTerm);

                                    if (isVisible) {
                                        row.style.display = '';
                                        const numberCell = row.querySelector('td:first-child');
                                        if (numberCell) {
                                            numberCell.textContent = visibleCount + 1;
                                        }
                                        visibleCount++;
                                    } else {
                                        row.style.display = 'none';
                                    }
                                });

                                const noDataRow = activeTable.querySelector('.no-data-row');
                                if (noDataRow) {
                                    noDataRow.style.display = visibleCount === 0 ? '' : 'none';
                                }
                            }
                        });
                    });
                }

                function initializeTabSwitching() {
                    document.querySelectorAll('.raport-card').forEach(card => {
                        const tabs = card.querySelectorAll('.semester-tab');
                        const tabContents = card.querySelectorAll('.tab-content');
                        const searchInput = card.querySelector('.kelas-search');

                        tabs.forEach(tabButton => {
                            tabButton.addEventListener('click', function() {
                                const selectedTab = this.getAttribute('data-tab');

                                tabs.forEach(btn => {
                                    if (btn.getAttribute('data-tab') === selectedTab) {
                                        btn.classList.add('tab-active',
                                            'border-hvPrimary', 'font-semibold',
                                            'text-primary', 'dark:text-hvPrimary',
                                            'border-b-2');
                                        btn.classList.remove('tab-inactive',
                                            'text-gray-600', 'dark:text-gray-400');
                                    } else {
                                        btn.classList.remove('tab-active',
                                            'border-hvPrimary', 'font-semibold',
                                            'text-primary', 'dark:text-hvPrimary',
                                            'border-b-2');
                                        btn.classList.add('tab-inactive',
                                            'text-gray-600', 'dark:text-gray-400');
                                    }
                                });

                                tabContents.forEach(content => {
                                    if (content.getAttribute('data-tab') ===
                                        selectedTab) {
                                        content.classList.remove('hidden');
                                    } else {
                                        content.classList.add('hidden');
                                    }
                                });

                                if (searchInput) {
                                    const event = new Event('input');
                                    searchInput.dispatchEvent(event);
                                }
                            });
                        });
                    });
                }
            });
        </script>

        <script>
            document.querySelectorAll('.kelasCardsContainer').forEach(container => {
                const groupKey = container.id;
                const tabs = container.querySelectorAll('.semester-tab');
                const contents = container.querySelectorAll('.tab-content');

                const activeTab = localStorage.getItem('activeTab_' + groupKey) || 'ganjil';

                function activateTab(tabName) {
                    tabs.forEach(tab => {
                        const isActive = tab.dataset.tab === tabName;

                        tab.classList.toggle('tab-active', isActive);
                        tab.classList.toggle('tab-inactive', !isActive);

                        // Tambahkan class aktif
                        tab.classList.toggle('text-primary', isActive);
                        tab.classList.toggle('dark:text-hvPrimary', isActive);
                        tab.classList.toggle('font-semibold', isActive);

                        // Hapus class aktif ketika nonaktif
                        tab.classList.toggle('text-gray-600', !isActive);
                        tab.classList.toggle('dark:text-gray-400', !isActive);
                        tab.classList.toggle('font-normal', !isActive);
                    });

                    contents.forEach(content => {
                        content.classList.toggle('hidden', content.dataset.tab !== tabName);
                    });

                    // Toggle semester buttons visibility
                    const semesterButtons = container.querySelectorAll('.semester-buttons');
                    semesterButtons.forEach(btnContainer => {
                        const btnSemester = btnContainer.getAttribute('data-semester');
                        btnContainer.classList.toggle('hidden', btnSemester !== tabName);
                    });
                }

                // Aktifkan tab tersimpan
                activateTab(activeTab);

                tabs.forEach(tab => {
                    tab.addEventListener('click', () => {
                        const selectedTab = tab.dataset.tab;
                        activateTab(selectedTab);
                        localStorage.setItem('activeTab_' + groupKey, selectedTab);
                    });
                });
            });
        </script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const pendingSuccessMessage = localStorage.getItem('bukuIndukUpdateSuccess');
                if (pendingSuccessMessage) {
                    toastr.options = {
                        "progressBar": true,
                        "closeButton": true,
                        "positionClass": "toast-top-right",
                        "timeOut": 3000
                    };
                    toastr.success(pendingSuccessMessage, 'SUKSES');
                    localStorage.removeItem('bukuIndukUpdateSuccess');
                }

                // Handle download raport button click
                document.querySelectorAll('.download-raport-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const groupKey = this.getAttribute('data-group-key');
                        const selectElement = document.querySelector(
                            `.download-raport-select[data-group-key="${groupKey}"]`
                        );

                        if (!selectElement) {
                            alert('Terjadi kesalahan: Select tidak ditemukan');
                            return;
                        }

                        const semesterOption = selectElement.value;
                        const card = this.closest('.raport-card');

                        if (!card) {
                            alert('Terjadi kesalahan: Card tidak ditemukan');
                            return;
                        }

                        // Get all students in this card
                        const studentRows = card.querySelectorAll('.student-row');
                        const raportHeadIds = [];

                        studentRows.forEach(row => {
                            // Cari tombol download yang aktif (tidak disabled) di row ini
                            let downloadLinks;

                            if (semesterOption === 'all') {
                                // Ambil semua tombol download yang tidak disabled
                                downloadLinks = row.querySelectorAll(
                                    'a[href*="raport"][href*="download"]:not([disabled])');
                            } else {
                                // Tentukan tab yang sesuai dengan semester
                                const tabContent = row.closest('.tab-content');
                                const tabSemester = tabContent ? tabContent.getAttribute(
                                    'data-tab') : null;

                                // Hanya ambil jika semester sesuai dengan pilihan
                                if ((semesterOption === 'Ganjil' && tabSemester === 'ganjil') ||
                                    (semesterOption === 'Genap' && tabSemester === 'genap')) {
                                    downloadLinks = row.querySelectorAll(
                                        'a[href*="raport"][href*="download"]:not([disabled])'
                                    );
                                }
                            }

                            if (downloadLinks && downloadLinks.length > 0) {
                                downloadLinks.forEach(link => {
                                    const href = link.getAttribute('href');
                                    // Extract raport head id from URL
                                    const matches = href.match(
                                        /raport\/(\d+)\/download/);
                                    if (matches && matches[1]) {
                                        raportHeadIds.push(matches[1]);
                                    }
                                });
                            }
                        });

                        if (raportHeadIds.length === 0) {
                            alert(
                                'Tidak ada raport yang tersedia untuk diunduh dengan filter yang dipilih.'
                            );
                            return;
                        }

                        // Redirect to download route with raport head ids and semester
                        const url = new URL('{{ route('raport.downloadBulk') }}', window.location
                            .origin);
                        url.searchParams.append('ids', raportHeadIds.join(','));
                        url.searchParams.append('semester', semesterOption);
                        url.searchParams.append('group_key', groupKey);

                        window.location.href = url.toString();
                    });
                });

                // Handle download all raport button in header
                const downloadAllBtn = document.getElementById('downloadAllRaport');
                if (downloadAllBtn) {
                    downloadAllBtn.addEventListener('click', function() {
                        const raportHeadIds = [];
                        const selectedSemesterFilter = '{{ $selectedSemester ?? 'all' }}';

                        // Get all raport cards
                        const allCards = document.querySelectorAll('.raport-card');

                        allCards.forEach(card => {
                            const studentRows = card.querySelectorAll('.student-row');

                            studentRows.forEach(row => {
                                let downloadLinks;

                                if (selectedSemesterFilter === 'all') {
                                    // Get all download links
                                    downloadLinks = row.querySelectorAll(
                                        'a[href*="raport"][href*="download"]:not([disabled])'
                                    );
                                } else {
                                    // Get download links based on selected semester
                                    const tabContent = row.closest('.tab-content');
                                    const tabSemester = tabContent ? tabContent.getAttribute(
                                        'data-tab') : null;

                                    if ((selectedSemesterFilter === 'ganjil' && tabSemester ===
                                            'ganjil') ||
                                        (selectedSemesterFilter === 'genap' && tabSemester ===
                                            'genap')) {
                                        downloadLinks = row.querySelectorAll(
                                            'a[href*="raport"][href*="download"]:not([disabled])'
                                        );
                                    }
                                }

                                if (downloadLinks && downloadLinks.length > 0) {
                                    downloadLinks.forEach(link => {
                                        const href = link.getAttribute('href');
                                        const matches = href.match(
                                            /raport\/(\d+)\/download/);
                                        if (matches && matches[1]) {
                                            raportHeadIds.push(matches[1]);
                                        }
                                    });
                                }
                            });
                        });

                        if (raportHeadIds.length === 0) {
                            alert('Tidak ada raport yang tersedia untuk diunduh dengan filter yang dipilih.');
                            return;
                        }

                        // Redirect to download route
                        const url = new URL('{{ route('raport.downloadBulk') }}', window.location.origin);
                        url.searchParams.append('ids', raportHeadIds.join(','));
                        url.searchParams.append('semester', selectedSemesterFilter);

                        window.location.href = url.toString();
                    });
                }

                // Initialize Wali Progress Tab Switching
                function initializeWaliProgressTab() {
                    const waliProgressTabs = document.querySelectorAll('.semester-tab-wali-progress');

                    waliProgressTabs.forEach(tab => {
                        tab.addEventListener('click', function() {
                            const semester = this.getAttribute('data-semester');
                            const card = this.closest('.bg-gray-50');

                            // Update tab styles
                            card.querySelectorAll('.semester-tab-wali-progress').forEach(t => {
                                t.classList.remove('text-primary', 'dark:text-hvPrimary',
                                    'border-primary');
                                t.classList.add('text-gray-600', 'dark:text-gray-400',
                                    'border-transparent');
                            });

                            this.classList.remove('text-gray-600', 'dark:text-gray-400',
                                'border-transparent');
                            this.classList.add('text-primary', 'dark:text-hvPrimary', 'border-primary');

                            // Show/hide content
                            card.querySelectorAll('.semester-content-wali-progress').forEach(
                                content => {
                                    const contentSemester = content.getAttribute('data-semester');

                                    if (contentSemester === semester) {
                                        content.classList.remove('hidden');
                                    } else {
                                        content.classList.add('hidden');
                                    }
                                });
                        });
                    });
                }

                // Initialize Download Dropdown
                document.querySelectorAll('.download-dropdown-btn').forEach(button => {
                    button.addEventListener('click', function(e) {
                        e.stopPropagation();
                        const groupKey = this.getAttribute('data-group-key');
                        const semester = this.getAttribute('data-semester');

                        // Find the dropdown menu
                        const dropdown = document.querySelector(
                            `.download-dropdown-menu[data-group-key="${groupKey}"][data-semester="${semester}"]`
                        );

                        // Close all other dropdowns
                        document.querySelectorAll('.download-dropdown-menu').forEach(menu => {
                            if (menu !== dropdown) {
                                menu.classList.add('hidden');
                            }
                        });

                        // Toggle this dropdown
                        if (dropdown) {
                            dropdown.classList.toggle('hidden');
                        }
                    });
                });

                // Close dropdown when clicking outside
                document.addEventListener('click', function(e) {
                    if (!e.target.closest('.download-dropdown-btn') && !e.target.closest(
                            '.download-dropdown-menu')) {
                        document.querySelectorAll('.download-dropdown-menu').forEach(menu => {
                            menu.classList.add('hidden');
                        });
                    }
                });

                // Handle Download Excel Button
                document.querySelectorAll('.download-excel-btn').forEach(button => {
                    button.addEventListener('click', function(e) {
                        e.preventDefault();
                        const groupKey = this.getAttribute('data-group-key');
                        const semester = this.getAttribute('data-semester');
                        const kelasId = this.getAttribute('data-kelas-id');
                        const kelasName = this.getAttribute('data-kelas-name');

                        if (!kelasId) {
                            alert('Terjadi kesalahan: Kelas ID tidak ditemukan');
                            return;
                        }

                        // Build download URL
                        const url = new URL('{{ route('buku-induk.downloadExcel') }}', window.location
                            .origin);
                        url.searchParams.append('kelas_id', kelasId);
                        url.searchParams.append('semester', semester);
                        url.searchParams.append('tahun_ajaran', '{{ $selectedTahunAjaran }}');
                        url.searchParams.append('kelas_name', kelasName);

                        // Redirect to download
                        window.location.href = url.toString();

                        // Close dropdown
                        const dropdown = this.closest('.download-dropdown-menu');
                        if (dropdown) {
                            dropdown.classList.add('hidden');
                        }
                    });
                });

                // Handle Download PDF Button
                document.querySelectorAll('.download-pdf-btn').forEach(button => {
                    button.addEventListener('click', function(e) {
                        e.preventDefault();
                        const groupKey = this.getAttribute('data-group-key');
                        const semester = this.getAttribute('data-semester');
                        const kelasId = this.getAttribute('data-kelas-id');
                        const kelasName = this.getAttribute('data-kelas-name');

                        if (!kelasId) {
                            alert('Terjadi kesalahan: Kelas ID tidak ditemukan');
                            return;
                        }

                        // Build download URL
                        const url = new URL('{{ route('buku-induk.downloadPDF') }}', window.location
                            .origin);
                        url.searchParams.append('kelas_id', kelasId);
                        url.searchParams.append('semester', semester);
                        url.searchParams.append('tahun_ajaran', '{{ $selectedTahunAjaran }}');
                        url.searchParams.append('kelas_name', kelasName);

                        // Redirect to download
                        window.location.href = url.toString();

                        // Close dropdown
                        const dropdown = this.closest('.download-dropdown-menu');
                        if (dropdown) {
                            dropdown.classList.add('hidden');
                        }
                    });
                });

                // Handle Import Nilai Button Click - Update modal content before showing
                document.querySelectorAll('.import-nilai-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const groupKey = this.getAttribute('data-group-key');
                        const kelasName = this.getAttribute('data-kelas-name');

                        // Find the card for this group
                        const card = document.querySelector(
                            `.raport-card[data-group-key="${groupKey}"]`);

                        if (!card) {
                            alert('Terjadi kesalahan: Card tidak ditemukan');
                            return;
                        }

                        // Find the active tab (semester)
                        const activeTab = card.querySelector('.semester-tab.tab-active');

                        if (!activeTab) {
                            alert('Terjadi kesalahan: Tab aktif tidak ditemukan');
                            return;
                        }

                        const activeSemester = activeTab.getAttribute('data-tab');
                        const semesterText = activeSemester === 'ganjil' ? 'Ganjil' : 'Genap';

                        // Extract kelas_id from groupKey (format: kelas-{id})
                        const kelasId = groupKey.replace('kelas-', '');

                        // Set the modal message
                        const messageElement = document.getElementById('importNilaiMessage');
                        messageElement.innerHTML =
                            `Anda akan mengimpor nilai siswa kelas <strong>${kelasName}</strong> pada semester <strong>${semesterText}</strong>.`;

                        // Set hidden form fields
                        document.getElementById('importSemester').value = activeSemester;
                        document.getElementById('importKelasId').value = kelasId;

                        // Reset file input
                        document.getElementById('excelFile').value = '';
                    });
                });

                // Handle Delete Nilai Button Click - Update modal content before showing
                document.querySelectorAll('.delete-nilai-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const groupKey = this.getAttribute('data-group-key');
                        const kelasName = this.getAttribute('data-kelas-name');
                        const semester = this.getAttribute('data-semester');

                        // Extract kelas_id from groupKey (format: kelas-{id} or angkatan-{year})
                        let kelasId = '';
                        if (groupKey.startsWith('kelas-')) {
                            kelasId = groupKey.replace('kelas-', '');
                        }

                        // Set the modal message
                        const messageElement = document.getElementById('deleteNilaiMessage');
                        messageElement.innerHTML =
                            `Apakah anda yakin akan menghapus seluruh nilai siswa dari kelas <strong>${kelasName}</strong> pada semester <strong>${semester}</strong>?`;

                        // Set hidden form fields
                        document.getElementById('deleteSemester').value = semester;
                        document.getElementById('deleteKelasId').value = kelasId;
                        document.getElementById('deleteTahunAjaran').value =
                            '{{ $selectedTahunAjaran }}';
                    });
                });

                // Handle Edit Nilai Button Click
                document.querySelectorAll('.edit-nilai-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const groupKey = this.getAttribute('data-group-key');
                        const card = document.querySelector(
                            `.raport-card[data-group-key="${groupKey}"]`);

                        if (!card) return;

                        // Find active semester tab
                        const activeTab = card.querySelector('.semester-tab.tab-active');
                        const activeSemester = activeTab ? activeTab.getAttribute('data-tab') :
                            'ganjil';

                        // Get the active tab content
                        const tabContent = card.querySelector(
                            `.tab-content[data-tab="${activeSemester}"]`);
                        if (!tabContent) return;

                        // Enable all inputs in this tab
                        const inputs = tabContent.querySelectorAll('.nilai-input, .deskripsi-input');
                        inputs.forEach(input => {
                            input.removeAttribute('disabled');
                            input.removeAttribute('readonly');
                            input.classList.add('border', 'border-gray-300', 'rounded');
                            input.classList.remove('border-0');

                            // Auto-resize textarea on input
                            if (input.tagName === 'TEXTAREA') {
                                input.addEventListener('input', function() {
                                    this.style.height = 'auto';
                                    this.style.height = (this.scrollHeight) + 'px';
                                });
                            }
                        });

                        // Toggle buttons
                        const semesterButtons = card.querySelector(
                            `.semester-buttons[data-semester="${activeSemester}"]`);
                        if (semesterButtons) {
                            semesterButtons.querySelector('.edit-nilai-btn').classList.add('hidden');
                            semesterButtons.querySelector('.cancel-edit-btn').classList.remove(
                                'hidden');
                            semesterButtons.querySelector('.save-nilai-btn').classList.remove('hidden');

                            // Hide delete/import buttons during edit
                            const deleteBtn = semesterButtons.querySelector('.delete-nilai-btn');
                            const importBtn = semesterButtons.querySelector('.import-nilai-btn');
                            if (deleteBtn) deleteBtn.classList.add('hidden');
                            if (importBtn) importBtn.classList.add('hidden');
                        }
                    });
                });

                // Handle Cancel Edit Button Click
                document.querySelectorAll('.cancel-edit-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const groupKey = this.getAttribute('data-group-key');
                        const card = document.querySelector(
                            `.raport-card[data-group-key="${groupKey}"]`);

                        if (!card) return;

                        // Find active semester tab
                        const activeTab = card.querySelector('.semester-tab.tab-active');
                        const activeSemester = activeTab ? activeTab.getAttribute('data-tab') :
                            'ganjil';

                        // Reload page to reset values
                        location.reload();
                    });
                });

                // Handle Save Nilai Button Click
                document.querySelectorAll('.save-nilai-btn').forEach(button => {
                    button.addEventListener('click', function() {
                        const groupKey = this.getAttribute('data-group-key');
                        const card = document.querySelector(
                            `.raport-card[data-group-key="${groupKey}"]`);

                        if (!card) return;

                        // Find active semester tab
                        const activeTab = card.querySelector('.semester-tab.tab-active');
                        const activeSemester = activeTab ? activeTab.getAttribute('data-tab') :
                            'ganjil';

                        // Get the active tab content
                        const tabContent = card.querySelector(
                            `.tab-content[data-tab="${activeSemester}"]`);
                        if (!tabContent) return;

                        // Collect all changed data
                        const updates = [];
                        const inputs = tabContent.querySelectorAll('.nilai-input, .deskripsi-input');

                        inputs.forEach(input => {
                            const bookDetailId = input.getAttribute('data-book-detail-id');
                            const bookHeadId = input.getAttribute('data-book-head-id');
                            const siswaId = input.getAttribute('data-siswa-id');
                            const mapelDetailId = input.getAttribute('data-mapel-detail-id');
                            const mapelHeadId = input.getAttribute('data-mapel-head-id');
                            const type = input.getAttribute('data-type');
                            const isNilai = input.classList.contains('nilai-input');
                            const value = input.value.trim();

                            // Find or create update entry for this detail
                            let updateEntry = updates.find(u =>
                                u.book_detail_id === bookDetailId &&
                                u.siswa_id === siswaId &&
                                u.type === type &&
                                (type === 'detail' ? u.mapel_detail_id === mapelDetailId : u
                                    .mapel_head_id === mapelHeadId)
                            );

                            if (!updateEntry) {
                                updateEntry = {
                                    book_detail_id: bookDetailId,
                                    book_head_id: bookHeadId,
                                    siswa_id: siswaId,
                                    mapel_detail_id: mapelDetailId,
                                    mapel_head_id: mapelHeadId,
                                    type: type,
                                    nilai_akhir: null,
                                    deskripsi: null
                                };
                                updates.push(updateEntry);
                            }

                            if (isNilai) {
                                updateEntry.nilai_akhir = value !== '' ? value : null;
                            } else {
                                updateEntry.deskripsi = value !== '' ? value : null;
                            }
                        });

                        // Send AJAX request to save
                        fetch('{{ route('buku-induk.updateNilai') }}', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                },
                                body: JSON.stringify({
                                    updates: updates,
                                    semester: activeSemester,
                                    tahun_ajaran: '{{ $selectedTahunAjaran }}'
                                })
                            })
                            .then(response => response.json())
                            .then(data => {
                                if (data.success) {
                                    const successMessage = data.message ||
                                        'Berhasil menyimpan perubahan nilai!';
                                    localStorage.setItem('bukuIndukUpdateSuccess', successMessage);
                                    location.reload();
                                } else {
                                    toastr.options = {
                                        "progressBar": true,
                                        "closeButton": true,
                                        "positionClass": "toast-top-right",
                                        "timeOut": 5000
                                    };
                                    toastr.error(data.message || 'Terjadi kesalahan', 'ERROR');
                                }
                            })
                            .catch(error => {
                                console.error('Error:', error);
                                toastr.options = {
                                    "progressBar": true,
                                    "closeButton": true,
                                    "positionClass": "toast-top-right",
                                    "timeOut": 5000
                                };
                                toastr.error('Terjadi kesalahan saat menyimpan data', 'ERROR');
                            });
                    });
                });
            });
        </script>
    @endpush

</x-app-layout>
