<title>Edit Nilai Siswa</title>
<x-app-layout>
    <x-slot name="header"></x-slot>

    <section class="p-6 lg:ml-[285px] mt-16" id="sectionDashboard">
        <div class="md:flex justify-between mb-4">
            <div>
                <h1>
                    <div class="flex gap-2 items-start">
                        <a href="{{ route('raport.index') }}" class="mt-1 hover:text-hvPrimary">
                            <i class="fa-solid fa-arrow-left text-xl"></i>
                        </a>
                        <div>
                            <p class="text-xl sm:text-2xl font-bold">Edit Raport</p>
                            <p class="text-xs sm:text-sm ms-[1px]">Index / Edit Nilai Siswa</p>
                        </div>
                    </div>
                </h1>
            </div>
        </div>

        @php
            $madrasah = 'MTSs AL Ikhlas Panganten';
            $alamat = 'Kp. Panganten';

            $ekskulEntries = old(
                'ekstrakurikuler',
                $ekskulPengisian
                    ->map(
                        fn($row) => [
                            'kegiatan_id' => $row->ekskul_id,
                            'nilai_id' => $row->ket_nilai,
                            'keterangan' => $row->keterangan,
                        ],
                    )
                    ->toArray(),
            );
            if (!is_array($ekskulEntries) || count($ekskulEntries) === 0) {
                $ekskulEntries = [
                    [
                        'kegiatan_id' => null,
                        'nilai_id' => null,
                        'keterangan' => null,
                    ],
                ];
            }
            $ekskulEntries = array_values($ekskulEntries);

            $prestasiEntries = old(
                'prestasi',
                $prestasiPengisian
                    ->map(
                        fn($row) => [
                            'jenis' => $row->jenis_prestasi,
                            'keterangan' => $row->keterangan,
                        ],
                    )
                    ->toArray(),
            );
            if (!is_array($prestasiEntries) || count($prestasiEntries) === 0) {
                $prestasiEntries = [
                    [
                        'jenis' => null,
                        'keterangan' => null,
                    ],
                ];
            }
            $prestasiEntries = array_values($prestasiEntries);
        @endphp

        {{-- Form Edit Data --}}
        <form action="{{ route('raport.update', $raportHead->id) }}" method="POST" enctype="multipart/form-data"
            class="w-full shadow rounded-md p-5 bg-gray-50 text-gray-900 dark:bg-gray-800 dark:text-gray-50 border-t-4 border-primary">
            @csrf
            @method('PUT')
            <input type="hidden" name="total_nilai_akhir" id="input-total-nilai-akhir"
                value="{{ old('total_nilai_akhir', $raportHead->jml_nilai_akhir ?? 0) }}">
            <input type="hidden" name="siswa_id" value="{{ $siswa->id }}">

            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4 mb-6">
                <div class="flex justify-center sm:justify-start sm:w-32">
                    <img src="{{ asset('img/logoUtama.png') }}" alt="Logo Kiri" class="w-24 h-24 object-contain" />
                </div>
                <div class="text-center flex-1">
                    <p class="text-xs sm:text-sm font-semibold uppercase tracking-wide">Kementerian Agama Republik
                        Indonesia</p>
                    <p class="text-lg sm:text-xl font-bold uppercase">{{ $madrasah }}</p>
                    <p class="italic text-xs sm:text-sm">{{ $alamat }}</p>
                    <p class="italic text-[11px] sm:text-xs">Kecamatan Cigalontang, Kabupaten Tasikmalaya - Jawa Barat
                    </p>
                </div>
                <div class="flex justify-center sm:justify-end sm:w-32">
                    <img src="{{ asset('img/logoKedua.png') }}" alt="Logo Kanan" class="w-24 h-24 object-contain" />
                </div>
            </div>

            <div class="border-y-2 border-gray-600 py-4 text-xs sm:text-sm">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-y-1 md:gap-y-2 gap-x-6">
                    <div class="flex items-start gap-2">
                        <span class="w-28 md:w-24 font-semibold uppercase">Nama</span>
                        <span>:</span>
                        <span class="flex-1 font-semibold uppercase">{{ $siswa->nama_siswa }}</span>
                    </div>
                    <div class="flex items-start gap-2">
                        <span class="w-28 md:w-28 font-semibold uppercase">Kelas</span>
                        <span>:</span>
                        <span class="flex-1 font-semibold uppercase">{{ $kelasDisplay ?? '-' }}</span>
                    </div>

                    <div class="flex items-start gap-2">
                        <span class="w-28 md:w-24 font-semibold uppercase">NIS/NISN</span>
                        <span>:</span>
                        <span class="flex-1">{{ $siswa->nis }} / {{ $siswa->nisn }}</span>
                    </div>
                    <div class="flex items-start gap-2">
                        <span class="w-28 md:w-28 font-semibold uppercase">Fase</span>
                        <span>:</span>
                        <span class="flex-1 uppercase">{{ $fase ?? '-' }}</span>
                    </div>

                    <div class="flex items-start gap-2">
                        <span class="w-28 md:w-24 font-semibold uppercase">Madrasah</span>
                        <span>:</span>
                        <span class="flex-1 uppercase">{{ $madrasah }}</span>
                    </div>
                    <div class="flex items-start gap-2">
                        <span class="w-28 md:w-28 font-semibold uppercase">Semester</span>
                        <span>:</span>
                        <span class="flex-1 uppercase">{{ $semester ?? '-' }}</span>
                    </div>

                    <div class="flex items-start gap-2">
                        <span class="w-28 md:w-24 font-semibold uppercase">Alamat</span>
                        <span>:</span>
                        <span class="flex-1 uppercase">{{ $alamat }}</span>
                    </div>
                    <div class="flex items-start gap-2">
                        <span class="w-28 md:w-28 font-semibold uppercase">Tahun Ajaran</span>
                        <span>:</span>
                        <span class="flex-1 uppercase">{{ $tahunAjaran ?? '-' }}</span>
                    </div>
                </div>
            </div>

            <div class="mt-8">
                <h2 class="text-center font-bold uppercase text-sm sm:text-base mb-4">Capaian Hasil Belajar</h2>
                <div class="overflow-x-auto">
                    <table class="w-full border border-gray-600 text-xs sm:text-sm">
                        <x-thead>
                            <x-tr>
                                <x-th class="w-12 text-center">No.</x-th>
                                <x-th class="w-1/3 text-center">Mata Pelajaran</x-th>
                                <x-th class="w-24 text-center">Nilai Akhir</x-th>
                                <x-th class="text-center">Capaian Kompetensi</x-th>
                            </x-tr>
                        </x-thead>
                        <tbody>
                            @php $rowNumber = 1; @endphp
                            @foreach ($mapelHeads as $headIndex => $head)
                                @php
                                    $details = $head->details;
                                    $detailsCount = $details->count();
                                    $rowspan = $detailsCount > 0 ? $detailsCount + 1 : 1;
                                    $hasDetails = $detailsCount > 0;
                                    $headScore = $headScores->get($head->id);
                                @endphp
                                <x-tr class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                    <x-td class="px-3 py-2 text-center align-top" rowspan="{{ $rowspan }}">
                                        {{ $rowNumber++ }}.
                                    </x-td>
                                    <x-td class="px-3 py-2">{{ $head->nama_mapel }}</x-td>
                                    <x-td class="px-3 py-2 text-center">
                                        @if ($hasDetails)
                                            <span></span>
                                        @else
                                            <x-input type="number" min="0" max="100" step="1"
                                                name="mapel_heads[{{ $head->id }}][nilai_akhir]"
                                                class="nilai-input text-center" data-group="head-{{ $head->id }}"
                                                placeholder="0"
                                                value="{{ old('mapel_heads.' . $head->id . '.nilai_akhir', optional($headScore)->nilai_akhir) }}"
                                                required />
                                        @endif
                                    </x-td>
                                    <x-td class="px-3 py-2">
                                        @if ($hasDetails)
                                            <span class="text-gray-500"></span>
                                        @else
                                            <x-textarea name="mapel_heads[{{ $head->id }}][capaian_kompetensi]"
                                                rows="1" class="capitalize-input"
                                                placeholder="Masukan Keterangan..."
                                                required>{{ old('mapel_heads.' . $head->id . '.capaian_kompetensi', optional($headScore)->deskripsi) }}</x-textarea>
                                        @endif
                                    </x-td>
                                </x-tr>
                                @foreach ($details as $detailIndex => $detail)
                                    @php
                                        $detailScore = $detailScores->get($detail->id);
                                    @endphp
                                    <tr>
                                        <x-td class="px-3 py-2 pl-6">
                                            <span>{{ chr(65 + $detailIndex) }}.
                                                {{ $detail->nama_mapel_detail }}</span>
                                        </x-td>
                                        <x-td class="px-3 py-2 text-center">
                                            <x-input type="number" min="0" max="100" step="1"
                                                name="mapel_details[{{ $detail->id }}][nilai_akhir]"
                                                class="nilai-input text-center" data-group="detail-{{ $detail->id }}"
                                                placeholder="0"
                                                value="{{ old('mapel_details.' . $detail->id . '.nilai_akhir', optional($detailScore)->nilai_akhir) }}"
                                                required />
                                        </x-td>
                                        <x-td class="px-3 py-2">
                                            <x-textarea name="mapel_details[{{ $detail->id }}][capaian_kompetensi]"
                                                rows="1" class="capitalize-input"
                                                placeholder="Masukan Keterangan..."
                                                required>{{ old('mapel_details.' . $detail->id . '.capaian_kompetensi', optional($detailScore)->deskripsi) }}</x-textarea>
                                        </x-td>
                                    </tr>
                                @endforeach
                            @endforeach
                        </tbody>
                        <tfoot>
                            <x-tr class="font-semibold">
                                <x-td colspan="2" class="px-3 py-2 text-right">Jumlah</x-td>
                                <x-td class="px-3 py-2 text-center" id="total-nilai-akhir">
                                    {{ old('total_nilai_akhir', $raportHead->jml_nilai_akhir ?? 0) }}
                                </x-td>
                                <x-td class="px-3 py-2"></x-td>
                            </x-tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="mt-8 space-y-8">
                <div>
                    <div class="flex justify-between items-center mb-2">
                        <h3 class="font-bold uppercase text-sm sm:text-base">Ekstrakurikuler</h3>
                        <x-btn-add type="button" id="add-ekstrakurikuler" class="text-xs text-light">
                            <i class="fas fa-plus"></i> Tambah
                        </x-btn-add>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-600 border-collapse text-xs sm:text-sm">
                            <x-thead>
                                <x-tr>
                                    <x-th class="w-12 text-center">No.</x-th>
                                    <x-th class="text-center">Kegiatan Ekstrakurikuler</x-th>
                                    <x-th class="text-center">Nilai</x-th>
                                    <x-th class="text-center">Keterangan</x-th>
                                    <x-th id="ekskul-aksi-header"
                                        class="w-16 text-center {{ count($ekskulEntries) > 1 ? '' : 'hidden' }}">Aksi</x-th>
                                </x-tr>
                            </x-thead>
                            <tbody id="ekstrakurikuler-tbody">
                                @foreach ($ekskulEntries as $index => $row)
                                    <x-tr class="ekstrakurikuler-row">
                                        <x-td class="px-3 py-2 text-center">{{ $index + 1 }}</x-td>
                                        <x-td class="px-3 py-2">
                                            <x-select name="ekstrakurikuler[{{ $index }}][kegiatan_id]"
                                                class="w-full">
                                                <option value="">-- Pilih Ekskul --</option>
                                                @foreach ($ekskuls as $ekskul)
                                                    <option value="{{ $ekskul->id }}"
                                                        {{ (string) old('ekstrakurikuler.' . $index . '.kegiatan_id', $row['kegiatan_id']) === (string) $ekskul->id ? 'selected' : '' }}>
                                                        {{ $ekskul->nama_ekskul }}
                                                    </option>
                                                @endforeach
                                            </x-select>
                                        </x-td>
                                        <x-td class="px-3 py-2">
                                            <x-select name="ekstrakurikuler[{{ $index }}][nilai_id]"
                                                class="w-full">
                                                <option value="">-- Pilih Ket. Nilai --</option>
                                                @foreach ($ketNilaiList as $nilai)
                                                    <option value="{{ $nilai->id }}"
                                                        {{ (string) old('ekstrakurikuler.' . $index . '.nilai_id', $row['nilai_id']) === (string) $nilai->id ? 'selected' : '' }}>
                                                        {{ $nilai->nama_keterangan }}
                                                    </option>
                                                @endforeach
                                            </x-select>
                                        </x-td>
                                        <x-td class="px-3 py-2">
                                            <x-textarea name="ekstrakurikuler[{{ $index }}][keterangan]"
                                                rows="1" class="w-full capitalize-input"
                                                placeholder="Masukan Keterangan...">{{ old('ekstrakurikuler.' . $index . '.keterangan', $row['keterangan']) }}</x-textarea>
                                        </x-td>
                                        <x-td
                                            class="px-3 py-2 text-center aksi-cell-ekskul {{ count($ekskulEntries) > 1 ? '' : 'hidden' }}">
                                            <button type="button" class="remove-row text-red-500 hover:text-red-700"
                                                {{ count($ekskulEntries) > 1 ? '' : 'disabled' }}>
                                                <i class="fa-solid fa-x"></i>
                                            </button>
                                        </x-td>
                                    </x-tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div>
                    <div class="flex justify-between items-center mb-2">
                        <h3 class="font-bold uppercase text-sm sm:text-base">Prestasi</h3>
                        <x-btn-add type="button" id="add-prestasi" class="text-xs text-light">
                            <i class="fas fa-plus"></i> Tambah
                        </x-btn-add>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-600 border-collapse text-xs sm:text-sm">
                            <x-thead>
                                <x-tr>
                                    <x-th class="w-12 text-center">No.</x-th>
                                    <x-th class="text-center">Jenis Prestasi</x-th>
                                    <x-th class="text-center">Keterangan</x-th>
                                    <x-th id="prestasi-aksi-header"
                                        class="w-16 text-center {{ count($prestasiEntries) > 1 ? '' : 'hidden' }}">Aksi
                                    </x-th>
                                </x-tr>
                            </x-thead>
                            <tbody id="prestasi-tbody">
                                @foreach ($prestasiEntries as $index => $row)
                                    <x-tr class="prestasi-row">
                                        <x-td class="px-3 py-2 text-center">{{ $index + 1 }}</x-td>
                                        <x-td class="px-3 py-2">
                                            <x-input type="text" name="prestasi[{{ $index }}][jenis]"
                                                class="w-full capitalize-input"
                                                placeholder="Masukan Jenis Prestasi..."
                                                value="{{ old('prestasi.' . $index . '.jenis', $row['jenis']) }}" />
                                        </x-td>
                                        <x-td class="px-3 py-2">
                                            <x-textarea name="prestasi[{{ $index }}][keterangan]"
                                                rows="1" class="w-full capitalize-input"
                                                placeholder="Masukan Keterangan...">{{ old('prestasi.' . $index . '.keterangan', $row['keterangan']) }}</x-textarea>
                                        </x-td>
                                        <x-td
                                            class="px-3 py-2 text-center aksi-cell-prestasi {{ count($prestasiEntries) > 1 ? '' : 'hidden' }}">
                                            <button type="button" class="remove-row text-red-500 hover:text-red-700"
                                                {{ count($prestasiEntries) > 1 ? '' : 'disabled' }}>
                                                <i class="fa-solid fa-x"></i>
                                            </button>
                                        </x-td>
                                    </x-tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div>
                    <h3 class="font-bold uppercase text-sm sm:text-base mb-2">Ketidakhadiran</h3>
                    <div class="overflow-x-auto">
                        <table class="w-full border border-gray-600 border-collapse text-xs sm:text-sm">
                            <tbody>
                                @php
                                    $ketidakhadiranTypes = [
                                        'sakit' => 'Sakit',
                                        'izin' => 'Izin',
                                        'alpa' => 'Alpa',
                                    ];
                                @endphp
                                @foreach ($ketidakhadiranTypes as $key => $label)
                                    <x-tr>
                                        <x-td class="px-3 py-2 font-semibold">{{ $label }}</x-td>
                                        <x-td class="px-3 py-2 w-32">
                                            <x-input type="number" min="0" step="1"
                                                name="ketidakhadiran[{{ $key }}]" class="text-center"
                                                placeholder="0"
                                                value="{{ old('ketidakhadiran.' . $key, $ketidakhadiran[$key] ?? 0) }}"
                                                required />
                                        </x-td>
                                        <x-td class="px-3 py-2 w-24 text-center">Hari</x-td>
                                    </x-tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div>
                    <h3 class="font-bold uppercase text-sm sm:text-base mb-2">Catatan Pendidik</h3>
                    <div class="border border-gray-600 p-3">
                        <x-textarea name="catatan_pendidik" rows="3" class="w-full capitalize-input"
                            placeholder="Masukan Keterangan..."
                            required>{{ old('catatan_pendidik', $raportHead->catatan_pendidik) }}</x-textarea>
                    </div>
                </div>

                @if ($semester === 'Genap')
                    <div>
                        <h3 class="font-bold uppercase text-sm sm:text-base mb-2">
                            {{ $siswa->kelas->nama_kelas_nomor == 9 ? 'Keterangan Kelulusan' : 'Keterangan Kenaikan Kelas' }}
                        </h3>
                        <div
                            class="border border-gray-600 p-3 flex flex-col sm:flex-row sm:items-center gap-2 text-xs sm:text-sm">
                            <span class="font-semibold">
                                {{ $siswa->kelas->nama_kelas_nomor == 9 ? 'Keterangan Kelulusan:' : 'Keterangan Kenaikan Kelas:' }}
                            </span>
                            <x-select name="keterangan_kenaikan_kelas" class="flex-1" required>
                                <option value="" selected disabled>-- Pilih Keterangan --</option>
                                @foreach ($promotionOptions as $option)
                                    <option value="{{ $option }}"
                                        {{ old('keterangan_kenaikan_kelas', $selectedPromotion) == $option ? 'selected' : '' }}>
                                        {{ $option }}</option>
                                @endforeach
                            </x-select>
                        </div>
                    </div>
                @endif

                <div class="flex mx-20">
                    <div class="w-full"></div>
                    <div class="flex gap-2 items-center w-full">
                        <div>Tasikmalaya,</div>
                        <div>
                            <x-input type="date" name="tanggal_titimangsa" id="tanggal"
                                value="{{ old('tanggal_titimangsa', optional($raportHead->tanggal_titimangsa)->format('Y-m-d')) }}"
                                required />
                        </div>
                    </div>
                    <div class="w-full"></div>
                </div>

                <div class="flex mx-20">
                    <div class="w-full text-center">
                        <h1>Orang Tua/Wali</h1>
                        <div class="border border-gray-400 mt-28 mx-10 border-dashed"></div>
                    </div>
                    <div class="w-full"></div>
                    <div class="w-full text-center">
                        <h1>Wali Kelas</h1>
                        <div class="mt-24">
                            <div class="font-bold">{{ optional($raportHead->waliKelas)->nama_guru ?? '-' }}</div>
                            <div>NIP. {{ optional($raportHead->waliKelas)->nip ?? '-' }}</div>
                        </div>
                    </div>
                </div>

                <div class="flex mx-20">
                    <div class="w-full"></div>
                    <div class="w-full text-center">
                        <h1>Mengetahui</h1>
                        <h1>Kepala Madrasah</h1>
                        <div class="mt-24">
                            <div class="font-bold">{{ optional($raportHead->kepalaSekolah)->nama_lengkap ?? '-' }}
                            </div>
                            <div>NIP. {{ optional($raportHead->kepalaSekolah)->nip ?? '-' }}</div>
                        </div>
                    </div>
                    <div class="w-full"></div>
                </div>
            </div>

            <div class="mt-8 flex justify-center">
                <x-btn-save class="px-28">
                    <div class="flex items-center gap-1 font-medium">
                        <i class="fa-solid fa-floppy-disk"></i>
                        <p>Simpan Perubahan</p>
                    </div>
                </x-btn-save>
                {{-- <button as="a" href="{{ route('raport.index') }}">
                    <i class="fa-solid fa-arrow-left"></i> Kembali
                </button>
                <button type="submit" class="bg-primary hover:bg-hvPrimary">
                    <i class="fa-solid fa-floppy-disk me-1"></i> Simpan Perubahan
                </button> --}}
            </div>
        </form>
    </section>

    @push('js')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Function to convert text to title case
                function toTitleCase(str) {
                    return str.replace(/\w\S*/g, function(txt) {
                        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
                    });
                }

                // Function to apply title case functionality to elements
                function applyTitleCase() {
                    const capitalizeInputs = document.querySelectorAll('.capitalize-input');

                    capitalizeInputs.forEach(function(input) {
                        // Transform existing value to title case on page load
                        if (input.value && !input.hasAttribute('data-title-case-applied')) {
                            input.value = toTitleCase(input.value);
                            input.setAttribute('data-title-case-applied', 'true');
                        }

                        // Transform input on change/input events
                        input.addEventListener('input', function() {
                            this.value = toTitleCase(this.value);
                        });

                        // Also transform on blur to ensure consistency
                        input.addEventListener('blur', function() {
                            this.value = toTitleCase(this.value);
                        });
                    });
                }

                // Apply title case on page load
                applyTitleCase();

                // Apply title case whenever new rows are added (for dynamically added elements)
                const observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                            applyTitleCase();
                        }
                    });
                });

                // Observe changes to the ekstrakurikuler and prestasi tables
                const ekstrakurikulerTbody = document.getElementById('ekstrakurikuler-tbody');
                const prestasiTbody = document.getElementById('prestasi-tbody');

                if (ekstrakurikulerTbody) {
                    observer.observe(ekstrakurikulerTbody, {
                        childList: true
                    });
                }
                if (prestasiTbody) {
                    observer.observe(prestasiTbody, {
                        childList: true
                    });
                }
            });
        </script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const nilaiInputs = document.querySelectorAll('.nilai-input');
                const totalField = document.getElementById('total-nilai-akhir');
                const ekstrakurikulerTbody = document.getElementById('ekstrakurikuler-tbody');
                const prestasiTbody = document.getElementById('prestasi-tbody');
                const addEkstrakurikulerBtn = document.getElementById('add-ekstrakurikuler');
                const addPrestasiBtn = document.getElementById('add-prestasi');

                function calculateTotal() {
                    let total = 0;
                    nilaiInputs.forEach(input => {
                        const value = parseFloat(input.value);
                        if (!isNaN(value)) {
                            total += value;
                        }
                    });
                    if (totalField) {
                        totalField.textContent = total;
                    }
                    const totalInput = document.getElementById('input-total-nilai-akhir');
                    if (totalInput) {
                        totalInput.value = total;
                    }
                }

                nilaiInputs.forEach(input => {
                    input.addEventListener('input', calculateTotal);
                });

                calculateTotal();

                addEkstrakurikulerBtn?.addEventListener('click', function() {
                    addRow(ekstrakurikulerTbody);
                });

                addPrestasiBtn?.addEventListener('click', function() {
                    addRow(prestasiTbody);
                });

                document.addEventListener('click', function(e) {
                    const removeBtn = e.target.closest('.remove-row');
                    if (!removeBtn) {
                        return;
                    }

                    const row = removeBtn.closest('tr');
                    const tbody = row?.closest('tbody');
                    if (!row || !tbody) {
                        return;
                    }

                    row.remove();
                    updateRowNumbers(tbody);
                    toggleRemoveButtons();
                });

                function addRow(tbody) {
                    if (!tbody) {
                        return;
                    }

                    const templateRow = tbody.querySelector('tr');
                    if (!templateRow) {
                        return;
                    }

                    const newRow = templateRow.cloneNode(true);
                    resetRowInputs(newRow);
                    tbody.appendChild(newRow);
                    updateRowNumbers(tbody);
                    toggleRemoveButtons();
                }

                function resetRowInputs(row) {
                    row.querySelectorAll('select').forEach(select => {
                        select.selectedIndex = 0;
                    });

                    row.querySelectorAll('input:not([type="hidden"])').forEach(input => {
                        if (input.type === 'checkbox' || input.type === 'radio') {
                            input.checked = false;
                        } else {
                            input.value = '';
                        }
                    });

                    row.querySelectorAll('textarea').forEach(textarea => {
                        textarea.value = '';
                    });
                }

                function updateRowNumbers(tbody) {
                    if (!tbody) {
                        return;
                    }

                    const rows = tbody.querySelectorAll('tr');
                    rows.forEach((row, index) => {
                        const numberCell = row.querySelector('td:first-child');
                        if (numberCell) {
                            numberCell.textContent = index + 1;
                        }

                        const inputs = row.querySelectorAll('[name*="["]');
                        inputs.forEach(input => {
                            const name = input.getAttribute('name');
                            if (name) {
                                input.setAttribute('name', name.replace(/\[\d+\]/, `[${index}]`));
                            }
                        });
                    });
                }

                function toggleRemoveButtons() {
                    toggleTableAction(ekstrakurikulerTbody, 'ekskul-aksi-header', 'aksi-cell-ekskul');
                    toggleTableAction(prestasiTbody, 'prestasi-aksi-header', 'aksi-cell-prestasi');
                }

                function toggleTableAction(tbody, headerId, cellClass) {
                    if (!tbody) {
                        return;
                    }

                    const rows = tbody.querySelectorAll('tr');
                    const header = document.getElementById(headerId);
                    const showActions = rows.length > 1;

                    if (header) {
                        header.classList.toggle('hidden', !showActions);
                    }

                    rows.forEach(row => {
                        const aksiCell = row.querySelector(`.${cellClass}`);
                        if (aksiCell) {
                            aksiCell.classList.toggle('hidden', !showActions);
                            const removeBtn = aksiCell.querySelector('.remove-row');
                            if (removeBtn) {
                                removeBtn.disabled = !showActions;
                            }
                        }
                    });
                }

                toggleRemoveButtons();

                const tanggalInput = document.getElementById('tanggal');
                if (tanggalInput && !tanggalInput.value) {
                    tanggalInput.value = new Date().toISOString().split('T')[0];
                }
            });
        </script>
    @endpush
</x-app-layout>
