<aside id="sidebar" style="position: fixed; overflow-y: auto;"
    class="sidebar bg-gray-50 dark:bg-dark text-dark dark:text-light shadow-lg dark:shadow-gray-700 w-72 fixed inset-y-0 left-0 transform -translate-x-full lg:hidden z-40">
    <div class="px-5 py-4">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-2">
                {{-- <img src="/img/logoUtama.png" alt="logo" class="w-14"> --}}
                <img src="/logo_app/{{ Auth::user()->logo }}" alt="logo" class="w-14">
                <div>
                    <h2 class=" text-xl font-semibold">
                        BUKU INDUK</h2>
                    <h2 class="text-xs">{{ Auth::user()->nama_sekolah }}</h2>
                </div>
            </div>
            <div class="lg:hidden hover:text-hvPrimary">
                <button id="closeSidebar">
                    <i class="fa-solid fa-arrow-left-long"></i>
                </button>
            </div>
        </div>
        <div class="border border-gray-200 mt-4"></div>
        <ul class="mt-4 text-[15px]">
            {{-- Dashboard --}}
            <li class="my-1">
                <a href="/dashboard"
                    class="block py-2 px-4 font-semibold {{ request()->is('dashboard') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                    <i class="fa-solid fa-house me-1"></i> Dashboard
                </a>
            </li>

            @can('Admin')
                <div class="mt-1 text-primary font-semibold">Akademik</div>
                {{-- Tahun Ajaran --}}
                <li class="my-1">
                    <a href="/tahun-ajaran"
                        class="block py-2 px-4 font-semibold {{ request()->is('tahun-ajaran') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-calendar-days me-1"></i> Tahun Ajaran
                    </a>
                </li>

                {{-- Mata Pelajaran --}}
                <li class="my-1">
                    <a href="/kelas"
                        class="block py-2 px-4 font-semibold {{ request()->is('kelas') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-border-all me-1"></i> Data Kelas
                    </a>
                </li>
                <li class="my-1">
                    <a href="/mata-pelajaran"
                        class="block py-2 px-4 font-semibold {{ request()->is('mata-pelajaran') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-scroll me-1"></i> Mata Pelajaran
                    </a>
                </li>

                {{-- <li class="my-1">
                    <a href="/kepala-sekolah"
                        class="block py-2 px-4 font-semibold {{ request()->is('kepala-sekolah') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-user-shield me-1"></i> Kepala Sekolah
                    </a>
                </li>
                <li class="my-1">
                    <a href="/ekstrakulikuler"
                        class="block py-2 px-4 font-semibold {{ request()->is('ekstrakulikuler') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-futbol me-1"></i> Ekstrakulikuler
                    </a>
                </li> --}}
                {{-- <div class="mt-1 text-primary font-semibold">Wali Kelas</div>
                <li class="my-1">
                    <a href="/wali-kelas"
                        class="block py-2 px-4 font-semibold {{ request()->is('wali-kelas') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-user-tie me-1"></i> Wali Kelas
                    </a>
                </li>
                <li class="my-1">
                    <a href="/wali-kelas-periode"
                        class="block py-2 px-4 font-semibold {{ request()->is('wali-kelas-periode') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-user-clock me-1"></i> Periode Wali Kelas
                    </a>
                </li> --}}

                {{-- <div class="mt-1 text-primary font-semibold">Kesiswaan</div> --}}
                {{-- <li class="my-1">
                    <a href="/pekerjaan"
                        class="block py-2 px-4 font-semibold {{ request()->is('pekerjaan') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-briefcase me-1"></i> Pekerjaan Ortu
                    </a>
                </li> --}}
                <li class="my-1">
                    <a href="/siswa"
                        class="block py-2 px-4 font-semibold {{ request()->is('siswa') || request()->is('siswa/create') || request()->is('siswa/*') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                        <i class="fa-solid fa-user-graduate me-1"></i> Data Siswa
                    </a>
                </li>

                <div class="mt-1 text-primary font-semibold">Laporan</div>
            @endcan
            {{-- Raport --}}
            {{-- <li class="my-1">
                <a href="/raport"
                    class="block py-2 px-4 font-semibold {{ request()->is('raport') || request()->is('raport/create') || request()->is('raport/*') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                    <i class="fa-solid fa-book me-1"></i> Input Raport
                </a>
            </li> --}}
            {{-- Buku Induk --}}
            <li class="my-1">
                <a href="/buku-induk"
                    class="block py-2 px-4 font-semibold {{ request()->is('buku-induk') || request()->is('buku-induk/*') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                    <i class="fa-solid fa-book-open me-1"></i> Buku Induk
                </a>
            </li>
            {{-- Rekap Nilai Siswa --}}
            {{-- <li class="my-1">
                <a href="/rekap-nilai"
                    class="block py-2 px-4 font-semibold {{ request()->is('rekap-nilai') || request()->is('rekap-nilai/*') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                    <i class="fa-solid fa-file-lines me-1"></i> Rekap Nilai Siswa
                </a>
            </li> --}}

            @can('Admin')
                <div class="mt-1 text-primary font-semibold">Akun</div>
            @endcan
            {{-- Profil --}}
            <li class="my-1">
                <a href="/profil"
                    class="block py-2 px-4 font-semibold {{ request()->is('profil') || request()->is('profil/*') ? 'bg-activeSidebar dark:bg-opacity-20 border-l-4 border-primary -ms-1' : 'hover:bg-gray-100 dark:bg-opacity-10' }}">
                    <i class="fa-solid fa-user-circle me-1"></i> Profil
                </a>
            </li>

        </ul>
    </div>
</aside>

@push('js')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.getElementById('sidebar');

            if (!sidebar) {
                return;
            }

            const storageKey = 'sidebar-scroll-position';
            const savedPosition = localStorage.getItem(storageKey);

            if (savedPosition !== null) {
                sidebar.scrollTop = parseInt(savedPosition, 10) || 0;
            }

            sidebar.addEventListener('scroll', function() {
                localStorage.setItem(storageKey, sidebar.scrollTop);
            });
        });
    </script>
@endpush
