<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Login</title>

    <!-- Favicons -->
    <link href="/img/logoUtama.png" rel="icon">
    <link href="/img/logoUtama.png" rel="apple-touch-icon">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!--Icons Cdn-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <!-- Scripts -->
    @viteReactRefresh
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        .bg-img {
            background-image: url('img/bg_login.png');
            background-repeat: no-repeat;
            background-size: contain;
            background-attachment: fixed;
            background-position: left bottom;
        }

        .bg-gradient-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(to top, rgb(0, 0, 0), transparent);
            z-index: 0;
        }

        .bg-pattern {
            background-image: url('img/bg_pattern2.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            background-attachment: fixed;
            background-color: rgba(255, 255, 255, 0.9);
            background-blend-mode: overlay;
        }
    </style>
</head>

<body>

    <div class="flex bg-white justify-center shadow-lg h-screen">
        <!-- Left side with image and text -->
        <div class="hidden lg:flex lg:w-[60%] bg-img relative">
            <!-- Layer gradasi hitam -->
            <div class="bg-gradient-overlay"></div>
            <div class="p-10 absolute bottom-0">
                <div>
                    <img src="/img/logoUtama.png" alt="logo" class="w-20 -ms-2">
                    <h2 class="text-2xl font-bold text-white mb-1 drop-shadow-lg mt-2">PROGRAM APLIKASI BUKU INDUK
                    </h2>
                    {{-- <p class="text-white text-LG drop-shadow-xl -mt-1">MTSs AL IKHLAS PANGANTEN</p> --}}
                </div>
            </div>
        </div>

        <!-- Right side with login form -->
        <div
            class="w-full lg:w-[40%] p-8 sm:p-32 md:p-56 lg:p-8 xl:p-20 flex justify-center items-center rounded-lg bg-pattern relative">
            <div class="absolute top-4 left-5">
                <a href="/"><i class="fa-solid fa-arrow-left text-primary hover:text-hvPrimary text-2xl"></i></a>
            </div>
            <div class="w-full">
                <img src="/img/logoUtama.png" alt="logo" class="w-32 mx-auto mb-5">
                <p class="text-lg font-semibold text-gray-600 text-center">SELAMAT DATANG DI</p>
                <h2 class="text-base xl:text-lg font-extrabold text-primary text-center">
                    PROGRAM APLIKASI BUKU INDUK
                </h2>
                <p class="text-base xl:text-lg font-semibold text-primary text-center">
                    {{-- MTSs AL IKHLAS PANGANTEN --}}
                </p>

                <form method="POST" action="{{ route('login') }}" class="mt-6">
                    @csrf
                    <div class="mb-4">
                        <label for="email" class="font-bold text-sm"><i class="fa-solid fa-user"></i>
                            Username</label>
                        <input type="text" id="email" name="email"
                            class="w-full py-2 rounded-lg text-sm border-gray-300 shadow-sm {{ $errors->first('email') ? 'border-red-500' : '' }}"
                            tabindex="1" value="{{ old('email') }}" autofocus>
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>

                    <div class="mb-4 relative">
                        <label for="password" class="font-bold text-sm"><i class="fa-solid fa-lock"></i>
                            Password</label>
                        <input type="password" id="password" name="password"
                            class="w-full py-2 rounded-lg text-sm border-gray-300 shadow-sm {{ $errors->first('password') ? 'border-red-500' : '' }}"
                            tabindex="2">
                        <button id="eyePassword" type="button" class="absolute right-5 mt-2">
                            <i id="iconEyePassword" class="fa-solid fa-eye-slash"></i>
                        </button>
                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                    </div>

                    <div class="mt-6">
                        <button type="submit" tabindex="3"
                            class="w-full bg-primary font-bold text-white py-2 rounded-lg hover:bg-hvPrimary transition duration-200 focus:outline-none focus:bg-hvPrimary">LOGIN</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('eyePassword').addEventListener('click', function() {
            var passwordInput = document.getElementById('password');
            var iconEyePassword = document.getElementById('iconEyePassword');

            // Cek tipe input dan ubah
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text'; // Ubah ke tipe text
                iconEyePassword.classList.remove('fa-eye-slash');
                iconEyePassword.classList.add('fa-eye'); // Ganti ikon
            } else {
                passwordInput.type = 'password'; // Kembali ke tipe password
                iconEyePassword.classList.remove('fa-eye');
                iconEyePassword.classList.add('fa-eye-slash'); // Kembalikan ikon
            }
        });
    </script>

</body>

</html>
