<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SiswaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $siswas = [
            // Kelas 7A
            [
                'kelas_id' => 1,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2025001',
                'nisn' => '0012345001',
                'no_kip' => '1234567890001',
                'no_kk' => '3201010101010001',
                'nama_siswa' => 'Ahmad Rizki Maulana',
                'jenis_kelamin' => 'Laki-Laki',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '2012-05-15',
                'agama' => 'Islam',
                'alamat' => 'Jl. Merdeka No. 123, Jakarta',
                'no_hp_siswa' => '081234567001',
                'nama_ayah' => 'Budi Santoso',
                'pekerjaan_ayah_id' => 1, // PNS
                'nama_ibu' => 'Siti Aminah',
                'pekerjaan_ibu_id' => 10, // Ibu Rumah Tangga
                'no_hp_ortu' => '081234567101',
                'angkatan' => '2025',
                'status' => 'Aktif',
            ],
            [
                'kelas_id' => 1,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2025002',
                'nisn' => '0012345002',
                'no_kip' => '1234567890002',
                'no_kk' => '3201010101010002',
                'nama_siswa' => 'Siti Nurhaliza',
                'jenis_kelamin' => 'Perempuan',
                'tempat_lahir' => 'Bandung',
                'tanggal_lahir' => '2012-08-20',
                'agama' => 'Islam',
                'alamat' => 'Jl. Sudirman No. 45, Bandung',
                'no_hp_siswa' => '081234567002',
                'nama_ayah' => 'Hendra Wijaya',
                'pekerjaan_ayah_id' => 4, // Wiraswasta
                'nama_ibu' => 'Dewi Lestari',
                'pekerjaan_ibu_id' => 8, // Guru
                'no_hp_ortu' => '081234567102',
                'angkatan' => '2025',
                'status' => 'Aktif',
            ],
            [
                'kelas_id' => 1,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2025003',
                'nisn' => '0012345003',
                'no_kip' => '1234567890003',
                'no_kk' => '3201010101010003',
                'nama_siswa' => 'Muhammad Fadli',
                'jenis_kelamin' => 'Laki-Laki',
                'tempat_lahir' => 'Surabaya',
                'tanggal_lahir' => '2012-03-10',
                'agama' => 'Islam',
                'alamat' => 'Jl. Pahlawan No. 78, Surabaya',
                'no_hp_siswa' => '081234567003',
                'nama_ayah' => 'Agus Setiawan',
                'pekerjaan_ayah_id' => 3, // Pegawai Swasta
                'nama_ibu' => 'Ratna Sari',
                'pekerjaan_ibu_id' => 10, // Ibu Rumah Tangga
                'no_hp_ortu' => '081234567103',
                'angkatan' => '2025',
                'status' => 'Aktif',
            ],

            // Kelas 7B
            [
                'kelas_id' => 2,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2025004',
                'nisn' => '0012345004',
                'no_kip' => '1234567890004',
                'no_kk' => '3201010101010004',
                'nama_siswa' => 'Rina Wulandari',
                'jenis_kelamin' => 'Perempuan',
                'tempat_lahir' => 'Yogyakarta',
                'tanggal_lahir' => '2012-07-12',
                'agama' => 'Islam',
                'alamat' => 'Jl. Diponegoro No. 90, Yogyakarta',
                'no_hp_siswa' => '081234567004',
                'nama_ayah' => 'Bambang Sutrisno',
                'pekerjaan_ayah_id' => 5, // Petani
                'nama_ibu' => 'Ani Suryani',
                'pekerjaan_ibu_id' => 10, // Ibu Rumah Tangga
                'no_hp_ortu' => '081234567104',
                'angkatan' => '2025',
                'status' => 'Aktif',
            ],
            [
                'kelas_id' => 2,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2025005',
                'nisn' => '0012345005',
                'no_kip' => '1234567890005',
                'no_kk' => '3201010101010005',
                'nama_siswa' => 'Dedi Kurniawan',
                'jenis_kelamin' => 'Laki-Laki',
                'tempat_lahir' => 'Semarang',
                'tanggal_lahir' => '2012-11-25',
                'agama' => 'Islam',
                'alamat' => 'Jl. Gatot Subroto No. 56, Semarang',
                'no_hp_siswa' => '081234567005',
                'nama_ayah' => 'Eko Prasetyo',
                'pekerjaan_ayah_id' => 6, // Pedagang
                'nama_ibu' => 'Wati Handayani',
                'pekerjaan_ibu_id' => 6, // Pedagang
                'no_hp_ortu' => '081234567105',
                'angkatan' => '2025',
                'status' => 'Aktif',
            ],

            // Kelas 8A
            [
                'kelas_id' => 3,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2024001',
                'nisn' => '0012345006',
                'no_kip' => '1234567890006',
                'no_kk' => '3201010101010006',
                'nama_siswa' => 'Putri Ayu Lestari',
                'jenis_kelamin' => 'Perempuan',
                'tempat_lahir' => 'Malang',
                'tanggal_lahir' => '2011-04-18',
                'agama' => 'Islam',
                'alamat' => 'Jl. Ahmad Yani No. 34, Malang',
                'no_hp_siswa' => '081234567006',
                'nama_ayah' => 'Hadi Susanto',
                'pekerjaan_ayah_id' => 1, // PNS
                'nama_ibu' => 'Sri Mulyani',
                'pekerjaan_ibu_id' => 8, // Guru
                'no_hp_ortu' => '081234567106',
                'angkatan' => '2024',
                'status' => 'Aktif',
            ],
            [
                'kelas_id' => 3,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2024002',
                'nisn' => '0012345007',
                'no_kip' => '1234567890007',
                'no_kk' => '3201010101010007',
                'nama_siswa' => 'Arif Rahman Hakim',
                'jenis_kelamin' => 'Laki-Laki',
                'tempat_lahir' => 'Solo',
                'tanggal_lahir' => '2011-09-30',
                'agama' => 'Islam',
                'alamat' => 'Jl. Veteran No. 67, Solo',
                'no_hp_siswa' => '081234567007',
                'nama_ayah' => 'Joko Widodo',
                'pekerjaan_ayah_id' => 4, // Wiraswasta
                'nama_ibu' => 'Ningsih Rahayu',
                'pekerjaan_ibu_id' => 10, // Ibu Rumah Tangga
                'no_hp_ortu' => '081234567107',
                'angkatan' => '2024',
                'status' => 'Aktif',
            ],

            // Kelas 8B
            [
                'kelas_id' => 4,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2024003',
                'nisn' => '0012345008',
                'no_kip' => '1234567890008',
                'no_kk' => '3201010101010008',
                'nama_siswa' => 'Indah Permatasari',
                'jenis_kelamin' => 'Perempuan',
                'tempat_lahir' => 'Medan',
                'tanggal_lahir' => '2011-02-14',
                'agama' => 'Islam',
                'alamat' => 'Jl. Imam Bonjol No. 88, Medan',
                'no_hp_siswa' => '081234567008',
                'nama_ayah' => 'Rizal Ramli',
                'pekerjaan_ayah_id' => 2, // TNI/POLRI
                'nama_ibu' => 'Fitri Handayani',
                'pekerjaan_ibu_id' => 10, // Ibu Rumah Tangga
                'no_hp_ortu' => '081234567108',
                'angkatan' => '2024',
                'status' => 'Aktif',
            ],
            [
                'kelas_id' => 4,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2024004',
                'nisn' => '0012345009',
                'no_kip' => '1234567890009',
                'no_kk' => '3201010101010009',
                'nama_siswa' => 'Reza Pahlevi',
                'jenis_kelamin' => 'Laki-Laki',
                'tempat_lahir' => 'Palembang',
                'tanggal_lahir' => '2011-06-22',
                'agama' => 'Islam',
                'alamat' => 'Jl. Sudirman No. 99, Palembang',
                'no_hp_siswa' => '081234567009',
                'nama_ayah' => 'Fahmi Idris',
                'pekerjaan_ayah_id' => 3, // Pegawai Swasta
                'nama_ibu' => 'Lina Marlina',
                'pekerjaan_ibu_id' => 3, // Pegawai Swasta
                'no_hp_ortu' => '081234567109',
                'angkatan' => '2024',
                'status' => 'Aktif',
            ],

            // Kelas 9A
            [
                'kelas_id' => 5,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2023001',
                'nisn' => '0012345010',
                'no_kip' => '1234567890010',
                'no_kk' => '3201010101010010',
                'nama_siswa' => 'Nurul Hidayah',
                'jenis_kelamin' => 'Perempuan',
                'tempat_lahir' => 'Makassar',
                'tanggal_lahir' => '2010-01-08',
                'agama' => 'Islam',
                'alamat' => 'Jl. Pettarani No. 55, Makassar',
                'no_hp_siswa' => '081234567010',
                'nama_ayah' => 'Syamsul Bahri',
                'pekerjaan_ayah_id' => 9, // Dokter
                'nama_ibu' => 'Nurhayati',
                'pekerjaan_ibu_id' => 8, // Guru
                'no_hp_ortu' => '081234567110',
                'angkatan' => '2023',
                'status' => 'Aktif',
            ],
            [
                'kelas_id' => 5,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2023002',
                'nisn' => '0012345011',
                'no_kip' => '1234567890011',
                'no_kk' => '3201010101010011',
                'nama_siswa' => 'Fajar Ramadhan',
                'jenis_kelamin' => 'Laki-Laki',
                'tempat_lahir' => 'Denpasar',
                'tanggal_lahir' => '2010-12-05',
                'agama' => 'Islam',
                'alamat' => 'Jl. Gatot Subroto No. 77, Denpasar',
                'no_hp_siswa' => '081234567011',
                'nama_ayah' => 'Made Wirawan',
                'pekerjaan_ayah_id' => 4, // Wiraswasta
                'nama_ibu' => 'Ketut Suartini',
                'pekerjaan_ibu_id' => 6, // Pedagang
                'no_hp_ortu' => '081234567111',
                'angkatan' => '2023',
                'status' => 'Aktif',
            ],

            // Kelas 9B
            [
                'kelas_id' => 6,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2023003',
                'nisn' => '0012345012',
                'no_kip' => '1234567890012',
                'no_kk' => '3201010101010012',
                'nama_siswa' => 'Zahra Amelia',
                'jenis_kelamin' => 'Perempuan',
                'tempat_lahir' => 'Padang',
                'tanggal_lahir' => '2010-03-28',
                'agama' => 'Islam',
                'alamat' => 'Jl. Khatib Sulaiman No. 22, Padang',
                'no_hp_siswa' => '081234567012',
                'nama_ayah' => 'Zulkifli',
                'pekerjaan_ayah_id' => 1, // PNS
                'nama_ibu' => 'Yuliana',
                'pekerjaan_ibu_id' => 10, // Ibu Rumah Tangga
                'no_hp_ortu' => '081234567112',
                'angkatan' => '2023',
                'status' => 'Aktif',
            ],
            [
                'kelas_id' => 6,
                'thn_ajaran_awal' => 2025,
                'thn_ajaran_akhir' => 2026,
                'nis' => '2023004',
                'nisn' => '0012345013',
                'no_kip' => '1234567890013',
                'no_kk' => '3201010101010013',
                'nama_siswa' => 'Kevin Pratama',
                'jenis_kelamin' => 'Laki-Laki',
                'tempat_lahir' => 'Pontianak',
                'tanggal_lahir' => '2010-10-17',
                'agama' => 'Islam',
                'alamat' => 'Jl. Ahmad Yani No. 44, Pontianak',
                'no_hp_siswa' => '081234567013',
                'nama_ayah' => 'Gunawan',
                'pekerjaan_ayah_id' => 7, // Buruh
                'nama_ibu' => 'Sumiati',
                'pekerjaan_ibu_id' => 10, // Ibu Rumah Tangga
                'no_hp_ortu' => '081234567113',
                'angkatan' => '2023',
                'status' => 'Aktif',
            ],
        ];

        foreach ($siswas as $siswa) {
            DB::table('siswas')->insert([
                'kelas_id' => $siswa['kelas_id'],
                'thn_ajaran_awal' => $siswa['thn_ajaran_awal'],
                'thn_ajaran_akhir' => $siswa['thn_ajaran_akhir'],
                'nis' => $siswa['nis'],
                'nisn' => $siswa['nisn'],
                'no_kip' => $siswa['no_kip'],
                'no_kk' => $siswa['no_kk'],
                'nama_siswa' => $siswa['nama_siswa'],
                'jenis_kelamin' => $siswa['jenis_kelamin'],
                'tempat_lahir' => $siswa['tempat_lahir'],
                'tanggal_lahir' => $siswa['tanggal_lahir'],
                'agama' => $siswa['agama'],
                'alamat' => $siswa['alamat'],
                'no_hp_siswa' => $siswa['no_hp_siswa'],
                'nama_ayah' => $siswa['nama_ayah'],
                'pekerjaan_ayah_id' => $siswa['pekerjaan_ayah_id'],
                'nama_ibu' => $siswa['nama_ibu'],
                'pekerjaan_ibu_id' => $siswa['pekerjaan_ibu_id'],
                'no_hp_ortu' => $siswa['no_hp_ortu'],
                'angkatan' => $siswa['angkatan'],
                'status' => $siswa['status'],
                'keterangan_kenaikan' => null,
                'deleted' => '0',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
