<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MapelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Insert Mapel Heads
        $mapelHeads = [
            ['id' => 1, 'nama_mapel' => 'Pendidikan Agama Islam', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 2, 'nama_mapel' => 'Pendidikan Pancasila', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 3, 'nama_mapel' => 'Bahasa Indonesia', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 4, 'nama_mapel' => 'Matematika', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 5, 'nama_mapel' => 'Ilmu Pengetahuan Alam', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 6, 'nama_mapel' => 'Ilmu Pengetahuan Sosial', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 7, 'nama_mapel' => 'Bahasa Inggris', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 8, 'nama_mapel' => 'Pendidikan Jasmani', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 9, 'nama_mapel' => 'Seni Budaya', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 10, 'nama_mapel' => 'Prakarya', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 11, 'nama_mapel' => 'Bahasa Arab', 'status' => 'Aktif', 'deleted' => '0'],
            ['id' => 12, 'nama_mapel' => 'Informatika', 'status' => 'Aktif', 'deleted' => '0'],
        ];

        foreach ($mapelHeads as $mapel) {
            DB::table('mapel_heads')->insert([
                'id' => $mapel['id'],
                'nama_mapel' => $mapel['nama_mapel'],
                'status' => $mapel['status'],
                'deleted' => $mapel['deleted'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // Insert Mapel Details untuk Pendidikan Agama Islam
        $mapelDetails = [
            ['mapel_head_id' => 1, 'nama_mapel_detail' => 'Al-Quran Hadits', 'status' => 'Aktif', 'deleted' => '0'],
            ['mapel_head_id' => 1, 'nama_mapel_detail' => 'Akidah Akhlak', 'status' => 'Aktif', 'deleted' => '0'],
            ['mapel_head_id' => 1, 'nama_mapel_detail' => 'Fiqih', 'status' => 'Aktif', 'deleted' => '0'],
            ['mapel_head_id' => 1, 'nama_mapel_detail' => 'Sejarah Kebudayaan Islam', 'status' => 'Aktif', 'deleted' => '0'],
        ];

        foreach ($mapelDetails as $detail) {
            DB::table('mapel_details')->insert([
                'mapel_head_id' => $detail['mapel_head_id'],
                'nama_mapel_detail' => $detail['nama_mapel_detail'],
                'status' => $detail['status'],
                'deleted' => $detail['deleted'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        // Insert Mapel Kelas - Assign all mapel to all kelas
        $kelasIds = [1, 2, 3, 4, 5, 6]; // 7A, 7B, 8A, 8B, 9A, 9B
        $mapelKelasData = [];

        // Assign mapel heads (except Pendidikan Agama Islam which has details)
        foreach ($kelasIds as $kelasId) {
            // Mapel heads
            for ($mapelId = 1; $mapelId <= 12; $mapelId++) {
                $mapelKelasData[] = [
                    'mapel_id' => $mapelId,
                    'mapel_type' => 'head',
                    'kelas_id' => $kelasId,
                    'created_at' => now(),
                    'updated_at' => now(),
                ];
            }

            // Mapel details untuk Pendidikan Agama Islam
            for ($detailId = 1; $detailId <= 4; $detailId++) {
                $mapelKelasData[] = [
                    'mapel_id' => $detailId,
                    'mapel_type' => 'detail',
                    'kelas_id' => $kelasId,
                    'created_at' => now(),
                    'updated_at' => now(),
                ];
            }
        }

        DB::table('mapel_kelas')->insert($mapelKelasData);
    }
}
