<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('book_heads', function (Blueprint $table) {
            $table->id();
            $table->foreignId('siswa_id');
            $table->integer('thn_ajaran_awal');
            $table->integer('thn_ajaran_akhir');
            $table->string('nama_kelas_nomor');
            $table->enum('semester', ['Ganjil', 'Genap']);
            $table->double('jml_nilai_akhir');
            // $table->enum('status_input', ['Sudah Input', 'Belum Input'])->default('Belum Input');
            $table->enum('deleted', ['0', '1'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('book_heads');
    }
};
