<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('temporary_siswas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('kelas_id');
            $table->foreignId('siswa_id');
            $table->integer('thn_ajaran_awal');
            $table->integer('thn_ajaran_akhir');
            $table->enum('status', ['Aktif', 'Non-Aktif', 'Alumni'])->default('Aktif');
            $table->string('keterangan_kenaikan', 100)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('temporary_siswas');
    }
};
