<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('periode_wali_kelas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('wali_kelas_id');
            $table->foreignId('kelas_id');
            // $table->foreignId('tahun_ajaran_id');
            $table->integer('thn_ajaran_awal');
            $table->integer('thn_ajaran_akhir');
            $table->enum('deleted', ['0', '1'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('periode_wali_kelas');
    }
};
