<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('raport_ekskuls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('raport_head_id');
            $table->foreignId('ekskul_id');
            $table->foreignId('ket_nilai');
            $table->text('keterangan')->nullable();
            $table->enum('deleted', ['0', '1'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('raport_ekskuls');
    }
};
