<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('raport_heads', function (Blueprint $table) {
            $table->id();
            $table->foreignId('siswa_id');
            $table->integer('thn_ajaran_awal');
            $table->integer('thn_ajaran_akhir');
            $table->foreignId('kepala_sekolah_id');
            $table->foreignId('wali_kelas_id');
            $table->string('fase', 50);
            $table->enum('semester', ['Ganjil', 'Genap']);
            $table->double('jml_sakit');
            $table->double('jml_izin');
            $table->double('jml_alpa');
            $table->text('catatan_pendidik');
            $table->string('keterangan_kenaikan', 100)->nullable();
            $table->date('tanggal_titimangsa');
            $table->double('jml_nilai_akhir');
            // $table->enum('status_input', ['Sudah Input', 'Belum Input'])->default('Belum Input');
            $table->enum('deleted', ['0', '1'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('raport_heads');
    }
};
