<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('siswas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('kelas_id');
            $table->integer('thn_ajaran_awal');
            $table->integer('thn_ajaran_akhir');
            $table->string('nis', 50)->unique();
            $table->string('nisn', 50)->unique();
            $table->string('no_kip', 50)->unique()->nullable();
            $table->string('no_kk', 50)->nullable();
            $table->string('nama_siswa', 50);
            $table->enum('jenis_kelamin', ['Laki-Laki', 'Perempuan']);
            $table->string('tempat_lahir', 50)->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->enum('agama', ['Islam', 'Kristen', 'Hindu', 'Buddha', 'Konghucu'])->default('Islam');
            $table->text('alamat')->nullable();
            $table->string('no_hp_siswa', 15)->nullable();
            $table->string('nama_ayah', 50)->nullable();
            $table->foreignId('pekerjaan_ayah_id')->nullable();
            $table->string('nama_ibu', 50)->nullable();
            $table->foreignId('pekerjaan_ibu_id')->nullable();
            $table->string('no_hp_ortu', 15)->nullable();
            $table->string('angkatan', 50);
            $table->enum('status', ['Aktif', 'Non-Aktif', 'Alumni'])->default('Aktif');
            $table->string('keterangan_kenaikan', 100)->nullable();
            $table->text('foto')->nullable();
            $table->enum('deleted', ['0', '1'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('siswas');
    }
};
