<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TahunAjaran extends Model
{
    use HasFactory;
    
    protected $guarded = ['id'];
    
    protected $fillable = [
        'tahun_awal',
        'tahun_akhir',
        'status',
        'deleted',
    ];

    protected static function boot()
    {
        parent::boot();

        // Ensure only one "Aktif" status exists
        static::saving(function ($tahunAjaran) {
            if ($tahunAjaran->status === 'Aktif') {
                // Set all other records to "Tidak Aktif"
                static::where('id', '!=', $tahunAjaran->id)
                    ->where('status', 'Aktif')
                    ->update(['status' => 'Tidak Aktif']);
            }
        });
    }

    /**
     * Get the active tahun ajaran
     */
    public static function getAktif()
    {
        return static::where('status', 'Aktif')
            ->where('deleted', '0')
            ->first();
    }
}
