<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RaportHead extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function siswa()
    {
        return $this->belongsTo(Siswa::class);
    }

    public function waliKelas()
    {
        return $this->belongsTo(WaliKelas::class, 'wali_kelas_id');
    }

    public function kepalaSekolah()
    {
        return $this->belongsTo(KepalaSekolah::class);
    }

    public function details()
    {
        return $this->hasMany(RaportDetail::class, 'raport_head_id')
            ->where('deleted', '0');
    }

    public function ekskuls()
    {
        return $this->hasMany(RaportEkskul::class, 'raport_head_id')
            ->where('deleted', '0');
    }

    public function prestasis()
    {
        return $this->hasMany(RaportPrestasi::class, 'raport_head_id')
            ->where('deleted', '0');
    }
}
