<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KepalaSekolah extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    protected static function boot()
    {
        parent::boot();

        // Ensure only one "Aktif" status exists
        static::saving(function ($kepalaSekolah) {
            if ($kepalaSekolah->status === 'Aktif') {
                // Set all other records to "Non-Aktif"
                static::where('id', '!=', $kepalaSekolah->id)
                    ->where('status', 'Aktif')
                    ->where('deleted', '0')
                    ->update(['status' => 'Non-Aktif']);
            }
        });
    }

    /**
     * Get the active kepala sekolah
     */
    public static function getAktif()
    {
        return static::where('status', 'Aktif')
            ->where('deleted', '0')
            ->first();
    }
}
