<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Kelas extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    // Accessor for nama_kelas
    public function getNamaKelasAttribute()
    {
        $namaKelas = $this->nama_kelas_romawi;
        if ($this->nama_kelas_sub) {
            $namaKelas .= $this->nama_kelas_sub;
        }
        return $namaKelas;
    }

    public function waliKelas()
    {
        return $this->belongsTo(WaliKelas::class);
    }
}
