# Dokumentasi Import Data Siswa dari Excel

## Fitur Import Siswa

Fitur ini memungkinkan pengguna untuk mengimpor data siswa dari file Excel ke dalam sistem secara massal.

## Cara Penggunaan

### 1. Persiapan File Excel

File Excel harus memiliki format kolom sebagai berikut:

#### Struktur File Excel:

**Baris 1:** Header Kolom
```
No | Kelas | Tahun Ajaran | NIS | NISN | No KIP | No KK | Nama Siswa | Jenis Kelamin | Tempat Lahir | Tanggal Lahir | Agama | Alamat | No HP Siswa | Nama Ayah | Pekerjaan Ayah | Nama Ibu | Pekerjaan Ibu | No HP Ortu | Angkatan
```

**Baris 2 dst:** Data Siswa

**PENTING**: Format ini sesuai dengan hasil export Excel. Anda dapat menggunakan file hasil export sebagai template untuk import.

### Format Kolom:

| Kolom | Nama Field | Deskripsi | Format | Wajib |
|-------|------------|-----------|--------|-------|
| A | No | Nomor urut (diabaikan saat import) | Angka | ❌ Tidak |
| B | Kelas | Kelas siswa | "7", "7A", "8B", "9", etc | ✅ Ya |
| C | Tahun Ajaran | Tahun ajaran aktif | Format: "2025/2026" | ✅ Ya |
| D | NIS | Nomor Induk Siswa | Angka/Text | ✅ Ya |
| E | NISN | Nomor Induk Siswa Nasional | Angka/Text | ✅ Ya |
| F | No KIP | Nomor Kartu Indonesia Pintar | Text (max 50 karakter) | ❌ Tidak |
| G | No KK | Nomor Kartu Keluarga | Text (max 50 karakter) | ❌ Tidak |
| H | Nama Siswa | Nama lengkap siswa | Text (max 50 karakter) | ✅ Ya |
| I | Jenis Kelamin | Jenis kelamin siswa | "Laki-Laki" atau "Perempuan" | ✅ Ya |
| J | Tempat Lahir | Tempat lahir siswa | Text (max 50 karakter) | ❌ Tidak |
| K | Tanggal Lahir | Tanggal lahir siswa | Date (DD-MM-YYYY atau Excel Date) | ❌ Tidak |
| L | Agama | Agama siswa | "Islam", "Kristen", "Hindu", "Buddha", "Konghucu" | ✅ Ya |
| M | Alamat | Alamat lengkap siswa | Text | ❌ Tidak |
| N | No HP Siswa | Nomor HP siswa | Text/Angka (max 15 karakter) | ❌ Tidak |
| O | Nama Ayah | Nama ayah siswa | Text (max 50 karakter) | ❌ Tidak |
| P | Pekerjaan Ayah | Nama pekerjaan ayah | Text (harus sesuai dengan master pekerjaan) | ❌ Tidak |
| Q | Nama Ibu | Nama ibu siswa | Text (max 50 karakter) | ❌ Tidak |
| R | Pekerjaan Ibu | Nama pekerjaan ibu | Text (harus sesuai dengan master pekerjaan) | ❌ Tidak |
| S | No HP Ortu | Nomor HP orang tua | Text/Angka (max 15 karakter) | ❌ Tidak |
| T | Angkatan | Tahun angkatan | Angka (contoh: 2025) | ✅ Ya |

### Field Default (Otomatis):

Field berikut akan diisi otomatis oleh sistem saat import:
- **deleted**: '0' (aktif)
- **foto**: null (kosong)
- **status**: 'Aktif'
- **keterangan_kenaikan**: null (kosong)

### 2. Langkah Import

1. Buka halaman **Data Siswa** (`/siswa`)
2. Klik tombol **"Impor Siswa"** di pojok kanan atas
3. Modal akan muncul dengan judul "Impor Data Siswa Dari Excel"
4. Klik **"Pilih File Excel"** dan pilih file .xlsx atau .xls (Max 10MB)
5. Klik tombol **"Konfirmasi"**
6. Sistem akan memproses file dan menampilkan notifikasi hasil import

### 3. Proses Import

Sistem akan melakukan hal berikut:

1. **Validasi Data**: Memeriksa format dan kelengkapan data wajib
   
2. **Cek NISN**:
   - Jika NISN **sudah ada** di database: Data siswa akan **diupdate**
   - Jika NISN **belum ada**: Siswa baru akan **ditambahkan**

3. **Validasi Unik**:
   - **NIS**: Harus unik (tidak boleh duplikat)
   - **No KIP**: Harus unik jika diisi
   - **NISN**: Acuan utama untuk update/insert

4. **Lookup Data**:
   - **Kelas**: Dicari berdasarkan nama kelas (contoh: "7A" → kelas 7 dengan sub A)
   - **Pekerjaan**: Dicari berdasarkan nama pekerjaan di master data

5. **Simpan Data**:
   - Data siswa disimpan ke tabel `siswas`
   - Field `deleted` = '0' (aktif)

### 4. Notifikasi Hasil

- **Sukses**: "Import siswa berhasil! X siswa berhasil ditambahkan. Y siswa berhasil diperbarui."
- **Warning**: "Import selesai dengan beberapa error." + Daftar error
- **Error**: Menampilkan pesan error jika terjadi kesalahan sistem

## Contoh File Excel

### Template Excel:

**TIPS**: Gunakan fitur **Export Excel** untuk mendapatkan template yang sudah sesuai format!

| No | Kelas | Tahun Ajaran | NIS | NISN | No KIP | No KK | Nama Siswa | Jenis Kelamin | Tempat Lahir | Tanggal Lahir | Agama | Alamat | No HP Siswa | Nama Ayah | Pekerjaan Ayah | Nama Ibu | Pekerjaan Ibu | No HP Ortu | Angkatan |
|----|-------|--------------|-----|------|--------|-------|------------|---------------|--------------|---------------|-------|--------|-------------|-----------|----------------|----------|---------------|------------|----------|
| 1 | 7A | 2025/2026 | 2025001 | 0012345001 | K001 | 3201012345678901 | Ahmad Rizki Maulana | Laki-Laki | Jakarta | 15-05-2010 | Islam | Jl. Merdeka No. 123 | 081234567890 | Budi Santoso | Pegawai Swasta | Siti Aminah | Ibu Rumah Tangga | 081234567891 | 2025 |
| 2 | 7A | 2025/2026 | 2025002 | 0012345002 | - | 3201012345678902 | Siti Nurhaliza | Perempuan | Bandung | 20-08-2010 | Islam | Jl. Pahlawan No. 45 | 082345678901 | Ahmad Yani | Wiraswasta | Fatimah | Pedagang | 082345678902 | 2025 |
| 3 | 7B | 2025/2026 | 2025003 | 0012345003 | K002 | - | Muhammad Fadli | Laki-Laki | Surabaya | 10-03-2010 | Islam | Jl. Sudirman No. 78 | - | Ridwan | PNS | Aminah | Guru | 083456789012 | 2025 |

## Catatan Penting

1. **NISN adalah kunci utama**:
   - Sistem menggunakan NISN untuk menentukan apakah data akan di-insert (tambah baru) atau di-update
   - Pastikan NISN unik dan konsisten

2. **Format file**: .xlsx atau .xls (maksimal 10MB)

3. **Header harus ada**: Baris pertama harus berisi header kolom

4. **Field wajib**:
   - Kelas (kolom B)
   - Tahun Ajaran (kolom C, format: YYYY/YYYY)
   - NIS (kolom D)
   - NISN (kolom E)
   - Nama Siswa (kolom H)
   - Jenis Kelamin (kolom I: Laki-Laki/Perempuan)
   - Agama (kolom L: Islam/Kristen/Hindu/Buddha/Konghucu)
   - Angkatan (kolom T)

5. **Format Kelas**:
   - Nomor saja: "7", "8", "9"
   - Dengan sub kelas: "7A", "8B", "9C"
   - Kelas harus sudah terdaftar di master kelas

6. **Format Tahun Ajaran**: "2025/2026" (dengan slash)

7. **Pekerjaan**: Nama pekerjaan harus sesuai dengan master data pekerjaan. Jika tidak ditemukan, field akan diisi null.

8. **Update vs Insert**:
   - Jika NISN ditemukan → Data akan di-**UPDATE**
   - Jika NISN tidak ditemukan → Data akan di-**INSERT** (tambah baru)

9. **Baris kosong**: Baris dengan NISN atau Nama Siswa kosong akan di-skip

10. **Partial Import**: Jika ada error pada beberapa baris, data yang valid tetap tersimpan

## Troubleshooting

### NISN duplikat saat insert
- Jika NISN sudah ada, data akan di-update bukan di-insert baru
- Pastikan NISN benar-benar unik untuk siswa baru

### NIS sudah terdaftar
- Cek apakah NIS sudah digunakan siswa lain
- Update NIS di Excel dengan nomor yang belum digunakan

### Kelas tidak ditemukan
- Pastikan format kelas sesuai (contoh: "7A", "8B", "9")
- Pastikan kelas sudah terdaftar di menu **Kelas**
- Format kelas case-insensitive (7a = 7A)

### Format tanggal tidak valid
- Gunakan format Excel Date atau "YYYY-MM-DD"
- Contoh: "2010-05-15" atau 15/05/2010

### Jenis Kelamin tidak valid
- Harus persis: "Laki-Laki" atau "Perempuan"
- Huruf besar kecil harus sesuai

### Agama tidak valid
- Pilihan valid: "Islam", "Kristen", "Hindu", "Buddha", "Konghucu"
- Huruf besar kecil harus sesuai

### Import gagal
- Cek ukuran file (max 10MB)
- Pastikan format Excel valid (.xlsx atau .xls)
- Cek log error di `storage/logs/laravel.log`

## Technical Details

### Models
- `Siswa`: Model utama untuk data siswa
- `Kelas`: Master data kelas
- `Pekerjaan`: Master data pekerjaan orang tua

### Import Class
- Location: `app/Imports/SiswaImport.php`
- Package: `maatwebsite/excel`
- Interface: `ToCollection`, `WithCalculatedFormulas`

### Route
- POST `/siswa/import`
- Name: `siswa.import`
- Middleware: `auth`

### Controller Method
- `SiswaController@import`

### Validasi File
```php
'file' => 'required|mimes:xlsx,xls|max:10240'
```
- Required: Ya
- Format: .xlsx atau .xls
- Max size: 10MB (10240 KB)

### Database Table
- Table: `siswas`
- Primary Key: `id` (auto increment)
- Unique Fields: `nisn`, `nis`, `no_kip`

## Tips & Best Practices

1. **Backup Data**: Selalu backup database sebelum import massal
2. **Test dengan Data Kecil**: Coba import 5-10 data terlebih dahulu
3. **Cek Master Data**: Pastikan master Kelas dan Pekerjaan sudah lengkap
4. **Format Konsisten**: Gunakan format yang konsisten untuk semua data
5. **Review Error**: Perhatikan pesan error dan perbaiki data Excel
6. **Update Bertahap**: Untuk update massal, lakukan per kelas/angkatan
