# Dokumentasi Import Nilai Buku Induk dari Excel

## Fitur Import Nilai

Fitur ini memungkinkan pengguna untuk mengimpor nilai siswa dari file Excel ke dalam sistem Buku Induk secara massal.

## Cara Penggunaan

### 1. Persiapan File Excel

File Excel harus memiliki format yang **persis sama** dengan tabel "Tabel Nilai Siswa" yang ada di halaman Buku Induk.

#### Struktur File Excel:

**Baris 1:** Header Kolom
- `No.` | `NISN` | `Nama Siswa` | `Nilai` | `Deskripsi` | `Nilai` | `Deskripsi` | ...
- Untuk setiap mata pelajaran, ada 2 kolom: Nilai dan Deskripsi

**Baris 2 dst:** Data Siswa
- Kolom A: Nomor urut (1, 2, 3, ...)
- Kolom B: **NISN** (wajib diisi, akan dicocokkan dengan database)
- Kolom C: Nama Siswa
- Kolom D: Nilai mata pelajaran pertama
- Kolom E: Deskripsi mata pelajaran pertama
- Kolom F: Nilai mata pelajaran kedua
- Kolom G: Deskripsi mata pelajaran kedua
- Dan seterusnya...

### 2. Langkah Import

1. Buka halaman **Buku Induk**
2. Pilih **Tahun Ajaran** dan **Kelas** yang sesuai
3. Pilih **Tab Semester** (Ganjil atau Genap) yang akan diimpor
4. Klik tombol **"Impor Nilai Dari Excel"**
5. Modal akan muncul menampilkan konfirmasi kelas dan semester
6. Klik **"Pilih File Excel"** dan pilih file .xlsx atau .xls (Max 10MB)
7. Klik tombol **"Import"**
8. Sistem akan memproses file dan menampilkan notifikasi hasil import

### 3. Proses Import

Sistem akan melakukan hal berikut:

1. **Validasi NISN**: Mencocokkan NISN di Excel dengan data siswa di database
   - Hanya siswa yang terdaftar di kelas dan tahun ajaran yang dipilih yang akan diproses
   
2. **Buat/Update BookHead**: 
   - Jika belum ada record untuk siswa tersebut, sistem akan membuat `book_heads` baru
   - Field yang diisi:
     - `siswa_id`: ID siswa dari tabel `siswas` (berdasarkan NISN)
     - `thn_ajaran_awal`: Dari data siswa
     - `thn_ajaran_akhir`: Dari data siswa  
     - `semester`: Sesuai tab yang aktif (Ganjil/Genap)
     - `jml_nilai_akhir`: 0 (sementara)

3. **Simpan BookDetail**:
   - Untuk setiap mapel/detail yang memiliki nilai atau deskripsi
   - Jika sudah ada, akan di-update
   - Jika belum ada, akan dibuat baru

### 4. Notifikasi Hasil

- **Sukses**: Menampilkan jumlah data yang berhasil diimpor
- **Warning**: Menampilkan jumlah sukses dan daftar error (jika ada NISN tidak ditemukan)
- **Error**: Menampilkan pesan error jika terjadi kesalahan sistem

## Format File Excel

### Contoh Struktur:

```
| No. | NISN        | Nama Siswa         | Bahasa Arab |              |
|-----|-------------|--------------------|-------------|--------------|
|     |             |                    | Nilai       | Deskripsi    |
| 1   | 0012345001  | Ahmad Rizki M.     | 90          | lorem ipsum  |
| 2   | 0012345003  | Muhammad Fadli     | 85          | lorem ipsum  |
| 3   | 0012345002  | Siti Nurhaliza     | 87          | lorem ipsum  |
```

**Catatan:** 
- Jika ada lebih dari satu mata pelajaran, tambahkan kolom Nilai dan Deskripsi untuk setiap mapel
- Urutan kolom harus sesuai dengan urutan mapel di halaman Buku Induk

## Catatan Penting

1. **NISN adalah kunci utama** - Pastikan NISN di Excel sesuai dengan data di database
2. **Format file**: .xlsx atau .xls (maksimal 10MB)
3. **Urutan kolom** harus sesuai dengan tabel di halaman Buku Induk
4. **Semester** ditentukan dari tab yang aktif saat tombol import diklik
5. **Data yang sudah ada akan di-update** jika NISN ditemukan
6. Baris kosong akan di-skip otomatis
7. Jika ada error, data yang berhasil tetap tersimpan (partial import)

## Troubleshooting

### NISN tidak ditemukan
- Pastikan NISN di Excel sama persis dengan database
- Pastikan siswa terdaftar di kelas dan tahun ajaran yang dipilih
- Cek status siswa (harus Aktif, bukan Non-Aktif)

### Format file tidak sesuai
- Pastikan struktur header (3 baris) sesuai dengan tabel
- Pastikan urutan kolom sama dengan tabel di halaman
- Gunakan file .xlsx atau .xls

### Import gagal
- Cek ukuran file (max 10MB)
- Pastikan tidak ada karakter khusus di NISN
- Cek log error untuk detail masalah

## Technical Details

### Models
- `BookHead`: Menyimpan header nilai siswa per semester
- `BookDetail`: Menyimpan detail nilai per mapel/detail
- `Siswa`: Data siswa (sumber NISN)

### Import Class
- Location: `app/Imports/BukuIndukImport.php`
- Package: `maatwebsite/excel`

### Route
- POST `/buku-induk/import`
- Name: `buku-induk.import`

### Controller Method
- `BukuIndukController@importNilai`
